/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import jp.snowgoose.treno.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);
    private static final List<ResourceFinder> DEFAULT_STRATEGIES = Arrays.asList(FindResourceStrategies.CLASSPATH, FindResourceStrategies.URL, FindResourceStrategies.FILE);

    private ResourceUtils() {
    }

    public static URL findResource(String name) {
        if (StringUtils.isEmpty(name)) {
            log.debug("resource name is empty.");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("resource name : " + name);
        }
        return ResourceUtils.findResource(name, DEFAULT_STRATEGIES);
    }

    public static URL findResource(String name, List<ResourceFinder> strategies) {
        for (ResourceFinder strategy : strategies) {
            URL found = strategy.find(name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static List<URL> findResources(String name) {
        ArrayList<URL> found = new ArrayList<URL>();
        URL resource = ResourceUtils.findResource(name, Arrays.asList(FindResourceStrategies.FILE, FindResourceStrategies.URL));
        if (resource != null) {
            found.add(resource);
        }
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                if (urls == null) continue;
                found.add(urls.nextElement());
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return found;
    }

    public static interface FindResourceStrategies {
        public static final ResourceFinder FILE = new ResourceFinder(){

            public URL find(String filename) {
                try {
                    char sep = File.separator.charAt(0);
                    String file = filename.replace(sep, '/');
                    if (file.charAt(0) != '/') {
                        String dir = System.getProperty("user.dir");
                        if ((dir = dir.replace(sep, '/') + '/').charAt(0) != '/') {
                            dir = "/" + dir;
                        }
                    }
                    URL fileURL = new URL("file", null, file);
                    log.debug("file resource : " + fileURL);
                    if (!new File(file).exists()) {
                        log.debug("not avilable file resource.");
                        return null;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("file resource found. " + fileURL);
                    }
                    return fileURL;
                }
                catch (MalformedURLException e) {
                    log.debug("can't convert from filename");
                    return null;
                }
            }
        };
        public static final ResourceFinder CLASSPATH = new ResourceFinder(){

            public URL find(String name) {
                URL resource = Thread.currentThread().getContextClassLoader().getResource(name);
                if (resource != null) {
                    log.debug("classpath resource found." + resource.getPath());
                    return resource;
                }
                log.debug("classpath resource not found.");
                return null;
            }
        };
        public static final ResourceFinder URL = new ResourceFinder(){

            public URL find(String name) {
                try {
                    URL url = new URL(name);
                    log.debug("url resource found." + url.getPath());
                    return url;
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        };
    }

    public static interface ResourceFinder {
        public URL find(String var1);
    }
}

