/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.result.type;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jp.snowgoose.treno.component.ActionInstance;
import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.exception.ResultEvaluationFailureException;
import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.metadata.Scope;
import jp.snowgoose.treno.result.type.DirectionType;
import jp.snowgoose.treno.util.IOUtils;
import jp.snowgoose.treno.util.Maps;

public class Stream
implements DirectionType {
    public void render(RequestContext context, RequestValueMapper requestValueMapper, ActionInstance actionInstance, ResultDescriptor resultDescriptor) throws ResultEvaluationFailureException {
        HttpServletResponse response = context.getResponse();
        try {
            ServletOutputStream out = response.getOutputStream();
            StreamResponse resource = StreamResponse.findResource(requestValueMapper);
            if (resource == null) {
                throw new ResultEvaluationFailureException(new IllegalArgumentException("stream resource required. e.d file or stream or text."), resultDescriptor);
            }
            resource.setUpResponseHeaders(response);
            IOUtils.writeAndFlush((OutputStream)out, resource.getInputStream());
            if (!resource.close()) {
                throw new ResultEvaluationFailureException(new IOException(), resultDescriptor);
            }
        }
        catch (IOException e) {
            throw new ResultEvaluationFailureException(e, resultDescriptor);
        }
    }

    private static class StreamResponse {
        private InputStream stream;
        private Map<String, String> headers = Maps.newLinkedHashMap();

        private StreamResponse(InputStream in) {
            this.stream = in;
        }

        private StreamResponse(byte[] in) {
            this.stream = new ByteArrayInputStream(in);
        }

        private StreamResponse(File file) throws IOException {
            this.stream = new FileInputStream(file);
        }

        static StreamResponse findResource(RequestValueMapper valueMapper) throws IOException {
            Map<?, ?> components = valueMapper.getAll(Scope.RESPONSE);
            StreamResponse response = null;
            for (Object value : components.values()) {
                if (value instanceof File) {
                    response = new StreamResponse((File)value);
                    continue;
                }
                if (value instanceof InputStream) {
                    response = new StreamResponse((InputStream)value);
                    continue;
                }
                if (!(value instanceof byte[])) continue;
                response = new StreamResponse((byte[])value);
            }
            if (components.containsKey("headers") && response != null) {
                response.headers.putAll((Map)components.get("headers"));
            }
            return response;
        }

        public InputStream getInputStream() {
            return this.stream;
        }

        public boolean close() {
            return IOUtils.closeSilently(this.stream);
        }

        public void setUpResponseHeaders(HttpServletResponse response) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                response.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }
}

