/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import javax.servlet.http.HttpServletRequest;
import jp.snowgoose.treno.metadata.MappedPath;
import jp.snowgoose.treno.metadata.Suffix;

public class RequestMappedPath
extends MappedPath {
    private static final long serialVersionUID = 1L;
    private Suffix suffix;

    public RequestMappedPath(HttpServletRequest request) {
        super(RequestMappedPath.getFormattedPath(request));
        this.suffix = this.getSuffix(request);
    }

    private Suffix getSuffix(HttpServletRequest request) {
        String uri = RequestMappedPath.removeJsessionId(request.getRequestURI());
        if (uri.lastIndexOf(46) != -1) {
            return new Suffix(uri.substring(uri.lastIndexOf(46)));
        }
        return Suffix.NONE;
    }

    private static String getFormattedPath(HttpServletRequest request) {
        String uri = RequestMappedPath.removeJsessionId(request.getRequestURI());
        return RequestMappedPath.removeSuffix(uri.replaceFirst(request.getContextPath(), ""));
    }

    private static String removeJsessionId(String uri) {
        int indexOfSessionIdSeparator = uri.indexOf(";");
        if (indexOfSessionIdSeparator == -1) {
            return uri;
        }
        return uri.substring(0, indexOfSessionIdSeparator);
    }

    private static String removeSuffix(String uri) {
        if (uri.lastIndexOf(46) > 0) {
            return uri.substring(0, uri.lastIndexOf(46));
        }
        return uri;
    }

    public boolean pathThrowgh(Suffix suffix) {
        return !this.suffix.getSuffix().equals(suffix.getSuffix());
    }
}

