/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import jp.snowgoose.treno.metadata.BindDescriptor;
import jp.snowgoose.treno.util.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindDescriptors
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, BindDescriptor> bindMap = Maps.newLinkedHashMap();

    public void put(BindDescriptor bindDescriptor) {
        if (bindDescriptor != null) {
            this.bindMap.put(bindDescriptor.getName(), bindDescriptor);
        }
    }

    public void putAll(Collection<BindDescriptor> bindDescriptors) {
        for (BindDescriptor bindDescriptor : bindDescriptors) {
            this.put(bindDescriptor);
        }
    }

    public BindDescriptor getBindDescriptor(String name) {
        return this.bindMap.get(name);
    }

    public Collection<BindDescriptor> getAll() {
        return this.bindMap.values();
    }

    public Collection<BindDescriptor> getParameterBindDescriptors() {
        return this.getBindDescriptors0(BindDescriptor.BindElementType.BindType.PARAMETER);
    }

    public Collection<BindDescriptor> getMethodBindDescriptors() {
        return this.getBindDescriptors0(BindDescriptor.BindElementType.BindType.METHOD);
    }

    public Collection<BindDescriptor> getFieldBindDescriptors() {
        return this.getBindDescriptors0(BindDescriptor.BindElementType.BindType.FIELD);
    }

    protected Collection<BindDescriptor> getBindDescriptors0(BindDescriptor.BindElementType.BindType elementType) {
        ArrayList<BindDescriptor> bindDescriptors = new ArrayList<BindDescriptor>();
        for (BindDescriptor bindDesc : this.getAll()) {
            if (!elementType.equals((Object)bindDesc.getBindElementType().getType())) continue;
            bindDescriptors.add(bindDesc);
        }
        return bindDescriptors;
    }
}

