#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TreeSh.h"
#include "Image.h"
#include "Pop.h"

GdkPixmap* Image::P;

/*
 * Image: Constructr/Destructor
 */
Image::Image() : TshWgt()
{
  setMode(false);
  W[0] = NULL, W[1] = NULL, I = NULL, P = NULL, B = NULL, Pm = NULL;

  W[0] = gtk_window_new(GTK_WINDOW_POPUP);
  W[2] = gtk_drawing_area_new ();

  gtk_container_add(GTK_CONTAINER(W[0]), W[2]);
  gtk_signal_connect (GTK_OBJECT (W[2]), "motion_notify_event",
		      (GtkSignalFunc) motion, this);
  gtk_signal_connect (GTK_OBJECT (W[2]), "expose_event",
		      (GtkSignalFunc) expose, this);
  gtk_widget_set_events (W[2], GDK_EXPOSURE_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_POINTER_MOTION_HINT_MASK);

  setPP(gtk_scrolled_window_new ((GtkAdjustment*)NULL, (GtkAdjustment*)NULL));
  gtk_signal_connect (GTK_OBJECT(getPP()), "button_press_event",
		      GTK_SIGNAL_FUNC(press), (gpointer)this);
  gdk_imlib_init();
}
Image::~Image() { clear(); }
void Image::setXY() { X = I->rgb_width, Y = I->rgb_height; }

/*
 * Public Members
 */
void Image::load(char* _F, int _B)
{
  switch(_B){
  case 0:
    clear();
    if(!(I = gdk_imlib_load_image(_F))) return;
    setXY();
    break;
  case 2:
    if(!I) return;
    clearWPB();
    adjust();
    break;
  case 3:
    if(!I) return;
    clearWPB();
    rotate();
    break;
  }

  if(M) adjustScreen();
  gdk_imlib_render(I, X, Y);
  B = gdk_imlib_copy_mask(I);
  P = gdk_imlib_move_image(I);
  W[1] = gtk_pixmap_new(P, B);
  if(M) gtk_widget_show_all(W[0]);
  else{
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(getPP()), W[1]);
    gtk_widget_hide (W[2]);
  }
}

void Image::clear()
{
  clearWPB();
  if(I) gdk_imlib_destroy_image(I);
  I = NULL;
}

void Image::clearWPB()
{
  if(W[1]) gtk_widget_destroy(W[1]);
  if(P) gdk_imlib_free_pixmap(P);
  if(B) gdk_imlib_free_bitmap(B);
  W[1] = NULL, P = NULL, B = NULL;
}

void Image::adjust()
{
  if(I->rgb_width > 400){
    X = I->rgb_height*400/I->rgb_width;
    Y = 400;
  }
  if(I->rgb_height > 500){
    Y = I->rgb_width*500/I->rgb_height;
    X = 500;
  }
  resize();
}

void Image::adjustScreen()
{
  X = gdk_screen_width();
  Y = gdk_screen_height();
  gtk_drawing_area_size (GTK_DRAWING_AREA (W[2]), X, Y);
  resize();
}

void Image::rotate()
{
  gdk_imlib_rotate_image(I, -1);
  setXY();
  resize();
}

void Image::resize()
{
  GdkImlibImage* i = gdk_imlib_clone_scaled_image(I, X, Y);
  gdk_imlib_destroy_image(I);
  I = NULL;
  I = i;
}

void Image::setMode(bool _M) { M = _M; }
void Image::hideRoot() { gtk_widget_hide_all(W[0]); }

void Image::motion(GtkWidget* _W, GdkEventMotion* _E, Image* _I)
{
  int x, y;
  GdkModifierType st;

  if (_E->is_hint)
    gdk_window_get_pointer (_E->window, &x, &y, &st);
  else {
    x = (int)_E->x;
    y = (int)_E->y;
    st = (GdkModifierType)_E->state;
  }
    
  if (st & GDK_BUTTON1_MASK && P != NULL)
    _I->draw(_W, x, y);
}

void Image::press(GtkWidget* _W, GdkEventButton* _E, Image* _I)
{
  switch(_E->button){
  case 2:
    _I->popUp(_E);
    break;
  }
}
void Image::popUp(GdkEventButton* _E)
{
  if(!Pm) newPop();
  if(Pm) Pm->popUp(_E);
}
void Image::newPop()
{
  if(!Pm) {
    char path[BUFSIZ];
    sprintf(path, "%s/ImagePop", Tsh->getD());

    if(FILE* fp = fopen(path, "r")) {
      Pm = new Pop(fp, NULL);
      fclose(fp);
    }
  }
}

gint Image::expose(GtkWidget* _W, GdkEventExpose* _E, Image* _I)
{
  gdk_draw_pixmap(_W->window, _W->style->fg_gc[GTK_WIDGET_STATE (_W)], P,
		  _E->area.x, _E->area.y, _E->area.x, _E->area.y,
		  _E->area.width, _E->area.height);

  return FALSE;
}

void Image::draw(GtkWidget* _W, gdouble _X, gdouble _Y)
{
  GdkRectangle r;

  r.x      = (int)_X - 5;
  r.y      = (int)_Y - 5;
  r.width  = 10;
  r.height = 10;

  gdk_draw_rectangle (P, _W->style->white_gc, TRUE,
		      r.x, r.y, r.width, r.height);

  gtk_widget_draw (_W, &r);
}
