#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TreeSh.h"
#include "Canvas.h"
#include "Util.h"
#include "CList.h"
#include "Text.h"
#include "Image.h"
#include "Form.h"

/*
 * Canvas: Constructr/Destructor
 */
Canvas::Canvas() : TshWgt()
{
  Cm = new CLMgr();
  T  = new Text();
  I  = new Image();
  F  = new FMgr();
}

/*
 * Public Members
 */
void Canvas::hideAll()
{
  clistHide();
  textHide();
  imageHide();
  formHide();
}

/*
 * clist
 */
void Canvas::clistRenew(GtkCTreeNode* _R) { Cm->renew(_R); }
void Canvas::clistAutoResize()            { Cm->autoResize(); }
void Canvas::clistClear()                 { Cm->clear(); }
void Canvas::clistShow()
{
  hideAll();
  Cm->show();
}
void Canvas::clistHide()                 { Cm->hide(); }
GtkWidget* Canvas::getPpC()              { return(Cm->getPp()); }

void Canvas::clistSet(CList* _C, bool _B)
{
  Cm->set(_C);
  if(_B) Tsh->addP2(getPpC());
}
void Canvas::clistAppend(GtkCTreeNode* _R) { Cm->append(_R); }
void Canvas::clistAppend(char* _S)         { Cm->append(_S); }

/*
 * text
 */
void Canvas::textShow()
{
  hideAll();
  T->show();
}
void Canvas::textHide()           { T->hide(); }
GtkWidget* Canvas::getPpT()       { return(T->getPP()); }
void Canvas::textInsert(char* _S) { T->insert(_S); }
void Canvas::textClear()          { T->clear(); }

/*
 * image
 */
void Canvas::imageShow()
{
  hideAll();
  I->show();
}
void Canvas::imageHide()                 { I->hide(); }
void Canvas::imageLoad(char* _F, int _B) { I->load(_F, _B); }
GtkWidget* Canvas::getPpI()              { return(I->getPP()); }
void Canvas::imageCanvas()
{
  I->setMode(false);
  I->hideRoot();
}
void Canvas::imageFullScreen()           { I->setMode(true); }

/*
 * form
 */
void Canvas::formShow()
{
  hideAll();
  F->show();
}
void Canvas::formHide()                  { F->hide(); }
GtkWidget* Canvas::getPpF()              { return(F->getPP()); }

void Canvas::formSet(Form* _F, bool _B)
{
  formHide();
  F->set(_F);
  if(_B) Tsh->addP2(getPpF());
  formShow();
}
