#include <stdio.h>
#include <string.h>

#include "CmdLine.h"
#include "TreeSh.h"
#include "Tree.h"
#include "Util.h"

int  CmdLine::K;

/*
 * CmdLine: Constructr/Destructor
 */
CmdLine::CmdLine() : TshWgt()
{
  E = gtk_entry_new();
  K = 0;
  
  GtkWidget* h = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start (GTK_BOX(h), gtk_label_new("Path:"), FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(h), E, TRUE, TRUE, 0);

  setPP(h);
  show();
  setEvents();
}

void CmdLine::setEvents()
{
  gtk_signal_connect (GTK_OBJECT(E), "key_release_event",
		      GTK_SIGNAL_FUNC(keyRelease), (gpointer)this);
}

/*
 * CmdLine: Public Members
 */
void CmdLine::keyRelease(GtkWidget* _W, GdkEventKey* _E, CmdLine* _C)
{
  char buf[BUFSIZ],* c;
  sprintf(buf, "%s", _C->getStr());

  switch(_E->keyval){
  case 65288: if(buf[strlen(buf)-1] == '/') Tsh->T->parent(); break; // BS
  case 65307: // Esc
    if(c = strrchr(buf, '/')) {
      c++;
      if(c) Tsh->T->complete(c);
    }
    break;
    /**
  case 65293: // Enter
    break;
    **/
  case 47:
    if(K == 47) c = "/";
    else {
      buf[strlen(buf)-1] = '\0';
      if(c = strrchr(buf, '/')) c++;
    }
    if(c) Tsh->T->find(c);
    break;
  }
  K = _E->keyval;
}

char* CmdLine::getStr()         { return(gtk_entry_get_text(GTK_ENTRY(E))); }
void  CmdLine::setStr()
{
  char buf[BUFSIZ],* s = Util::path(NULL, "/", 0, 0);
  sprintf(buf, "/%s/", s);
  
  gtk_entry_set_text(GTK_ENTRY(E), buf);
  delete [] s;
  s = NULL;
}
