#include "Window.h"
#include "TshObj.h"

/*
 * Constructr / Destructor
 */
Window::Window(int _W, int _H) : TshObj(Tsh)
{
  create();
  setSize(_W, _H);
  show();
  setEvents();
}
Window::~Window() {}

void Window::setEvents()
{
  gtk_signal_connect (GTK_OBJECT(W), "delete_event",
		      GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
}

/*
 * Public Members
 */
GtkWidget* Window::getW() { return W; }
void Window::create()
{
  W = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  P = gtk_hpaned_new ();

  for(int i=0; i<2; i++) V[i] = gtk_vbox_new(FALSE, 0);
  for(int i=0; i<3; i++) H[i] = gtk_hbox_new(FALSE, 0);

  gtk_container_set_border_width (GTK_CONTAINER(W), 5);

  gtk_box_pack_start (GTK_BOX(V[0]), H[0], FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(V[0]), H[1], FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(V[0]), H[2], TRUE, TRUE, 0);

  gtk_container_add (GTK_CONTAINER(H[2]), P);
  gtk_paned_add2(GTK_PANED(P), V[1]);

  gtk_container_add(GTK_CONTAINER(W), V[0]);
}
void Window::setSize(int _W, int _H) { gtk_widget_set_usize(W, _W, _H); }
void Window::show()
{
  gtk_widget_show (W);
  gtk_widget_show_all (V[1]);
  gtk_widget_show_all (V[0]);
}

/*
 * Menu
 */
void Window::packH(GtkWidget* _W, gboolean _B, int _H)
{
  gtk_box_pack_start (GTK_BOX(H[_H]), _W, _B, TRUE, 0);
}
void Window::addP1(GtkWidget* _W) { gtk_paned_add1(GTK_PANED(P), _W); }
void Window::addP2(GtkWidget* _W)
{
  gtk_box_pack_start (GTK_BOX(V[1]), _W, TRUE, TRUE, 0);
}
