#include <stdlib.h>  
#include <stdio.h>   
#include <string.h>   


char* infile;
char* outfile;

int  nPoint,nTri,i,v0,v1,v2;
double x,y,z;
char buf[1024];


int  main(int argc,char** argv){

  if(argc != 3){
    fprintf (stderr, "Usage : \n");
    fprintf (stderr, "%s pchFileName(in) wrlFileName(out) \n",argv[0]);
    exit (-1);
  }
   

  infile  = argv[1];
  outfile = argv[2];


  FILE* fin = fopen(infile,"r");
  if(fin == NULL)
    exit (-1);

  FILE* fout = fopen(outfile,"w");
  if(fout == NULL)
    exit (-1);


  /*  pch read & wrl write */


  /* wrl header */
  fprintf(fout, "%s\n", "#VRML V1.0 ascii");
  fprintf(fout, "%s\n", "DEF BackgroundColor Info { string \"1 1 1\"}");

  fprintf(fout, "%s\n", "Material { diffuseColor 0 1 1 }");

  /* Coordinate3 */
  fscanf (fin, "%d \n", &nPoint);

  fprintf(fout, "%s\n", "Coordinate3{");
  fprintf(fout, "%s\n", "  point[");

  for(i = 0; i < nPoint - 1 ;i++){
     fscanf (fin,    "%lf %lf %lf \n", &x,&y,&z);
     fprintf(fout,   "    %f %f %f ,\n",x,y,z);
  }
  fscanf (fin,    "%lf %lf %lf \n", &x,&y,&z);
  fprintf(fout, "    %f %f %f\n",x,y,z);
  fprintf(fout, "%s\n", "  ]");
  fprintf(fout, "%s\n", "}");



  fscanf (fin, "%d", &nTri);
  fprintf(fout, "%s\n", "IndexedFaceSet{");
  fprintf(fout, "%s\n", "  coordIndex[");

  for(i = 0; i < nTri - 1  ;i++){
    fscanf (fin, "%d %d %d", &v0,&v1,&v2);
    fprintf(fout, "    %d, %d, %d, -1,\n",v0,v1,v2);
  }
  fscanf (fin, "%d %d %d", &v0,&v1,&v2);
  fprintf(fout, "    %d, %d, %d, -1\n",v0,v1,v2);

  fprintf(fout, "%s\n", "  ]");
  fprintf(fout, "%s\n", "}");

  fclose(fin);
  fclose(fout);

  return 0;

}









