#include <stdlib.h>  
#include <stdio.h>   
#include <string.h>   
#include <math.h>   


char* infile;
char* outfile;


/* point info */
int  nPos;
double (*pos)[3];



void  vector_get_normal(double p0[3],double p1[3],double p2[3],double retNormal[3])
{
  double a[3];
  double b[3];
  double c[3];
  double norm;
  /* create vector */
  a[0] = p1[0] - p0[0]; a[1] = p1[1] - p0[1]; a[2] = p1[2] - p0[2];
  b[0] = p2[0] - p0[0]; b[1] = p2[1] - p0[1]; b[2] = p2[2] - p0[2];
  /* cross product */
  c[0] = a[1] * b[2] - a[2] * b[1];
  c[1] = a[2] * b[0] - a[0] * b[2];
  c[2] = a[0] * b[1] - a[1] * b[0];

  /* make unit vector */
  norm = sqrt(c[0]*c[0] + c[1]*c[1] + c[2]*c[2]);
  retNormal[0] = c[0] / norm;
  retNormal[1] = c[1] / norm;
  retNormal[2] = c[2] / norm;

}




int  main(int argc,char** argv)
{
  int  nTri,i,v0,v1,v2;
  double normalVec[3];


  if(argc != 3){
    fprintf (stderr, "Usage : \n");
    fprintf (stderr, "%s pchFileName(in) stlFileName(out) \n",argv[0]);
    exit (-1);
  }
   

  infile  = argv[1];
  outfile = argv[2];


  FILE* fin = fopen(infile,"r");
  if(fin == NULL)
    exit (-1);

  FILE* fout = fopen(outfile,"w");
  if(fout == NULL)
    exit (-1);


  /*  read postion */
  fscanf (fin, "%d \n",&nPos);
  pos=  (double (*)[3])calloc(nPos,sizeof(double[3]));

  for(i = 0; i < nPos ;i++){
    fscanf (fin,  "%lf %lf %lf \n",  &pos[i][0],&pos[i][1],&pos[i][2]);
  }

  /*  write stl */
  fprintf(fout, "solid trans3d\n");



  fscanf (fin, "%d \n", &nTri);
  for(i = 0; i < nTri ;i++){
    fscanf (fin, "%d %d %d", &v0,&v1,&v2);
    vector_get_normal(pos[v0], pos[v1], pos[v2], normalVec);
    
    fprintf(fout, "  facet normal %f %f %f\n",normalVec[0],normalVec[1],normalVec[2]);
    fprintf(fout, "    outer loop\n");
    fprintf(fout, "      vertex  %f %f %f\n",pos[v0][0],pos[v0][1],pos[v0][2]);
    fprintf(fout, "      vertex  %f %f %f\n",pos[v1][0],pos[v1][1],pos[v1][2]);
    fprintf(fout, "      vertex  %f %f %f\n",pos[v2][0],pos[v2][1],pos[v2][2]);
    fprintf(fout, "    endloop\n");
    fprintf(fout, "  endfacet\n");
  }

  fprintf(fout, "endsolid trans3d\n");

  fclose(fin);
  fclose(fout);

  return 0;

}









