#include <stdlib.h>  
#include <stdio.h>   
#include <string.h>   
#include <math.h>   

char* outfile;
char option[256];
int len,i;

/************************
 function for cube
************************/
static int  CUBE_TRI_MAP[12][3] = {
  { 4, 5, 6},{ 4, 6, 7},
  { 5, 1, 2},{ 5, 2, 6},
  { 0, 2, 1},{ 0, 3, 2},
  { 0, 7, 3},{ 0, 4, 7},
  { 7, 6, 2},{ 7, 2, 3},
  { 4, 1, 5},{ 4, 0, 1}
};

/* cube map

     v3-------------- v2
     /                /
    / |      y       / |
   /  |      ^      /  |
  v7--|------|-----v6  |
   |  |      *--> x |  |
   |  |   center    |  |
   | v0-------------|-- v1
   | /              | /
   |/               |/
   -----------------
  v4              v5

*/

int cube_create(char* option,FILE* fout)
{
  double xLen,yLen,zLen;
  double pos[8][3];
  int count = 0; 

  len = strlen(option);
   for(i = 0; i < len;i++){
     if((option[i] == 'x')||(option[i] == 'X')){
       option[i]=' ';
       count++;
     }
   }

   if(count != 2){
     printf("#ERR The option is not enough\n");
     exit(1);
   }

   sscanf(option,"%lf %lf %lf",&xLen,&yLen,&zLen);

   printf("create cube side=%f longitudinal=%f height=%f\n",xLen,yLen,zLen);

   pos[0][0] = 0.0; pos[0][1] = 0.0; pos[0][2] = 0.0;
   pos[1][0] = xLen;pos[1][1] = 0.0; pos[1][2] = 0.0;
   pos[2][0] = xLen;pos[2][1] = yLen;pos[2][2] = 0.0;
   pos[3][0] = 0.0; pos[3][1] = yLen;pos[3][2] = 0.0;
   pos[4][0] = 0.0; pos[4][1] = 0.0; pos[4][2] = zLen;
   pos[5][0] = xLen;pos[5][1] = 0.0; pos[5][2] = zLen;
   pos[6][0] = xLen;pos[6][1] = yLen;pos[6][2] = zLen;
   pos[7][0] = 0.0; pos[7][1] = yLen;pos[7][2] = zLen;

   fprintf(fout, "8\n");

   for(i = 0; i < 8;i++){
     fprintf(fout, "%f %f %f\n",pos[i][0],pos[i][1],pos[i][2]);
   }

   fprintf(fout, "12\n");

   for(i = 0; i < 12 ;i++){
      fprintf(fout, "%d %d %d\n",CUBE_TRI_MAP[i][0],CUBE_TRI_MAP[i][1],CUBE_TRI_MAP[i][2]);
   }

  return 0;
}

/************************
 function for cylinder
************************/
/*
 R(u) = c + r * (cos(u) * x + sin(u) * y) 
 c is center of upper circle.
 r is radius.
 x and y is unit vector of each axis.
 range of u is from 0.0 to 2*pi.
*/

void  get_curve_position(double c[3],double r,double u,double R[3])
{
  double x = 1.0;
  double y = 1.0;
  R[0] = c[0] + r * (cos(u) * x);
  R[1] = c[1] + r * (sin(u) * y);
  R[2] = c[2];
}

int cylinder_create(char* option,FILE* fout)
{
  double r,height;
  int count=0;
  int numSidePos = 100;
  int numLowerTri, numUpperTri, numSideTri;
  double incre = (2* M_PI) / numSidePos ;
  double u = 0.0;
  double degree = 0.0;
  double c[3];c[0]=0.0;c[1]=0.0;c[2]=0.0;
  double R[3];



  len = strlen(option);
   for(i = 0; i < len;i++){
     if((option[i] == 'x')||(option[i] == 'X')){
       option[i]=' ';
       count++;
     }
   }

   if(count == 0 || count > 3){
     printf("#ERR The option is not enough\n");
     exit(1);
   }


   if(count == 1){
     sscanf(option,"%lf %lf ",&r,&height);
     printf("create cylinder radius=%f height=%f\n",r,height);
   }

   if(count == 2){
     sscanf(option,"%lf %lf %d",&r,&height,&numSidePos);
     printf("create cylinder radius=%f height=%f division number of circle=%d\n",r,height,numSidePos);
     incre = (2* M_PI) / numSidePos ;
   }

   if(count == 3){
     sscanf(option,"%lf %lf %d %lf",&r,&height,&numSidePos,&degree);
     printf("create cylinder radius=%f height=%f division number of circle=%d\n degree=%f\n",r,height,numSidePos,degree);

    incre = ((degree * M_PI) / 180) / numSidePos ;
   }



   /* write pch format */
   fprintf(fout, "%d\n",numSidePos*2);

    /* position of lower circle  */
   for(i = 0; i < numSidePos;i++){
     get_curve_position(c,r,u,R);
     /* printf("c=(%f,%f,%f),r= %f,u=%f,R(%f,%f,%f)\n",c[0],c[1],c[2],r,u,R[0],R[1],R[2]); */
     fprintf(fout, "%f %f %f\n",R[0],R[1],R[2]);
     u +=incre;
   }
   
   /* position of upper circle  */
   c[2]=height;
   u = 0.0;   

   for(i = 0; i < numSidePos;i++){
     get_curve_position(c,r,u,R);     
     fprintf(fout, "%f %f %f\n",R[0],R[1],R[2]); 
     u +=incre;
   }


   numLowerTri = numSidePos-2;
   numUpperTri = numSidePos-2;
   numSideTri =  numSidePos*2;



   fprintf(fout, "%d\n",numLowerTri+numUpperTri+numSideTri);

  /* face of lower  */
   for(i = 0; i < numLowerTri ;i++){
     fprintf(fout, "%d %d %d\n",0,i+1,i+2);
   }
  /* face of side  */
   for(i = 0; i < numSidePos ;i++){
     /* last  */ 
     if( i == numSidePos -1){
       fprintf(fout, "%d %d %d\n",i,numSidePos+i,numSidePos);
       fprintf(fout, "%d %d %d\n",i,numSidePos,0);
       break;
     } 
     fprintf(fout, "%d %d %d\n",i,numSidePos+i,numSidePos+i+1);
     fprintf(fout, "%d %d %d\n",i,numSidePos+i+1,i+1);
   }

  /* face of upper  */
   for(i = 0; i < numUpperTri ;i++){
     fprintf(fout, "%d %d %d\n",numSidePos,numSidePos+i+2,numSidePos+i+1);
   }



  return 0;
}



int  main(int argc,char** argv){

  if(argc < 3){
    fprintf (stderr, "Usage : \n");
    fprintf (stderr, "%s  pchFileName(out) modelType option \n",argv[0]);
    fprintf (stderr, "modelType and option\n");
    fprintf (stderr, "  -cube  side x  longitudinal x height\n");
    fprintf (stderr, "  -cylinder  radius x  height\n");
    fprintf (stderr, "  -cylinder  radius x  height x division number of circle\n");
    fprintf (stderr, "  -cylinder  radius x  height x division number of circle x degree\n");
    fprintf (stderr, "ex-box)\n");
    fprintf (stderr, "%s result.pch -cube  10x20x60\n",argv[0]);
    fprintf (stderr, "ex-cylinder)\n");
    fprintf (stderr, "%s result.pch -cylinder  10x20\n",argv[0]);


    exit (-1);
  }

  outfile = argv[1];
  FILE* fout = fopen(outfile,"w");
  if(fout == NULL){
    return -1;
  }


  if(!strcmp("-cube",argv[2])){
    strcpy(option,argv[3]);
    cube_create(option,fout);
  }else{
     if(!strcmp("-cylinder",argv[2])){
       strcpy(option,argv[3]);
       cylinder_create(option,fout);
     }else{
       printf("#ERR The option is not enough\n");
       exit(1);
     }
  }


  fclose(fout);

  return 0;
}










