#include <stdlib.h>  
#include <stdio.h>   
#include <string.h>   
#include <math.h>   

/* point info */
int  nPos;
double (*pos)[3];

/* tri info */
int  nTri;
int (*tri)[3];

/* edge info */
/* 0 and 1 is number of vertex.
   2 is swap flag.
   3 was  connected face id.
*/
int  nEdge;
int (*edge)[4]; 

static int  TRI_EDGE_MAP[3][2] = {
  { 0, 1 },{ 1, 2 },{ 2, 0 }
};

/* analysis info */
int   solid = 1;
double  area = 0.0;
double  volume = 0.0;
double  minimum[3];
double  maximum[3];
char errFileName[256];

void print_err_edge_info(FILE* fout,char* reason,int edgeInfo[4])
{
  if(fout == NULL)
    return;
  
  if(edgeInfo[2] == 1){
    fprintf(fout,"%s:(%d,%d,%d)\n",reason,edgeInfo[1],edgeInfo[0],edgeInfo[3]);
  }else{ 
    fprintf(fout,"%s:(%d,%d,%d)\n",reason,edgeInfo[0],edgeInfo[1],edgeInfo[3]);
   }
}     
void print_err_vertex_info(FILE* fout,char* reason,int vertex)
{
  if(fout == NULL)
    return;
  fprintf(fout,"%s:(%d)\n",reason,vertex);
}     


int  compare(const void* x, const void* y)
{
  int* a = (int*)x; 
  int* b = (int*)y;
  
  /* a < b */
  if(a[0] < b[0]){
     return -1;
  }
  if(a[0] == b[0]) 
    if(a[1] < b[1]) 
      return -1;
  
  if(a[0] == b[0] && a[1] == b[1])
     return 0;

  return 1;
}

void solid_check()
{
  int i,j,w;
  int numEdeg = 0;
  nEdge = nTri * 3;
  /* for errFile */
  FILE* fout = NULL;
  /* check edge */
  int count = 1;
  int master = 0;
  int current = 1;
  int oCount=0;
 /* check vertex */
  int* vertexFlg;

  edge=  (int (*)[4])calloc(nEdge,sizeof(int[4]));

  /* make edge list */
  for(i = 0; i < nTri ;i++){
    for(j = 0; j < 3 ;j++){
      edge[numEdeg][0] = tri[i][TRI_EDGE_MAP[j][0]];
      edge[numEdeg][1] = tri[i][TRI_EDGE_MAP[j][1]];
      if(edge[numEdeg][0] > edge[numEdeg][1]){
        w = edge[numEdeg][0];
        edge[numEdeg][0] = edge[numEdeg][1];
        edge[numEdeg][1] = w;
        edge[numEdeg][2] = 1;
      }
      edge[numEdeg][3] = i;
      numEdeg++;
    }     
  }

  /* sort edge  */
  qsort(edge,nEdge,sizeof(int)*4,compare);

  if(strlen(errFileName)){
    fout = fopen(errFileName,"w");
    fprintf(fout,"#The error edge message is as follows.\n");
    fprintf(fout,"#reason: (start vertex id of edge ,end vertex id  of edge,connection face id)\n");
    fprintf(fout,"#The error vertex message is as follows.\n");
    fprintf(fout,"#reason: (vertex id)\n");

  }


  /* check degeneracy edge */
  for(i = 0; i < nEdge ;i++){
    if(edge[i][0] == edge[i][1]){
      print_err_edge_info(fout,"degeneracy edge", edge[i]);
    }
  }

  /* check connection of edge and face  */
  while(master <  nEdge){
    while(current < nEdge){
      if(edge[master][0] == edge[current][0] 
         && edge[master][1] == edge[current][1]){
        count++;
        current++;
      }else{
        break;
      }
    }

    /*free edge */
    if(count == 1){
      print_err_edge_info(fout,"free edge", edge[master]);
      solid = 0;
    }

    /* orient is illegal */
    if(count == 2){
      oCount += edge[master][2];
      oCount += edge[master+1][2];

      if(oCount != 1){
         print_err_edge_info(fout,"illegal(orient) edge", edge[master]);
         print_err_edge_info(fout,"illegal(orient) edge", edge[master+1]);
         solid = 0;
      }
      oCount = 0;
    }


    /* edge was connected to many faces */
    if(count > 2){
      for(i = master; i < current;i++){
        print_err_edge_info(fout,"many edge connected to face", edge[i]);
      }
      solid = 0;
    }
    master = current;
    current = master+1;
    count=1;
  }

  /* check free vertex  */
  vertexFlg =  (int*)calloc(nPos,sizeof(int));
  
  for(i = 0; i < nPos ;i++){
    vertexFlg[i] = 0;
  }

  for(i = 0; i < nTri ;i++){
    for(j = 0; j < 3 ;j++){
      vertexFlg[tri[i][j]] = 1;
    }
  }
  
  for(i = 0; i < nPos ;i++){
    if(vertexFlg[i] == 0){
      print_err_vertex_info(fout,"vertex is not used",i);
    }
  }

  /* free work data */
  free(edge);
  free(vertexFlg);

  if(fout != NULL){
    fclose(fout);
  }
}

void   boundBox_check()
{
  int i;

  minimum[0] = pos[0][0]; minimum[1] = pos[0][1]; minimum[2] = pos[0][2]; 
  maximum[0] = pos[0][0]; maximum[1] = pos[0][1]; maximum[2] = pos[0][2]; 

  for(i = 1; i < nPos ;i++){
    if(minimum[0] > pos[i][0]) minimum[0] = pos[i][0];
    if(maximum[0] < pos[i][0]) maximum[0] = pos[i][0];
    if(minimum[1] > pos[i][1]) minimum[1] = pos[i][1];
    if(maximum[1] < pos[i][1]) maximum[1] = pos[i][1];
    if(minimum[2] > pos[i][2]) minimum[2] = pos[i][2];
    if(maximum[2] < pos[i][2]) maximum[2] = pos[i][2];
  }

}  

void  print_analysis_info()
{

  printf("number of triangle: %d\n",nTri);
  printf("number of vertex: %d\n",nTri);

  if(solid){
    printf("solid: true\n");
    printf("area: %f\n",area);
    printf("volume: %f\n",volume);
  }else{
    printf("solid: false\n");
    printf("area: %f\n",area);
    printf("volume: unknown\n");
  }

  printf("x-axis minimum maximum:(%f,%f)\n",minimum[0],maximum[0]);
  printf("y-axis minimum maximum:(%f,%f)\n",minimum[1],maximum[1]);
  printf("z-axis minimum maximum:(%f,%f)\n",minimum[2],maximum[2]);
}

double tri_get_area(double p0[3],double p1[3],double p2[3])
{
  double a[3];
  double b[3];
  double c[3];
  /* create vector */ 
  a[0] = p1[0] - p0[0]; a[1] = p1[1] - p0[1]; a[2] = p1[2] - p0[2];
  b[0] = p2[0] - p0[0]; b[1] = p2[1] - p0[1]; b[2] = p2[2] - p0[2];
  /* cross product */ 
  c[0] = a[1] * b[2] - a[2] * b[1];
  c[1] = a[2] * b[0] - a[0] * b[2];
  c[2] = a[0] * b[1] - a[1] * b[0];

  /* area */ 
  return  sqrt(c[0]*c[0] + c[1]*c[1] + c[2]*c[2]) * 0.5;
}

double tetra_get_volume(double p0[3],double p1[3],double p2[3],double p3[3])
{
  return (    (p1[0] - p0[0]) * (p2[1] - p0[1]) * (p3[2] - p0[2])
	    + (p1[1] - p0[1]) * (p2[2] - p0[2]) * (p3[0] - p0[0])
	    + (p1[2] - p0[2]) * (p2[0] - p0[0]) * (p3[1] - p0[1])
	    - (p3[0] - p0[0]) * (p2[1] - p0[1]) * (p1[2] - p0[2])
	    - (p3[1] - p0[1]) * (p2[2] - p0[2]) * (p1[0] - p0[0])
	    - (p3[2] - p0[2]) * (p2[0] - p0[0]) * (p1[1] - p0[1])) / 6.0;
}


int  pch_read(char* infile)
{
  int i;  
  FILE* fin = fopen(infile,"r");
  if(fin == NULL){
    fprintf(stderr,"### ERR file not found (%s)\n",infile);
    exit (-1);
  }

  /*  pch read & pch write */
  fscanf (fin, "%d \n",&nPos);
  pos=  (double (*)[3])calloc(nPos,sizeof(double[3]));
 
  for(i = 0; i < nPos ;i++){
    fscanf (fin,"%lf %lf %lf \n", &pos[i][0],&pos[i][1],&pos[i][2]);
  }

  fscanf (fin, " %d \n", &nTri);
  tri=  (int (*)[3])calloc(nTri,sizeof(int[3]));

  for(i = 0; i < nTri ;i++){
    fscanf (fin, "%d %d %d", &tri[i][0],&tri[i][1],&tri[i][2]);
  }

  fclose(fin);
  return 0;

}


int  main(int argc,char** argv)
{
  int i;  
  char infile[256];
  double org[3];

  if(argc != 2 && argc != 4){
    fprintf (stderr, "Usage : \n");
    fprintf (stderr, "%s pchFileName(in) [-ef errFileName]\n",argv[0]);
    exit (-1);
  }
  errFileName[0] = '\0';

  if(argc == 4){
    if(strcmp("-ef",argv[2])){
      fprintf (stderr, "### ERR option\n");
      exit(1);
    }
    strcpy(errFileName,argv[3]);
  }

  strcpy(infile,argv[1]);
  pch_read(infile);


  /* sum of area */
  for(i = 0; i < nTri ;i++){
    area += tri_get_area(pos[tri[i][0]],pos[tri[i][1]],pos[tri[i][2]]);
  }

  /* sum of volume */
  org[0] = 0.0; org[1] = 0.0;org[2] = 0.0;
  for(i = 0; i < nTri ;i++){
    volume += fabs(tetra_get_volume(pos[tri[i][0]],pos[tri[i][1]],pos[tri[i][2]],org));
  }

  /* check of solid */
  solid_check();

  /* check bound box */
  boundBox_check();  

  print_analysis_info();
 
  return 0;

}




