/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: sample1.h,v 1.2 2009/01/31 13:26:27 suikan Exp $
 */

/*
 *  TvvO(1)̃wb_t@C
 */

#include <t_services.h>

/*
 *  e^XN̗Dx̒`
 */

#define MAIN_PRIORITY	5		/* C^XN̗Dx */
					/* HIGH_PRIORITY 荂邱 */

#define HIGH_PRIORITY	9		/* Ɏs^XN̗Dx */
#define MID_PRIORITY	10
#define LOW_PRIORITY	11

/*
 *  ^[Qbgˑ̒`iCPUOnh̋N@Ȃǁj
 */

#ifdef M68K

#define CPUEXC1		5		/* [ZO */
#define RAISE_CPU_EXCEPTION	syslog(LOG_NOTICE, "zerodiv = %d", 10 / 0)

#elif defined(SH3)

#define CPUEXC1		224		/* [hG[O */
#define RAISE_CPU_EXCEPTION	(*((volatile int *) 0xFFFFFEC1))

#elif defined(SH1)

#define CPUEXC1		9		/* CPUAhXG[O */
#define RAISE_CPU_EXCEPTION	(*((volatile int *) 0xFFFFFEC1))
#ifdef TOKIWA_SH1
#define	STACK_SIZE	512		/* ^XÑX^bNTCY */
#endif /* TOKIWA_SH1 */

#elif defined(ARMV4)

#define CPUEXC1		4		/* [hG[O */
#define RAISE_CPU_EXCEPTION	(*((volatile int *) 0xFFFFFEC1))

#elif defined(V850)

#elif defined(H8)

#undef CPUEXC1				/* CPUOnhT|[gȂ */

#elif defined(H8S)

#undef CPUEXC1				/* CPUOnhT|[gȂ */
#define LOOP_REF	4000L		/* xvp̃[v */

#elif defined(MICROBLAZE)

#undef CPUEXC1				/* CPUOnhT|[gȂ */
#define STACK_SIZE	2048		/* ^XÑX^bNTCY */

#elif defined(IA32)

#define CPUEXC1		0		/* [ZO */
#define RAISE_CPU_EXCEPTION   syslog(LOG_NOTICE, "zerodiv = %d", 10 / 0)
#define OMIT_VGET_TIM

#elif defined(TMS320C54X)

#undef CPUEXC1				/* CPUOnhT|[gȂ */
#define STACK_SIZE	320		/* ^XÑX^bNTCY */
#define LOOP_REF	500000L		/* xvp̃[v */

#elif defined(XSTORMY16)

#define CPUEXC1		0		/* ߗO */
#define RAISE_CPU_EXCEPTION	__asm__( ".hword 0x0006" )
#define OMIT_VGET_TIM			/* vxget_tim()͔T|[g */
#define LOOP_REF 	4000L		/* xvp̃[v */
#define STACK_SIZE	256		/* ^XÑX^bNTCY */
#define TASK_PORTID	2		/* SIO̓|[g2p */

#elif defined(MIPS3) || defined(MIPS64)

#define CPUEXC1     Bp      /* u[N|CgOi[Zɔj */
#define RAISE_CPU_EXCEPTION   syslog(LOG_NOTICE, "zerodiv = %d", 10 / 0)

#elif defined(M16C) && defined(OAKS16)

#define CPUEXC1     32      /* CPUOnhԍ */
#define RAISE_CPU_EXCEPTION asm("   int #32") /* \tgEFAݔ */
#define STACK_SIZE  512     /* ^XÑX^bNTCY */
#define TASK_PORTID 2       /* ͂VA|[gID */

#elif defined(M16C) && defined(OAKS16_MINI)

#define CPUEXC1     32      /* CPUOnhԍ */
#define RAISE_CPU_EXCEPTION asm("   int #32") /* \tgEFAݔ */
#define STACK_SIZE  384     /* ^XÑX^bNTCY */
#define TASK_PORTID 2       /* ͂VA|[gID */

#elif defined(M16C) && defined(M3029) 

#define CPUEXC1     32      /* CPUOnhԍ */
#define RAISE_CPU_EXCEPTION asm("   int #32") /* \tgEFAݔ */
#define STACK_SIZE  512     /* ^XÑX^bNTCY */
#define TASK_PORTID 1       /* ͂VA|[gID */

#elif defined(BLACKFIN)

#define CPUEXC1     0      /* CPUOnhԍ */
#define RAISE_CPU_EXCEPTION asm("excpt 0;") /* \tgEFAݔ */
#define STACK_SIZE  512     /* ^XÑX^bNTCY */
#define TASK_PORTID 1       /* ͂VA|[gID */

#elif defined(LINUX)

#undef CPUEXC1				/* CPUOnhT|[gȂ */
#define OMIT_VGET_TIM
#define LOOP_REF	4000000		/* xvp̃[v */

#elif defined(NIOS2)

#define CPUEXC1		0		  /* ߗO */
#define RAISE_CPU_EXCEPTION	  Asm("div zero, zero, zero");

#elif defined(M32C)

#define CPUEXC1 32 /* CPUOnhԍ */
#define RAISE_CPU_EXCEPTION asm(" int #32") /* \tgEFAݔ */
#define STACK_SIZE 512 /* ^XÑX^bNTCY */
#define TASK_PORTID 1 /* ͂VA|[gID */ 

#elif defined(M32R)

#define CPUEXC1 EXC_TRAP00
#define RAISE_CPU_EXCEPTION Asm("trap 0")

#elif defined(TLCS_900) && defined(ZUP_F16_EX)

#define CPUEXC1     3      /* CPUOnhԍ */
#define RAISE_CPU_EXCEPTION Asm("   swi 2") /* \tgEFAݔ */
#define STACK_SIZE  512     /* ^XÑX^bNTCY */
#define TASK_PORTID 1       /* ͂VA|[gID */
#define OMIT_VGET_TIM

#endif

/*
 *  ^[QbgɈˑ\̂萔̒`
 */

#ifndef TASK_PORTID
#define	TASK_PORTID	1		/* ͂VA|[gID */
#endif /* TASK_PORTID */

#ifndef STACK_SIZE
#define	STACK_SIZE	8192		/* ^XÑX^bNTCY */
#endif /* STACK_SIZE */

#ifndef LOOP_REF
#define LOOP_REF	1000000		/* xvp̃[v */
#endif /* LOOP_REF */

/*
 *  ֐̃vg^Cv錾
 */
#ifndef _MACRO_ONLY

extern void	task(VP_INT tskno);
extern void	main_task(VP_INT exinf);
extern void	tex_routine(TEXPTN texptn, VP_INT tskno);
extern void	cyclic_handler(VP_INT exinf);
extern void	cpuexc_handler(VP p_excinf);

#endif /* _MACRO_ONLY */
