/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cyclic.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	nh@\
 */

#ifndef _CYCLIC_H_
#define _CYCLIC_H_

#include "queue.h"
#include "time_event.h"

/*
 *  nhubN
 */
typedef struct cyclic_handler_initialization_block {
	ATR	cycatr;		/* nh */
	VP_INT	exinf;		/* nh̊g */
	FP	cychdr;		/* nh̋NԒn */
	RELTIM	cyctim;		/* nh̋N */
	RELTIM	cycphs;		/* nh̋Nʑ */
} CYCINIB;

/*
 *  nhǗubN
 */
typedef struct cyclic_handler_control_block {
	const CYCINIB *cycinib;	/* nhubNւ̃|C^ */
	BOOL	cycsta;		/* nh̓ */
	EVTTIM	evttim;		/* ɎnhN鎞 */
	TMEVTB	tmevtb;		/* ^CCxgubN */
} CYCCB;

/*
 *  nh@\̏
 */
extern void	cyclic_initialize(void);

/*
 *  nhN̂߂̃^CCxgubN̓o^
 */
extern void	tmevtb_enqueue_cyc(CYCCB *cyccb, EVTTIM evttim);

/*
 *  nhN[`
 */
extern void	call_cychdr(CYCCB *cyccb);

#endif /* _CYCLIC_H_ */
