/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: fc_bfd.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */


#include "base/filecontainer.h"

#include "base/message.h"

#include "bfd.h"
#include "libiberty.h"

#include <string>
#include <map>

using namespace std;


/*
 *  BFDgt@CReiNX
 */
class filecontainer_BFD : public filecontainer
{
protected:
    bfd * object;                           //IuWFNg
    map<string, asymbol *> symbol_table;    //pnbVǂ
    asymbol ** symbol_container;

public:
    filecontainer_BFD(void)  throw();
    ~filecontainer_BFD(void) throw();

    virtual bool attach_module(const char *);
    virtual bool change_endian(void * target, unsigned int size);
    virtual bool load_contents(void * dest, unsigned long address, unsigned int size);
    virtual unsigned long get_symbol_address(const char *);
    virtual const char * get_architecture(void);

} Instance_of_filecontainer_BFD;

filecontainer_BFD::filecontainer_BFD(void) throw()
{
    bfd_init();

    object = NULL;
    symbol_table.clear();
    symbol_container = NULL;
    instance = this;
}

filecontainer_BFD::~filecontainer_BFD(void) throw()
{
    if(object != NULL)
        bfd_close(object);
}

/*
 *  attach_module : ΏۃW[A^b`
 */
bool filecontainer_BFD::attach_module(const char * filename)
{
    char ** target_list;
    asymbol ** symbols;
    asymbol *  sym;
    int num_syms;
    boolean result;
    int i;

    if(object != NULL)
        bfd_close(object);
    symbol_table.clear();

        //W[I[v (Ǎp)
    object = bfd_openr(filename, "default");

        //^[Qbg
    target_list = (char **)bfd_target_list();
    result = bfd_check_format_matches(object, bfd_object, &target_list);
    if(result == 0)
        ExceptionMessage("Internel error: BFD could not recognize the target file format.","G[: BFD̓t@C̓ǂݏoɎs܂").throwException();

        //V{̃nbVǂ쐬
    symbols = (asymbol **)xmalloc( bfd_get_symtab_upper_bound(object) );
    num_syms = bfd_canonicalize_symtab(object, symbols);

    for(i=0;i<num_syms;i++)
    {
        sym = *(symbols+i);
        if(sym != NULL && sym->name != NULL && *(sym->name) != '\x0')
            symbol_table[string(sym->name)] = sym;
    }

    symbol_container = symbols;
    return true;
}

bool filecontainer_BFD::change_endian(void * target, unsigned int size)
{
        //zXg̓gƉ
    enum bfd_endian host_endian = BFD_ENDIAN_LITTLE;

    char * top, * tail;

    if(object == NULL)
        return false;

    if(object->xvec->byteorder == BFD_ENDIAN_UNKNOWN)
        return false;

/*
    unsigned int __work = 0x1;
    if( *(char *)__work == 0)
        host_endian = BFD_ENDIAN_BIG;
*/

    if(object->xvec->byteorder == host_endian)
        return true;

    /*
     *  C[v : bswapȂŁAfɏ
     */

    top  = (char *)target;
    tail = (char *)target+size -1;

    while(top < tail)
    {
        *top ^= *tail, *tail ^= *top, *top ^= *tail;
        top ++;
        tail --;
    }

    return true;
}


bool filecontainer_BFD::load_contents(void * dest, unsigned long address, unsigned int size)
{
    struct sec * section;

    if(object == 0)
        return false;

        //ΏۃAhXۗLZNVT
    section = object->sections;
    while(section != 0)
    {
        if(address - (unsigned long)section->vma <= section->_raw_size 
            && (section->flags & (SEC_ALLOC|SEC_HAS_CONTENTS)) == (SEC_ALLOC|SEC_HAS_CONTENTS))
        {
                //ǂݏo
            bfd_get_section_contents(object, section, dest, address - (unsigned long)section->vma, size);
            return true;
        }
        section = section->next;
    }

        //ǂɂȂ
    ExceptionMessage("Internel error: Memory read with unmapped address","G[; }bvĂȂAhXgă[hs܂").throwException();

    return false;
}


/*
 * get_symbol_address : V{AhXl擾
 */
unsigned long filecontainer_BFD::get_symbol_address(const char * symbol)
{
    map<string, asymbol *>::iterator scope;
    string symbol_name;

    if(object == 0)
        ExceptionMessage("Not initialized","Ă܂").throwException();

        //V{𐶐 ("_"Ƃ̏)
    if(object->xvec->symbol_leading_char != '\x0')
        symbol_name += object->xvec->symbol_leading_char;
    symbol_name += symbol;

    scope = symbol_table.find(symbol_name);
    if(scope == symbol_table.end())
        return 0;
        //Exception("Internal error: Unknown symbol [%s]","G[: sȃV{ [%s]").format(symbol_name.c_str());

        //Address = ZNVItZbgl + ZNVVMA
    return (*scope).second->value + (*scope).second->section->vma;
}

/*
 * get_architecture : A[LeN`̎擾
 */
const char * filecontainer_BFD::get_architecture(void)
{
    if(object == NULL)
        return "Unknown";

        //Ƃ肠^[QbgăA[LeN`ɂĂB
        // #ǂoi[ɂgĂȂ ̂Ƃ
    return object->xvec->name;
}

