/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: component.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/component.h,v 1.1 2009/01/31 05:27:37 suikan Exp $

#include "base/testsuite.h"
#include "base/singleton.h"
#include "base/except.h"
#include "base/message.h"
#include "base/option.h"
#include "base/collection.h"
#include "base/directorymap.h"

#include <list>
#include <map>

#ifndef COMPONENT_H
#define COMPONENT_H

class Component : public RuntimeObject
{
public:
        //R|[lg̋NDx
    enum tagProcessStage {
        INITIALIZE,                 //Ƃɂ^ɓ

        BEFORE_PARSE,               //p[XO
        PARSER,                     //p[T
        AFTER_PARSE,                //p[X

        PREDECESSOR,                //ėp̑O
        GENERAL_PURPOSE,            //ėp
        SUCCESSOR,                  //ėp̌

        BEFORE_CODEGENERATION,      //R[hO
        CODEGENERATOR,              //R[h
        AFTER_CODEGENERATION,       //R[h

        FINALIZE
    };

        //R|[lgɋʂ̃f[^/삷NX
    class ComponentInfo
    {
    protected:
        std::string                     banner;
        std::multimap<int, Component *> componentList;
        std::list<Component *>          activatedComponentList;

            //RXgN^ (eXgp)
        ComponentInfo(void) throw() {}
    public:
            //RXgN^
        SINGLETON_CONSTRUCTOR(ComponentInfo) {}

            //R|[lg̒ǉ
        bool addComponent(Component * component, int order) throw();

            //R|[lg̓o^
        void removeComponent(Component * component, int order) throw();     //̗Dx
        void removeComponent(Component * component) throw();                //Sĉ

            //R|[lg̋Nv
        bool activateComponent(Component * component) throw();

            //IvṼp[X
        void parseOption(OptionParameter & option);

            //R|[lg̋N
        void activateComponent(void);

            //ُ폈nh̋N
        void onFatalExit(void);

            //R|[lgTNĂ邩𔻒
        template<class T>
        bool isActive(void) const throw()
        {
            std::list<Component *>::const_iterator scope;

            scope = activatedComponentList.begin();
            while(scope != activatedComponentList.end()) {
                if(dynamic_cast<T *>(*scope) != 0)
                    return true;
                ++ scope;
            }
            return false;
        }

            //oi[ϐւ̃ANZT
        inline void setBanner(std::string src)
        {   banner = src;    }
        inline std::string getBanner(void) const
        {   return banner;   }


        TESTSUITE_PROTOTYPE(main)
    };


protected:
    static bool is_valid;       //R|[lg̏ɐǂtO

    /*
     *   Ɗ֐
     */

        //R|[lg̋N
    inline bool activateComponent(void) throw()
    {   return Singleton<ComponentInfo>::getInstance()->activateComponent(this);   }

        //ʓIȃIvV̏
    static void _parseCommonOption(OptionParameter & option) throw();


        //ɐsR|[lg̋N
    template<class T>
    static bool isActive(void) throw()
    {   
        bool result = false;
        ComponentInfo * info = Singleton<ComponentInfo>::getInstance(std::nothrow);
        if(info != 0)
            result = info->isActive<T>();
        return result;
    }


        /*
         *   ߋƂ̌݊̂߂̃p[^API
         */

    static bool findOption (const char * key1, const char * key2 = 0, std::string * = 0) throw();
    static bool checkOption(const char * key1, const char * key2 = 0) throw();
    static OptionParameter::OptionItem getOption  (const char * key1, const char * key2 = 0, bool dirty = true) throw();
    static OptionParameter::OptionItem mergeOption(const char * key1, const char * key2 = 0) throw();

public:
        //RXgN^
    Component(int order = GENERAL_PURPOSE) throw();

        //fXgN^
    virtual ~Component(void) throw();

        //L
    static bool isValid(void) throw()
    {   return is_valid && SingletonBase::isValid();   }

        //R|[lg̎s
    static void executeComponents(OptionParameter & option);
    static void executeComponents(int argc, char * argv []);

        //oi[ANZT
    static void        setBanner(std::string) throw(std::bad_alloc);
    static std::string getBanner(void)        throw(std::bad_alloc);

    /*
     *   Cxgnh
     */

        //IvṼp[X
    virtual void parseOption(OptionParameter &)
    { parseOption(*Singleton<Directory>::getInstance()); }
    
    virtual void parseOption(Directory &) {}

        //R|[lg̖{
    virtual void body(void)        { body(*Singleton<Directory>::getInstance()); }
    virtual void body(Directory &) {}

        //ُInh
    virtual void onFatalExit(void) {}



    TESTSUITE_PROTOTYPE(main)
};


#endif



