/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *   ADSP-BF533 UART ʰSIOɥ饤
 *
 *   ΥեϡTOPPERS/JSP 1.4.2 pdic/simple_sio/st16c2550.h
 *   ͡षμ̻ҤѹΤǤ롣
 */
#ifndef _UART_H_
#define _UART_H_

#include <t_config.h>

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
    UW reg_base;    	/* 쥸Υ١ɥ쥹 */
    UB dlm_val;     	/* ܡ졼Ⱦ̤   */
    UB dll_val;  	  	/* ܡ졼Ȳ̤   */
	UB set_ucen:1;		/* 1ΤȤGCTLUCEN1ˤ(ADSP-BF53xΤ) */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block {
    const SIOPINIB  *siopinib; /* ꥢI/OݡȽ֥å */
    VP_INT          exinf;     /* ĥ */
    BOOL    openflag;          /* ץѤߥե饰 */
    BOOL    sendflag;          /* ߥ֥͡ե饰 */
    BOOL    getready;          /* ʸ */
    BOOL    putready;          /* ʸǤ */
}SIOPCB;


/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND    1u      /* ǽХå */
#define SIO_ERDY_RCV    2u      /* ΥХå */


/*
 * ͥ뵯ưѤν(sys_putcѤ뤿)
 */
extern void uart_init(void);

/*
 *  ꥢI/OݡȤؤΥݡ󥰤Ǥν
 */
extern void uart_pol_putc(char c, ID siopid);


/*
 *  SIOɥ饤Фν롼
 */
extern void uart_initialize(void);


/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL uart_openflag(void);


/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB   *uart_opn_por(ID siopid, VP_INT exinf);


/*
 *  ꥢI/OݡȤΥ
 */
extern void uart_cls_por(SIOPCB *siopcb);


/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL uart_snd_chr(SIOPCB *siopcb, char c);


/*
 *  ꥢI/OݡȤʸ
 */
extern INT  uart_rcv_chr(SIOPCB *siopcb);


/*
 *  ꥢI/OݡȤΥХåε
 */
extern void uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  SIOγߥӥ롼
 */
extern void uart0_tx_isr(void);
extern void uart0_rx_isr(void);


/*
 *  ꥢI/OݡȤǽХå
 */
extern void uart_ierdy_snd(VP_INT exinf);


/*
 *  ꥢI/OݡȤμΥХå
 */
extern void uart_ierdy_rcv(VP_INT exinf);


#endif
