/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004 by Suikan
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  
 */


/*
 *	vZbTɈˑAvP[Vp̒`iBLACKfinpj
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD̃t@CC
 *  N[hOɁCt_stddef.h  itron.h CN[ĥŁC
 *  ɈˑĂ悢D
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#define BLACKFIN			/* vZbT */


/*
 *  VXeEC^[tF[XEC[
 */
 
/*
 *  vZbT̃GfBA
 */
#define	SIL_ENDIAN	SIL_ENDIAN_LITTLE	/* gGfBA */


/*
* 荞݃bN
*/

#define SIL_PRE_LOC		UINT _intmask_
#define SIL_LOC_INT()	asm volatile ( "cli %0;": "=d"(_intmask_) )
#define SIL_UNL_INT()	asm volatile ( "sti %0;": :"d"(_intmask_) )
 
 



#ifndef _MACRO_ONLY

/*
 *  ݁^CPUOnhԍ̌^
 */
typedef	UINT	INHNO;		/* ݃nhԍ */
typedef	UINT	EXCNO;		/* CPUOnhԍ */



/*
 *  ԑ҂
 *  VXeˑ SIL_DLY_TIM1SIL_DLY_TIM2`ĂB
 *  SIL_DLY_TIM1sil_dly_nsěĂяoI[o[wbh(nS)
 *  SIL_DLY_TIM2sil_dly_nsẽ[v̒(nS)
 */
void sil_dly_nse(UINT dlytim);



/*
 *  \]pVXe̎Q
 *  cycleJE^64rbg̒loB
 */
typedef	long long	SYSUTIM;	/* \]pVXe */

Inline  ER	vxget_tim(SYSUTIM *p_sysutim)
{
	unsigned int lo, hi;
	
	asm( "%0=CYCLES; %1=CYCLES2;" :"=d"(lo), "=d"(hi) );
	((unsigned int *)p_sysutim)[0] = lo;
	((unsigned int *)p_sysutim)[1] = hi;
	return(0);
}

/*
* VXeEEANZX
*/

VH sil_reh_mem(VP);
VW sil_rew_mem(VP);
VH sil_reh_lem(VP);
VW sil_rew_lem(VP);
VH sil_reh_bem(VP);
VW sil_rew_bem(VP);

void sil_wrh_mem(VP, VH);
void sil_wrw_mem(VP, VW);
void sil_wrh_lem(VP, VH);
void sil_wrw_lem(VP, VW);
void sil_wrh_bem(VP, VH);
void sil_wrw_bem(VP, VW);

inline void sil_wrb_iop( VP iop, VB data)
{
	sil_wrh_mem( iop, (UB)data );
}

inline void sil_wrh_iop( VP iop, VH data)
{
	sil_wrh_mem( iop, data );
}

inline void sil_wrw_iop( VP iop, VW data)
{
	sil_wrw_mem( iop, data );
}

inline void sil_wrh_lep( VP iop, VH data)
{
	sil_wrh_lem( iop, data );
}

inline void sil_wrw_lep( VP iop, VW data)
{
	sil_wrw_lem( iop, data );
}

inline void sil_wrh_bep(VP iop, VH data)	
{
	sil_wrh_bem( iop, data );
}

inline void sil_wrw_bep( VP iop, VW data)
{
	sil_wrw_bem( iop, data );
}

// DESTRUCTIVE_READsys_defs.hŒ`B 

// j󐫓ǂݏoWX^ɃANZXꍇ
// 荞݃bN
// 0xFFE06100 TBUFWX^

#define PROLOGUE \
	SIL_PRE_LOC;\
    if ( DESTRUCTIVE_READ(iop) )\
	    SIL_LOC_INT();

#define EPILOGUE \
	if ( DESTRUCTIVE_READ(iop) )\
    	SIL_UNL_INT();


inline VB sil_reb_iop(VP iop)
{
	VH temp;
	PROLOGUE
	
    temp = sil_reh_mem((VP)iop);

	EPILOGUE;
    return temp;
}

inline VH sil_reh_iop(VP iop)
{
	VH temp;
	PROLOGUE

    temp = sil_reh_mem((VP)iop);

	EPILOGUE;
    return temp;
}

inline VW sil_rew_iop(VP iop)
{
	VW temp;
	PROLOGUE

    temp = sil_rew_mem((VP)iop);

	EPILOGUE;
    return temp;
}


inline VH sil_reh_lep(VP iop)
{
	VH temp;
	PROLOGUE
	
    temp = sil_reh_lem((VP)iop);

    EPILOGUE;
    return temp;
}


inline VW sil_rew_lep(VP iop)
{
	VW temp;
	PROLOGUE
	
    temp = sil_rew_lem((VP)iop);

    EPILOGUE;
    return temp;
}

inline VH sil_reh_bep(VP iop)
{
	VH temp;
	PROLOGUE
	
    temp = sil_reh_bem((VP)iop);

	EPILOGUE;
    return temp;
}

inline VW sil_rew_bep(VP iop)
{
	VW temp;
	PROLOGUE
	
    temp = sil_rew_bem((VP)iop);

	EPILOGUE;
    return temp;
}

#undef PROLOGUE
#undef EPILOGUE

#endif /* _MACRO_ONLY */




#endif /* _CPU_DEFS_H_ */
