/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004 by Suikan
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  
 */


#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_


/*
 *  J[l̓ʖ̃l[
 */
#include <sys_rename.h>

/*
* {[hݒt@C̓ǂݍ
*/
#include <board_config.h>
 
/*
 *	^[QbgVXeˑW[iADSP-BF537pj
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
*/

/*
 *  ^[QbgVXẽn[hEFA̒`
 * 
 *  DEVICE_INTERRUPT_COUNTSIC_IMASK̃rbg
 *  ^B
 *  ADSP-BF537̃rbg32Ȃ̂ŁAl32łB
 */

#define DEVICE_INTERRUPT_COUNT 32
 


/*
 *  TICp^C}[̎
 */
#define PLLCLOCK (CLKIN*MSELVAL)
#define SYSCLOCK  (PLLCLOCK / SSELVAL)
#define CORECLOCK (PLLCLOCK / CSELVAL)



/*
 *  TIC̊݃nh̃xN^ԍ
 */
#ifdef USE_TIC_CORE
#define INHNO_TIMER	INHNO_CORE_TIMER
#else
#define INHNO_TIMER	INHNO_GP_TIMER7
#endif


/*
 *  VA|[g̒`
 *  pidc/simple_sio/uart.cŎgB
 */
#define TNUM_PORT	0	/* T|[gVA|[g̐ */
#define TNUM_SIOP	0	/* T|[gVA|[g̐ */

/*
 *  VA|[gԍɊւ`
 */
#define	LOGTASK_PORTID	0	/* VXeOɗpVA|[gԍ */


/*
 *  VA|[g̃{[[gɊւ`
 *
 *  UART̃{[[gWFl[^ɐݒ肷ׂlD
 *  pidc/simple_sio/uart.cŎgB
 */

#define DLH_VAL	SYSCLOCK/16/115200/256		/* 115200bpsiʁj*/
#define DLL_VAL	SYSCLOCK/16/115200%256		/* 115200bpsiʁj*/

/*
 *  VA|[g̃AhX
 *  pidc/simple_sio/uart.cŎgB
 *
 */
#define UART_0 0xFFC00400	// UART THR̃AhXB

/*
 *  ԑ҂̂߂̒`
 *  sil_dly_nsěĂяoI[o[wbhƃ[v{fB[TCN
 *  nSŕ\B֐cpu_support.asmɒ`ĂB
 *  SIL_DLY_TIM124TCNB32nS( 750MHz ), 40nS( 600MHz )
 *  SIL_DLY_TIM212TCNB16nS( 750MHz ), 20nS( 600MHz )
 */


#define	SIL_DLY_TIM1	(24*1000000000/CORECLOCK)
#define	SIL_DLY_TIM2	(12*1000000000/CORECLOCK)


/*
 *  荞݃xNgԍ
 *
 *  ̒`̓RtBO[Vt@CDEF_INḦƂĎg
 *  SIC_ISRɂrbgԍłB
 *
 */
#define INHNO_PLL				0
#define INHNO_DMA_ERROR			1
#define INHNO_PERIPHERAL_ERROR		2
#define INHNO_RTC			3
#define INHNO_PPI			4
#define INHNO_SPORT0_RX		5
#define INHNO_SPORT0_TX		6
#define INHNO_SPORT1_RX		7
#define INHNO_SPORT1_TX		8
#define INHNO_TWI			9
#define INHNO_SPI			10
#define INHNO_UART0_RX		11
#define INHNO_UART0_TX		12
#define INHNO_UART1_RX		13
#define INHNO_UART1_TX		14
#define INHNO_CAN_RX		15
#define INHNO_CAN_TX		16
#define INHNO_MAC_RX		17
#define INHNO_PORT_H_A		17
#define INHNO_MAC_TX		18
#define INHNO_PORT_H_B		18
#define INHNO_GP_TIMER0		19
#define INHNO_GP_TIMER1		20
#define INHNO_GP_TIMER2		21
#define INHNO_GP_TIMER3		22
#define INHNO_GP_TIMER4		23
#define INHNO_GP_TIMER5		24
#define INHNO_GP_TIMER6		25
#define INHNO_GP_TIMER7		26
#define INHNO_PORT_FG_A		27
#define INHNO_PORT_G_B		28
#define INHNO_MEMORY_DMA0	29
#define INHNO_MEMORY_DMA1	30
#define INHNO_WDG			31
#define INHNO_PORT_F_B		31

// SIC_ISRɂȂȊ荞
#ifdef USE_HW_ERROR
#define INHNO_HW_ERROR 		32
#endif
#define INHNO_GP_TIMER 		33
#define INHNO_RAISE 		34


/*
 *  SIC_ISR̊荞݂̃xN^ԍ
 *
 *  ̒`ena_int, dis_inẗƂĎgB
 */

#define INTNO_PLL				0
#define INTNO_DMA_ERROR			1
#define INTNO_PERIPHERAL_ERROR		2
#define INTNO_RTC			3
#define INTNO_PPI			4
#define INTNO_SPORT0_RX		5
#define INTNO_SPORT0_TX		6
#define INTNO_SPORT1_RX		7
#define INTNO_SPORT1_TX		8
#define INTNO_TWI			9
#define INTNO_SPI			10
#define INTNO_UART0_RX		11
#define INTNO_UART0_TX		12
#define INTNO_UART1_RX		13
#define INTNO_UART1_TX		14
#define INTNO_CAN_RX		15
#define INTNO_CAN_TX		16
#define INTNO_MAC_RX		17
#define INTNO_PORT_H_A		17
#define INTNO_MAC_TX		18
#define INTNO_PORT_H_B		18
#define INTNO_GP_TIMER0		19
#define INTNO_GP_TIMER1		20
#define INTNO_GP_TIMER2		21
#define INTNO_GP_TIMER3		22
#define INTNO_GP_TIMER4		23
#define INTNO_GP_TIMER5		24
#define INTNO_GP_TIMER6		25
#define INTNO_GP_TIMER7		26
#define INTNO_PORT_FG_A		27
#define INTNO_PORT_G_B		28
#define INTNO_MEMORY_DMA0	29
#define INTNO_MEMORY_DMA1	30
#define INTNO_WDG			31
#define INTNO_PORT_F_B		31



#ifndef _MACRO_ONLY

/*
* SIC_IARx͂āACxgʂƂɊ蓖ĂĂ銄荞
* ̃rbg}bvBSIC_IARx̃tB[hl͗D揇-7Ȃ̂
* ̕␳B
*/
void make_priority_mask( void );

/*
 *  ^[QbgVXeˑ̏
 */
extern void	sys_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgDROMj^^GDB STUBďoŎD
 */
extern void	sys_exit(void);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`DROMj^^GDB STUBďoŎ
 *  D
 */
extern void	sys_putc(char c);

/*
* SIC_IARx͂āACxgʂƂɊ蓖ĂĂ銄荞
* ̃rbg}bvBSIC_IARx̃tB[hl͗D揇-7Ȃ̂
* ̕␳B
*/
void make_priority_mask( void );

/*
 * 荞݂̋A֎~
 *
 */
typedef unsigned int INTNO; 
extern ER ena_int( INTNO intno );
extern ER dis_int( INTNO intno );

/*
 * 荞݃}XN̑
 *
 *
 */
typedef unsigned int IMS;
extern ER chg_ims( IMS ims );
extern ER get_ims( IMS * p_ims );


#endif /* _MACRO_ONLY */
#endif /* _SYS_CONFIG_H_ */
