/*
 * loadpolicy.c
 *
 * Load the policy on the disk into the kernel.
 *
 * Copyright (C) 2005-2006  NTT DATA CORPORATION
 *
 * Version: 1.3.1   2006/12/08
 *
 * This program loads policies from /etc/ccs/ directory.
 * You can call this program to reload policies after editing policy files.
 *
 */

#include "policy.h"

int main(int argc, char *argv[]) {
	int load_system_policy = 0;
	int load_exception_policy = 0;
	int load_domain_policy = 0;
	int refresh_policy = 0;
	if (access("/proc/ccs/policy/", F_OK)) {
		fprintf(stderr, "You can't run this program for this kernel.\n");
		return 0;
	}
	if (argc == 1) {
		goto usage;
	} else {
		int i;
		for (i = 1; i < argc; i++) {
			char *p = argv[i];
			char *s = strchr(p, 's');
			char *e = strchr(p, 'e');
			char *d = strchr(p, 'd');
			char *a = strchr(p, 'a');
			char *f = strchr(p, 'f');
			if (s || a) load_system_policy = 1;
			if (e || a) load_exception_policy = 1;
			if (d || a) load_domain_policy = 1;
			if (f) refresh_policy = 1;
			if (strcspn(p, "sedaf")) {
			usage: ;
				printf("%s [s][e][d][a][f]\n"
					   "s : Load system_policy.\n"
					   "e : Load exception_policy.\n"
					   "d : Load domain_policy.\n"
					   "a : Load all policies.\n"
					   "f : Delete on-memory policy before loading on-disk policy.\n\n", argv[0]);
				printf("Note that 'accept mode' might be unable to append permissions for this program if 'f' is used "
					   "because 'f' might delete 'domain for this program' and 'execute permission for parent domain'.\n");
				return 0;
			}
		}
	}
	if (chdir("/etc/ccs/")) {
		printf("Directory /etc/ccs/ doesn't exist.\n");
		return 1;
	}

	if (load_system_policy) {
		FILE *file_fp, *proc_fp;
		if ((file_fp = fopen("system_policy.txt", "r")) == NULL) {
			fprintf(stderr, "Can't open system_policy.txt\n");
			goto out_system;
		}
		if ((proc_fp = fopen("/proc/ccs/policy/system_policy", "w")) == NULL) {
			fprintf(stderr, "Can't open /proc/ccs/policy/system_policy\n");
			fclose(file_fp);
			goto out_system;
		}
		if (refresh_policy) {
			FILE *proc_clear_fp = fopen("/proc/ccs/policy/system_policy", "r");
			if (!proc_clear_fp) {
				fprintf(stderr, "Can't open /proc/ccs/policy/system_policy\n");
				fclose(file_fp);
				fclose(proc_fp);
				goto out_system;
			}
			while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 1, proc_clear_fp) != NULL) {
				char *cp = strchr(buffer, '\n');
				if (cp) *cp = '\0';
				else if (!feof(proc_clear_fp)) break;
				NormalizeLine(buffer);
				if (buffer[0]) fprintf(proc_fp, "delete %s\n", buffer);
			}
			fclose(proc_clear_fp);
			fflush(proc_fp);
		}
		while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 1, file_fp) != NULL) {
			char *cp = strchr(buffer, '\n');
			if (cp) *cp = '\0';
			else if (!feof(file_fp)) break;
			NormalizeLine(buffer);
			if (buffer[0]) fprintf(proc_fp, "%s\n", buffer);
		}
		fclose(proc_fp);
		fclose(file_fp);
	}
 out_system: ;
	
	if (load_exception_policy) {
		FILE *file_fp, *proc_fp;
		if ((file_fp = fopen("exception_policy.txt", "r")) == NULL) {
			fprintf(stderr, "Can't open exception_policy.txt\n");
			goto out_exception;
		}
		if ((proc_fp = fopen("/proc/ccs/policy/exception_policy", "w")) == NULL) {
			fprintf(stderr, "Can't open /proc/ccs/policy/exception_policy\n");
			fclose(file_fp);
			goto out_exception;
		}
		if (refresh_policy) {
			FILE *proc_clear_fp = fopen("/proc/ccs/policy/exception_policy", "r");
			if (!proc_clear_fp) {
				fprintf(stderr, "Can't open /proc/ccs/policy/exception_policy\n");
				fclose(file_fp);
				fclose(proc_fp);
				goto out_exception;
			}
			while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 1, proc_clear_fp) != NULL) {
				char *cp = strchr(buffer, '\n');
				if (cp) *cp = '\0';
				else if (!feof(proc_clear_fp)) break;
				NormalizeLine(buffer);
				if (buffer[0]) fprintf(proc_fp, "delete %s\n", buffer);
			}
			fclose(proc_clear_fp);
			fflush(proc_fp);
		}
		while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 1, file_fp) != NULL) {
			char *cp = strchr(buffer, '\n');
			if (cp) *cp = '\0';
			else if (!feof(file_fp)) break;
			NormalizeLine(buffer);
			if (buffer[0]) fprintf(proc_fp, "%s\n", buffer);
		}
		fclose(proc_fp);
		fclose(file_fp);
	}
 out_exception: ;

	if (load_domain_policy) {
		int new_index;
		FILE *proc_fp = fopen("/proc/ccs/policy/domain_policy", "w");
		if (!proc_fp) {
			fprintf(stderr, "Can't open /proc/ccs/policy/domain_policy\n");
			goto out_domain;
		}
		ReadDomainPolicy("domain_policy.txt", 0);
		ReadDomainPolicy("/proc/ccs/policy/domain_policy", 1);
		if (domain_list_count[0] == 0) {
			fprintf(stderr, "Can't open domain_policy.txt\n");
			fclose(proc_fp);
			goto out_domain;
		}
		for (new_index = 0; new_index < domain_list_count[0]; new_index++) {
			const char *domainname = domain_list[0][new_index].domainname;
			const char **new_string_ptr = domain_list[0][new_index].string_ptr;
			const int new_string_count = domain_list[0][new_index].string_count;
			const int old_index = FindDomain(domainname, 1);
			int i, j;
			if (refresh_policy && old_index >= 0) {
				/* Old policy for this domain found. */
				const char **old_string_ptr = domain_list[1][old_index].string_ptr;
				const int old_string_count = domain_list[1][old_index].string_count;
				fprintf(proc_fp, "select %s\n", domainname);
				for (j = 0; j < old_string_count; j++) {
					for (i = 0; i < new_string_count; i++) {
						if (new_string_ptr[i] == old_string_ptr[j]) break;
					}
					/* Delete this entry from old policy if not found in new policy. */
					if (i == new_string_count) fprintf(proc_fp, "delete %s\n", old_string_ptr[j]);
				}
			} else {
				/* Old policy for this domain not found or Append to old policy. */
				fprintf(proc_fp, "%s\n", domainname);
			}
			for (i = 0; i < new_string_count; i++) fprintf(proc_fp, "%s\n", new_string_ptr[i]);
			if (old_index >= 0) domain_list[1][old_index].domainname = ""; /* Don't delete this domain later. */
		}
		if (refresh_policy) {
			int old_index;
			/* Delete all domains that are not defined in new policy. */
			for (old_index = 0; old_index < domain_list_count[1]; old_index++) {
				if (domain_list[1][old_index].domainname[0]) fprintf(proc_fp, "delete %s\n", domain_list[1][old_index].domainname);
			}
		}
		fclose(proc_fp);
	}
 out_domain: ;

	return 0;
}
