#! /bin/sh

export PATH=/root/ccstools/kernel_test/:${PATH}

echo "Testing all. (All results are reported)"
newns sakura_trace_test
newns sakura_filesystem_test
newns sakura_capability_test
newns sakura_bind_test
#newns tomoyo_info_test
newns tomoyo_file_test
newns tomoyo_capability_test
newns tomoyo_signal_test
newns tomoyo_port_test
#newns tomoyo_name_test
echo 
echo
echo
echo "Testing all. (Only ERRORS are reported)"
pipegrep MISSING 'newns sakura_trace_test' || echo "SAKURA: Trace Test OK"
pipegrep BUG 'newns sakura_filesystem_test'|| echo "SAKURA: Filesystem Test OK"
pipegrep BUG 'newns sakura_capability_test' || echo "SAKURA: Capabiliy Test OK"
pipegrep BUG 'newns sakura_bind_test' || echo "SAKURA: Bind Test OK"
#newns tomoyo_info_test
pipegrep BUG 'newns tomoyo_file_test' || echo "TOMOYO: File Test OK"
pipegrep BUG 'newns tomoyo_capability_test' || echo "TOMOYO: Capability Test OK"
pipegrep BUG 'newns tomoyo_signal_test' || echo "TOMOYO: Signal Test OK"
pipegrep BUG 'newns tomoyo_port_test' || echo "TOMOYO: Bind and Connect Test OK"
#newns tomoyo_name_test
