
/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2006 Kouhei Sutou <kou@cozmixng.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA  02111-1307  USA
 *
 *  $Id: tomoe-recognizer.c,v 1.18 2006/11/29 02:53:11 kous Exp $
 */

#include <stdlib.h>

#include "tomoe-module.h"
#include "tomoe-recognizer.h"

static GList *recognizers = NULL;

void
tomoe_recognizer_load (const gchar *base_dir)
{
    if (!base_dir)
        base_dir = RECOGNIZERDIR;

    recognizers = g_list_concat (tomoe_module_load_modules (base_dir),
                                 recognizers);
}

void
tomoe_recognizer_unload (void)
{
    g_list_foreach (recognizers, (GFunc) g_object_unref, NULL);
    g_list_free (recognizers);
    recognizers = NULL;
}

G_DEFINE_ABSTRACT_TYPE (TomoeRecognizer, tomoe_recognizer, G_TYPE_OBJECT)

static void
tomoe_recognizer_class_init (TomoeRecognizerClass *klass)
{
    klass->search = NULL;
}

static void
tomoe_recognizer_init (TomoeRecognizer *recognizer)
{
}

TomoeRecognizer *
tomoe_recognizer_new (const gchar *name, const gchar *first_property, ...)
{
    GObject *recognizer;
    va_list var_args;

    va_start (var_args, first_property);
    recognizer = tomoe_module_instantiate (recognizers, name,
                                           first_property, var_args);
    va_end (var_args);

    return TOMOE_RECOGNIZER (recognizer);
}

GList *
tomoe_recognizer_search (TomoeRecognizer *recognizer,
                         TomoeDict *dict, TomoeWriting *input)
{
    TomoeRecognizerClass *klass;

    g_return_val_if_fail (TOMOE_IS_RECOGNIZER (recognizer), NULL);

    klass = TOMOE_RECOGNIZER_GET_CLASS (recognizer);
    if (klass->search)
        return klass->search (recognizer, dict, input);
    else
        return NULL;
}

/*
vi:ts=4:nowrap:ai:expandtab
*/
