/**
 * Title: PrinterAttributesPanel
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.5
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.settings;

import java.awt.*;
import java.awt.event.*;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.*;
import java.awt.print.*;

import je.tn5250j.tools.*;
import je.tn5250j.SessionConfig;
import je.tn5250j.TN5250jConstants;
import je.tn5250j.gui.*;

public class PrinterAttributesPanel extends AttributesPanel implements ItemListener {

	JComboBox printerList;
	JCheckBox selectPrinter;

	JCheckBox defaultPrinter;

	JCheckBox showPrintDialog;
	JPanel ppp;
	JButton setPortAttributes;
	JButton setLandAttributes;
	Paper pappyPort;
	Paper pappyLand;
	JComboBox fontsList;
	TN5250jFontsSelection fs;
	protected int orientation80, orientation132;

	public PrinterAttributesPanel(SessionConfig config) {
		super(config, "Printer");
	}

	/**Component initialization*/
	public void initPanel() throws Exception {

		setLayout(new BorderLayout());
		contentPane = new JPanel();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		add(contentPane, BorderLayout.NORTH);

		// chg start pei 060929
		ppp = new JPanel();
		ppp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.print")));
		ppp.setLayout(new BorderLayout());
		
		// defaultPrinterpl	
		JPanel dpPanel = new JPanel();
		//defaultPrinter = new JCheckBox(LangTool.getString("sa.defaultPrinter"));
		defaultPrinter = new JCheckBox(LangTool.getString("sa.defaultPrinter"));
		defaultPrinter.addItemListener(this);
		
		dpPanel.add(defaultPrinter);

		// printerListpl
		JPanel psPanel = new JPanel();

		printerList = new JComboBox();
		printerList.setEnabled(false);
		PrintService[] ps;
		
		// chg pei 060223 Error Catch AppletΉ
		try{
			ps = PrintServiceLookup.lookupPrintServices(null, null);
		} catch(Error err) {
			ps = null;	
		}

		if (ps != null) {
			if (ps.length > 0) {
				for (int i=0; i<ps.length; i++) {
					printerList.addItem(ps[i].getName());
				}
			}
		} else {
			printerList.addItem("");
		}
		
		if (getStringProperty("print.printer").length() != 0) {
			printerList.setSelectedItem(getStringProperty("print.printer"));
		}
		psPanel.add(printerList);		
		
		// _CAO\pl
		JPanel pdPanel = new JPanel();
		showPrintDialog = new JCheckBox(LangTool.getString("sa.showPrintDialog"));

		if (getStringProperty("defaultPrinter").equals("Yes")) {
			defaultPrinter.setSelected(true);
			showPrintDialog.setEnabled(false);
			printerList.setEnabled(false);
		} else {
			defaultPrinter.setSelected(false);
			showPrintDialog.setEnabled(true);
			printerList.setEnabled(true);
		}
		if (getStringProperty("showPrintDialog").equals("Yes")) {
			showPrintDialog.setSelected(true);
		} else {
			showPrintDialog.setSelected(false);
		}
		
		pdPanel.add(showPrintDialog);

		ppp.add(dpPanel, BorderLayout.NORTH);
		ppp.add(pdPanel, BorderLayout.CENTER);
		ppp.add(psPanel, BorderLayout.SOUTH);

// chg end

		//--- Create a printerJob object
		PrinterJob printJob = PrinterJob.getPrinterJob();

		// will have to remember this for the next time.
		//   Always set a page format before call setPrintable to
		//   set the orientation.
		PageFormat pf = printJob.defaultPage();

		pappyPort = pf.getPaper();

		pappyLand = pf.getPaper();

		// Portrait paper parameters
		if (getStringProperty("print.portWidth").length() != 0
			&& getStringProperty("print.portHeight").length() != 0
			&& getStringProperty("print.portImageWidth").length() != 0
			&& getStringProperty("print.portImageHeight").length() != 0
			&& getStringProperty("print.portImage.X").length() != 0
			&& getStringProperty("print.portImage.Y").length() != 0) {

			pappyPort.setSize(
				Double.parseDouble(getStringProperty("print.portWidth")),
				Double.parseDouble(getStringProperty("print.portHeight")));

			pappyPort.setImageableArea(
				Double.parseDouble(getStringProperty("print.portImage.X")),
				Double.parseDouble(getStringProperty("print.portImage.Y")),
				Double.parseDouble(getStringProperty("print.portImageWidth")),
				Double.parseDouble(getStringProperty("print.portImageHeight")));
		}

		String so= getStringProperty("print.Orientation80");
		if (so == null || so.length() == 0) {
			orientation80= PageFormat.PORTRAIT;
		} else {
			orientation80= Integer.parseInt(so);
		}
			
		// Landscape paper parameters
		if (getStringProperty("print.landWidth").length() != 0
			&& getStringProperty("print.landHeight").length() != 0
			&& getStringProperty("print.landImageWidth").length() != 0
			&& getStringProperty("print.landImageHeight").length() != 0
			&& getStringProperty("print.landImage.X").length() != 0
			&& getStringProperty("print.landImage.Y").length() != 0) {

			pappyLand.setSize(
				Double.parseDouble(getStringProperty("print.landWidth")),
				Double.parseDouble(getStringProperty("print.landHeight")));

			pappyLand.setImageableArea(
				Double.parseDouble(getStringProperty("print.landImage.X")),
				Double.parseDouble(getStringProperty("print.landImage.Y")),
				Double.parseDouble(getStringProperty("print.landImageWidth")),
				Double.parseDouble(getStringProperty("print.landImageHeight")));
		}

		so= getStringProperty("print.Orientation132");
		if (so == null || so.length() == 0) {
			orientation132= PageFormat.LANDSCAPE;
		} else {
			orientation132= Integer.parseInt(so);
		}

		// define page panel
		JPanel page = new JPanel();
		page.setBorder(
			BorderFactory.createTitledBorder(
				LangTool.getString("sa.pageParameters")));

		page.setLayout(new BorderLayout());
		setPortAttributes = new JButton(LangTool.getString("sa.columns24"));

		setPortAttributes
			.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getPortraitAttributes();
			}
		});

		setLandAttributes = new JButton(LangTool.getString("sa.columns132"));

		setLandAttributes
			.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getLandscapeAttributes();
			}
		});

		// now create page dialog holder panel
		JPanel pagePage = new JPanel();

		pagePage.add(setPortAttributes);
		pagePage.add(setLandAttributes);
		page.add(pagePage, BorderLayout.NORTH);

		// now create fonts selection
		JPanel pageFont = new JPanel();
		fs = new TN5250jFontsSelection();

// chg start pei 060816 ftHgtHgɉʃtHgݒ肷
		if (getStringProperty("print.font").length() != 0) {
			fs.setSelectedItem(getStringProperty("print.font"));
		} else {
			fs.setSelectedItem(getStringProperty("font"));	
		}
// chg end
		pageFont.add(fs);
		page.add(pageFont, BorderLayout.SOUTH);
		
		contentPane.add(ppp);
		contentPane.add(page);
	}

	private void getPortraitAttributes() {

		PrinterJob printJob = PrinterJob.getPrinterJob();

		PageFormat documentPageFormat = new PageFormat();
		documentPageFormat.setOrientation(orientation80);
		documentPageFormat.setPaper(pappyPort);

		documentPageFormat = printJob.pageDialog(documentPageFormat);

		orientation80= documentPageFormat.getOrientation();
		setProperty("print.Orientation80", Integer.toString(orientation80));
		
		pappyPort = documentPageFormat.getPaper();

	}

	private void getLandscapeAttributes() {

		PrinterJob printJob = PrinterJob.getPrinterJob();

		PageFormat documentPageFormat = new PageFormat();
		documentPageFormat.setOrientation(orientation132);
		documentPageFormat.setPaper(pappyLand);

		documentPageFormat = printJob.pageDialog(documentPageFormat);

		orientation132= documentPageFormat.getOrientation();
		setProperty("print.Orientation132", Integer.toString(orientation132));
		pappyLand = documentPageFormat.getPaper();

	}

	public void save() {

	}

	public boolean applyAttributes() {

		if (defaultPrinter.isSelected()) {
			changes.firePropertyChange(
				this,
				"defaultPrinter",
				getStringProperty("defaultPrinter"),
				"Yes");
			setProperty("defaultPrinter", "Yes");
		} else {
			changes.firePropertyChange(
				this,
				"defaultPrinter",
				getStringProperty("defaultPrinter"),
				"No");
			setProperty("defaultPrinter", "No");
		}
		// portrait parameters
		propChangesub("print.portWidth", pappyPort.getWidth());

		propChangesub("print.portImageWidth", pappyPort.getImageableWidth());

		propChangesub("print.portHeight", pappyPort.getHeight());

		propChangesub("print.portImageHeight", pappyPort.getImageableHeight());

		propChangesub("print.portImage.X", pappyPort.getImageableX());

		propChangesub("print.portImage.Y", pappyPort.getImageableY());
		
		// landscape parameters
		propChangesub("print.landWidth", pappyLand.getWidth());

		propChangesub("print.landImageWidth", pappyLand.getImageableWidth());

		propChangesub("print.landHeight", pappyLand.getHeight());

		propChangesub("print.landImageHeight", pappyLand.getImageableHeight());

		propChangesub("print.landImage.X", pappyLand.getImageableX());

		propChangesub("print.landImage.Y", pappyLand.getImageableY());

		if (fs.getSelectedItem() != null) {
			changes.firePropertyChange(
				this,
				"print.font",
				getStringProperty("print.font"),
				(String) fs.getSelectedItem());
			setProperty("print.font", (String) fs.getSelectedItem());
		}

		if (printerList.getSelectedItem() != null) {
			changes.firePropertyChange(
				this,
				"print.printer",
				getStringProperty("print.printer"),
				(String) printerList.getSelectedItem());
			setProperty("print.printer", (String) printerList.getSelectedItem());
		}

		if (showPrintDialog.isSelected()) {
			changes.firePropertyChange(
				this,
				"showPrintDialog",
				getStringProperty("showPrintDialog"),
				"Yes");
			setProperty("showPrintDialog", "Yes");
		} else {
			changes.firePropertyChange(
				this,
				"showPrintDialog",
				getStringProperty("showPrintDialog"),
				"No");
			setProperty("showPrintDialog", "No");
		}
		return (true);
	}

	protected void propChangesub(String nm, double val) {
		String wk = getStringProperty(nm);
		if (wk.length() == 0) {
			wk = "0";
		}
		changes.firePropertyChange(this, nm, new Double(wk), new Double(val));
		setProperty(nm, Double.toString(val));
	}
	
	public void itemStateChanged(ItemEvent e) {
		JCheckBox source = (JCheckBox)e.getItemSelectable();
		
		if (e.getStateChange() == ItemEvent.SELECTED){
			printerList.setEnabled(false);
			showPrintDialog.setEnabled(false);
        }else if (e.getStateChange() == ItemEvent.DESELECTED){
        	printerList.setEnabled(true);
        	showPrintDialog.setEnabled(true);
        }
	}
}