/**
 * Title: JumpPrevAction.java
 * Copyright:   Copyright (c) 2001,2002
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.5
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.keyboard.actions;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import java.awt.event.ActionEvent;

import je.tn5250j.TN5250jConstants;
import je.tn5250j.Session;
import je.tn5250j.keyboard.KeyMapper;

/**
 * Jump to the Previous session action
 */
public class JumpPrevAction extends EmulatorAction implements TN5250jConstants {

   public JumpPrevAction(Session session, KeyMapper keyMap) {
      super(session,
            MNEMONIC_JUMP_PREV,
            KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN,KeyEvent.ALT_MASK),
            keyMap);

   }

   public void actionPerformed(ActionEvent e) {

      session.prevSession();
   }
}