/*
 *  Added NOV/2005 By pei
 */
package je.tn5250j.event;

import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class ProgMouseButton {
	private byte flag;
	private byte ev1;
	private byte ev2;
	private byte aid;
	private int sts;
	private int pos1;
	private int pos2;

	public ProgMouseButton(byte b1, byte b2, byte b3, byte b4){
		super();
		flag= b1;
		ev1= b2;
		ev2= b3;
		aid= b4;
		sts= 0;
   }

	public int checkEvent(MouseEvent e, int pos) {
		if ((flag & 0x80) == 0) {		// single-event
			if (check(e, ev1)) {
				pos2= pos1= pos;
				return(2);
			}
		} else {						// two-event
			if (sts == 0) {
				if (check(e, ev1)) {
					sts= 1;
					pos1= pos;
					return(1);
				}
			} else {
				if (check(e, ev2)) {
					pos2= pos;
					return(2);
				}
				// add pei 060901
				sts= 0;
			}
		}
		return (0);
	}
	
	private boolean check(MouseEvent e, byte ev) {
		boolean ret= false;
		switch (ev) {
			case 1:
				ret= e.getID() == MouseEvent.MOUSE_PRESSED && SwingUtilities.isLeftMouseButton(e);
				break;
			case 2:
				ret= e.getID() == MouseEvent.MOUSE_RELEASED && SwingUtilities.isLeftMouseButton(e);
				break;
			case 3:
				ret= e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e);
				break;
			case 4:
				ret= e.getID() == MouseEvent.MOUSE_PRESSED && SwingUtilities.isRightMouseButton(e);
				break;
			case 5:
				ret= e.getID() == MouseEvent.MOUSE_RELEASED && SwingUtilities.isRightMouseButton(e);
				break;
			case 6:
				ret= e.getClickCount() == 2 && SwingUtilities.isRightMouseButton(e);
				break;
		}
		return (ret);
	}

	public int getAid() {
		return (aid & 0xff);
	}

	public boolean isSingle() {
		return ((flag & 0x80) == 0);
	}
	
	public int getPos1() {
		return (pos1);
	}
	
	public int getPos2() {
		return (pos2);
	}
	
	public byte getFlag() {
		return(flag);
	}
	
	public byte getEV1() {
		return(ev1);
	}
	
	public byte getEV2() {
		return(ev2);
	}
	
}
