/**
 * Title: JavaCodePage
 * Copyright:   Copyright (c) 2001, 2002, 2003
 * Company:
 * @author  LDC, WVL, Luc
 * @version 0.4
 * 
 * Modified by pei DEC/2004
 * 
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.encoding;

import java.io.UnsupportedEncodingException;
import java.io.CharConversionException;
import sun.io.CharToByteConverter;
import sun.io.ByteToCharConverter;

class JavaCodePage extends CodePage {
	protected UniCodePage unicp;
	protected byte [] dbspace= {0x40, 0x40};
	protected byte [] sbspace= {0x40};
	
	JavaCodePage(
		String encoding,
		CharToByteConverter c2b,
		ByteToCharConverter b2c,
		boolean nuse_s, boolean ext) {
		super(encoding);
		this.c2b = c2b;
		this.b2c = b2c;
		nuse_small = nuse_s;
		uni_ext= ext;
		if (uni_ext) {
			unicp= new UniCodePage();
		}
	}
	
	// chg pei 0608223 synchronized
	//public char ebcdic2uni(int index) {
	public synchronized char ebcdic2uni(int index) {
		try {
			if (nuse_small && (byte)index == (byte)0xb2) {		//back-slash
				return ((char)0x7f);
			}
			char ret= b2c.convertAll(new byte[] {(byte) index })[0];
			if (nuse_small) {
				if (ret >= 'a' && ret <= 'z') {
					ret= '.';
				} else {
					switch (ret) {
						case 0x007e:
						case '^':
						case '[':
						case ']':
						case '{':
						case '}':
							ret= (char)0x7f;
							break;
					}
				}
			}
			if (ret == (char)0x203e) {
				ret= 0x007e;
			}
			return ret;
		} catch (CharConversionException cce) {
			return ' ';
		}
	}

	// chg pei 060823 synchronized
	//public char ebcdic2unik(int index1, int index2) {
	public synchronized char ebcdic2unik(int index1, int index2) {
		try {
			//    	char [] ww= b2c.convertAll(new byte[] { 0x0e, (byte) index1, (byte) index2, 0x0f});
			//    	System.out.println("???" + ww.length + ":" + ww[0]);
			if (uni_ext) {
				char c= unicp.ebcdic2unik(index1, index2);
				if (c != ' ') return (c);
			}
			// chg pei 070803 Sp}CiX̕\PCOMMɍ킹ĕύX
			// chg pei 080313 Sp}CiX̕R[hjR[h̏ꍇ͈قȂ
			if (index1 == 0x42 && index2 == 0x60){
				if (uni_ext) return (0x2212);	
				return (0xff0d);	// add MAR/2006	
			}
			
			return b2c.convertAll(
				new byte[] { 0x0e, (byte) index1, (byte) index2, 0x0f })[0];
		} catch (CharConversionException cce) {
			return '@';
		}
	}
	/*
	  public byte uni2ebcdic (char index)
	  {
	    try
	    {
	      return c2b.convertAll(new char[] {index})[0];
	    }
	    catch (CharConversionException cce)
	    {
	      return 0x0;
	    }
	  }
	*/
	
//	deleted JUN/2006
//	public byte[] uni2ebcdic(char index) {
//		return (uni2ebcdic(index, true));
//	}

	// chg pei 060823 synchronized
	//public byte[] uni2ebcdic(char index, boolean dbcf) {
	public synchronized byte[] uni2ebcdic(char index, boolean dbcf) {
		try {
			if (uni_ext) {
				byte [] b= unicp.uni2ebcdic(index);
				if (b != null) return (b);
			}
			if ((int)index == 0xfffd) {
				return (dbcf ? dbspace : sbspace);
			}
			if ((int)index == 0x007e) {
				index= 0x203e;
			}	
			byte[] wb = c2b.convertAll(new char[] { index });
			if (wb.length == 4 && wb[0] == 0x0e) {
				if (!dbcf && (index & 0xff00) == 0xff00) {
					return (new byte [] {(byte)index});
				}
				return (new byte[] { wb[1], wb[2] });
			}
			// added JUN/2006
			if (dbcf && wb.length == 1) {
				return (new byte[] { (byte)0xfe, (byte)0xfd });
			}
			return wb;
		} catch (CharConversionException cce) {
			return (dbspace);
		}
	}

	public static CodePage getCodePage(String pencoding) {
		boolean ns= false;	//pei
		String encoding = pencoding;
		CharToByteConverter c2b;
		ByteToCharConverter b2c;
		boolean uni= false;
		try {
			//pei
			int off = pencoding.indexOf("-");
			if (off > 0) {
				encoding= pencoding.substring(0, off);
				if (pencoding.equals("930-{pJi") || pencoding.endsWith("-2")) {
					ns= true;
				}
			}
			if (encoding.equals("1390")) {
				encoding= "930";
				uni= true;
			}				
			if (encoding.equals("1399")) {
				encoding= "939";
				uni= true;
			}				
			c2b = CharToByteConverter.getConverter(encoding);
			b2c = ByteToCharConverter.getConverter(encoding);
		} catch (UnsupportedEncodingException uee) {
			c2b = null;
			b2c = null;
		}

		if ((c2b != null) && (b2c != null))
			return new JavaCodePage(encoding, c2b, b2c, ns, uni);

		return null;
	}
	public boolean available(char c) {
		if (nuse_small) {
			switch (c) {
				case '^':
				case '[':
				case ']':
				case '{':
				case '}':
				case '`':
					return (false);
			}
		}
		return (true);
	}
// add start pei 080312
	public String getCodePage() {
		if ("930".equals(encoding)) return ("290");
		return ("1027");
	}
	public String getCharSet() {
		if (nuse_small) return ("332");
		return ("1172");
	}
	public String getKBDType() {
		if ("930".equals(encoding)) return ("JKB");
		return ("JPB");
	}
// add end
	private CharToByteConverter c2b;
	private ByteToCharConverter b2c;
}