/**
 * Title: tn5250J
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.5
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import je.tn5250j.encoding.CodePage;

public class ScreenFields implements TN5250jConstants {

	private ScreenField[] screenFields;
	private ScreenField currentField;
	private ScreenField saveCurrent;
	private int sizeFields;
	private boolean cpfExists;
	private int nextField;
	private int fieldIds;
	private Screen5250 screen;
	private boolean masterMDT;
	protected boolean currentModified;

	public ScreenFields(Screen5250 s) {

		screen = s;
		screenFields = new ScreenField[512];
	}

	public void clearFFT() {

		sizeFields = nextField = fieldIds = 0;
		cpfExists = false; // clear the cursor progression fields flag
		currentField = null;
		masterMDT = false;

	}

	protected boolean existsAtPos(int lastPos) {

		ScreenField sf = null;

		// from 14.6.12 for Start of Field Order 5940 function manual
		//  examine the format table for an entry that begins at the current
		//  starting address plus 1.
		for (int x = 0; x < sizeFields; x++) {
			sf = screenFields[x];

			if (lastPos == sf.startPos()) {
				currentField = sf;
				currentModified = false;
				return true;
			}

		}

		return false;
	}

	public boolean isMasterMDT() {
		return masterMDT;
	}

	protected void setMasterMDT() {
		masterMDT = true;
	}

	public boolean isCurrentField() {
		return currentField == null;
	}

	public boolean isCurrentFieldFER() {
		return currentField.isFER();
	}

	public boolean isCurrentFieldDupEnabled() {
		return currentField.isDupEnabled();
	}

	public boolean isCurrentFieldCur() {
		return currentField.isCField();
	}

	public boolean isCurrentFieldToUpper() {
		return currentField.isToUpper();
	}

	public boolean isCurrentFieldBypassField() {
		return currentField.isBypassField();
	}

	public boolean isCurrentFieldHighlightedEntry() {
		if (currentField != null)
			return currentField.isHiglightedEntry();
		else
			return false;
	}

	public boolean isCurrentFieldAutoEnter() {
		return currentField.isAutoEnter();
	}

	public boolean withinCurrentField(int pos) {
		return currentField.withinField(pos);
	}

	public boolean isCurrentFieldContinued() {
		return currentField.isContinued();
	}

	public boolean isCurrentFieldContinuedFirst() {
		return currentField.isContinuedFirst();
	}

	public boolean isCurrentFieldContinuedMiddle() {
		return currentField.isContinuedMiddle();
	}

	public boolean isCurrentFieldContinuedLast() {
		return currentField.isContinuedLast();
	}

	public boolean isCurrentFieldModified() {
		return currentModified;
	}

	/**
	 * This routine is used to check if we can send the Aid key to the host
	 *
	 * Taken from Section  16.2.1.2 Enter/Rec Adv Key
	 *
	 * In the normal unlocked state, when the workstation operator presses the
	 * Enter/Rec Adv key:
	 *
	 * 1. The 5494 checks for the completion of mandatory-fill, self-check, and
	 *    right-adjust fields when in an active field. (An active field is one in
	 *    which the workstation operator has begun entering data.) If the
	 *    requirements of the field have not been satisfied, an error occurs.
	 *
	 * @return
	 *
	 */
	public boolean isCanSendAid() {

		// We also have to check if we are still in the field.
		if (currentField != null
			&& (currentField.getAdjustment() > 0
				|| currentField.isSignedNumeric())
			&& currentModified
			&& isInField()
			&& !currentField.isCanSend())
			return false;
		else
			return true;

	}

	protected void saveCurrentField() {
		saveCurrent = currentField;
	}

	protected void restoreCurrentField() {
		currentField = saveCurrent;
	}

	protected void setCurrentField(ScreenField sf) {
		currentField = sf;
	}

	protected void setCurrentFieldMDT() {
		currentField.setMDT();
		currentModified = true;
		masterMDT = true;
	}

	protected void setCurrentFieldFFWs(int ffw1, int ffw2) {

		masterMDT = currentField.setFFWs(ffw1, ffw2);
		// add pei 080208
		currentField.reset();
	}

	protected ScreenField setField(
		int type,
		int attr,
		int row,
		int col,
		int len,
		int rows,
		int ffw1,
		int ffw2,
		int fcw1,
		int fcw2) {

		ScreenField sf = null;
		switch (type) {
			case ScreenField.F_BUTTON:
				screenFields[nextField] = new ButtonField(screen);
				break;
			case ScreenField.F_SCROLLBAR:
				// add pei 080208
				if (nextField > 0 && screenFields[nextField - 1] instanceof ScrollBarField) {
					--nextField;
					--sizeFields;
					break;
				}
				screenFields[nextField] = new ScrollBarField(screen);
				// add pei 060821 del pei 080208
//				currentField= screenFields[nextField - 1];
				break;
			case ScreenField.F_SINGLESELECTION:
			case ScreenField.F_MULTISELECTION:
			// add pei 080208
			case ScreenField.F_SINGLESELECTION_PD:
			case ScreenField.F_SINGLESELECTION_LIST:
			case ScreenField.F_MENU:
				// chg pei 080312
//				screenFields[nextField] = new SingleSelectionField(screen);
				//screenFields[nextField] = new SingleSelectionField(screen, type);
				screenFields[nextField] = new SelectionField(screen, type);
				break;
			default:
				screenFields[nextField] = new ScreenField(screen);
				break;
		}
		screenFields[nextField].setField(
			attr,
			row,
			col,
			len,
			rows,
			ffw1,
			ffw2,
			fcw1,
			fcw2);
		sf = screenFields[nextField++];

		sizeFields++;

		// set the field id if it is not a bypass field
		// this is used for cursor progression
		//  changed this because of problems not allocating field id's for
		//  all fields.  kjp 2002/10/21
		//      if (!sf.isBypassField())
		
		// add by pei MAR/2006
		// don't change id's for ContinuedMiddle or ContinuedLast field
		if (!((fcw1 & 0x86) == 0x86) || !(fcw2 == 2 || fcw2 == 3)) {
			++fieldIds;
		}
		sf.setFieldId(fieldIds);

		// check if the cursor progression field flag should be set.
		//      if ((fcw1 & 0x88) == 0x88)
		if (fcw1 == 0x88)
			cpfExists = true;

		if (currentField != null) {
			currentField.next = sf;
			sf.prev = currentField;
		}

		currentField = sf;

		// check if the Modified Data Tag was set while creating the field
		if (!masterMDT)
			masterMDT = currentField.mdt;

		currentModified = false;

		return currentField;

	}

	public ScreenField getField(int index) {

		return screenFields[index];
	}

	public ScreenField getCurrentField() {
		return currentField;
	}

	public int getCurrentFieldPos() {
		return currentField.getCurrentPos();
	}

	protected int getCurrentFieldShift() {
		return currentField.getFieldShift();
	}

	public String getCurrentFieldText() {

		return currentField.getText();
	}

	public int getCurrentFieldHighlightedAttr() {
		return currentField.getHighlightedAttr();
	}

	public int getSize() {

		return sizeFields;
	}

	public boolean isInField(int pos) {
		return isInField(pos, true);
	}

	public boolean isInField() {
		return isInField(screen.getLastPos(), true);
	}

	public boolean isInField(int pos, boolean chgToField) {

		ScreenField sf;

		for (int x = 0; x < sizeFields; x++) {
			sf = screenFields[x];

			if (sf.withinField(pos)) {

				if (chgToField) {
					if (!currentField.equals(sf))
						currentModified = false;
					currentField = sf;
				}
				return true;
			}
		}
		return false;

	}

	public ScreenField getCurrentField2() {
		int pos= screen.getLastPos();
		for (int x = 0; x < sizeFields; x++) {
			ScreenField sf= screenFields[x];
			if (sf.withinField(pos)) {
				return sf;
			}
		}
		return (null);
	}

	public boolean canInput(int pos) {

		ScreenField sf;

		for (int x = 0; x < sizeFields; x++) {
			sf = screenFields[x];

			if (sf.withinField(pos)) {
				return (!sf.isBypassField());
			}
		}
		return false;

	}

	public ScreenField[] getFields() {
		ScreenField[] fields = new ScreenField[sizeFields];
		for (int x = 0; x < sizeFields; x++) {

			fields[x] = screenFields[x];
		}

		return fields;
	}

	// chg pei 071025 gotoFieldNexẗTABtOǉ
	//public void gotoFieldNext() {
	public void gotoFieldNext(boolean tab) {

		// sanity check - we where getting null pointers after a restore of screen
		//   and cursor was not positioned on a field when returned
		//   *** Note *** to myself
		//   maybe this is fixed I will have to check this some time
		int lastPos = screen.getLastPos();

		if (currentField == null
			&& (sizeFields != 0)
			&& !isInField(lastPos, true)) {
			int pos = lastPos;
// chg start pei 061101 Synchronized
			synchronized (screen) {
				//screen.setCursorOff();
				screen.setCursorActive(false);

				screen.advancePos();
				lastPos = screen.getLastPos();
				while (!isInField() && pos != lastPos) {
					screen.advancePos();
				}
				//screen.setCursorOn();
				screen.setCursorActive(true);
			}
// chg end
		}

		// if we are still null do nothing
		if (currentField == null)
			return;

		ScreenField sf = currentField;

		if (!sf.withinField(lastPos)) {
// chg start pei 061101 Synchronized
			synchronized (screen) {
				//screen.setCursorOff();
				screen.setCursorActive(false);
	
				if (sizeFields > 0) {
	
					// lets get the current position so we can test if we have looped
					//    the screen and not found a valid field.
					int pos = lastPos;
					int savPos = lastPos;
					boolean done = false;
					do {
						screen.advancePos();
						lastPos = screen.getLastPos();
						if (isInField(lastPos) || pos == lastPos) {
							if (!currentField.isBypassField() || currentField.isCField()) {
								screen.gotoField(currentField);
								done = true;
							}
						}
					} while (!done && lastPos != savPos);
				}
				currentModified = false;
				//screen.setCursorOn();
				screen.setCursorActive(true);
			}
// chg end

		} else {
			// chg pei 071025 TAB̏ꍇƂ̏𕪊
			//if (!cpfExists) {
			// AtB[h̍ŏԂ̏ꍇTABL[ł͂Ȃꍇ
			if (!cpfExists || (!tab && (sf.isContinuedFirst() || sf.isContinuedMiddle()))) {	
				do {
					sf = sf.next;
				} while (sf != null && sf.isBypassField() && !sf.isCField());

			} else {
				int f = 0;
				// add pei 071025 AtB[h̍ŏȊȌꍇ͍ŏ܂ŃtB[h߂
				//iŏ̃tB[h̃tB[hIDێĂ邽߁j
				if (sf.isContinuedLast() || sf.isContinuedMiddle()) {
					do {
						sf = sf.prev;
					} while (!sf.isContinuedFirst());
				}
				
				int cp = sf.getCursorProgression();	// ̃tB[hID擾
				
				// IDȂꍇ͎̃tB[hTĈڂ
				if (cp == 0) {
					do {
						sf = sf.next;
					} while (sf != null && sf.isBypassField() && !sf.isCField());

				// IDꍇ͂̃tB[hɈڂ
				} else {
					ScreenField sf1 = null;
					boolean found = false;
					while (!found && f < sizeFields) {

						sf1 = screenFields[f++];
						if (sf1.getFieldId() == cp)
							found = true;
					}
					if (found)
						sf = sf1;
					else {
						do {
							sf = sf.next;
						} while (sf != null && sf.isBypassField() && !sf.isCField());

					}
					sf1 = null;
				}
			}
			if (sf == null)
				screen.gotoField(1);
			else {
				currentField = sf;
				screen.gotoField(currentField);
			}

			currentModified = false;

		}
	}

	// chg pei 071031 BACK_TABʂ̃tOǉ
	//public void gotoFieldPrev() {
	public void gotoFieldPrev(boolean tab) {

		ScreenField sf = currentField;
		int lastPos = screen.getLastPos();

		if (!sf.withinField(lastPos)) {
// chg start pei 061101 Synchronized
			synchronized (screen) {
				//screen.setCursorOff();
				screen.setCursorActive(false);
	
				if (sizeFields > 0) {
					// lets get the current position so we can test if we have looped
					//    the screen and not found a valid field.
					int pos = lastPos;
					int savPos = lastPos;
					boolean done = false;
	
					do {
						screen.changePos(-1);
						lastPos = screen.getLastPos();
	
						if (isInField(lastPos) || (pos == lastPos)) {
	
							if (!currentField.isBypassField() || currentField.isCField()) {
								screen.gotoField(currentField);
								done = true;
							}
						}
					} while (!done && lastPos != savPos);
				}
				//screen.setCursorOn();
				screen.setCursorActive(true);
			}
// chg end
		} else {
			// add pei 071025 AtB[h̍ŏ̃tB[h܂Ŗ߂
			if (sf.isContinuedLast() || sf.isContinuedMiddle()) {
				do {
					sf = sf.prev;
				} while (sf != null && sf.isBypassField() && !sf.isCField());
			}
			// chg pei 071025 if  else if
			//if (sf.startPos() == lastPos ||
			else if (sf.startPos() == lastPos ||
//			 (sf.isDBCSOnly() && screen.screen[sf.startPos()].getDBCF() == ScreenChar.F_DBC_IN && sf.startPos() + 1 == lastPos)) {
			 (screen.screen[sf.startPos()].getDBCF() == ScreenChar.F_DBC_IN && sf.startPos() + 1 == lastPos)) {
				if (!cpfExists) {

					do {
						sf = sf.prev;
					} while (sf != null && sf.isBypassField() && !sf.isCField());
				} else {

					int f = 0;
					int cp = sf.getFieldId();
					ScreenField sf1 = null;
					boolean found = false;
					while (!found && f < sizeFields) {

						sf1 = screenFields[f++];
						// chg pei 070618 BackTabL[sC
						//if (sf1.getCursorProgression() == cp)
						if (!sf1.isBypassField() && sf1.getCursorProgression() == cp)
							found = true;
					}
					if (found) {
						sf = sf1;
						// add pei 071031 BACK_TABł͂ȂAtB[h̍ŏꍇ
						// Ō܂ňړ
						if (!tab && sf.isContinuedFirst()) {
							do {
								sf = sf.next;
							} while (!sf.isContinuedLast());
						}
					} else {
						do {
							sf = sf.prev;
						} while (sf != null && sf.isBypassField() && !sf.isCField());
					}
					sf1 = null;
				}
			}

			// add pei 071025
			screen.setCursorActive(false);
			
			if (sf == null) {
				int size = sizeFields;
				sf = screenFields[size - 1];

				while (sf.isBypassField()  && !sf.isCField() && size-- > 0) {
					sf = screenFields[size];

				}
			}
			currentField = sf;
			currentModified = false;
			screen.gotoField(currentField);
			// add pei 071025
			screen.setCursorActive(true);
		}
	}

	protected void readFormatTable(
		ByteArrayOutputStream baosp,
		int readType,
		CodePage codePage) {

		ScreenField sf;
		boolean isSigned = false;
		char c;

		if (masterMDT) {

			StringBuffer sb = new StringBuffer();
			for (int x = 0; x < sizeFields; x++) {
				isSigned = false;

				sf = screenFields[x];
//				if (sf.getType() == ScreenField.F_SINGLESELECTION) {
				if (sf.isSelectionField() && sf.mdt) {
//					baosp.write(17); // start of field data
//					baosp.write(sf.startRow() + 1);
//					baosp.write(sf.startCol() + 1);
//					int spos= ((SingleSelectionField)sf).getSelectPos();
//					
//					// chg pei 060831
//					//spos += 0x1f;
//					if (spos != 0) {
//						spos += 0x1f;
//					}
//					
//					baosp.write((byte)(spos >> 8));
//					baosp.write((byte)spos);
//					// add pei 080208
//					if (sf.getType() == ScreenField.F_SINGLESELECTION_LIST) {
//						baosp.write((byte)0);
//						baosp.write((byte)0);
//						baosp.write((byte)0);
//						baosp.write((byte)0);
//					}
					((SelectionField)sf).readData(baosp);
					continue;
				}
				if (sf.mdt || (readType == CMD_READ_INPUT_FIELDS)) {

					sb.setLength(0);
					sb.append(sf.getText());

					if (readType == CMD_READ_MDT_FIELDS
						|| readType == CMD_READ_MDT_IMMEDIATE_ALT) {
						int len = sb.length() - 1;

						// we strip out all '\u0020' and less
						while (len >= 0
							&& //                     (sb.charAt(len) <= ' ' || sb.charAt(len) >= '\uff20' )) {
						 (sb.charAt(len) < ' ')) {

							// if we have the dup character and dup is enabled then we
							//    stop here
							if (sb.charAt(len) == 0x1C && sf.isDupEnabled())
								break;
							if (sb.charAt(len) == 0x0F)
								break;

							sb.deleteCharAt(len--);
						}

					}

					//               System.out.println("field " + sf.toString());
					//               System.out.println(">" + sb.toString() + "<");
					//               System.out.println(" field is all nulls");
					if (sf.isSignedNumeric()
						&& sb.length() > 0
						&& sb.charAt(sb.length() - 1) == '-') {
						isSigned = true;
						sb.setLength(sb.length() - 1);
					}

					int len3 = sb.length();

					if (len3 > 0
						|| (readType == CMD_READ_MDT_FIELDS
							|| readType == CMD_READ_MDT_IMMEDIATE_ALT)) {

						if ((readType == CMD_READ_MDT_FIELDS
							|| readType == CMD_READ_MDT_IMMEDIATE_ALT)) {

							baosp.write(17); // start of field data
							baosp.write(sf.startRow() + 1);
							baosp.write(sf.startCol() + 1);
						}

						//                  int len = sb.length();
						
						// chg pei 061228 G^Cvł̑Spp
						//boolean dbcf= false;
						boolean dbcf= sf.isDBCSPure();
						
						for (int k = 0; k < len3; k++) {
							c = sb.charAt(k);
							// here we have to check for special instances of the
							//    characters in the string field.  Attribute bytes
							//    are encoded with an offset of \uff00
							//    This is a hack !!!!!!!!!!!
							//    See ScreenField object for a description
							// if it is an offset attribute byte we just pass
							//    it straight on to the output stream
//							if (c >= '\uff20' && c <= '\uff3f') {
//								baosp.write(c - '\uff00');
//							} else
							if (c < ' ') {
								if (c == 0x1C) { 
									baosp.write(c);
								} else if (c == 0x0e) { 
									baosp.write(c);
									dbcf= true;
								} else if (c == 0x0f) { 
									baosp.write(c);
									dbcf= false;
								} else {
									baosp.write(codePage.uni2ebcdic(' ', false)[0]);
								}
							} else {
								if (isSigned && k == len3 - 1) {
									baosp.write(0xd0 | (0x0f & c));
								} else {
									try {
										baosp.write(codePage.uni2ebcdic(c, dbcf));
									} catch (IOException e) {
									}
								}

							}
						}
					}
				}
			}
		}
	}

}