/**
 *
 * <p>Title: Screen5250.jar</p>
 * <p>Description: Main interface to draw the graphical image of the screen</p>
 * <p>Copyright: Copyright (c) 2000 - 2002</p>
 * <p>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 * </p>
 * @author Kenneth J. Pouncey
 * @version 0.5
 * 
 * Modified by pei DEC/2004
 * 
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j;

import java.awt.*;
import java.awt.event.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.awt.im.*;
import java.text.*;
import java.util.*;
import java.awt.datatransfer.*;
import java.beans.*;
import java.io.ByteArrayOutputStream;
import java.io.IOException;	// add pei 061121
import java.io.UnsupportedEncodingException;

import sun.awt.image.IntegerInterleavedRaster;

//import org.python.modules.synchronize;

import je.tn5250j.encoding.CodePage;
import je.tn5250j.tools.*;
import je.tn5250j.tools.system.OperatingSystem;
import je.tn5250j.event.ProgMouseButton;

public class Screen5250
	implements PropertyChangeListener, TN5250jConstants, ActionListener {

	ScreenChar[] screen;
	private ScreenChar[] errorLine;
	private ScreenFields screenFields;
	private int errorLineNum;
	public Font font;
	private int lastAttr;
	private int lastRow;
	private int lastCol;
	private int lastPos;
	private int lenScreen;

	private GuiGraphicBuffer bi;

	private boolean keyboardLocked;
	private KeyStrokenizer strokenizer;
	private tnvt sessionVT;
	private int numRows = 0;
	private int numCols = 0;
	int fmWidth = 0;
	int fmHeight = 0;
	int dfmWidth = 0;
	LineMetrics lm;
	Color colorBlue;
	Color colorWhite;
	Color colorRed;
	Color colorGreen;
	Color colorPink;
	Color colorYellow;
	Color colorBg;
	Color colorTurq;
	Color colorGUIField;
	Color colorCursor;
	Color colorSep;
	Color colorHexAttr;
// add start pei 060807 ̔wiF
	Color colorBlueBg;
	Color colorWhiteBg;
	Color colorRedBg;
	Color colorGreenBg;
	Color colorPinkBg;
	Color colorYellowBg;
	Color colorTurqBg;
	Color colorDivision;
// add end

	private boolean updateCursorLoc;

	private Rectangle2D cursor = new Rectangle2D.Float();
	private Rectangle2D tArea; // text area

	private Rectangle2D aArea; // all screen area
	private Rectangle2D cArea; // command line area
	private Rectangle2D sArea; // status area
	private Rectangle2D pArea; // position area (cursor etc..)
	private Rectangle2D mArea; // message area
	private Rectangle2D iArea; // insert indicator
	private Rectangle2D kbArea; // keybuffer indicator
	private Rectangle2D scriptArea; // script indicator

	private char char0 = 0;
	private static final int initAttr = 32;
	private static final char initChar = 0;
	private boolean statusErrorCode;
	private boolean statusXSystem;
	private int top;
	private int left;
	private Rectangle workR = new Rectangle();
	private int colSepLine = 3;
	public boolean cursorActive = false;
	private boolean cursorShown = true;
	private boolean insertMode = false;
	private boolean keyProcessed = false;
	private Rectangle dirty = new Rectangle();
	private Graphics2D g2d;
	protected Graphics2D gg2d;
	private Point startPoint;
	private Point endPoint;
	private int crossHair = 0;
	private boolean messageLight = false;
	public int homePos = 0;
	public int saveHomePos = 0;
	private boolean keysBuffered;
	private String bufferedKeys;
	private boolean updateFont;

	public boolean pendingInsert = false;
	public boolean savependingInsert = false;

	private Gui5250 gui;
	private int cursorSize = 0;
	private boolean hotSpots = false;
	private boolean showHex = false;
	private float sfh = 1.2f; // font scale height
	private float sfw = 1.0f; // font scale height
	private float ps132 = 0; // Font point size
	private final static int FONT_WA = 1; //pei font width adjust

	public final static byte STATUS_SYSTEM = 1;
	public final static byte STATUS_ERROR_CODE = 2;
	public final static byte STATUS_VALUE_ON = 1;
	public final static byte STATUS_VALUE_OFF = 2;

	private final static String xSystem = "X - System";
	private final static String xError = "X - II";
	private String statusString = "";
	private StringBuffer hsMore = new StringBuffer("More...");
	private StringBuffer hsBottom = new StringBuffer("Bottom");

	/*	error codes to be sent to the host on an error
	 *	0x01	ŌɉꂽL[FȂB 
	 *	0x02	ŌɉꂽL[FȂB
	 *	0x03	R}hEL[̎ɉꂽL[ȂB
	 *	0x04	̓o̓tB[hɃf[^̓͂͋ȂB
	 *	0x05	ʂ̕یɃJ[\B	
	 *	0x06	VXevL[̎ɉꂽL[ȂB
	 *	0x07	͕K{tB[hłBf[^͂Ȃ΂Ȃ܂B
	 *	0x08	̃tB[h͉płȂ΂ȂȂB
	 *	0x09	̃tB[h͐łȂ΂ȂȂB
	 *	0x10	09܂ł̕ĂȂB
	 *	0x11	tB[h̃̕L[ȂB
	 *	0x12	f[^}]n܂B
	 *	0x13	}[hɂ,f[^EL[gpłȂB
	 *	0x14	S̓tB[hBI܂œ͂Ȃ΂Ȃ܂B
	 *	0x15	G[B
	 *	0x16	̃tB[hFIELD-L[͐ȂB
	 *	0x17	IOɁC̃tB[hɓ͂Ȃ΂ȂȂBgpL[܂B
	 *	0x18	tB[hI邽߂ɎgpL[ȂB
	 *	0x19	̃tB[hł͕ʃL[܂̓tB[hE}[NEL[͎gpłȂB
	 *	0x20	̃tB[hɂ͎sL[͋ĂȂB
	 *	0x21	͕K{tB[hɂ̓f[^͂Ȃ΂ȂȂB
	 *	0x22	tB[h̏󋵂słB
	 *	0x23	ŏ16iL[͈̔͂4-9, A-FłC2Ԗڂ16iL[͈̔͂0-9, A-
	 *	0x24	0-9ȊÕf[^܂DUPL[͎gpłȂB
	 *	0x25	gp\ȃwvEeLXgȂB
	 *	0x26	ptB[h̍Ō̌ɂ0-9KvłB
	 *	0x27	L[`ĂȂ̂ŐȂB
	 *	0x28	L[`ĂȂ̂ŐȂB
	 *	0x29	̎̃L[ȂB
	 *	0x30	gp\ȃwvEeLXgȂB
	 *	0x31	CXgCvǎ@\̃G[B
	 *	0x32	W@\̃f[^]G[B
	 *	0x33	ʃR[h`ĂȂC邢͊ԈtB[hɂB
	 *	0x34	CXgCvEf[^̓tB[h̃TCY𒴂ĂB
	 *	0x35	CXgCvEJ[hɃf[^܂͐R[hȂC邢͎CXgC
	 *	0x36	݂̃tB[h̓͂܂ŁCCgEy͎gpłȂB
	 *	0x37	̃tB[hI邱Ƃ͂łȂB
	 *	0x38	MSRf[^̃J[\ȂB
	 *	0x40	f[^EZbgEfB[ItB
	 *	0x42	M̍ꂽB
	 *	0x43	f[^EZbgEfB[(DSR)؂ւȂB
	 *	0x44	30b̃^CAEgB
	 *	0x50	M(CTS)G[B
	 *	0x51	M̍ꂽB
	 *	0x52	n[hEFAEG[B
	 *	0x53	RLSDEi[vjLSAeXgȂB
	 *	0x54	CMDRMꂽB
	 *	0x60	͂ƂDBCSKvłB
	 *	0x61	tB[hEf[^͉płȂ΂ȂȂB
	 *	0x62	݂̃J[\ʒuŃR}h^[hEL[ȂB
	 *	0x63	OȂC邢͖`łB
	 *	0x64	s[hł́C͐̕ȂB
	 *	0x65	ʂ̕یɃJ[\B
	 *	0x66	ŏ̃tB[hʒuŔL[͐ȂB
	 *	0x67	DBCStHgEe[uςłB
	 *	0x68	OɌȂB
	 *	0x69	o̓f[^EXg[̕ȂB
	 *	0x82	ItB[hŐȂL[{[h@\gpB
	 *	0x83	ȂI𕶎͂B
	 *	0x84	Iڂ͑IɎgpłȂB
	 *	0x90	}]nȂB
	 *	0x91	̐܂Ԃ̓tB[h̃L[ȂB
	 *	0x92	ʔ]L[́CpAhbVOł͎gp邱ƂłȂB
	 */
	private final static int ERR_CURSOR_PROTECTED = 0x05;
	private final static int ERR_NUMERIC_ONLY = 0x09;
	private final static int ERR_NUMERIC_09 = 0x10;
	private final static int ERR_INVALID_SIGN = 0x11;
	private final static int ERR_NO_ROOM_INSERT = 0x12;
	private final static int ERR_MANDITORY_FILL_ENTER = 0x14;
	private final static int ERR_DUP_KEY_NOT_ALLOWED = 0x19;
	private final static int ERR_FIELD_MINUS = 0x16;
	private final static int ERR_FIELD_EXIT_INVALID = 0x18;
	private final static int ERR_ENTER_NO_ALLOWED = 0x20;
	private final static int ERR_MANDITORY_ENTER = 0x21;
	private final static int ERR_NUMERIC_ONLY_AND_DUP_NOT_ALLOWED = 0x24;	// pei ȊO&DUPL[G[
	private final static int ERR_FIELD_MINUS_2 = 0x26; // pei
	private final static int ERR_DBCS = 0x60;
	private final static int ERR_SBCS = 0x61;
	private final static int ERR_PRIVATE = 0x63;	// pei OG[
	private final static int ERR_CHAR = 0x64;	// pei sG[
	private final static int ERR_DISPLAY = 0x65;	// pei ʕی̈G[
	private final static int ERR_MOUSE_NO_ALLOWED = 0x84;	// pei }EXIG[

	private boolean guiInterface = false;
	protected boolean guiShowUnderline = true;
	private boolean restrictCursor = false;
	private Rectangle restriction;
	private boolean resetRequired;
	private int cursorBottOffset;
	private boolean defaultPrinter;
	// add pei 070115
	private boolean showPrintDialog;
	private SessionConfig config;
	private boolean rulerFixed;
	//	private boolean antialiased = true;
	private boolean antialiased = false;
	private boolean feError;
	
	// add pei 070226 MS932Only
	private boolean ms932;

	private boolean fullRepaint;
	//   private Image tileimage;

	//LDC - 12/02/2003 -  boolean: true: it must be repainted
	private boolean drawing;
	private javax.swing.Timer blinker;

	// chg pei 061121 rQΉ
	//protected byte[] gridbf;
	protected ByteArrayOutputStream gridbf_bs= null;
	
	protected byte[][] gridbf_tb= new byte[6][];
//	protected int gridtype;	// 1: DDS GRID 2: TOOLBOX GRID
	
	protected int im_pre_acil = 0;
	protected ScreenField im_pre_field;
	private byte [] pco_check_data= {(byte)0, (byte)0, (byte)0xfc, (byte)0xd7,
										(byte)0xc3,(byte)0xd6,(byte)0x40,(byte)0x83,
										(byte)0x80 };
	protected boolean siso_flg= false;
	
	private int im_px;
	private int im_py;
	private java.lang.Character.Subset [] im_kana= {InputSubset.HALFWIDTH_KATAKANA};
	private java.lang.Character.Subset [] im_kanji= {InputSubset.KANJI};
	private String cmd;
//int end;
	private boolean cursorbtn= false;
	
	protected Vector p_mouse_btn= new Vector();
	protected ScrollBarField scrlfield;
	private int dragg_startpos;
	private int dragg_row;
	private boolean lastpos_mdt= false;
	// add pei 060817 J[\ʒuLtO
	protected boolean pendingInsertResore= false;
//	public boolean skipgohome= false;
	
	// add pei 060824 SO/SI GENERATE
	private final char siso_char= (char)0x0e0f;
	
	// add pei 061128 ADDIN
	private AddInControl addin= null;

	public Screen5250(Gui5250 gui, SessionConfig config) {

		//      ImageIcon ic = new ImageIcon("transtable1.jpg");
		//      tileimage = ic.getImage();
		cmd= System.getProperty("os.name").equals("Windows 98") ? "command" : "cmd";

		this.gui = gui;

		this.config = config;

		// load the session properties from it's profile.
		loadProps();

		try {
			jbInit();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	void jbInit() throws Exception {

		// damn I hate putting this in but it is the only way to get
		//  it to work correctly.  What a pain in the ass.
// pei JUN/2005 ?????
//		if (OperatingSystem.isMacOS() && OperatingSystem.hasJava14())
			fullRepaint = true;

		if (!config.isPropertyExists("font")) {
			font = new Font("Courier", Font.PLAIN, 14);
			//			font = new Font(GUIGraphicsUtils.getDefaultFont(), Font.PLAIN, 14);
			config.setProperty("font", font.getFontName());
		} else {
			font = new Font(getStringProperty("font"), Font.PLAIN, 14);
			//			font = new Font("Courier", Font.PLAIN, 14);
		}

		gui.setFont(font);

		lastAttr = 32;

		// default number of rows and columns
		numRows = 24;
		numCols = 80;

		goto_XY(1, 1); // set initial cursor position

		restriction = new Rectangle(0, 0);

		errorLineNum = numRows;
		updateCursorLoc = false;
		FontRenderContext frc =
			new FontRenderContext(font.getTransform(), true, true);
		lm = font.getLineMetrics("Wy", frc);
		//fmWidth = (int) font.getStringBounds("W", frc).getWidth() + FONT_WA;
		fmWidth = (int) font.getStringBounds("W", frc).getWidth() + (int) FONT_WA;
		fmHeight =
			(int) (font.getStringBounds("g", frc).getHeight()
				+ lm.getDescent()
				+ lm.getLeading());
		dfmWidth = (int) font.getStringBounds("", frc).getWidth();
		keyboardLocked = true;

		checkOffScreenImage();
		lenScreen = numRows * numCols;
		screen = new ScreenChar[lenScreen];
		for (int y = 0; y < lenScreen; y++) {
			screen[y] = new ScreenChar(this);
			screen[y].setCharAndAttr(' ', initAttr, false, 0, (byte) 0x40);
			screen[y].setRowCol(getRow(y), getCol(y));
		}

		screenFields = new ScreenFields(this);
		strokenizer = new KeyStrokenizer();

		gui.addFocusListener(new java.awt.event.FocusListener() {
			public void focusGained(java.awt.event.FocusEvent e) {
				if (sessionVT != null) {
					sessionVT.killPCO();
				}
			}
			public void focusLost(java.awt.event.FocusEvent e) {
				;
			}
		});
	}

	public final void setRowsCols(int rows, int cols) {

		// default number of rows and columns
		numRows = rows;
		numCols = cols;

		lenScreen = numRows * numCols;

		screen = new ScreenChar[lenScreen];
		for (int y = 0; y < lenScreen; y++) {
			screen[y] = new ScreenChar(this);
			screen[y].setCharAndAttr(' ', initAttr, false, 0, (byte) 0x40);
			screen[y].setRowCol(getRow(y), getCol(y));
		}
		errorLineNum = numRows;

		Rectangle r = gui.getDrawingBounds();
		resizeScreenArea(r.width, r.height);
		gui.repaint();
	}

	/**
	 * Property̓ǂݍ
	 */
	public void loadProps() {

		loadColors();

		if (config.isPropertyExists("colSeparator")) {
			if (getStringProperty("colSeparator").equals("Line"))
				colSepLine = 0;
			if (getStringProperty("colSeparator").equals("ShortLine"))
				colSepLine = 1;
			if (getStringProperty("colSeparator").equals("Dot"))
				colSepLine = 2;
			if (getStringProperty("colSeparator").equals("Hide"))
				colSepLine = 3;
		}

		if (config.isPropertyExists("showAttr")) {
			if (getStringProperty("showAttr").equals("Hex"))
				showHex = true;
		}

		if (config.isPropertyExists("guiInterface")) {
			if (getStringProperty("guiInterface").equals("Yes"))
				guiInterface = true;
			else
				guiInterface = false;
		}

		if (config.isPropertyExists("guiShowUnderline")) {
			if (getStringProperty("guiShowUnderline").equals("Yes"))
				guiShowUnderline = true;
			else
				guiShowUnderline = false;
		}

		if (config.isPropertyExists("hotspots")) {
			if (getStringProperty("hotspots").equals("Yes"))
				hotSpots = true;
			else
				hotSpots = false;
		}

		if (config.isPropertyExists("hsMore")) {
			if (getStringProperty("hsMore").length() > 0) {
				hsMore.setLength(0);
				hsMore.append(getStringProperty("hsMore"));
			}
		}

		if (config.isPropertyExists("hsBottom")) {
			if (getStringProperty("hsBottom").length() > 0) {
				hsBottom.setLength(0);
				hsBottom.append(getStringProperty("hsBottom"));
			}
		}

		if (config.isPropertyExists("colSeparator")) {
			if (getStringProperty("colSeparator").equals("Line"))
				colSepLine = 0;
			if (getStringProperty("colSeparator").equals("ShortLine"))
				colSepLine = 1;
			if (getStringProperty("colSeparator").equals("Dot"))
				colSepLine = 2;
			if (getStringProperty("colSeparator").equals("Hide"))
				colSepLine = 3;
		}

		if (config.isPropertyExists("cursorSize")) {
			if (getStringProperty("cursorSize").equals("Full"))
				cursorSize = 2;
			if (getStringProperty("cursorSize").equals("Half"))
				cursorSize = 1;
			if (getStringProperty("cursorSize").equals("Line"))
				cursorSize = 0;

		}

		if (config.isPropertyExists("crossHair")) {
			if (getStringProperty("crossHair").equals("None"))
				crossHair = 0;
			if (getStringProperty("crossHair").equals("Horz"))
				crossHair = 1;
			if (getStringProperty("crossHair").equals("Vert"))
				crossHair = 2;
			if (getStringProperty("crossHair").equals("Both"))
				crossHair = 3;

		}

		if (config.isPropertyExists("rulerFixed")) {

			if (getStringProperty("rulerFixed").equals("Yes"))
				rulerFixed = true;
			else
				rulerFixed = false;

		}

		if (config.isPropertyExists("fontScaleHeight")) {
			sfh = getFloatProperty("fontScaleHeight");
		}

		if (config.isPropertyExists("fontScaleWidth")) {
			sfw = getFloatProperty("fontScaleWidth");
		}

		if (config.isPropertyExists("fontPointSize")) {
			ps132 = getFloatProperty("fontPointSize");
		}

		if (config.isPropertyExists("cursorBottOffset")) {
			cursorBottOffset = getIntProperty("cursorBottOffset");
		}

		if (config.isPropertyExists("defaultPrinter")) {
			if (getStringProperty("defaultPrinter").equals("Yes"))
				defaultPrinter = true;
			else
				defaultPrinter = false;
		}
		
		// add pei 070115
		if (config.isPropertyExists("showPrintDialog")) {
			if (getStringProperty("showPrintDialog").equals("Yes"))
				showPrintDialog = true;
			else
				showPrintDialog = false;
		}

		if (config.isPropertyExists("resetRequired")) {
			if (getStringProperty("resetRequired").equals("Yes"))
				resetRequired = true;
			else
				resetRequired = false;
		}

		if (config.isPropertyExists("useAntialias")) {

			if (getStringProperty("useAntialias").equals("Yes"))
				antialiased = true;
			else
				antialiased = false;

		}

// add start pei 061128 ADDIN
		if (config.isPropertyExists("addin")) {
			addin= new AddInControl(getStringProperty("addin"), this);
		}
// add end

		if (config.getStringProperty("cursorBlink").equals("Yes")) {
			blinker = new javax.swing.Timer(500, this);
			blinker.start();
		}
	}

	protected final void loadColors() {

		colorBlue = new Color(140, 120, 255);
		colorTurq = new Color(0, 240, 255);
		colorRed = Color.red;
		colorWhite = Color.white;
		colorYellow = Color.yellow;
		colorGreen = Color.green;
		colorPink = Color.magenta;
		colorGUIField = Color.white;
		colorSep = Color.white;
		colorHexAttr = Color.white;
		// add pei 060807 ̔wiF
		colorDivision = new Color(140, 120, 255);

		if (guiInterface)
			colorBg = Color.lightGray;
		else
			colorBg = Color.black;

		colorCursor = Color.white;

		if (!config.isPropertyExists("colorBg"))
			setProperty("colorBg", Integer.toString(colorBg.getRGB()));
		else {
			colorBg = getColorProperty("colorBg");
		}
		gui.setBackground(colorBg);
		
// add start pei 060823 OVer̐ݒ肪Ȃꍇ͑̔wiFwiFɍ킹
		colorBlueBg = colorBg;
		colorWhiteBg = colorBg;
		colorRedBg = colorBg;
		colorGreenBg = colorBg;
		colorPinkBg = colorBg;
		colorYellowBg = colorBg;
		colorTurqBg = colorBg;
// add end

		if (!config.isPropertyExists("colorBlue"))
			setProperty("colorBlue", Integer.toString(colorBlue.getRGB()));
		else
			colorBlue = getColorProperty("colorBlue");

		if (!config.isPropertyExists("colorTurq"))
			setProperty("colorTurq", Integer.toString(colorTurq.getRGB()));
		else
			colorTurq = getColorProperty("colorTurq");

		if (!config.isPropertyExists("colorRed"))
			setProperty("colorRed", Integer.toString(colorRed.getRGB()));
		else
			colorRed = getColorProperty("colorRed");

		if (!config.isPropertyExists("colorWhite"))
			setProperty("colorWhite", Integer.toString(colorWhite.getRGB()));
		else
			colorWhite = getColorProperty("colorWhite");

		if (!config.isPropertyExists("colorYellow"))
			setProperty("colorYellow", Integer.toString(colorYellow.getRGB()));
		else
			colorYellow = getColorProperty("colorYellow");

		if (!config.isPropertyExists("colorGreen"))
			setProperty("colorGreen", Integer.toString(colorGreen.getRGB()));
		else
			colorGreen = getColorProperty("colorGreen");

		if (!config.isPropertyExists("colorPink"))
			setProperty("colorPink", Integer.toString(colorPink.getRGB()));
		else
			colorPink = getColorProperty("colorPink");

// add start pei 060807 ̔wiFݒǉ
		if (!config.isPropertyExists("colorBlueBg"))
			setProperty("colorBlueBg", Integer.toString(colorBlueBg.getRGB()));
		else
			colorBlueBg = getColorProperty("colorBlueBg");

		if (!config.isPropertyExists("colorTurqBg"))
			setProperty("colorTurqBg", Integer.toString(colorTurqBg.getRGB()));
		else
			colorTurqBg = getColorProperty("colorTurqBg");

		if (!config.isPropertyExists("colorRedBg"))
			setProperty("colorRedBg", Integer.toString(colorRedBg.getRGB()));
		else
			colorRedBg = getColorProperty("colorRedBg");

		if (!config.isPropertyExists("colorWhiteBg"))
			setProperty("colorWhiteBg", Integer.toString(colorWhiteBg.getRGB()));
		else
			colorWhiteBg = getColorProperty("colorWhiteBg");

		if (!config.isPropertyExists("colorYellowBg"))
			setProperty("colorYellowBg", Integer.toString(colorYellowBg.getRGB()));
		else
			colorYellowBg = getColorProperty("colorYellowBg");

		if (!config.isPropertyExists("colorGreenBg"))
			setProperty("colorBg", Integer.toString(colorGreenBg.getRGB()));
		else
			colorGreenBg = getColorProperty("colorBg");

		if (!config.isPropertyExists("colorPinkBg"))
			setProperty("colorPinkBg", Integer.toString(colorPinkBg.getRGB()));
		else
			colorPinkBg = getColorProperty("colorPinkBg");
			
		if (!config.isPropertyExists("colorDivision")) {
			setProperty("colorDivision", Integer.toString(colorDivision.getRGB()));
		} else
			colorDivision = getColorProperty("colorDivision");
// add end

		if (!config.isPropertyExists("colorGUIField"))
			setProperty(
				"colorGUIField",
				Integer.toString(colorGUIField.getRGB()));
		else
			colorGUIField = getColorProperty("colorGUIField");

		if (!config.isPropertyExists("colorCursor"))
			setProperty("colorCursor", Integer.toString(colorCursor.getRGB()));
		else
			colorCursor = getColorProperty("colorCursor");

		if (!config.isPropertyExists("colorSep")) {
			colorSep = colorWhite;
			setProperty("colorSep", Integer.toString(colorSep.getRGB()));
		} else
			colorSep = getColorProperty("colorSep");

		if (!config.isPropertyExists("colorHexAttr")) {
			colorHexAttr = colorWhite;
			setProperty(
				"colorHexAttr",
				Integer.toString(colorHexAttr.getRGB()));
		} else
			colorHexAttr = getColorProperty("colorHexAttr");

	}

	public void actionPerformed(ActionEvent actionevent) {
		if (actionevent.getSource() instanceof javax.swing.Timer) {

			if (!cursorActive || im_pre_acil != 0 || cursorbtn)
				return;
			synchronized (this) {
				if (updateCursorLoc2(false, false)) {
					if (cursorShown) {
//						setCursorOff();
						cursorShown = false;
					} else {
//						setCursorOn();
						cursorShown = true;
					}
				}
			}
			//			if (cursorActive)
			//				setCursorActive(false);
			//			else
			//				setCursorActive(true);
		}
	}

	protected final String getStringProperty(String prop) {

		return config.getStringProperty(prop);

	}

	protected final Color getColorProperty(String prop) {

		return config.getColorProperty(prop);

	}

	protected final float getFloatProperty(String prop) {

		return config.getFloatProperty(prop);

	}

	protected final int getIntProperty(String prop) {

		return config.getIntegerProperty(prop);

	}

	protected final void setProperty(String key, String val) {

		config.setProperty(key, val);

	}

	public void propertyChange(PropertyChangeEvent pce) {

		String pn = pce.getPropertyName();
		boolean resetAttr = false;

		if (pn.equals("colorBg")) {
			colorBg = (Color) pce.getNewValue();
			resetAttr = true;

		}

		if (pn.equals("colorBlue")) {
			colorBlue = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorTurq")) {
			colorTurq = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorRed")) {
			colorRed = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorWhite")) {
			colorWhite = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorYellow")) {
			colorYellow = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorGreen")) {
			colorGreen = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorPink")) {
			colorPink = (Color) pce.getNewValue();
			resetAttr = true;
		}

// add start pei 060807 ̔wiFݒǉ
		if (pn.equals("colorBlueBg")) {
			colorBlueBg = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorTurqBg")) {
			colorTurqBg = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorRedBg")) {
			colorRedBg = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorWhiteBg")) {
			colorWhiteBg = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorYellowBg")) {
			colorYellowBg = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorGreenBg")) {
			colorBg = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorPinkBg")) {
			colorPinkBg = (Color) pce.getNewValue();
			resetAttr = true;
		}
		
		if (pn.equals("colorDivision")) {
			colorDivision = (Color) pce.getNewValue();
			resetAttr = true;
		}
// add end

		if (pn.equals("colorGUIField")) {
			colorGUIField = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorCursor")) {
			colorCursor = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorSep")) {
			colorSep = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("colorHexAttr")) {
			colorHexAttr = (Color) pce.getNewValue();
			resetAttr = true;
		}

		if (pn.equals("cursorSize")) {
			if (pce.getNewValue().equals("Full"))
				cursorSize = 2;
			if (pce.getNewValue().equals("Half"))
				cursorSize = 1;
			if (pce.getNewValue().equals("Line"))
				cursorSize = 0;

		}

		if (pn.equals("crossHair")) {
			if (pce.getNewValue().equals("None"))
				crossHair = 0;
			if (pce.getNewValue().equals("Horz"))
				crossHair = 1;
			if (pce.getNewValue().equals("Vert"))
				crossHair = 2;
			if (pce.getNewValue().equals("Both"))
				crossHair = 3;
		}

		if (pn.equals("rulerFixed")) {
			if (pce.getNewValue().equals("Yes"))
				rulerFixed = true;
			else
				rulerFixed = false;
		}

		if (pn.equals("colSeparator")) {
			if (pce.getNewValue().equals("Line"))
				colSepLine = 0;
			if (pce.getNewValue().equals("ShortLine"))
				colSepLine = 1;
			if (pce.getNewValue().equals("Dot"))
				colSepLine = 2;
			if (pce.getNewValue().equals("Hide"))
				colSepLine = 3;
		}

		if (pn.equals("showAttr")) {
			if (pce.getNewValue().equals("Hex"))
				showHex = true;
			else
				showHex = false;
		}

		if (pn.equals("guiInterface")) {
			if (pce.getNewValue().equals("Yes"))
				guiInterface = true;
			else
				guiInterface = false;
		}

		if (pn.equals("guiShowUnderline")) {
			if (pce.getNewValue().equals("Yes"))
				guiShowUnderline = true;
			else
				guiShowUnderline = false;
		}

		if (pn.equals("hotspots")) {
			if (pce.getNewValue().equals("Yes"))
				hotSpots = true;
			else
				hotSpots = false;
		}

		if (pn.equals("defaultPrinter")) {
			if (pce.getNewValue().equals("Yes"))
				defaultPrinter = true;
			else
				defaultPrinter = false;
		}
		
		// add pei 070115
		if (pn.equals("showPrintDialog")) {
			if (pce.getNewValue().equals("Yes"))
				showPrintDialog = true;
			else
				showPrintDialog = false;
		}

		if (pn.equals("resetRequired")) {
			if (pce.getNewValue().equals("Yes"))
				resetRequired = true;
			else
				resetRequired = false;
		}

		if (pn.equals("hsMore")) {
			hsMore.setLength(0);
			hsMore.append((String) pce.getNewValue());

		}

		if (pn.equals("hsBottom")) {
			hsBottom.setLength(0);
			hsBottom.append((String) pce.getNewValue());

		}

		if (pn.equals("font")) {
			font = new Font((String) pce.getNewValue(), Font.PLAIN, 14);
			updateFont = true;
		}

		if (pn.equals("useAntialias")) {
			if (pce.getNewValue().equals("Yes"))
				bi.setUseAntialias(true);
			else
				bi.setUseAntialias(false);
			updateFont = true;
		}

		if (pn.equals("fontScaleHeight")) {

			//         try {
			sfh = Float.parseFloat((String) pce.getNewValue());
			updateFont = true;
			//         }

		}

		if (pn.equals("fontScaleWidth")) {

			//         try {
			sfw = Float.parseFloat((String) pce.getNewValue());
			updateFont = true;
			//         }

		}

		if (pn.equals("fontPointSize")) {

// chg start pei 070913 tHgTCYnull̏ꍇ0ݒ
			try {
//			ps132 = Float.parseFloat((String) pce.getNewValue());
//			updateFont = true;
				ps132 = Float.parseFloat((String) pce.getNewValue());
			} catch (NumberFormatException nfe) {
				ps132 = 0;
			}
// chg end pei
			updateFont = true;

		}

		if (pn.equals("cursorBottOffset")) {
//			cursorBottOffset = getIntProperty("cursorBottOffset");
			cursorBottOffset = Integer.parseInt((String) pce.getNewValue());;
		}

		if (pn.equals("cursorBlink")) {
			System.out.println(getStringProperty("cursorBlink"));
			if (pce.getNewValue().equals("Yes")) {

				if (blinker == null) {

					blinker = new javax.swing.Timer(500, this);
					blinker.start();
				}
			} else {

				if (blinker != null) {
					blinker.stop();
					blinker = null;
				}
			}
		}

		if (updateFont) {
			Rectangle r = gui.getDrawingBounds();
			resizeScreenArea(r.width, r.height);
			updateFont = false;
		}

		if (resetAttr) {
			for (int y = 0; y < lenScreen; y++) {
				screen[y].setAttribute(screen[y].getCharAttr());
			}
			// chg pei 060816 colorDivisionǉ
			bi.drawOIA(
				fmWidth,
				fmHeight,
				numRows,
				numCols,
				font,
				colorBg,
				colorBlue,
				colorDivision);
		}
		gui.validate();
		gui.repaint();
	}

	public boolean isHotSpots() {
		return hotSpots;
	}

	public void toggleHotSpots() {
		hotSpots = !hotSpots;
	}

	public void toggleGUIInterface() {
		guiInterface = !guiInterface;
	}

	/**
	 *
	 * RubberBanding start code
	 *
	 */

	/**
	 * Translate the starting point of mouse movement to encompass a full character
	 *
	 * @param start
	 * @return Point
	 */
	public Point translateStart(Point start) {

		// because getRowColFromPoint returns position offset as 1,1 we need
		// to translate as offset 0,0
		int pos = getPosFromView(start.x, start.y);
		start.setLocation(screen[pos].x, screen[pos].y);
		return start;

	}

	/**
	 * Translate the ending point of mouse movement to encompass a full character
	 *
	 * @param end
	 * @return Point
	 */
	public Point translateEnd(Point end) {

		// because getRowColFromPoint returns position offset as 1,1 we need
		// to translate as offset 0,0
		int pos = getPosFromView(end.x, end.y);
		int x = screen[pos].x + fmWidth - 1;
		int y = screen[pos].y + fmHeight - 1;

		end.setLocation(x, y);

		return end;
	}

	public Color getBackground() {
		return colorBg;
	}

	/**
	 *
	 * RubberBanding end code
	 *
	 */

	/**
	 *
	 * table_copy start code
	 *
	 */
// add start pei 071009 \`ŃRs[ǉ
	public final void table_copy() {
		// ͈͎wȂ͖
		if (!gui.rubberband.isAreaSelected()) return;
		
		Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
		StringBuffer sb = new StringBuffer();

		getBoundingArea(workR);

		gui.rubberband.reset();
		gui.repaint();

		int m = workR.x;
		int i = 0;
		int t = 0;
		
		boolean addsep = false;
		int height = workR.height;
		int ypos = workR.x;

		while (workR.height-- > 0) {
			t = workR.width;
			i = workR.y;

			while (t-- > 0) {
				int it = ypos;
				boolean colspace = true;
				for (int n = 0; n < height; n++) {
					ScreenChar schar = screen[getPos(it - 1, i - 1)];
					if ((schar.getEbcdic() != 0 && schar.getEbcdic() != 64) ||
						(schar.getDBCF() != 0 && schar.getDBCF() != 4 && schar.getDBCF() != 8)) {
						addsep = true;
						colspace = false;
					}
					it++;
				}
				int pos= getPos(m - 1, i - 1);
				ScreenChar sc = screen[pos];

				int dbcf= sc.getDBCF();
//System.out.println("=" + sc.getChar() + "\tEbcdic=" + sc.getEbcdic() + "\tDBCF=" + dbcf + "\taddsep=" + addsep + "\tcolspace=" + colspace);
				switch (dbcf) {
					case 0:
					case ScreenChar.F_DBC1:
						char c = sc.getChar();
						if ((sc.getDBCF() != 1 && sc.getDBCF() != 2) && (sc.getEbcdic() == 0 || sc.getEbcdic() == 64)) {
							if (addsep && colspace) {
								sb.append("\t");
								addsep = false;
							}
						} else if (c > ' ' && !sc.nonDisplay) {
							sb.append(c);
						} else {
							//s.append(' ');
						}
						break;						
					case ScreenChar.F_DBC2:
						break;
					case ScreenChar.F_DBC_IN:
						if (addsep && colspace) {
							sb.append("\t");
							addsep = false;
						}
						break;
					case ScreenChar.F_DBC_OUT:
						if (addsep && colspace) {
							sb.append("\t");
							addsep = false;
						}
						break;
				}
				i++;
			}
			if (sb.charAt(sb.length()-1) == '\t') sb.delete(sb.length()-1, sb.length());
			if (workR.height > 0) sb.append('\n');
			addsep = false;
			m++;
		}
		StringSelection contents = new StringSelection(sb.toString());
		cb.setContents(contents, null);
//System.out.println(sb.toString());
		gui.resizeMe();
	}
// add end

	/**
	 *
	 * Copy & Paste & Cut start code
	 *
	 */
// add start pei 060816 Jbg[hǉ
	public final void copyMe() {
			copy_cut(false);
	}
	
	public final void cutMe() {
		
		// add pei 061128 ͈͎wȂCut
		if (!gui.rubberband.isAreaSelected()) return;
		
		copy_cut(true);
		gui.resizeMe();
	}
// add end

	// chg pei 060816 copyMe  copy_cut Jbg[hǉ
	protected void copy_cut(boolean cut) {

		Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
		StringBuffer s = new StringBuffer();

		// lets get the bounding area using a rectangle that we have already
		// allocated
		getBoundingArea(workR);

		gui.rubberband.reset();
		gui.repaint();

//		System.out.println("Copying" + workR);

		// loop through all the screen characters to send them to the clip board
		int m = workR.x;
		int i = 0;
		int t = 0;

		while (workR.height-- > 0) {
			t = workR.width;
			i = workR.y;
			
			while (t-- > 0) {
				// only copy printable characters (in this case >= ' ')
				//pei
// chg start pei 060816 Jbgǉ
/*
				ScreenChar sc = screen[getPos(m - 1, i - 1)];
				int dbcf= sc.getDBCF();
				switch (dbcf) {
					case 0:
					case ScreenChar.F_DBC1:
						char c = sc.getChar();
						if (c >= ' ' && !sc.nonDisplay)
							s.append(c);
						else
							s.append(' ');
						break;
*/
				int pos= getPos(m - 1, i - 1);
				ScreenChar sc = screen[pos];

				int dbcf= sc.getDBCF();
				switch (dbcf) {
					case 0:
					case ScreenChar.F_DBC1:
						char c = sc.getChar();
						if (c >= ' ' && !sc.nonDisplay) {
							s.append(c);
							if (cut && isInField(pos) && !screenFields.isCurrentFieldBypassField()) {
								if (dbcf == 0) {
									sc.setChar(
										' ',
										0,
										(byte) 0x40);
								} else {	// DBC1
									sc.setChar(
										'@',
										ScreenChar.F_DBC1,
										(byte) 0);
								}
							}
						} else {
							s.append(' ');
						}
						break;						
// chg end
					case ScreenChar.F_DBC2:
						break;
					case ScreenChar.F_DBC_IN:
						//s.append(' ');	//??????????????????????
						break;
					case ScreenChar.F_DBC_OUT:
						//s.append(' ');	//??????????????????????
						break;
				}
/*
				if (sc.getDBCF() == 0 || sc.getDBCF() == ScreenChar.F_DBC1) {
					char c = sc.getChar();
					if (c >= ' ' && !sc.nonDisplay)
						s.append(c);
					else
						s.append(' ');
				}
*/
				i++;
			}
// chg start pei 060727 Rs[̍ŌɉsR[h͓Ȃ悤ɕύX
			//s.append('\n');
			if (workR.height > 0)
				s.append('\n');
// chg end
			m++;
		}
		StringSelection contents = new StringSelection(s.toString());
		cb.setContents(contents, null);
	}

	protected final void pasteMe(boolean special) {

		setCursorActive(false);
		if (screen[lastPos].getDBCF() == ScreenChar.F_DBC2
			&& lastPos != 0) {
			--lastPos;
		}
		Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
		Transferable content = cb.getContents(this);
		try {
			StringBuffer sb =
				new StringBuffer(
					(String) content.getTransferData(DataFlavor.stringFlavor));
			StringBuffer pd = new StringBuffer();
			int r = getRow(lastPos);
			int nextChar = 0;
			int nChars = sb.length();
			boolean omitLF = false;
			boolean done = false;
			screenFields.saveCurrentField();
			int lr = getRow(lastPos);
			int lc = getCol(lastPos);
			resetDirty(lastPos);

			while (!done) {

				if (nextChar >= nChars) { /* EOF */

					done = true;
					break;
				}

				pd.setLength(0);

				boolean eol = false;
				char c = 0;
				int i;

				/* Skip a leftover '\n', if necessary */
				if (omitLF && (sb.charAt(nextChar) == '\n'))
					nextChar++;

				boolean skipLF = false;
				omitLF = false;

				charLoop : for (i = nextChar; i < nChars; i++) {
					c = sb.charAt(i);
					if ((c == '\n') || (c == '\r')) {
						eol = true;
						break charLoop;
					}
				}

				int startChar = nextChar;
				nextChar = i;

				pd.append(sb.substring(startChar, startChar + (i - startChar)));

				if (eol) {
					nextChar++;
					if (c == '\r') {
						skipLF = true;
					}
				}
//				System.out.println("pasted >" + pd + "<");

				int col = getCol(lastPos);
				int t = numCols - col;
				if (t > pd.length())
					t = pd.length();
				int p = 0;
				char pc;
				boolean setIt;
				
				// chg pei 061108
				//while (t-- > 0) {
				for (int j= 0; j < t; ++j) {

					pc = pd.charAt(p);
					
					// add pei 080306 CodePage930̏ꍇA\tɏ啶ɕϊ
					if(sessionVT.getCodePage().nuse_small) pc = Character.toUpperCase(pc);
					
					setIt = true;
					// chg pei 060815
					//int cc = 0;
					int cc = 1;
					if (special
						&& (!Character.isLetter(pc) && !Character.isDigit(pc)))
						setIt = false;

					if (isInField(r, col)
						&& setIt
						&& !screenFields.isCurrentFieldBypassField()) {
							
						// add pei 061108
						int pos= getPos(r, col);
						if (j == 0 && screen[pos].getDBCF() == ScreenChar.F_DBC2) {
							// chg pei 080312
							//clearpos(pos);
							clearpos(pos, false);
						}
						
						// chg pei 061108
						cc =
							updatepos(
								pos,
								pc,
//								insertMode,
								false,
								sessionVT.getCodePage().uni2ebcdic(pc, false)[0]);
						//						screen[getPos(r, col)].setChar(pc);
						//						setDirty(r, col);
						screenFields.setCurrentFieldMDT();
					}
					p++;
					if (setIt)
						col += cc;
				}
				r++;

			}
			screenFields.restoreCurrentField();
			updateDirty();

			goto_XY(lr + 1, lc + 1);

			setCursorActive(true);
		} catch (Throwable exc) {
			System.err.println(exc);
		}
	}

	protected final void copyField(int pos) {

		Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
		StringBuffer s = new StringBuffer();
		screenFields.saveCurrentField();
		isInField(pos);
		//pei
		String ss= screenFields.getCurrentFieldText().replace((char)0x0e, ' ').replace((char)0x0f, ' ');
//		System.out.println("Copying:" + ss);
		StringSelection contents =
			new StringSelection(ss);
		cb.setContents(contents, null);
		screenFields.restoreCurrentField();
	}

	/**
	 * Fills the passed Rectangle with the starting row and column and width
	 * and height of the selected area.
	 *
	 * 1 BASED so column 1 row one is returned 1,1
	 *
	 * If there is no area bounded then the full screen area is returned.
	 *
	 * @param bounds
	 */
	public void getBoundingArea(Rectangle bounds) {

		// check to see if there is an area selected.  If not then return all
		//    screen area.
		if (!gui.rubberband.isAreaSelected()) {

			bounds.setBounds(1, 1, getCols(), getRows());
		} else {
			// lets get the bounding area using a rectangle that we have already
			// allocated
			gui.rubberband.getBoundingArea(workR);

			// get starting row and column
			int sPos = getRowColFromPoint(workR.x, workR.y);
			// get the width and height
			int ePos = getRowColFromPoint(workR.width, workR.height);

			int row = getRow(sPos) + 1;
			int col = getCol(sPos) + 1;

			bounds.setBounds(row, col, getCol(ePos) + 1, getRow(ePos) + 1);
		}
	}

	/**
	 *
	 * Copy & Paste end code
	 *
	 */

	/**
	 * Sum them
	 *
	 * @param which formatting option to use
	 * @return vector string of numberic values
	 */
	protected final Vector sumThem(boolean which) {

		StringBuffer s = new StringBuffer();

		getBoundingArea(workR);

		//      gui.rubberband.reset();
		//      gui.repaint();

		//      System.out.println("Summing");

		// obtain the decimal format for parsing
		DecimalFormat df = (DecimalFormat) NumberFormat.getInstance();

		DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();

		if (which) {
			dfs.setDecimalSeparator('.');
			dfs.setGroupingSeparator(',');
		} else {
			dfs.setDecimalSeparator(',');
			dfs.setGroupingSeparator('.');
		}

		df.setDecimalFormatSymbols(dfs);

		Vector sumVector = new Vector();

		// loop through all the screen characters to send them to the clip board
		int m = workR.x;
		int i = 0;
		int t = 0;

		double sum = 0.0;

		while (workR.height-- > 0) {
			t = workR.width;
			i = workR.y;
			while (t-- > 0) {

				// only copy printable numeric characters (in this case >= ' ')
				char c = screen[getPos(m - 1, i - 1)].getChar();
				if (((c >= '0' && c <= '9')
					|| c == '.'
					|| c == ','
					|| c == '-')
					&& !screen[getPos(m - 1, i - 1)].nonDisplay) {
					s.append(c);
				}
				i++;
			}

			if (s.length() > 0) {
				if (s.charAt(s.length() - 1) == '-') {
					s.insert(0, '-');
					s.deleteCharAt(s.length() - 1);
				}
				try {
					Number n = df.parse(s.toString());
					//               System.out.println(s + " " + n.doubleValue());

					sumVector.add(new Double(n.doubleValue()));
					sum += n.doubleValue();
				} catch (ParseException pe) {
					System.out.println(
						pe.getMessage() + " at " + pe.getErrorOffset());
				}
			}
			s.setLength(0);
			m++;
		}
		//      System.out.println(sum);
		return sumVector;
	}

	public boolean checkPMB(MouseEvent e) {
		
		// chg pei 060901
		// add pei 060821
		//if (e.getClickCount() > 1) return (false);
		if (keyboardLocked || e.getClickCount() > 1) return (false);
		
		int pos = getPosFromView(e.getX(), e.getY());
		if (screenFields.isInField(pos)) {
			switch (screenFields.getCurrentField().getType()) {
				case ScreenField.F_BUTTON:
				case ScreenField.F_SCROLLBAR:
				case ScreenField.F_SINGLESELECTION:
				// add pei 080208
				case ScreenField.F_SINGLESELECTION_PD:
				case ScreenField.F_SINGLESELECTION_LIST:
					return (false);
			}
		}
		if (!p_mouse_btn.isEmpty()) {
			int sz= p_mouse_btn.size();
			for (int i= 0; i < sz; ++i) {
				ProgMouseButton pmb= (ProgMouseButton)p_mouse_btn.elementAt(i);
				switch (pmb.checkEvent(e, pos)) {
					case 1:
						return (true);
					case 2:
						sessionVT.sendPMB(pmb);
						return (true);
				}
			}
		}
		return (false);
	}

	public boolean checkScrollBar(MouseEvent e) {
		
		// add pei 060901
		if (keyboardLocked) return (false);
		
		int pos = getPosFromView(e.getX(), e.getY());
		int row= getRow(pos);
		switch (e.getID()) {
			case MouseEvent.MOUSE_PRESSED:
				if (screen[pos].getWhichGUI() != ScreenChar.BUTTON_SB_THUMB) return (false);
				screenFields.isInField(pos);
				scrlfield= (ScrollBarField)screenFields.getCurrentField();
				dragg_startpos= pos;
				dragg_row= getRow(pos);
				return (true);
			case MouseEvent.MOUSE_DRAGGED:
				if (row > scrlfield.getMax() || row < scrlfield.getMin()) return (false);
				if (row != dragg_row) {
					int sb_pos= getPos(row, getCol(dragg_startpos));
					screen[sb_pos].setUseGUI(ScreenChar.BUTTON_SB_THUMB);
					setDirty(sb_pos);
					sb_pos= getPos(dragg_row, getCol(dragg_startpos));
					if (row > dragg_row) {
						screen[sb_pos].setUseGUI(ScreenChar.BUTTON_SB_UP);
					} else {
						screen[sb_pos].setUseGUI(ScreenChar.BUTTON_SB_DN);
					}
					setDirty(sb_pos);
					dragg_row= row;
					setCursorActive(false);
					updateImage(dirty);
					setCursorActive(true);
				}
				break;
			case MouseEvent.MOUSE_RELEASED:
				if (dragg_startpos == 0) return (true);
// chg start pei 080208
//				int start= getRow(dragg_startpos);
				int cpr= scrlfield.getCpr();				
//				if (scrlfield.isFirstRow(row)) {
//					sessionVT.sendAidKey_SB(tnvt.AID_ROLL_UP, scrlfield.getSliderColPos(), scrlfield.startPos);
//				} else if (start < row) {
//					cpr *= (row - start);
//					sessionVT.sendAidKey_SB(tnvt.AID_ROLL_DOWN, cpr, scrlfield.startPos);
//				} else if (start > row) {
//					cpr *= (start - row);
//					sessionVT.sendAidKey_SB(tnvt.AID_ROLL_UP, cpr, scrlfield.startPos);
//				}
				cpr *= (row - scrlfield.startRow() - 1);
				int c= scrlfield.getSliderColPos();
//				System.out.println("FROM " + c + " TO " + cpr);
				if (c < cpr) {
//					System.out.println("DOWN");
					sessionVT.sendAidKey_SB(tnvt.AID_ROLL_DOWN, cpr - c, scrlfield.startPos, scrlfield);
				} if (c > cpr) {
//					System.out.println("UP");
					sessionVT.sendAidKey_SB(tnvt.AID_ROLL_UP, c - cpr, scrlfield.startPos, scrlfield);
				}
// chg end
				dragg_startpos= 0;
				return (true);
			case MouseEvent.MOUSE_EXITED:
				return (true);
		}
		return (false);
	}

	// chg pei 061101 Synchronized
	//public void moveCursor(MouseEvent e) {
	public synchronized void moveCursor(MouseEvent e) {
		if (!keyboardLocked) {

			int pos = getPosFromView(e.getX(), e.getY());
			//         System.out.println((getRow(pos)) + "," + (getCol(pos)));
			//         System.out.println(e.getX() + "," + e.getY()+ "," + fmWidth+ "," + fmHeight);
			if (pos < 0)
				return;
			// because getRowColFromPoint returns offset of 1,1 we need to
			//    translate to offset 0,0
			//         pos -= (numCols + 1);
			int g = screen[pos].getWhichGUI();

			// lets check for button V1.3
			if (screenFields.isInField(pos)) {
				ScreenField sf= screenFields.getCurrentField();
				switch (sf.getType()) {
					case ScreenField.F_BUTTON:
						setCursorActive(false);
						lastPos= pos;
						gui.sendAidKey(((ButtonField)sf).getAid());
						return;
					case ScreenField.F_SINGLESELECTION:
					case ScreenField.F_MULTISELECTION:
					// add pei 080208
					case ScreenField.F_SINGLESELECTION_PD:
					case ScreenField.F_SINGLESELECTION_LIST:
// chg start pei 080312
						//SingleSelectionField ssf= (SingleSelectionField)sf;
						SelectionField ssf= (SelectionField)sf;
						// chg pei 080312 
						//int sp= getRow(pos) - ssf.startRow() + 1;
						int sp= ssf.getChoice(pos);
// chg start pei 080208
//						if (ssf.isAvalilable(sp)) {
//							ssf.setSelectPos(sp == ssf.getSelectPos() ? 0 : sp);
//							screenFields.setCurrentFieldMDT();
//							drawSingleSelection(ssf);
//						}
						if (sp != -1) {
							if (!ssf.isAvalilable(sp)) {
								displayError(ERR_MOUSE_NO_ALLOWED);
								return;
							}
//							ssf.setSelectPos(sp == ssf.getSelectPos() ? 0 : sp);
							ssf.setSelectPos(sp);
							screenFields.setCurrentFieldMDT();
							drawSelection(ssf);
						} else {
						//if (!ssf.isAvalilable(sp)) {
							displayError(ERR_MOUSE_NO_ALLOWED);
							return;

						}
//						ssf.setSelectPos(sp == ssf.getSelectPos() ? 0 : sp);
//						screenFields.setCurrentFieldMDT();
//						drawSelection(ssf);
// chg end
// chg end
						break;
					// add pei 080208
					case ScreenField.F_MENU:
						setCursorOff();
						// chg pei 080312 classύX
						//ssf= (SingleSelectionField)sf;
						ssf= (SelectionField)sf;
						boolean chg= ssf.changeMenu(pos);
						setCursorOn();
						lastPos= pos;
						if (chg) {
							screenFields.setCurrentFieldMDT();
							sendAid(tnvt.AID_ENTER);
						}
						return;
				}
			}
			// lets check for hot spots
			if (g >= ScreenChar.BUTTON_LEFT && g <= ScreenChar.BUTTON_LAST) {
				StringBuffer aid = new StringBuffer();
				boolean aidFlag = true;
				switch (g) {
					case ScreenChar.BUTTON_RIGHT :
					case ScreenChar.BUTTON_MIDDLE :
						while (screen[--pos].getWhichGUI()
							!= ScreenChar.BUTTON_LEFT) {
						}
					case ScreenChar.BUTTON_LEFT :
						if (screen[pos].getChar() == 'F') {
							pos++;
						} else
							aidFlag = false;
// chg pei 061128 hotspot
						//if (screen[pos + 1].getChar() != '='
						//	&& screen[pos + 1].getChar() != '.'
						//	&& screen[pos + 1].getChar() != '/') {
						if (screen[pos + 1].getChar() >= '0'
							&& screen[pos + 1].getChar() <= '9') {
							//		System.out.println(" Hotspot clicked!!! we will send characters " +
							//		screen[pos].getChar() +
							//		screen[pos+1].getChar());
							aid.append(screen[pos].getChar());
							aid.append(screen[pos + 1].getChar());
						} else {
							//		System.out.println(" Hotspot clicked!!! we will send character " +
							//		screen[pos].getChar());
							//
							aid.append(screen[pos].getChar());
						}
						break;

				}
				if (aidFlag) {
					switch (g) {

						case ScreenChar.BUTTON_LEFT_UP :
						case ScreenChar.BUTTON_MIDDLE_UP :
						case ScreenChar.BUTTON_RIGHT_UP :
							gui.sendAidKey(tnvt.AID_ROLL_UP);
							break;
						case ScreenChar.BUTTON_ONE_UP :
							// chg pei 080208
//							sessionVT.sendAidKey_SB(tnvt.AID_ROLL_UP, 1, pos);
							ScrollBarField sbf= (ScrollBarField)screenFields.getCurrentField();
							sessionVT.sendAidKey_SB(tnvt.AID_ROLL_UP, 1, pos, sbf);
							break;
						case ScreenChar.BUTTON_SB_UP :
						case ScreenChar.BUTTON_SB_GUIDE :
							// chg pei 080208
//							ScrollBarField sbf= (ScrollBarField)screenFields.getCurrentField();
//							sessionVT.sendAidKey_SB(tnvt.AID_ROLL_UP, 0, sbf.startPos);
							sbf= (ScrollBarField)screenFields.getCurrentField();
							sessionVT.sendAidKey_SB(tnvt.AID_ROLL_UP, sbf.getRows(), sbf.startPos, sbf);
							break;

						case ScreenChar.BUTTON_LEFT_DN :
						case ScreenChar.BUTTON_MIDDLE_DN :
						case ScreenChar.BUTTON_RIGHT_DN :
							gui.sendAidKey(tnvt.AID_ROLL_DOWN);
							break;
						case ScreenChar.BUTTON_ONE_DN :
							sbf= (ScrollBarField)screenFields.getCurrentField();
//							sessionVT.sendAidKey_SB(tnvt.AID_ROLL_DOWN, 1, sbf.startPos);
							sessionVT.sendAidKey_SB(tnvt.AID_ROLL_DOWN, 1, sbf.startPos, sbf);
							break;
						case ScreenChar.BUTTON_SB_DN :
						case ScreenChar.BUTTON_SB_THUMB :
							sbf= (ScrollBarField)screenFields.getCurrentField();
//							sessionVT.sendAidKey_SB(tnvt.AID_ROLL_DOWN, 0, sbf.startPos);
							sessionVT.sendAidKey_SB(tnvt.AID_ROLL_DOWN, sbf.getRows(), sbf.startPos, sbf);
							break;

						case ScreenChar.BUTTON_LEFT_EB :
						case ScreenChar.BUTTON_MIDDLE_EB :
						case ScreenChar.BUTTON_RIGHT_EB :
							System.out.println("Send to external Browser");
							break;

						default :
							int aidKey = Integer.parseInt(aid.toString());
							if (aidKey >= 1 && aidKey <= 12)
								gui.sendAidKey(0x30 + aidKey);
							if (aidKey >= 13 && aidKey <= 24)
								gui.sendAidKey(0xB0 + (aidKey - 12));
					}
				} else {
					if (screenFields.getCurrentField() != null) {
						int xPos = screenFields.getCurrentField().startPos();
						for (int x = 0; x < aid.length(); x++) {
							//                  System.out.println(sr + "," + (sc + x) + " " + aid.charAt(x));
							screen[xPos
								+ x].setChar(
									aid.charAt(x),
									0,
									sessionVT.getCodePage().uni2ebcdic(
										aid.charAt(x), false)[0]);
						}
						//			System.out.println(aid);
						screenFields.setCurrentFieldMDT();
						gui.sendAidKey(tnvt.AID_ENTER);
					}

				}
			} else {
				// this is a note to not execute this code here when we implement
				//   the remain after edit function option.
				if (gui.rubberband.isAreaSelected()) {
					gui.rubberband.reset();
					gui.repaint();
				} else {
					goto_XY_with_C(pos);
					isInField(lastPos);
				}
			}
		}
		gui.requestFocus();
	}

	/**
	 *
	 *
	 * @param x
	 * @param y
	 * @return
	 */
	public int getPosFromView(int x, int y) {

		// we have to translate the point into a an upper left 0,0 based format
		// to get the position into the character array which is 0,0 based.
		// we take the point of x,y and subtract the screen offsets.

		x -= bi.offLeft;
		y -= bi.offTop;

		if (x > tArea.getMaxX())
			x = (int) tArea.getMaxX() - 1;
		if (y > tArea.getMaxY())
			y = (int) tArea.getMaxY() - 1;
		if (x < tArea.getMinX())
			x = 0;
		if (y < tArea.getMinY())
			y = 0;

		//      int s = fmWidth * numCols; // image length in pixels
		//      int t = s - x; // image length minus the  x point
		//      int u = t / fmWidth; //
		//      int v = numCols - u; //

		int s0 = y / fmHeight;
		int s1 = x / fmWidth;

		//      System.out.println("row " + s0 + ", column " + s1 + " pos " + getPos(s0,s1));
		//      return getPos((numRows - ((((fmHeight * (numRows)) - y) / fmHeight))),
		//                     (numCols - ((((fmWidth * (numCols)) - x) / fmWidth)))
		//                  );
		return getPos(s0, s1);

	}

	/**
	 * Return the row column based on the screen x,y position coordinates
	 *
	 * It will calculate a 0,0 based row and column based on the screen point
	 * coordinate.
	 *
	 * @param x screen x position
	 * @param y screen y position
	 *
	 * @return screen array position based 0,0 so position row 1 col 3 would be 2
	 */
	public int getRowColFromPoint(int x, int y) {

		if (x > tArea.getMaxX())
			x = (int) tArea.getMaxX() - 1;
		if (y > tArea.getMaxY())
			y = (int) tArea.getMaxY() - 1;
		if (x < tArea.getMinX())
			x = 0;
		if (y < tArea.getMinY())
			y = 0;

		//      int s = fmWidth * numCols; // image length in pixels
		//      int t = s - x; // image length minus the  x point
		//      int u = t / fmWidth; //
		//      int v = numCols - u; //

		int s0 = y / fmHeight;
		int s1 = x / fmWidth;

		//      System.out.println("row " + s0 + ", column " + s1 + " pos " + getPos(s0,s1));
		//      return getPos((numRows - ((((fmHeight * (numRows)) - y) / fmHeight))),
		//                     (numCols - ((((fmWidth * (numCols)) - x) / fmWidth)))
		//                  );
		return getPos(s0, s1);

		//      return 0;
	}

	/**
	 * This will return the screen coordinates of a row and column.
	 *
	 * @param r
	 * @param c
	 * @param point
	 */
	public void getPointFromRowCol(int r, int c, Point point, boolean to) {

		// here the x + y coordinates of the row and column are obtained from
		// the character array which is based on a upper left 0,0 coordinate
		//  we will then add to that the offsets to get the screen position point
		//  x,y coordinates.  Maybe change this to a translate routine method or
		//  something.
		//pei
		int pos = getPos(r, c);
		if (to) {
			if (screen[pos].getDBCF() == ScreenChar.F_DBC1)
				++pos;
		} else {
			if (screen[pos].getDBCF() == ScreenChar.F_DBC2)
				--pos;
		}
		point.x = screen[pos].x + bi.offLeft;
		point.y = screen[pos].y + bi.offTop;

	}

	protected void setVT(tnvt v) {

		sessionVT = v;
	}

	/**
	 * Searches the mnemonicData array looking for the specified string.  If
	 * it is found it will return the value associated from the mnemonicValue
	 *
	 * @see #sendKeys
	 * @param mnem string mnemonic value
	 * @return key value of Mnemonic
	 */
	private int getMnemonicValue(String mnem) {

		for (int x = 0; x < mnemonicData.length; x++) {

			if (mnemonicData[x].equals(mnem))
				return mnemonicValue[x];
		}
		return 0;

	}

	protected void setPrehelpState(
		boolean setErrorCode,
		boolean lockKeyboard,
		boolean unlockIfLocked) {
		statusErrorCode = setErrorCode;
		bufferedKeys = null;
		keysBuffered = false;
		if (isKeyboardLocked() && unlockIfLocked)
			setKeyboardLocked(false);
		else
			setKeyboardLocked(lockKeyboard);
		setKBIndicatorOff();
	}

	/**
	 * Activate the cursor on screen
	 *
	 * @param activate
	 */
	// chg pei 061101 Synchronized
	//public void setCursorActive(boolean activate) {
	public synchronized void setCursorActive(boolean activate) {

		//		System.out.println("cursor active " + updateCursorLoc + " " + cursorActive + " " + activate);
		//System.out.println("cursor active " + cursorActive + " " + activate);
		if (cursorActive && !activate) {
			setCursorOff();
			cursorActive = activate;
		} else {
			if (!cursorActive && activate) {
				cursorActive = activate;
				setCursorOn();
			}
		}
	}

	/**
	 * Set the cursor on
	 */
	// chg pei 061101 Synchronized폜 publicprivateɕύX
	//public synchronized void setCursorOn() {
	private void setCursorOn() {

		int ftype= 0;
		ScreenField sf= null;
		if (screenFields != null) {
			if (screenFields.isInField()) {
				sf= screenFields.getCurrentField();
				ftype= sf.getType();
			}
		}
		switch (ftype) {
			case ScreenField.F_BUTTON:
				if (!cursorbtn) {
					fieldReverse(sf.startPos, sf.length);
					cursorbtn= true;
					// add pei 060823 p͂ɕύX
					changeIM(1);
				}
				break;
			case ScreenField.F_SINGLESELECTION:
			case ScreenField.F_MULTISELECTION:
// add start pei 080312
			case ScreenField.F_MENU:
				if (!cursorbtn) {
					SelectionField ssf= (SelectionField)sf;
					int sp= ssf.getChoice(lastPos);
					if (sp != -1) {
						lastPos= ssf.getChoice_pos(sp);
						fieldReverse(ssf.getChoice_pos(sp), ssf.getChoice_len(sp));
						cursorbtn= true;
						// add pei 060823 p͂ɕύX
						changeIM(1);
						if (ftype == ScreenField.F_MENU) {
							ssf.setSelectPos(sp);
						}
					}
				}
				break;
// add end
			// add pei 080208
			case ScreenField.F_SINGLESELECTION_PD:
			case ScreenField.F_SINGLESELECTION_LIST:
				if (!cursorbtn) {
					fieldReverse(getPos(getRow(lastPos), sf.startCol()), sf.length);
					cursorbtn= true;
					// add pei 060823 p͂ɕύX
					changeIM(1);
				}
				break;
//			// add pei 080208
//			case ScreenField.F_MENU:
//
//				if (!cursorbtn) {
//					int mn= ((SingleSelectionField)sf).getSelectPos();
//					lastPos= ((SingleSelectionField)sf).getMenu_pos(mn);
//					fieldReverse(lastPos, ((SingleSelectionField)sf).getMenu_len(mn));
//					cursorbtn= true;
//				}
//				break;

			case 0:
				updateCursorLoc(true);		// on
				cursorShown = true;
				break;
		}
	}

	/**
	 * Set the cursor off
	 */
	// chg pei 061101 Synchronized폜 publicprivateɕύX
	//public synchronized void setCursorOff() {
	private void setCursorOff() {
		int ftype= 0;
		ScreenField sf= null;
		if (screenFields != null) {
			if (screenFields.isInField()) {
				sf= screenFields.getCurrentField();
				ftype= sf.getType();
			}
		}
		switch (ftype) {
			case ScreenField.F_BUTTON:
				fieldReverse(sf.startPos, sf.length);
				cursorbtn= false;
				break;
			case ScreenField.F_SINGLESELECTION:
			case ScreenField.F_MULTISELECTION:
// add start pei 080312
				SelectionField ssf= (SelectionField)sf;
				int sp= ssf.getChoice(lastPos);
				if (sp != -1) {
					fieldReverse(ssf.getChoice_pos(sp), ssf.getChoice_len(sp));
					cursorbtn= false;
				} else {
					updateCursorLoc(false);	// off
					if (!cursorShown) {
						updateCursorLoc2(false, false);
					}
					cursorShown = false;
				}
				break;
// add end
			// add pei 080208
			case ScreenField.F_SINGLESELECTION_PD:
			case ScreenField.F_SINGLESELECTION_LIST:
				fieldReverse(getPos(getRow(lastPos), sf.startCol()), sf.length);
				cursorbtn= false;
				break;
			// add pei 080208
			case ScreenField.F_MENU:
				// chg pei 080312 classύX
				//int mn= ((SingleSelectionField)sf).getSelectPos();
				//fieldReverse(((SingleSelectionField)sf).getMenu_pos(mn), ((SingleSelectionField)sf).getMenu_len(mn));
				int mn= ((SelectionField)sf).getSingleSelectedPos();
				fieldReverse(((SelectionField)sf).getChoice_pos(mn), ((SelectionField)sf).getChoice_len(mn));
				cursorbtn= false;
				break;
				
			case 0:
				updateCursorLoc(false);	// off
				if (!cursorShown) {
					updateCursorLoc2(false, false);
				}
				cursorShown = false;
				break;
		}
	}

	/**
	 *
	 */
	private boolean updateCursorLoc(boolean on) {
		return (updateCursorLoc2(true, on));
	}

	private synchronized boolean updateCursorLoc2(boolean ruler, boolean on) {
		boolean ret= false;
//		System.out.println("cursor loc " + updateCursorLoc + " " + cursorActive);
		if (cursorActive) {

			int row = getRow(lastPos);
			int col = getCol(lastPos);
			int dbcf = screen[lastPos].getDBCF();
			int adj = 0;
			int w = 1;

			// Add By Pei
			if (dbcf == ScreenChar.F_DBC2) {
				adj = (col == 0) ? 1 : -1;
				dbcf = screen[lastPos + adj].getDBCF();
			}
			if ((dbcf == ScreenChar.F_DBC1 || dbcf == ScreenChar.F_DBC_OUT)
				&& col != numCols - 1) {
				w = 2;
			}
			// chg pei 060728 colorBlueǉ
			bi.drawCursor(
				this,
				row,
				col + adj,
				fmWidth,
				fmHeight,
				insertMode,
				ruler ? crossHair : 0,
				rulerFixed,
				cursorSize,
				colorCursor,
				colorBg,
				colorWhite,
				colorBlue,
				font,
				cursorBottOffset,
				w);
			//pei
			if (on) {	// only cursor on
				changeIM(w);
			}
			ret= true;
		}
		return (ret);
	}

	/**
	 * The sendKeys method sends a string of keys to the virtual screen. This
	 * method acts as if keystrokes were being typed from the keyboard.  The
	 * keystrokes will be sent to the location given. The string being passed can
	 * also contain mnemonic values such as [enter] enter key,[tab] tab key,
	 * [pf1] pf1 etc...
	 *
	 * These will be processed as if you had pressed these keys from the keyboard.
	 * All the valid special key values are contained in the MNEMONIC
	 * enumeration:
	 *
	 * <table BORDER COLS=2 WIDTH="50%" >
	 *
	 * <tr><td>MNEMONIC_CLEAR </td><td>[clear]</td></tr>
	 * <tr><td>MNEMONIC_ENTER </td><td>[enter]</td></tr>
	 * <tr><td>MNEMONIC_HELP </td><td>[help]</td></tr>
	 * <tr><td>MNEMONIC_PAGE_DOWN </td><td>[pgdown]</td></tr>
	 * <tr><td>MNEMONIC_PAGE_UP </td><td>[pgup]</td></tr>
	 * <tr><td>MNEMONIC_PRINT </td><td>[print]</td></tr>
	 * <tr><td>MNEMONIC_PF1 </td><td>[pf1]</td></tr>
	 * <tr><td>MNEMONIC_PF2 </td><td>[pf2]</td></tr>
	 * <tr><td>MNEMONIC_PF3 </td><td>[pf3]</td></tr>
	 * <tr><td>MNEMONIC_PF4 </td><td>[pf4]</td></tr>
	 * <tr><td>MNEMONIC_PF5 </td><td>[pf5]</td></tr>
	 * <tr><td>MNEMONIC_PF6 </td><td>[pf6]</td></tr>
	 * <tr><td>MNEMONIC_PF7 </td><td>[pf7]</td></tr>
	 * <tr><td>MNEMONIC_PF8 </td><td>[pf8]</td></tr>
	 * <tr><td>MNEMONIC_PF9 </td><td>[pf9]</td></tr>
	 * <tr><td>MNEMONIC_PF10 </td><td>[pf10]</td></tr>
	 * <tr><td>MNEMONIC_PF11 </td><td>[pf11]</td></tr>
	 * <tr><td>MNEMONIC_PF12 </td><td>[pf12]</td></tr>
	 * <tr><td>MNEMONIC_PF13 </td><td>[pf13]</td></tr>
	 * <tr><td>MNEMONIC_PF14 </td><td>[pf14]</td></tr>
	 * <tr><td>MNEMONIC_PF15 </td><td>[pf15]</td></tr>
	 * <tr><td>MNEMONIC_PF16 </td><td>[pf16]</td></tr>
	 * <tr><td>MNEMONIC_PF17 </td><td>[pf17]</td></tr>
	 * <tr><td>MNEMONIC_PF18 </td><td>[pf18]</td></tr>
	 * <tr><td>MNEMONIC_PF19 </td><td>[pf19]</td></tr>
	 * <tr><td>MNEMONIC_PF20 </td><td>[pf20]</td></tr>
	 * <tr><td>MNEMONIC_PF21 </td><td>[pf21]</td></tr>
	 * <tr><td>MNEMONIC_PF22 </td><td>[pf22]</td></tr>
	 * <tr><td>MNEMONIC_PF23 </td><td>[pf23]</td></tr>
	 * <tr><td>MNEMONIC_PF24 </td><td>[pf24]</td></tr>
	 * <tr><td>MNEMONIC_BACK_SPACE </td><td>[backspace]</td></tr>
	 * <tr><td>MNEMONIC_BACK_TAB </td><td>[backtab]</td></tr>
	 * <tr><td>MNEMONIC_UP </td><td>[up]</td></tr>
	 * <tr><td>MNEMONIC_DOWN </td><td>[down]</td></tr>
	 * <tr><td>MNEMONIC_LEFT </td><td>[left]</td></tr>
	 * <tr><td>MNEMONIC_RIGHT </td><td>[right]</td></tr>
	 * <tr><td>MNEMONIC_DELETE </td><td>[delete]</td></tr>
	 * <tr><td>MNEMONIC_TAB </td><td>"[tab]</td></tr>
	 * <tr><td>MNEMONIC_END_OF_FIELD </td><td>[eof]</td></tr>
	 * <tr><td>MNEMONIC_ERASE_EOF </td><td>[eraseeof]</td></tr>
	 * <tr><td>MNEMONIC_ERASE_FIELD </td><td>[erasefld]</td></tr>
	 * <tr><td>MNEMONIC_INSERT </td><td>[insert]</td></tr>
	 * <tr><td>MNEMONIC_HOME </td><td>[home]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD0 </td><td>[keypad0]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD1 </td><td>[keypad1]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD2 </td><td>[keypad2]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD3 </td><td>[keypad3]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD4 </td><td>[keypad4]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD5 </td><td>[keypad5]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD6 </td><td>[keypad6]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD7 </td><td>[keypad7]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD8 </td><td>[keypad8]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD9 </td><td>[keypad9]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD_PERIOD </td><td>[keypad.]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD_COMMA </td><td>[keypad,]</td></tr>
	 * <tr><td>MNEMONIC_KEYPAD_MINUS </td><td>[keypad-]</td></tr>
	 * <tr><td>MNEMONIC_FIELD_EXIT </td><td>[fldext]</td></tr>
	 * <tr><td>MNEMONIC_FIELD_PLUS </td><td>[field+]</td></tr>
	 * <tr><td>MNEMONIC_FIELD_MINUS </td><td>[field-]</td></tr>
	 * <tr><td>MNEMONIC_BEGIN_OF_FIELD </td><td>[bof]</td></tr>
	 * <tr><td>MNEMONIC_PA1 </td><td>[pa1]</td></tr>
	 * <tr><td>MNEMONIC_PA2 </td><td>[pa2]</td></tr>
	 * <tr><td>MNEMONIC_PA3 </td><td>[pa3]</td></tr>
	 * <tr><td>MNEMONIC_SYSREQ </td><td>[sysreq]</td></tr>
	 * <tr><td>MNEMONIC_RESET </td><td>[reset]</td></tr>
	 * <tr><td>MNEMONIC_ATTN </td><td>[attn]</td></tr>
	 * <tr><td>MNEMONIC_MARK_LEFT </td><td>[markleft]</td></tr>
	 * <tr><td>MNEMONIC_MARK_RIGHT </td><td>[markright]</td></tr>
	 * <tr><td>MNEMONIC_MARK_UP </td><td>[markup]</td></tr>
	 * <tr><td>MNEMONIC_MARK_DOWN </td><td>[markdown]</td></tr>
	 *
	 * </table>
	 *
	 * @param text The string of characters to be sent
	 *
	 * @see #sendAid
	 *
	 */
	public synchronized void sendKeys(String text) {

		//      if (text == null) {
		//         return;
		//      }
		if (isStatusErrorCode() && !resetRequired) {
			setCursorActive(false);
// chg start pei 060710 G[͎͂󂯕tȂ
			//simulateMnemonic(getMnemonicValue("[reset]"));
			//setCursorActive(true);
			
			if (text.length() == 1 && !text.equals("[") && !text.equals("]")) {
				return;
			} else {
				simulateMnemonic(getMnemonicValue("[reset]"));
				setCursorActive(true);
			}
// chg end
		}

		if (keyboardLocked) {
			if (text.equals("[reset]")
				|| text.equals("[sysreq]")
				|| text.equals("[attn]")) {
				setCursorActive(false);
				simulateMnemonic(getMnemonicValue(text));
				setCursorActive(true);

			} else {
				if (isStatusErrorCode()) {
					Toolkit.getDefaultToolkit().beep();
					return;
				}
// chg start pei L[obt@ON/OFF
				if (config.isPropertyExists("keybuffer")) {
					if (getStringProperty("keybuffer").equals("Yes")) {
						keysBuffered = true;
						setKBIndicatorOn();

						if (bufferedKeys == null) {
							bufferedKeys = text;
						return;
						} else {
							bufferedKeys += text;
							return;
						}
					}
					else {
						keysBuffered = false;

						return;
					}
				} else {
					setProperty("keybuffer","Yes");
					keysBuffered = true;
					setKBIndicatorOn();

					if (bufferedKeys == null) {
						bufferedKeys = text;
					return;
					} else {
						bufferedKeys += text;
						return;
					}
				}
/*						
				keysBuffered = true;
				setKBIndicatorOn();

				if (bufferedKeys == null) {
					bufferedKeys = text;
					return;
				} else {
					bufferedKeys += text;
					return;
				}
*/
// chg end
			}

		} else {

			if (keysBuffered) {
				if (bufferedKeys != null) {
					text = bufferedKeys + text;
				}
				//            if (text.length() == 0) {
				keysBuffered = false;
				setKBIndicatorOff();
				//            }
				bufferedKeys = null;

			}
			// check to see if position is in a field and if it is then change
			//   current field to that field
			isInField(lastPos, true);
			if (text.length() == 1 && !text.equals("[") && !text.equals("]")) {
				//               setCursorOff2();
				setCursorActive(false);
				simulateKeyStroke(text.charAt(0));
				setCursorActive(true);
				//               setCursorOn2();
				//                     System.out.println(" text one");

			} else {

				strokenizer.setKeyStrokes(text);
				String s;
				boolean done = false;

				//            setCursorOff2();
				setCursorActive(false);
				while (!done) {
					//            while (strokenizer.hasMoreKeyStrokes()  && !keyboardLocked &&
					//                        !isStatusErrorCode() && !done) {
					if (strokenizer.hasMoreKeyStrokes()) {

						s = strokenizer.nextKeyStroke();
						if (s.length() == 1) {
							//		setCursorOn();
							//		if (!keysBuffered) {
							//			System.out.println(" s two" + s);
							//			setCursorOn();
							//		}

							//		try { new Thread().sleep(400);} catch (InterruptedException ie) {}
							simulateKeyStroke(s.charAt(0));
							//			System.out.println(" s two " + s + " " + cursorActive);
							//			if (cursorActive && !keysBuffered) {
							//				System.out.println(" s two" + s);
							//				setCursorOn();
							//			}
						} else {

							if (s != null) {
								simulateMnemonic(getMnemonicValue(s));
								// add pei 080208
								screenFields.isInField();
								//		if (!cursorActive && !keysBuffered) {
								//			System.out.println(" m one");
								//			setCursorOn();
								//		}
							} else
								System.out.println(" send keys mnemonic " + s);
						}
						if (keyboardLocked) {

							bufferedKeys =
								strokenizer.getUnprocessedKeyStroked();
							if (bufferedKeys != null) {
								keysBuffered = true;
								setKBIndicatorOn();

							}
							done = true;
						}

					} else {
						//	setCursorActive(true);
						//	setCursorOn();
						done = true;
					}
				}
				setCursorActive(true);
			}
		}
	}

	/**
	 * The sendAid method sends an "aid" keystroke to the virtual screen. These
	 * aid keys can be thought of as special keystrokes, like the Enter key,
	 * PF1-24 keys or the Page Up key. All the valid special key values are
	 * contained in the AID_ enumeration:
	 *
	 * @param aidKey The aid key to be sent to the host
	 *
	 * @see #sendKeys
	 * @see TN5250jConstants#AID_CLEAR
	 * @see #AID_ENTER
	 * @see #AID_HELP
	 * @see #AID_ROLL_UP
	 * @see #AID_ROLL_DOWN
	 * @see #AID_ROLL_LEFT
	 * @see #AID_ROLL_RIGHT
	 * @see #AID_PRINT
	 * @see #AID_PF1
	 * @see #AID_PF2
	 * @see #AID_PF3
	 * @see #AID_PF4
	 * @see #AID_PF5
	 * @see #AID_PF6
	 * @see #AID_PF7
	 * @see #AID_PF8
	 * @see #AID_PF9
	 * @see #AID_PF10
	 * @see #AID_PF11
	 * @see #AID_PF12
	 * @see #AID_PF13
	 * @see #AID_PF14
	 * @see #AID_PF15
	 * @see #AID_PF16
	 * @see #AID_PF17
	 * @see #AID_PF18
	 * @see #AID_PF19
	 * @see #AID_PF20
	 * @see #AID_PF21
	 * @see #AID_PF22
	 * @see #AID_PF23
	 * @see #AID_PF24
	 */
	public void sendAid(int aidKey) {

		sessionVT.sendAidKey(aidKey);
	}

	/**
	 * Restores the error line and sets the error mode off.
	 *
	 */
	public void resetError() {

		restoreErrorLine();
		setStatus(STATUS_ERROR_CODE, STATUS_VALUE_OFF, "");

	}

	protected boolean simulateMnemonic(int mnem) {
		if (gui.im_aci != null)
			return false;

		boolean simulated = false;
		
		// chg pei 071116
		//if (mnem != FIELD_EXIT && mnem != RESET && mnem != TAB) lastpos_mdt= false;
		if (mnem != FIELD_EXIT && mnem != RESET && mnem != TAB && mnem != FIELD_MINUS) 
			lastpos_mdt= false;
		
		// add pei 080208
		ScreenField cf= screenFields.getCurrentField();
		switch (mnem) {

			case AID_CLEAR :
			case AID_ENTER :
			case AID_PF1 :
			case AID_PF2 :
			case AID_PF3 :
			case AID_PF4 :
			case AID_PF5 :
			case AID_PF6 :
			case AID_PF7 :
			case AID_PF8 :
			case AID_PF9 :
			case AID_PF10 :
			case AID_PF11 :
			case AID_PF12 :
			case AID_PF13 :
			case AID_PF14 :
			case AID_PF15 :
			case AID_PF16 :
			case AID_PF17 :
			case AID_PF18 :
			case AID_PF19 :
			case AID_PF20 :
			case AID_PF21 :
			case AID_PF22 :
			case AID_PF23 :
			case AID_PF24 :
			case AID_ROLL_DOWN :
			case AID_ROLL_UP :
			case AID_ROLL_LEFT :
			case AID_ROLL_RIGHT :

				ScreenField csf= screenFields.getCurrentField2();
				// chg pei 080208
//				if (csf != null && csf.getType() == ScreenField.F_SINGLESELECTION) {
				if (csf != null && (csf.getType() == ScreenField.F_SINGLESELECTION)) {
					// chg pei 080312 classύX
					//SingleSelectionField ssf= (SingleSelectionField)csf;
					SelectionField ssf= (SelectionField)csf;
					// chg pei 080208
					//if ((ssf.getFlag1() & 0x02) != 0) {
					// chg pei 080312 \bhύX
					//if ((ssf.getFlag1() & 0x02) != 0 && ssf.getSelectPos() == 0) {
					if ((ssf.getFlag1() & 0x02) != 0 && ssf.getSingleSelectedPos() == 0) {
						simulateKeyStroke(' ');
					}
				}
// add start pei 061128 S̓tB[hQΉ
				if (csf != null
					&& !csf.isContinued()
					&& !fill_check(csf)) {
					simulated = true;
					break;
				}
// add end
				if (!screenFields.isCanSendAid()) {
					displayError(ERR_ENTER_NO_ALLOWED);
				} else {
					sendAid(mnem);
				}
				simulated = true;

				break;
			case AID_HELP :
				sessionVT.sendHelpRequest();
				simulated = true;
				break;

			case AID_PRINT :
				sessionVT.hostPrint(1);
				simulated = true;
				break;

			case BACK_SPACE :
				if (screen[lastPos].getDBCF() == ScreenChar.F_DBC2) {
					--lastPos;
					screenFields.getCurrentField().changePos(-1);
				}
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {

					if (screenFields.getCurrentField().startPos() == lastPos)
						displayError(ERR_CURSOR_PROTECTED);

					else {
						screenFields.getCurrentField().getKeyPos(lastPos);
						screenFields.getCurrentField().changePos(-1);
						int ppos =
							screenFields.getCurrentField().getCurrentPos();
						resetDirty(ppos);
						int dbcc = 1;
						switch (screen[ppos].getDBCF()) {
							case ScreenChar.F_DBC_IN :
								if (screen[ppos + 1].getDBCF()
									== ScreenChar.F_DBC_OUT) {
									dbcc = 2;
								} else {
									displayError(ERR_CURSOR_PROTECTED);
									dbcc = 0;
								}
								break;
							case ScreenChar.F_DBC2 :
								--ppos;
								dbcc = 2;
								break;
							case ScreenChar.F_DBC_OUT :
								displayError(ERR_CURSOR_PROTECTED);
								dbcc = 0;
								break;
						}
						shiftLeft(ppos, dbcc);
						updateDirty();
						screenFields.setCurrentFieldMDT();

						simulated = true;
					}
				} else {
					displayError(ERR_CURSOR_PROTECTED);

				}
				break;
// add pei start 060728 CHAR_BACKSPACE
			case CHAR_BACKSPACE :
				if (screen[lastPos].getDBCF() == ScreenChar.F_DBC2) {
					--lastPos;
					screenFields.getCurrentField().changePos(-1);
				}
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {
					// ݂̃|WVtB[h̐擪̏ꍇ
					if (screenFields.getCurrentField().startPos() == lastPos) {			
						// ÕtB[hɈړ
						gotoFieldPrev(false);
						// add pei 071026 cQΉ
						setCursorActive(false);
						lastPos = screenFields.getCurrentField().endPos;
						resetDirty(lastPos);
						// tB[h̍ŌɃ|WVړ
						goto_XY(lastPos);
						if(screen[lastPos].getDBCF() == ScreenChar.F_DBC_OUT) {
							goto_XY(--lastPos);
						}
					} else {
						screenFields.getCurrentField().getKeyPos(lastPos);
						// |WV1OɈړ
						screenFields.getCurrentField().changePos(-1);
						int lastPos =
							screenFields.getCurrentField().getCurrentPos();
						resetDirty(lastPos);
						// 1̃|WV̏Ԃɂă|WVύX
						switch (screen[lastPos].getDBCF()) {
							case ScreenChar.F_DBC_IN :
								if(screenFields.getCurrentField().startPos() == lastPos) {
									// ÕtB[hɈړ
									gotoFieldPrev(false);
									// add pei 071026 cQΉ
									setCursorActive(false);
									lastPos = screenFields.getCurrentField().endPos;
									// tB[h̍ŌɃ|WVړ
									goto_XY(lastPos);
									if(screen[lastPos].getDBCF() == ScreenChar.F_DBC_OUT) {
										goto_XY(--lastPos);	
									}
								} else {
									goto_XY(--lastPos);
								}
								break;
							case ScreenChar.F_DBC2 :
								goto_XY(--lastPos);
								break;
							case ScreenChar.F_DBC_OUT :
								goto_XY(--lastPos);
								break;
							default :
								goto_XY(lastPos);
								break; 
						}
					}
					simulated = true;
				} else {
					// tB[h݂邩ǂ̔
					if (screenFields.getCurrentField() != null) {
						// ÕtB[hɈړ
						gotoFieldPrev(false);
						// add pei 071026 cQΉ
						setCursorActive(false);
						lastPos = screenFields.getCurrentField().endPos;
						// tB[h̍ŌɃ|WVړ
						goto_XY(screenFields.getCurrentField().endPos);
						if(screen[lastPos].getDBCF() == ScreenChar.F_DBC_OUT) {
							goto_XY(--lastPos);
						}
						simulated = true;
					}
				}
				break;
// add end
			case BACK_TAB :
// add start pei 061128 S̓tB[hQΉ
				// chg pei 080208
//				if (screenFields.getCurrentField() != null
//					&& !screenFields.isCurrentFieldContinued()
//					&& !fill_check(screenFields.getCurrentField())) {
				if (cf != null && !cf.isContinued() && !fill_check(cf)) {
					simulated = true;
					break;
				}
// add end
				// chg pei 080208
//				if (screenFields.getCurrentField() != null
//					&& screenFields.isCurrentFieldHighlightedEntry()) {
//					resetDirty(screenFields.getCurrentField().startPos);
				if (cf != null
					&& cf.isHiglightedEntry()) {
					resetDirty(cf.startPos);
					gotoFieldPrev(true);
					updateDirty();
				// chg pei 080208
//				} else {
//					gotoFieldPrev(true);
//				}
				} else {
					if (cf.getType() == ScreenField.F_MENU) {
						// chg pei 080312
//						SingleSelectionField ssf= (SingleSelectionField)cf;
//						ssf.advanceMenu(false);
//						goto_XY(ssf.getMenu_pos(ssf.getSelectPos()));
						SelectionField ssf= (SelectionField)cf;
						ssf.advancePos(false);
						goto_XY(ssf.getChoice_pos(ssf.getSingleSelectedPos()));
					} else {
						gotoFieldPrev(true);
					}
				}
				// chg pei 071025
				//if (screenFields.isCurrentFieldContinued()) {
				if (screenFields.isCurrentFieldContinued() && !screenFields.isCurrentFieldContinuedFirst()) {
					do {
						gotoFieldPrev(true);
					} while (
//						screenFields.isCurrentFieldContinuedMiddle()
//							|| screenFields.isCurrentFieldContinuedLast());
						screenFields.isInField() &&
						(screenFields.isCurrentFieldContinuedMiddle()
							|| screenFields.isCurrentFieldContinuedLast()));
				}
				isInField(lastPos);
				simulated = true;
				break;
			case UP :
			case MARK_UP :
				// chg pei 080208
//				process_XY(-numCols);
				if (cf != null && cf.isSelectionField()) {
					// chg pei 080312
					//ss_up(cf);
					ss_up((SelectionField)cf);
				} else {
					process_XY(-numCols);
				}
				simulated = true;
				break;
			case DOWN :
			case MARK_DOWN :
				// chg pei 080208
//				process_XY(numCols);
				if (cf != null && cf.isSelectionField()) {
					// chg pei 08032
					//ss_down(cf);
					ss_down((SelectionField)cf);
				} else {
					process_XY(numCols);
				}
				simulated = true;
				break;
			case LEFT :
			case MARK_LEFT :
				if (screenFields.isInField()) {
					// chg pei 080208
					if (cf.isSelectionField()) {
						// chg pei 080312
						//ss_left(cf);
						ss_left((SelectionField)cf);
						simulated = true;
						break;
					} else {
//					ScreenField sf= screenFields.getCurrentField();
//						if (sf.isCField()) {
						if (cf.isCField()) {
							while (screenFields.isInField()) lastPos--;
							// add pei 080208
							if (lastPos < 0) lastPos += numRows * numCols;
							goto_XY(lastPos);
//							goto_XY(sf.startPos() - 1);
							simulated = true;
							break;
						}
					}
				}
				process_XY(-1);
				simulated = true;
				break;
			case RIGHT :
			case MARK_RIGHT :
				if (screenFields.isInField()) {
					if (cf.isSelectionField()) {
						// chg pei 080312
						//ss_right(cf);
						ss_right((SelectionField)cf);
						simulated = true;
						break;
					} else {
//					ScreenField sf= screenFields.getCurrentField();
//					if (sf.isCField()) {
						if (cf.isCField()) {
							while (screenFields.isInField()) lastPos++;
							goto_XY(lastPos);
//							goto_XY(sf.startPos() + sf.getLength());
							simulated = true;
							break;
						}
					}
				}
				process_XY(1);
				simulated = true;
				break;
			case NEXTWORD :
				gotoNextWord();
				simulated = true;
				break;
			case PREVWORD :
				gotoPrevWord();
				simulated = true;
				break;
			case DELETE :
				if (screen[lastPos].getDBCF() == ScreenChar.F_DBC2) {
					--lastPos;
				}
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {
					// pei
					int dbcc = 1;
					switch (screen[lastPos].getDBCF()) {
						case ScreenChar.F_DBC_IN :
							if (screen[lastPos + 1].getDBCF()
								== ScreenChar.F_DBC_OUT) {
								dbcc = 2;
							} else {
								displayError(ERR_CURSOR_PROTECTED);
								dbcc = 0;
							}
							break;
						case ScreenChar.F_DBC1 :
							dbcc = 2;
							break;
						case ScreenChar.F_DBC2 :
							displayError(ERR_CURSOR_PROTECTED);
							dbcc = 0;
							break;
						case ScreenChar.F_DBC_OUT :
							if (screen[lastPos + 1].getDBCF() == ScreenChar.F_DBC_IN) {
								dbcc = 2;
								break;
							}
							displayError(ERR_CURSOR_PROTECTED);
							dbcc = 0;
							break;
					}
					resetDirty(lastPos);
					screenFields.getCurrentField().getKeyPos(lastPos);
					shiftLeft(screenFields.getCurrentFieldPos(), dbcc);
					screenFields.setCurrentFieldMDT();
					updateDirty();
					simulated = true;
				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}

				break;
			case TAB :
				// chg pei 080208
//				if (screenFields.getCurrentField() != null
//					&& !screenFields.isCurrentFieldContinued()) {
//					if (!fill_check(screenFields.getCurrentField())) {
				if (cf != null && !cf.isContinued()) {
					if (!fill_check(cf)) {
						simulated = true;
						break;
					}
					// chg pei 080208
//					if (screenFields.isCurrentFieldHighlightedEntry()) {
					if (cf.isHiglightedEntry()) {
						resetDirty(screenFields.getCurrentField().startPos);
						// chg pei 071025 gotoFieldNextTABtOǉ
						//gotoFieldNext();
						gotoFieldNext(true);
						updateDirty();
					} else {
						// chg pei 071025 gotoFieldNextTABtOǉ
						//gotoFieldNext();
						// chg pei 080208
//						gotoFieldNext(true);
						if (cf.getType() == ScreenField.F_MENU) {
							// chg pei 080312
//							SingleSelectionField ssf= (SingleSelectionField)cf;
//							ssf.advanceMenu(true);
//							goto_XY(ssf.getMenu_pos(ssf.getSelectPos()));
							SelectionField ssf= (SelectionField)cf;
							ssf.advancePos(true);
							goto_XY(ssf.getChoice_pos(ssf.getSingleSelectedPos()));
						} else {
							gotoFieldNext(true);
						}
					}
				} else {
					do {
						// chg pei 071025 gotoFieldNextTABtOǉ
						//gotoFieldNext();
						gotoFieldNext(true);
					} while (
						// add pei 080312
						screenFields.isInField() &&
						screenFields.getCurrentField() != null
							&& (screenFields.isCurrentFieldContinuedMiddle()
								|| screenFields.isCurrentFieldContinuedLast()));
				}

				isInField(lastPos);
				simulated = true;

				break;
			case EOF :
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {
					int where =
						endOfField(
							screenFields.getCurrentField().startPos(),
							true);
					if (where > 0) {
						goto_XY((where / numCols) + 1, (where % numCols) + 1);
					}
					simulated = true;
				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}
				resetDirty(lastPos);

				break;
			case ERASE_EOF :
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {

					int where = lastPos;
					resetDirty(lastPos);
					if (fieldExit()) {
						screenFields.setCurrentFieldMDT();
						if (!screenFields.isCurrentFieldContinued()) {
							// chg pei 071025 gotoFieldNextTABtOǉ
							//gotoFieldNext();
							gotoFieldNext(false);
						} else {
							do {
								// chg pei 071025 gotoFieldNextTABtOǉ
								//gotoFieldNext();
								gotoFieldNext(false);
								if (screenFields.isCurrentFieldContinued())
									fieldExit();
							} while (
								screenFields.isCurrentFieldContinuedMiddle()
									|| screenFields.isCurrentFieldContinuedLast());
						}
					}
					updateDirty();
					goto_XY(where);
					simulated = true;

				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}

				break;
			case ERASE_FIELD :
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {

					int where = lastPos;
					lastPos = screenFields.getCurrentField().startPos();
					resetDirty(lastPos);
					if (fieldExit()) {
						screenFields.setCurrentFieldMDT();
						if (!screenFields.isCurrentFieldContinued()) {
							// chg pei 071025 gotoFieldNextTABtOǉ
							//gotoFieldNext();
							gotoFieldNext(false);
						} else {
							do {
								// chg pei 071025 gotoFieldNextTABtOǉ
								//gotoFieldNext();
								gotoFieldNext(false);
								if (screenFields.isCurrentFieldContinued())
									fieldExit();
							} while (
								screenFields.isCurrentFieldContinuedMiddle()
									|| screenFields.isCurrentFieldContinuedLast());
						}
					}
					updateDirty();
					goto_XY(where);
					simulated = true;

				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}

				break;
			case INSERT :
				// we toggle it
				insertMode = insertMode ? false : true;
				break;
			case HOME :
				// position to the home position set
//				if (lastPos + numCols + 1 != homePos) {
//					goto_XY(homePos - numCols - 1);

// add start pei 061128 S̓tB[hQΉ
				if (screenFields.getCurrentField() != null
					&& !screenFields.isCurrentFieldContinued()
					&& !fill_check(screenFields.getCurrentField())) {
					simulated = true;
					break;
				}
// add end
				if (lastPos == homePos) {
					if (!screenFields.isCanSendAid()) {
						displayError(ERR_ENTER_NO_ALLOWED);
					} else {
						sendAid(0xf8);
						setCursorOff();
						saveHomePos= homePos;
						savependingInsert= pendingInsert;
					}
				} else {
					if (homePos > 0) {
						goto_XY(homePos);
						// now check if we are in a field
						isInField(lastPos);
					} else
						gotoField(1);
				}
				break;
			case KEYPAD_0 :
				simulated = simulateKeyStroke('0');
				break;
			case KEYPAD_1 :
				simulated = simulateKeyStroke('1');
				break;
			case KEYPAD_2 :
				simulated = simulateKeyStroke('2');
				break;
			case KEYPAD_3 :
				simulated = simulateKeyStroke('3');
				break;
			case KEYPAD_4 :
				simulated = simulateKeyStroke('4');
				break;
			case KEYPAD_5 :
				simulated = simulateKeyStroke('5');
				break;
			case KEYPAD_6 :
				simulated = simulateKeyStroke('6');
				break;
			case KEYPAD_7 :
				simulated = simulateKeyStroke('7');
				break;
			case KEYPAD_8 :
				simulated = simulateKeyStroke('8');
				break;
			case KEYPAD_9 :
				simulated = simulateKeyStroke('9');
				break;
			case KEYPAD_PERIOD :
				simulated = simulateKeyStroke('.');
				break;
			case KEYPAD_COMMA :
				simulated = simulateKeyStroke(',');
				break;
			case KEYPAD_MINUS :
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {

					int s = screenFields.getCurrentField().getFieldShift();
					if (s == 3 || s == 5 || s == 7) {
						screen[lastPos].setChar('-', 0, (byte) 0x60);
						resetDirty(lastPos);
						ScreenField currentf= screenFields.getCurrentField();
						advancePos();
						if (fieldExit()) {
							screenFields.setCurrentFieldMDT();
							if (!screenFields.isCurrentFieldContinued()) {
								// chg pei 071025 gotoFieldNextTABtOǉ
								//gotoFieldNext();
								gotoFieldNext(false);
							} else {
								do {
									// chg pei 071025 gotoFieldNextTABtOǉ
									//gotoFieldNext();
									gotoFieldNext(false);
								} while (
									screenFields
										.isCurrentFieldContinuedMiddle()
										|| screenFields
											.isCurrentFieldContinuedLast());
							}
							simulated = true;
							updateDirty();
//							if (screenFields.isCurrentFieldAutoEnter())
							if (currentf.isAutoEnter()) {
								sendAid(AID_ENTER);
							}
						}
					} else {
						displayError(ERR_FIELD_MINUS);

					}
				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}

				break;
			case FIELD_EXIT :
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {

					resetDirty(lastPos);
					ScreenField currentf= screenFields.getCurrentField();
					if (fieldExit()) {
						screenFields.setCurrentFieldMDT();
						if (!currentf.isAutoEnter()) {
							if (!screenFields.isCurrentFieldContinued()) {
								// chg pei 071025 gotoFieldNextTABtOǉ
								//gotoFieldNext();
								gotoFieldNext(false);
							} else {
								do {
									// chg pei 071025 gotoFieldNextTABtOǉ
									//gotoFieldNext();
									gotoFieldNext(false);
									if (screenFields.isCurrentFieldContinuedMiddle()
											|| screenFields.isCurrentFieldContinuedLast())
										fieldExit();
								} while (
									screenFields.isCurrentFieldContinuedMiddle()
										|| screenFields.isCurrentFieldContinuedLast());
							}
						}
					}

					updateDirty();
					simulated = true;
//					if (screenFields.isCurrentFieldAutoEnter())
					if (currentf.isAutoEnter()) {
						sendAid(AID_ENTER);
					}
				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}

				break;
			case FIELD_PLUS :
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {

					resetDirty(lastPos);
					ScreenField currentf= screenFields.getCurrentField();
					if (fieldExit()) {
						screenFields.setCurrentFieldMDT();
						if (!screenFields.isCurrentFieldContinued()) {
							// chg pei 071025 gotoFieldNextTABtOǉ
							//gotoFieldNext();
							gotoFieldNext(false);
						} else {
							do {
								// chg pei 071025 gotoFieldNextTABtOǉ
								//gotoFieldNext();
								gotoFieldNext(false);
							} while (
								screenFields.isCurrentFieldContinuedMiddle()
									|| screenFields.isCurrentFieldContinuedLast());
						}
					}
					updateDirty();
					simulated = true;
//					if (screenFields.isCurrentFieldAutoEnter())
					if (currentf.isAutoEnter()) {
						sendAid(AID_ENTER);
					}
				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}

				break;
			case FIELD_MINUS :
				// chg pei 071116
				ScreenField currentf= screenFields.getCurrentField();
				if (currentf != null
					&& currentf.withinField(lastPos)
					&& !currentf.isBypassField()) {

					int s = currentf.getFieldShift();

					if (s == 3 || s == 5 || s == 7) {
						//screen[lastPos].setChar('-', 0, (byte) 0x60);
						resetDirty(lastPos);
						if (s == 3) {
							if (currentf.startPos() == lastPos) {
								displayError(ERR_FIELD_MINUS_2);
								break;
							}
							int cpos= lastpos_mdt ? lastPos : lastPos - 1;
							byte b= screen[cpos].getEbcdic();
							b &= 0x0f;
							b |= 0xd0;
							screen[cpos].setChar(sessionVT.getCodePage().ebcdic2uni(b), 0, b);
						} else {
							screen[lastPos].setChar('-', 0, (byte) 0x60);
							updateDirty();
							advancePos();
						}
			
//						resetDirty(lastPos);
//						advancePos();
//						ScreenField currentf= screenFields.getCurrentField();
						if (fieldExit()) {
							currentf.setMDT();
							if (!currentf.isContinued()) {
								// chg pei 071025 gotoFieldNextTABtOǉ
								//gotoFieldNext();
								gotoFieldNext(false);
							} else {
								do {
									// chg pei 071025 gotoFieldNextTABtOǉ
									//gotoFieldNext();
									gotoFieldNext(false);
								} while (currentf.isContinuedMiddle()
										|| currentf.isContinuedLast());
							}
						}
						updateDirty();
						simulated = true;
//						if (screenFields.isCurrentFieldAutoEnter())
						if (currentf.isAutoEnter()) {
							sendAid(AID_ENTER);
						}
					} else {
						displayError(ERR_FIELD_MINUS);

					}
				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}

				break;
			case BOF :
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {
					int where = screenFields.getCurrentField().startPos();
					if (where > 0) {
						goto_XY(where);
					}
					simulated = true;
				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}
				resetDirty(lastPos);

				break;
			case SYSREQ :
				sessionVT.systemRequest();
				simulated = true;
				break;
			case RESET :
				// add pei 060727 RESETInsertԉ
				insertMode = false;
				
				if (isStatusErrorCode()) {
					resetError();
					isInField(lastPos);
					updateDirty();
				} else {
					setPrehelpState(false, isKeyboardLocked(), false);
				}
				gui.repaint();
				simulated = true;
				break;
			case COPY :
				copyMe();
				break;
			case PASTE :
				pasteMe(false);
				break;
			case CUT :
				cutMe();
				break;
			case ATTN :
				sessionVT.sendAttentionKey();
				simulated = true;
				break;
			case DUP_FIELD :
				if (screenFields.getCurrentField() != null
					&& screenFields.withinCurrentField(lastPos)
					&& !screenFields.isCurrentFieldBypassField()) {

					if (screenFields.isCurrentFieldDupEnabled()) {
						resetDirty(lastPos);
						screenFields.getCurrentField().setFieldChar(
							lastPos,
							(char) 0x1C,
							(byte) 0);
						screenFields.setCurrentFieldMDT();
						if (screenFields.getCurrentField().isAutoEnter()) {		// APR/2006
							lastPos= screenFields.getCurrentField().getCurrentPos() - 1;
							sendAid(AID_ENTER);
						} else {
							// chg pei 071025 gotoFieldNextTABtOǉ
							//gotoFieldNext();
							gotoFieldNext(false);
						}
						updateDirty();
						simulated = true;
					} else {
						displayError(ERR_DUP_KEY_NOT_ALLOWED);
					}
				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}

				break;
			case NEW_LINE :
				if (screenFields.getSize() > 0) {
					int startRow = getRow(lastPos) + 1;
					int startPos = lastPos;
					boolean isthere = false;

					if (startRow == getRows())
						startRow = 0;

					goto_XY(++startRow, 1);

					if (!isInField()
						|| (screenFields.getCurrentField() != null
						&& screenFields.isCurrentFieldBypassField())) {	// mod JUN/2006
						while (!isInField()
							|| (screenFields.getCurrentField() != null
							&& screenFields.isCurrentFieldBypassField())) {	// mod JUN/2006

							// lets keep going
							advancePos();

							// Have we looped the screen?
							if (lastPos == startPos) {
								// if so then go back to starting point
								goto_XY(startPos);
								break;
							}
						}
					}
					// mod JUN/2006
					if (screen[lastPos].getDBCF() == ScreenChar.F_DBC_IN) {
						advancePos();
					}
				}
				simulated = true;
				break;
			case JUMP_NEXT_SESS :
				gui.nextSession();
				simulated = true;
				break;
			case JUMP_PREV_SESS :
				gui.prevSession();
				simulated = true;
				break;
			case ALT_CP :
				altCodePage();
				break;
			case ALT_SISO :
				altSISO();
				break;
// add start pei 060824 SO/SI GENERATE
			case SISO_GEN:
				sosi_gen();
				break;
// add end
// add start pei 07109 
			case TABLE_COPY:
				table_copy();
				break;
// add end
			default :
				System.out.println(" Mnemonic not supported " + mnem);
				break;

		}

		return simulated;
	}

	protected boolean simulateKeyStroke(char c) {

		//	if (isStatusErrorCode() && !Character.isISOControl(c) && !keyProcessed) {
		//		if (resetRequired)
		//			return false;
		//		else
		//			resetError();
		//	}
		//add by pei
		if ((int)c == 0x005C) {
			c= (char)0x00A5;
		} else if (!sessionVT.getCodePage().available(c)) {
			setStatus(STATUS_ERROR_CODE, STATUS_VALUE_ON, "X -S");
			return false;
		}

		boolean updateField = false;
		boolean numericError = false;
		//		boolean updatePos = false;
		int cc = 0;
		boolean retv = false;
		boolean autoEnter = false;

		if (!Character.isISOControl(c)) {

			if (screenFields.getCurrentField() != null
				&& screenFields.withinCurrentField(lastPos)
				&& !screenFields.isCurrentFieldBypassField()) {

				if (screenFields.isCurrentFieldFER()
					&& !screenFields.withinCurrentField(
						screenFields.getCurrentFieldPos())
					&& lastPos == screenFields.getCurrentField().endPos()
					&& screenFields.getCurrentFieldPos()
						> screenFields.getCurrentField().endPos()) {

					displayError(ERR_FIELD_EXIT_INVALID);
					feError = true;
					return false;
				}

				lastpos_mdt= false;
				switch (screenFields.getCurrentFieldShift()) {
					case 0 : // Alpha shift
					case 2 : // Numeric Shift
					case 4 : // Kakana Shift
						updateField = true;
						break;
					case 1 : // Alpha Only
						if (Character.isLetter(c)
							|| c == ','
							|| c == '-'
							|| c == '.'
							|| c == ' ')
							updateField = true;
						break;
					case 3 : // Numeric only
						if (Character.isDigit(c)
							|| c == '+'
							|| c == ','
							|| c == '-'
							|| c == '.'
							|| c == ' ')
							updateField = true;
						else
							numericError = true;
						break;
					case 5 : // Digits only
						if (Character.isDigit(c))
							updateField = true;
						else
							displayError(ERR_NUMERIC_09);
						break;
					case 7 : // Signed numeric
						if (lastPos == screenFields.getCurrentField().endPos()) {
							if (c != '+' && c != '-') {
								displayError(ERR_INVALID_SIGN);
							} else {
								updateField = true;
							}
						} else {
							if (Character.isDigit(c)) {
								if (lastPos == screenFields.getCurrentField().endPos() - 1) {
									screenFields.getCurrentField().setRightAdjusted();
								}
								updateField = true;
							} else {
								displayError(ERR_NUMERIC_09);
							}
						}
						break;
				}

				if (updateField) {
					if (c >= 'a' && c <= 'z') {
						if (screenFields.isCurrentFieldToUpper()
							|| sessionVT.getCodePage().nuse_small)
							c = Character.toUpperCase(c);
					}
					//					updatePos = true;
					resetDirty(lastPos);

					if (screen[lastPos].getDBCF() == ScreenChar.F_DBC2
						&& lastPos != 0) {
						--lastPos;
					}
					cc =
						updatepos(
							lastPos,
							c,
							insertMode,
							sessionVT.getCodePage().uni2ebcdic(c, false)[0]);
					retv = cc != 0;
					if (retv) {
						screenFields.setCurrentFieldMDT();

						// if we have gone passed the end of the field then goto the next field
						// chg pei 071030 ɃtB[h̍ŌオShiftInꍇǉ
						//if (!screenFields.withinCurrentField(screenFields.getCurrentFieldPos())) {
						int cpos = screenFields.getCurrentFieldPos();
						if (!screenFields.withinCurrentField(cpos) || 
							(cpos == screenFields.getCurrentField().endPos() && screen[cpos].getDBCF() == ScreenChar.F_DBC_OUT)) {
/*
							if (screenFields.isCurrentFieldAutoEnter()) {
								autoEnter = true;
							} else if (!screenFields.isCurrentFieldFER())
								gotoFieldNext();
							else {
								lastpos_mdt= true;
								//screenFields.getCurrentField().changePos(1);
								//
								//if (screenFields.
								//	cursorPos == endPos)
								//	System.out.println("end of field");
								//
								//	feError != feError;
								//	if (feError)
								//		displayError(ERR_FIELD_EXIT_INVALID);
							}
*/
							if (!screenFields.isCurrentFieldFER()) {
								if (screenFields.isCurrentFieldAutoEnter()) {
									autoEnter = true;
								} else {
									// chg pei 071025 gotoField
									//gotoFieldNext();
									gotoFieldNext(false);
								}
							} else {
								lastpos_mdt= true;
							}
						} else {
							//goto_XY(
							//	screenFields.getCurrentField().getCursorRow()
							//		+ 1,
							//		screenFields.getCurrentField().getCursorCol()
							//		+ adv);
							goto_XY(lastPos + cc);
						}
					}

					updateImage(dirty);

					if (autoEnter)
						sendAid(AID_ENTER);
				} else {
					if (numericError) {
						displayError(ERR_NUMERIC_ONLY);
					}
				}
			} else {
				if (c == ' ' && screenFields.isInField()) {
					ScreenField sf= screenFields.getCurrentField();
					switch (sf.getType()) {
						case ScreenField.F_BUTTON:
							sendAid(((ButtonField)sf).getAid());
							break;
						case ScreenField.F_SINGLESELECTION:
						case ScreenField.F_MULTISELECTION:
						// add pei 080208
						case ScreenField.F_SINGLESELECTION_PD:
						case ScreenField.F_SINGLESELECTION_LIST:
// chg start pei 080312
//							SingleSelectionField ssf= (SingleSelectionField)sf;
//							int sel= getRow(lastPos) - ssf.startRow() + 1;
//							if (ssf.isAvalilable(sel)) {
//								ssf.setSelectPos(sel == ssf.getSelectPos() ? 0: sel);
							SelectionField ssf= (SelectionField)sf;
							int sel= ssf.getChoice(lastPos);
							if (sel != -1 && ssf.isAvalilable(sel)) {
								ssf.setSelectPos(sel);
// chg end
								screenFields.setCurrentFieldMDT();
								// chg pei 080208
								//drawSingleSelection(ssf);
								drawSelection(ssf);
							}
							break;		
						// add pei 080208	
						case ScreenField.F_MENU:
							screenFields.setCurrentFieldMDT();
							sendAid(AID_ENTER);
							break;
					}
				} else {
					displayError(ERR_CURSOR_PROTECTED);
				}
			}

		}
		return (retv);
	}

	/**
	 * @todo: Change to be mnemonic key.
	 *
	 * This toggles the ruler line.
	 *
	 *
	 */
	public void crossHair() {
		setCursorActive(false);
		crossHair++;
		if (crossHair > 3)
			crossHair = 0;
		setCursorActive(true);
	}

	/**
	 * Method: endOfField <p>
	 *
	 * convenience method that call endOfField with
	 *    lastRow
	 *    lastCol
	 *    and passes the posSpace to that method
	 *
	 * @param posSpace value of type boolean - specifying to return the position
	 *           of the the last space or not
	 * @return a value of type int - the screen postion (row * columns) + col
	 *
	 */
	private int endOfField(boolean posSpace) {
		return endOfField(lastPos, posSpace);
	}

	/**
	 * Method: endOfField <p>
	 *
	 * gets the position of the last character of the current field
	 *    posSpace parameter tells the routine whether to return the position
	 *    of the last space (<= ' ') or the last non space
	 *    posSpace == true  last occurrence of char <= ' '
	 *    posSpace == false last occurrence of char > ' '
	 *
	 * @param pos value of type int - position to start from
	 * @param posSpace value of type boolean - specifying to return the position
	 *           of the the last space or not
	 * @return a value of type int - the screen postion (row * columns) + col
	 *
	 */
	// chg pei 071030
	private int endOfField(int pos, boolean posSpace) {
		return (endOfField(screenFields.getCurrentField(), pos, posSpace));
	}
	
	// chg pei 071030
	private int endOfField(ScreenField csf, int pos, boolean posSpace) {
		// chg pei 071030
		//int endPos = screenFields.getCurrentField().endPos();
		int endPos = csf.endPos();
		
		int fePos = endPos;
		// get the number of characters to the right
		int count = endPos - pos;

		// first lets get the real ending point without spaces and the such
//		while (screen[endPos].getChar() <= ' ' && count-- > 0) {
//		while (count >= 0 && screen[endPos].getChar() <= ' ') {
		while (screen[endPos].getChar() <= ' ' && screen[endPos].getChar() != 0x1c && count-- > 0) {	// APR/2006 DUP
			if (screen[endPos].getDBCF() != 0)
				break; //pei
			endPos--;
//			--count;
		}

		if (endPos == fePos) {

			return endPos;

		} else {
/* chg pei 071030
			screenFields.getCurrentField().getKeyPos(endPos);
			if (posSpace)
				screenFields.getCurrentField().changePos(+1);

			return screenFields.getCurrentFieldPos();
*/
			csf.getKeyPos(endPos);
			if (posSpace)
				csf.changePos(+1);

			return csf.getCurrentPos();
		}
	}

	private boolean fieldExit() {

		int pos = lastPos;
		if (screen[pos].getDBCF() == ScreenChar.F_DBC2)
			--pos; //pei 
		boolean mdt = false;
		int end = endOfField(false); // get the ending position of the first
		// non blank character in field

		ScreenField sf = screenFields.getCurrentField();

		if (sf.isMandatoryEnter() && end == sf.startPos()) {
			displayError(ERR_MANDITORY_ENTER);
			return false;
		}

		// get the number of characters to the right
		int count = (end - sf.startPos()) - sf.getKeyPos(pos);

		// chg pei 060821
		//if (count == 0 && sf.isFER() && lastpos_mdt) {
		if (lastpos_mdt &&
			(screen[pos].getDBCF() == ScreenChar.F_DBC1 ? count <= 2 : count == 0) && 
			sf.isFER()) {
			mdt = true;
			return mdt;
		}

		if (sf.isDBCSOnly()) {
			count -= 2;
			count /= 2;
			
			// add pei 060824
			if (sf.isDBCSPure()) {
				++count;
			}
			
			if (screen[pos].getDBCF() == ScreenChar.F_DBC_IN) ++pos;
			for (; count >= 0; count--) {
//				if (screen[pos].getDBCF() == ScreenChar.F_DBC1) {
					screen[pos].setChar('@', ScreenChar.F_DBC1, (byte) 0);
					setDirty(pos);
					pos++;
					screen[pos].setChar('*', ScreenChar.F_DBC2, (byte) 0);
					setDirty(pos);
					pos++;
					mdt = true;
//				}
			}
		} else {
			int wdbcf = 0;
			int dbcf = screen[pos - 1].getDBCF();
			if (dbcf == ScreenChar.F_DBC2 || dbcf == ScreenChar.F_DBC_IN)
				wdbcf = ScreenChar.F_DBC_OUT;
			
			// add pei 061128 all clear
			count= sf.endPos() - pos;
			
			for (; count >= 0; count--) {
				screen[pos].setChar(wdbcf == 0 ? initChar : ' ', wdbcf, (byte) 0);
				wdbcf = 0;
				setDirty(pos);
				pos++;
			}
			mdt = true;
		}
		int adj = sf.getAdjustment();

		if (adj != 0) {

			switch (adj) {

				case 5 :
					//               System.out.println("Right adjust, zero fill " + screenFields.getCurrentField().getAdjustment());
					rightAdjustField('0');
					sf.setRightAdjusted();
					break;
				case 6 :
					//               System.out.println("Right adjust, blank fill " + screenFields.getCurrentField().getAdjustment());
					rightAdjustField(' ');
					sf.setRightAdjusted();

					break;
				case 7 :
					// chg pei 061128 S̓tB[hQΉ
					//System.out.println("Mandatory fill ");
					//sf.setManditoryEntered();
					//lastPos= sf.startPos();
					//displayError(ERR_MANDITORY_FILL_ENTER);
					//return false;
					return (fill_check(sf));
			}
		} else {

			// we need to right adjust signed numeric fields as well.
			if (sf.isSignedNumeric()) {
				rightAdjustField(' ');
			}
		}

		return mdt;
	}

	private boolean fill_check(ScreenField sf) {

		if (sf.getAdjustment() != 0x07) return (true);
/* chg start pei 061128 S̓tB[hQΉ
		int pos = lastPos;
		boolean mdt = false;
		int end = endOfField(false); // get the ending position of the first
		// non blank character in field

		if (sf.isMandatoryEnter() && end == sf.startPos()) {
			displayError(ERR_MANDITORY_ENTER);
			return false;
		}

		// get the number of characters to the right
		int count = (end - sf.startPos()) - sf.getKeyPos(pos);

		if (count == 0 && lastpos_mdt) {
			mdt = true;
			return mdt;
		}

		System.out.println("Mandatory fill ");
		sf.setManditoryEntered();
		lastPos= sf.startPos();
		displayError(ERR_MANDITORY_FILL_ENTER);
		return false;
*/		
		boolean retv= true;
		boolean f= false;
		int start= sf.startPos;
		int l= sf.getFieldLength();
		for (int i= 0; i < l; ++i) {
			char c= screen[start + i].getChar();
			if (screen[start + i].getDBCF() == 0 && c == 0) {
				if (f) {
					retv= false;
					break;
				}
			} else {
				if (i == 0) {
					f= true;
				} else if (!f) {
					retv= false;
					break;
				}
			}
		}
		if (!retv) {
//			System.out.println("Mandatory fill ");
			sf.setManditoryEntered();
			lastPos= sf.startPos();
			displayError(ERR_MANDITORY_FILL_ENTER);
		}
		return (retv);
// chg end
	}

	private void rightAdjustField(char fill) {

		int end = endOfField(false); // get the ending position of the first
		// non blank character in field

		// get the number of characters to the right
		int count = screenFields.getCurrentField().endPos() - end;

		// subtract 1 from count for signed numeric - note for later
		if (screenFields.getCurrentField().isSignedNumeric()) {
			if (screen[end - 1].getChar() != '-')
				count--;
		}

		int pos = screenFields.getCurrentField().startPos();
		byte ebc = sessionVT.getCodePage().uni2ebcdic(fill, false)[0];
		while (count-- >= 0) {

			shiftRight(pos, 1);
			screen[pos].setChar(fill, 0, ebc);
			setDirty(pos);

		}

	}

	private void shiftLeft(int sPos, int n) {

		if (n == 0) return;
		
		int endPos = 0;

		int pos = sPos;
		int pPos = sPos;

		ScreenField sf = screenFields.getCurrentField();
		if (sf.isDBCSOnly()) {
			pos= pPos + 2;
			while (screen[pos].getDBCF() == ScreenChar.F_DBC1) {
				screen[pPos].setChar(
					screen[pos].getChar(),
					screen[pos].getDBCF(),
					screen[pos].getEbcdic());
				setDirty(pPos++);
				++pos;
				screen[pPos].setChar(
					screen[pos].getChar(),
					screen[pos].getDBCF(),
					screen[pos].getEbcdic());
				setDirty(pPos++);
				++pos;
			}				
			screen[pPos].setChar('@', ScreenChar.F_DBC1, (byte)0x40);
			setDirty(pPos++);
			screen[pPos].setChar('*', ScreenChar.F_DBC2, (byte)0x40);
			setDirty(pPos);
		} else {
			int end;
			int count;
			do {
				end = endOfField(pPos, false);
				// get the ending position of the first
				// non blank character in field
	
				count =
					(end - screenFields.getCurrentField().startPos())
						- screenFields.getCurrentField().getKeyPos(pPos);
				// now we loop through and shift the remaining characters to the left
				while (count-- > 0) {
					pos= pPos + n;
					screen[pPos].setChar(
						screen[pos].getChar(),
						screen[pos].getDBCF(),
						screen[pos].getEbcdic());
					setDirty(pPos);
					++pPos;
	
				}
	
				if (screenFields.isCurrentFieldContinued()) {
					// chg pei 071025 gotoFieldNextTABtOǉ
					//gotoFieldNext();
					gotoFieldNext(false);
					if (screenFields.getCurrentField().isContinuedFirst())
						break;
	
					pos = screenFields.getCurrentField().startPos();
					screen[pPos].setChar(
						screen[pos].getChar(),
						screen[pos].getDBCF(),
						screen[pos].getEbcdic());
					setDirty(pPos);
	
					pPos = pos;
	
				}
			}
			while (screenFields.isCurrentFieldContinued()
				&& !screenFields.getCurrentField().isContinuedFirst());
	
			if (end >= 0 && count >= -1) {
	
				endPos = end;
			} else {
				endPos = sPos;
	
			}
	
			screenFields.setCurrentField(sf);
			for (int i= 0; i < n; ++i) {
				screen[endPos].setChar(initChar, 0, (byte) 0);
				setDirty(endPos++);
			}
		}
		goto_XY(screenFields.getCurrentFieldPos());
		sf = null;

	}

	// chg pei 071030
	private void shiftRight(int sPos, int n) {
		shiftRight(screenFields.getCurrentField(), sPos, n);
	}
	
	// chg pei 071030
	private void shiftRight(ScreenField csf, int sPos, int n) {
		
		// chg pei 071030
		//int field_endPos = screenFields.getCurrentField().endPos();
		//int end = endOfField(false); // get the ending position of the first
		int field_endPos = csf.endPos();
		int end = endOfField(csf, lastPos, false); // get the ending position of the first
		
		// non blank character in field
		int pos = end;
		int pPos = end + n;

		int count = end - sPos;

		// now we loop through and shift the remaining characters to the right
		while (count-- >= 0) {
			
			// add pei 061108 if
			if (pPos <= field_endPos) {
				screen[pPos].setChar(
					screen[pos].getChar(),
					screen[pos].getDBCF(),
					screen[pos].getEbcdic());
				setDirty(pPos);
			}
			// add pei 061108 SI/SOł̔pXy[X
			--pos;
			--pPos;
		}
	}

	private boolean shiftRightDBC(int sPos) {

		int end = endOfField(false); // get the ending position of the first
		// non blank character in field
		while (screen[end].getDBCF() != ScreenChar.F_DBC1) --end;
		if (screen[end].getChar() != '@') return (false);
		
		int pos = end - 2;
		int pPos = end;

		int count = (end - sPos) / 2;

		// now we loop through and shift the remaining characters to the right
		while (count-- >= 0) {

			screen[pPos].setChar(
				screen[pos].getChar(),
				screen[pos].getDBCF(),
				screen[pos].getEbcdic());
			setDirty(pPos);
			setDirty(pPos + 1);
			pos -= 2;
			pPos -= 2;
		}
		return (true);
	}

	public int getRow(int pos) {

		//      if (pos == 0)
		//         return 1;

		int row = pos / numCols;

		if (row < 0) {

			row = lastPos / numCols;
		}
		if (row > lenScreen - 1)
			row = lenScreen - 1;

		return row;

	}

	public int getCol(int pos) {

		//      if (pos == 0)
		//         return 1;

		int col = pos % (getCols());
		if (col > 0)
			return col;
		else
			return 0;
	}

	/**
	 * This routine is 0 based offset.  So to get row 20,1 then pass row 19,0
	 *
	 * @param row
	 * @param col
	 * @return
	 */
	public int getPos(int row, int col) {
		if (row >= numRows) row= numRows - 1;
		if (col >= numCols) col= numCols - 1;
		return (row * numCols) + col;
	}

	/**
	 * Current position is based on offsets of 1,1 not 0,0 of the current
	 *    position of the screen
	 *
	 * @return int
	 */
	public int getCurrentPos() {

		return lastPos + numCols + 1;

	}

	/**
	 *  I got this information from a tcp trace of each error.  I could not find
	 *  any documenation for this.  Maybe there is but I could not find it.  If
	 *  anybody finds this documention could you please send me a copy.  Please
	 *  note that I did not look that hard either.
	 *
	 * <p>
	 * 0000:  00 50 73 1D 89 81 00 50 DA 44 C8 45 08 00 45 00 .Ps....P.D.E..E.
	 * </p><p>
	 * 0010:  00 36 E9 1C 40 00 80 06 9B F9 C1 A8 33 58 C0 A8 .6..@.......3X..
	 * </p><p>
	 * 0020:  C0 02 06 0E 00 17 00 52 6E 88 73 40 DE CB 50 18 .......Rn.s@..P.
	 * </p><p>
	 * 0030:  20 12 3C 53 00 00 00 0C 12 A0 00 00 04 01 00 00  .<S............
	 * </p><p>
	 * 0040:  00 05 FF EF                                     ....
	 * ----------||
	 *    The 00 XX is the code to be sent.  I found the following
	 *
	 * <table BORDER COLS=2 WIDTH="50%" >
	 *
	 * <tr><td>    ERR_CURSOR_PROTECTED</td><td> 0x05</td></tr>
	 * <tr><td>    ERR_INVALID_SIGN</td><td> 0x11</td></tr>
	 * <tr><td>    ERR_NO_ROOM_INSERT</td><td> 0x12</td></tr>
	 * <tr><td>    ERR_NUMERIC_ONLY</td><td> 0x09</td></tr>
	 * <tr><td>    ERR_NUMERIC_09</td><td> 0x10</td></tr>
	 * <tr><td>    ERR_FIELD_MINUS</td><td> 0x16</td></tr>
	 * <tr><td>    ERR_ENTER_NOT_ALLOWED</td><td> 0x20</td></tr>
	 * <tr><td>    ERR_MANDITORY_ENTER</td><td> 0x21</td></tr>
	 * <tr><td>    ERR_ENTER_NOT_ALLOWED</td><td> 0x20</td></tr>
	 *
	 * </table>
	 *    I am tired of typing and they should be self explanitory.  Finding them
	 *    in the first place was the pain.
	 * </p>
	 *
	 *  @param ec error code
	 *
	 */
	private void displayError(int ec) {
		saveHomePos = homePos;
//		homePos = lastPos + numCols + 1;
		homePos = lastPos;
		savependingInsert= pendingInsert;
		pendingInsert = true;
		gui.sendNegResponse2(ec);

	}

	private void process_XY(int ppos) {
		int pos = lastPos + ppos;
		if (pos < 0)
			pos = lenScreen + pos;
		if (pos > lenScreen - 1)
			pos = pos - lenScreen;

		// Add By Pei
		if (ppos == 1 || ppos == -1) {
			if (screen[pos].getDBCF() == ScreenChar.F_DBC2) {
				pos += ppos == 1 ? 1 : -1;
			}
		}
		// if there was a field exit error then we need to treat the movement
		//  of the cursor in a special way that equals that of Client Access.
		//    If the cursor is moved from the field then we need to reset the
		//       position within the field so that the last character can be typed
		//       over again instead of sending the field exit error again.
		//       We also need to reset the field exit error flag.
		//
		//    How we know we have a field exit error is when the field position is
		//    set beyond the end of the field and a character is then typed we can
		//    not position that character.  To reset this we need to set the next
		//    position of the field to not be beyond the end of field but to the
		//    last character.
		//
		//    Now to make it work like Client Access if the cursor is a back space
		//    then do not move the cursor but place it on the last field.  All
		//    other keys will reset the field position so that entering over the
		//    last character will not cause an error but replace that character or
		//    just plain move the cursor if the key was to do that.

		if (feError) {
			feError = false;
			screenFields.getCurrentField().changePos(-1);

			if (screenFields.getCurrentField() != null
				&& screenFields.getCurrentField().isFER()
				&& screenFields.getCurrentFieldPos() - 1 == pos) {
			}
		} else {
			// chg pei 061128 S̓tB[hQΉ
			//goto_XY(pos);
			ScreenField csf1= screenFields.getCurrentField2();
			lastPos= pos;
			ScreenField csf2= screenFields.getCurrentField2();
			if (csf1 == null || csf1.equals(csf2) || fill_check(csf1)) {
				goto_XY(pos);
			}
		}
	}

	public boolean isUsingGuiInterface() {

		return guiInterface;
	}

	/**
	 * Convinience class to return if the cursor is in a field or not.
	 *
	 * @return true or false
	 */

	public boolean isInField() {

		return isInField(lastPos, true);
	}

	/**
	 *
	 * Convinience class to return if the position that is passed is in a field
	 * or not.  If it is then the chgToField parameter will change the current
	 * field to this field where the position indicates
	 *
	 * @param pos
	 * @param chgToField
	 * @return true or false
	 */
	public boolean isInField(int pos, boolean chgToField) {

		return screenFields.isInField(pos, chgToField);
	}

	/**
	 *
	 * Convinience class to return if the position that is passed is in a field
	 * or not.  If it is then the field at this position becomes the current
	 * working field
	 *
	 * @param pos
	 * @return true or false
	 */
	public boolean isInField(int pos) {

		return screenFields.isInField(pos, true);
	}

	/**
	 * Convinience class to return if the position at row and column that is
	 * passed is in a field or not.  If it is then the field at this position
	 * becomes the current working field.
	 *
	 * @param row
	 * @param col
	 * @return true or false
	 */
	public boolean isInField(int row, int col) {

		return isInField(row, col, true);
	}

	/**
	 *
	 * Convinience class to return if the position at row and column that is
	 * passed is in a field or not.  If it is then the chgToField parameter will
	 * change the current field to this field where the row and column indicates.
	 *
	 * @param row
	 * @param col
	 * @param chgToField
	 * @return true or false
	 */
	public boolean isInField(int row, int col, boolean chgToField) {
		return screenFields.isInField((row * numCols) + col, chgToField);
	}

	/**
	 * Gets the length of the screen - number of rows times number of columns
	 *
	 * @return int value of screen length
	 */
	public int getScreenLength() {

		return lenScreen;
	}

	/**
	 * Get the number or rows available.
	 *
	 * @return number of rows
	 */
	public int getRows() {

		return numRows;

	}

	/**
	 * Get the number of columns available.
	 *
	 * @return number of columns
	 */
	public int getCols() {

		return numCols;

	}

	/**
	 * Get the current row where the cursor is
	 *
	 * @return the cursor current row position 1,1 based
	 */
	public int getCurrentRow() {

		return (lastPos / numCols) + 1;

	}

	/**
	 * Get the current column where the cursor is
	 *
	 * @return the cursor current column position 1,1 based
	 */
	public int getCurrentCol() {

		return (lastPos % numCols) + 1;

	}

	/**
	 * The last position of the cursor on the screen
	 *    - Note - position is based 0,0
	 *
	 * @return last position
	 */
	protected int getLastPos() {

		return lastPos;

	}

	/**
	 * Hotspot More... string
	 *
	 * @return string literal of More...
	 */
	public StringBuffer getHSMore() {
		return hsMore;
	}

	/**
	 * Hotspot Bottom string
	 *
	 * @return string literal of Bottom
	 */
	public StringBuffer getHSBottom() {
		return hsBottom;
	}

	/**
	 * The column separator to be used
	 *
	 * @return column separator to be used
	 *          values:
	 *          0 - line
	 *          1 - dot
	 *          2 - short line
	 *          3 - do not show column separator
	 */
	public int getColSepLine() {
		return colSepLine;
	}

	/**
	 * Should the screen attributes be show in hex
	 *
	 * @return true we should and false we should not
	 */
	public boolean isShowHex() {
		return showHex;
	}

	public boolean isShowSISO() {
		return siso_flg;
	}

	/**
	 *
	 * Return the screen represented as a character array
	 *
	 * @return character array containing the text
	 */
	public char[] getScreenAsChars() {
		char[] sac = new char[lenScreen];
		char c;

		for (int x = 0; x < lenScreen; x++) {
			c = screen[x].getChar();
			// only draw printable characters (in this case >= ' ')
			if (c >= ' ' && !screen[x].nonDisplay) {
				sac[x] = c;
				if (screen[x].underLine && c <= ' ')
					sac[x] = '_';

			} else
				sac[x] = ' ';

		}
		return sac;
	}

	/**
	 * Set the keyboard as locked or not depending on the value passed
	 *
	 * @param k true of false
	 */
	public void setKeyboardLocked(boolean k) {
		synchronized (this) {
			keyboardLocked = k;

			if (!keyboardLocked) {
				
				// add pei 061128 ADDIN
				if (addin != null) {
					addin.exec_active();
				}
				
				notify();
				if (keysBuffered) {
					sendKeys("");
				}
			}
		}
	}

	/**
	 * Is the keyboard locked or not
	 *
	 * @return locked or not
	 */
	public boolean isKeyboardLocked() {
		return keyboardLocked;
	}

	/**
	 *   This routine is based on offset 1,1 not 0,0
	 *   it will translate to offset 0,0 and call the goto_XY(int pos)
	 *   it is mostly used from external classes that use the 1,1 offset
	 *
	 * @param row
	 * @param col
	 */
	public void goto_XY(int row, int col) {
		goto_XY(((row - 1) * numCols) + (col - 1));
	}

	// this routine is based on offset 0,0 not 1,1
	public void goto_XY(int pos) {
		//      setCursorOff();
		//		updateCursorLoc();	????
		lastPos = pos;
		lastAttr= 32;
		while (--pos >= 0) {
			if (screen[pos].isAttributePlace()) {
				lastAttr= screen[pos].getCharAttr();
				break;
			}
		}
		//      setCursorOn();
		//		updateCursorLoc();	????
	}

// chg start pei 061101 
	public synchronized void goto_XY_with_C(int pos) {
		//setCursorOff();
		setCursorActive(false);
		goto_XY(pos);
		//setCursorOn();
		setCursorActive(true);
	}
// chg end

	/**
	 * This returns whether or not any of the fields currently on the screen have
	 * been changed in any way.
	 *
	 * Convinience class to ScreenFields
	 *
	 * @return true or false
	 * @see org#tn5250j#ScreenFields
	 */
	public boolean isMasterMDT() {

		return screenFields.isMasterMDT();

	}

	/**
	 * Set the current working field to the field number specified.
	 *
	 * @param f - numeric field number on the screen
	 * @return true or false whether it was sucessful
	 */
	public boolean gotoField(int f) {

		int sizeFields = screenFields.getSize();

		if (f > sizeFields || f <= 0)
			return false;
		screenFields.setCurrentField(screenFields.getField(f - 1));

//		while (screenFields.isCurrentFieldBypassField() && !screenFields.isCurrentFieldCur() && f < sizeFields) {
		while (screenFields.isCurrentFieldBypassField() && !screenFields.isCurrentFieldCur()) {
			if (f >= sizeFields) return false;

			screenFields.setCurrentField(screenFields.getField(f++));

		}
		return gotoField(screenFields.getCurrentField());
	}

	/**
	 * Convenience method to set the field object passed as the currect working
	 * screen field
	 *
	 * @param f
	 * @return true or false whether it was sucessful
	 * @see je.tn5250j.ScreenField
	 */
	protected boolean gotoField(ScreenField f) {
		if (f != null) {
			int pos= f.startPos();
			if (f.isDBCSOnly() && screen[pos].getDBCF() == ScreenChar.F_DBC_IN) {
				++pos;
			}
			f.getKeyPos(pos);
			goto_XY(pos);
			return true;
		} else {
			return false;
		}

	}

	/**
	 * Convenience class to position the cursor to the next word on the screen
	 *
	 */
	private void gotoNextWord() {

		int pos = lastPos;

		if (screen[lastPos].getChar() > ' ') {
			advancePos();
			// get the next space character
			while (screen[lastPos].getChar() > ' ' && pos != lastPos) {
				advancePos();
			}
		} else
			advancePos();

		// now that we are positioned on the next space character get the
		// next none space character
		while (screen[lastPos].getChar() <= ' ' && pos != lastPos) {
			advancePos();
		}

	}

	/**
	 * Convenience class to position the cursor to the previous word on the screen
	 *
	 */
	private void gotoPrevWord() {

		int pos = lastPos;

		changePos(-1);

		// position previous white space character
		while (screen[lastPos].getChar() <= ' ') {
			changePos(-1);
			if (pos == lastPos)
				break;
		}

		changePos(-1);
		// get the previous space character
		while (screen[lastPos].getChar() > ' ' && pos != lastPos) {
			changePos(-1);
		}

		// and position one position more should give us the beginning of word
		advancePos();

	}

	/**
	 * Convinience class to position to the next field on the screen.
	 *
	 * @see je.tn5250j.ScreenFields
	 */
	// chg pei 071025 gotoFieldNexẗTABtOǉ
	//private void gotoFieldNext() {
	private void gotoFieldNext(boolean tab) {

		if (screenFields.isCurrentFieldHighlightedEntry())
			unsetFieldHighlighted(screenFields.getCurrentField());

		// chg pei 071025 gotoFieldNextTABtOǉ
		//screenFields.gotoFieldNext();
		screenFields.gotoFieldNext(tab);

		if (screenFields.isCurrentFieldHighlightedEntry())
			setFieldHighlighted(screenFields.getCurrentField());
	}

	/**
	 * Convinience class to position to the previous field on the screen.
	 *
	 * @see je.tn5250j.ScreenFields
	 */
	private void gotoFieldPrev(boolean tab) {

		if (screenFields.isCurrentFieldHighlightedEntry())
			unsetFieldHighlighted(screenFields.getCurrentField());

		screenFields.gotoFieldPrev(tab);

		if (screenFields.isCurrentFieldHighlightedEntry())
			setFieldHighlighted(screenFields.getCurrentField());

	}

	/**
	 * Used to restrict the cursor to a particular position on the screen.
	 *   Used in combination with windows to restrict the cursor to the active
	 *   window show on the screen.
	 *
	 *    Not supported yet.  Please implement me :-(
	 *
	 * @param depth
	 * @param width
	 */
	public void setRestrictCursor(int depth, int width) {

		restrictCursor = true;
		//      restriction

	}

	/**
	 * Creates a window on the screen
	 *
	 * @param depth
	 * @param width
	 * @param type
	 * @param gui
	 * @param monoAttr
	 * @param colorAttr
	 * @param ul
	 * @param upper
	 * @param ur
	 * @param left
	 * @param right
	 * @param ll
	 * @param bottom
	 * @param lr
	 */
	public void createWindow(
		int depth,
		int width,
		int type,
		boolean gui,
		int monoAttr,
		int colorAttr,
		int ul,
		int upper,
		int ur,
		int left,
		int right,
		int ll,
		int bottom,
		int lr) {

		int c = getCol(lastPos);
		int w = 0;
		width++;

		w = width;
		// set leading attribute byte
		// chg pei 080312
		//clearpos(lastPos); //pei
		clearpos(lastPos, false); //pei
		
		screen[lastPos].setCharAndAttr(initChar, initAttr, true, 0, (byte) 0);
		setDirty(lastPos);

		advancePos();
		// set upper left
		screen[lastPos].setCharAndAttr(
			(char) ul,
			colorAttr,
			false,
			0,
			(byte) 0);
		if (gui)
			screen[lastPos].setUseGUI(ScreenChar.UPPER_LEFT);
		setDirty(lastPos);

		advancePos();

		// draw top row

		while (w-- >= 0) {
			screen[lastPos].setCharAndAttr(
				(char) upper,
				colorAttr,
				false,
				0,
				(byte) 0);
			if (gui)
				screen[lastPos].setUseGUI(ScreenChar.UPPER);
			setDirty(lastPos);
			advancePos();
		}

		// set upper right
		screen[lastPos].setCharAndAttr(
			(char) ur,
			colorAttr,
			false,
			0,
			(byte) 0);
		if (gui)
			screen[lastPos].setUseGUI(ScreenChar.UPPER_RIGHT);
		setDirty(lastPos);
		advancePos();

		// set ending attribute byte
		// chg pei 080312
		//clearpos(lastPos); //pei
		clearpos(lastPos, false); //pei
		
		screen[lastPos].setCharAndAttr(initChar, initAttr, true, 0, (byte) 0);
		setDirty(lastPos);

		lastPos = ((getRow(lastPos) + 1) * numCols) + c;
		// now handle body of window
		while (depth-- > 0) {

			// set leading attribute byte
			// chg pei 080312
			//clearpos(lastPos); //pei
			clearpos(lastPos, false); //pei
			
			screen[lastPos].setCharAndAttr(
				initChar,
				initAttr,
				true,
				0,
				(byte) 0);
			setDirty(lastPos);
			advancePos();

			// set left
			screen[lastPos].setCharAndAttr(
				(char) left,
				colorAttr,
				false,
				0,
				(byte) 0);
			if (gui)
				screen[lastPos].setUseGUI(ScreenChar.LEFT);
			setDirty(lastPos);
			advancePos();

			w = width;
			// fill it in
			while (w-- >= 0) {
				screen[lastPos].setCharAndAttr(
					initChar,
					initAttr,
					true,
					0,
					(byte) 0);
				screen[lastPos].setUseGUI(ScreenChar.NO_GUI);
				setDirty(lastPos);
				advancePos();
			}

			// set right
			screen[lastPos].setCharAndAttr(
				(char) right,
				colorAttr,
				false,
				0,
				(byte) 0);
			if (gui)
				screen[lastPos].setUseGUI(ScreenChar.RIGHT);
			setDirty(lastPos);
			advancePos();

			// set ending attribute byte
			// chg pei 080312
			//clearpos(lastPos); //pei
			clearpos(lastPos, false); //pei
			
			screen[lastPos].setCharAndAttr(
				initChar,
				initAttr,
				true,
				0,
				(byte) 0);
			setDirty(lastPos);

			lastPos = ((getRow(lastPos) + 1) * numCols) + c;
		}

		// set leading attribute byte
		// chg pei 080312
		//clearpos(lastPos); //pei
		clearpos(lastPos, false); //pei
		
		screen[lastPos].setCharAndAttr(initChar, initAttr, true, 0, (byte) 0);
		setDirty(lastPos);
		advancePos();

		// set lower left
		screen[lastPos].setCharAndAttr(
			(char) ll,
			colorAttr,
			false,
			0,
			(byte) 0);
		if (gui)
			screen[lastPos].setUseGUI(ScreenChar.LOWER_LEFT);
		setDirty(lastPos);
		advancePos();

		w = width;
		// draw bottom row
		while (w-- >= 0) {
			screen[lastPos].setCharAndAttr(
				(char) bottom,
				colorAttr,
				false,
				0,
				(byte) 0);
			if (gui)
				screen[lastPos].setUseGUI(ScreenChar.BOTTOM);
			setDirty(lastPos);
			advancePos();
		}

		// set lower right
		screen[lastPos].setCharAndAttr(
			(char) lr,
			colorAttr,
			false,
			0,
			(byte) 0);
		if (gui)
			screen[lastPos].setUseGUI(ScreenChar.LOWER_RIGHT);
		setDirty(lastPos);
		advancePos();

		// set ending attribute byte
		// chg pei 080312
		//clearpos(lastPos); //pei
		clearpos(lastPos, false); //pei
		
		screen[lastPos].setCharAndAttr(initChar, initAttr, true, 0, (byte) 0);
		setDirty(lastPos);
		// chg pei 061121 rQΉ
		//gridbf = null;
		gridbf_bs = null;
		// add pei 070118 POPUPEBhEDDSrcΉ
		for (int i= 0; i < gridbf_tb.length; ++i) {
			gridbf_tb[i]= null;
		}
	}

	/**
	 * Creates a scroll bar on the screen using the parameters provided.
	 *
	 *    ** we only support vertical scroll bars at the time.
	 *
	 * @param flag - type to draw - vertical or horizontal
	 * @param totalRowScrollable
	 * @param totalColScrollable
	 * @param sliderRowPos
	 * @param sliderColPos
	 * @param sbSize
	 */
	public void createScrollBar(
		int sbpos,
		int flag,
		int totalRowScrollable,
		int totalColScrollable,
		int sliderRowPos,
		int sliderColPos,
		int sbSize) {

//	System.out.println("Scrollbar flag: " + flag +
//		" scrollable Rows: "  + totalRowScrollable +
//		" scrollable Cols: "  + totalColScrollable +
//		" thumb Row: " + sliderRowPos +
//		" thumb Col: " + sliderColPos +
//		" size: " + sbSize +
//		" row: " + getRow(lastPos) +
//		" col: " + getCol(lastPos));

		if ((flag & 0x80) != 0) {
			System.out.println("not supported horizontal scroll bar");
			return;
		}
		int sp = sbpos == -1 ? (lastPos + 1) : sbpos;
		int size = sbSize - 2;
		int spos= sp;

		int thumbPos =
			(int) (size
				* (float) ((float) sliderColPos / (float) totalColScrollable));
		//      System.out.println(thumbPos);

		// add pei 080208
		if (thumbPos == 0 && sliderColPos != 0) thumbPos= 1;
		screen[sp].setCharAndAttr(' ', 32, false, 0, (byte) 0x40);
		screen[sp].setUseGUI(ScreenChar.BUTTON_ONE_UP);

		int ctr = 0;
		while (ctr < size) {
			sp += numCols;
			screen[sp].setCharAndAttr(' ', 32, false, 0, (byte) 0);
			if (ctr == thumbPos)
				screen[sp].setUseGUI(ScreenChar.BUTTON_SB_THUMB);
			else if (ctr < thumbPos)
				screen[sp].setUseGUI(ScreenChar.BUTTON_SB_UP);
			else
				screen[sp].setUseGUI(ScreenChar.BUTTON_SB_DN);
			ctr++;
		}
		sp += numCols;
		screen[sp].setCharAndAttr(' ', 32, false, 0, (byte) 0x40);
		screen[sp].setUseGUI(ScreenChar.BUTTON_ONE_DN);
		ScrollBarField sbf= (ScrollBarField)screenFields.setField(ScreenField.F_SCROLLBAR, 0x20, getRow(spos), getCol(spos), 1, sbSize, 0x20, 0, 0, 0);
		sbf.setParam(flag, totalRowScrollable, totalColScrollable, sliderRowPos, sliderColPos, sbSize);
	}

	/**
	 * Write the title of the window that is on the screen
	 *
	 * @param pos
	 * @param depth
	 * @param width
	 * @param orientation
	 * @param monoAttr
	 * @param colorAttr
	 * @param title
	 */
	public void writeWindowTitle(
		int pos,
		int depth,
		int width,
		byte orientation,
		int monoAttr,
		int colorAttr,
//		StringBuffer title) {
		byte [] title) {

		int sp = lastPos;
		int len = title.length;

		// get bit 0 and 1 for interrogation
		switch (orientation & 0xc0) {
			case 0x40 : // right
				pos += (4 + width - len);
				break;
			case 0x80 : // left
				pos += 2;
				break;
			default : // center
				// this is to place the position to the first text position of the window
				//    the position passed in is the first attribute position, the next
				//    is the border character and then there is another attribute after
				//    that.
				pos += (3 + ((width / 2) - (len / 2)));
				break;

		}

		//  if bit 2 is on then this is a footer
		if ((orientation & 0x20) == 0x20)
			pos += ((depth + 1) * numCols);

		//      System.out.println(pos + "," + width + "," + len+ "," + getRow(pos)
		//                              + "," + getCol(pos) + "," + ((orientation >> 6) & 0xf0));

		boolean dbcs= false;
		for (int x = 0; x < len; x++) {
			byte byte0= title[x];
			switch (byte0) {
				case 0x0e:
					dbcs= true;
					screen[pos].setChar(' ', ScreenChar.F_DBC_IN, (byte) 0);
					break;
				case 0x0f:
					dbcs= false;
					screen[pos].setChar(' ', ScreenChar.F_DBC_OUT, (byte) 0);
					break;
				default:
					if (dbcs) {
						byte byte1= title[x + 1];
						++x;
						screen[pos].setChar(
							sessionVT.ebcdic2unik(
								byte0,
								byte1),
							ScreenChar.F_DBC1,
							(byte) 0);
						screen[pos].setAttribute(colorAttr);
						screen[pos++].setUseGUI(ScreenChar.NO_GUI);
						screen[pos].setChar(
							'*',
							ScreenChar.F_DBC2,
							(byte) 0);
					} else {
						screen[pos].setChar(sessionVT.ebcdic2uni(byte0), 0, byte0); 
					}
					break;
			}
//			screen[pos].setChar(
//				title.charAt(x),
//				0,
//				sessionVT.getCodePage().uni2ebcdic(title.charAt(x))[0]);

			screen[pos].setAttribute(colorAttr);
			screen[pos++].setUseGUI(ScreenChar.NO_GUI);
		}
	}

	/**
	 * Add a field to the field format table.
	 *
	 * @param attr - Field attribute
	 * @param len  - length of field
	 * @param ffw1 - Field format word 1
	 * @param ffw2 - Field format word 2
	 * @param fcw1 - Field control word 1
	 * @param fcw2 - Field control word 2
	 */
	public void addField(
		int attr,
		int len,
		int rows,
		int ffw1,
		int ffw2,
		int fcw1,
		int fcw2,
		int type) {

		lastAttr = attr;

		screen[lastPos].setCharAndAttr(initChar, lastAttr, true, 0, (byte) 0);
		//
		setDirty(lastPos);

		advancePos();

		ScreenField sf = null;

		// from 14.6.12 for Start of Field Order 5940 function manual
		//  examine the format table for an entry that begins at the current
		//  starting address plus 1.
		if (screenFields.existsAtPos(lastPos)) {
			screenFields.setCurrentFieldFFWs(ffw1, ffw2);
		} else {
			sf =
				screenFields.setField(
					type,
					attr,
					getRow(lastPos),
					getCol(lastPos),
					len,
					rows,
					ffw1,
					ffw2,
					fcw1,
					fcw2);
			lastPos = sf.startPos();
			int x = len;

			boolean gui = guiInterface;
			if (sf.isBypassField())
				gui = false;

			while (x-- > 0) {
				// add if pei 070522 bypass field 
				if ((ffw1 & 0x20) == 0) {	
					if (screen[lastPos].getChar() == 0)
						screen[lastPos].setCharAndAttr(
							' ',
							lastAttr,
							false,
							0,
							(byte) 0x40);
				
					else 
						screen[lastPos].setAttribute(lastAttr);
					
					if (gui) {
						screen[lastPos].setUseGUI(ScreenChar.FIELD_MIDDLE);
					}
				}
				advancePos();

			}
			int sv_lastpos= lastPos;
			if (sf.isDBCSPure()) {
				int n= len / 2;
				lastPos= sf.startPos();
				if (screen[lastPos].getDBCF() != ScreenChar.F_DBC1) {
					for (int i= 0; i < n; ++i) {
						setChar(
							'@',
							ScreenChar.F_DBC1,
							//chg pei 071002 (byte) 0); 
							(byte) 0, false);
						setChar(
							'*',
							ScreenChar.F_DBC2,
							//chg pei 071002 (byte) 0);
							(byte) 0, false);
					}
				}
			} else if (sf.isDBCSOnly()) {
				int n= len / 2 - 1;
				lastPos= sf.startPos();
				if (screen[lastPos].getDBCF() != ScreenChar.F_DBC_IN) {
					// chg pei 071002 
					//setChar(' ', ScreenChar.F_DBC_IN, (byte) 0);
					setChar(' ', ScreenChar.F_DBC_IN, (byte) 0, false);
					for (int i= 0; i < n; ++i) {
						setChar(
							'@',
							ScreenChar.F_DBC1,
							//(byte) 0);
							(byte) 0, false);
						setChar(
							'*',
							ScreenChar.F_DBC2,
							//(byte) 0);
							(byte) 0, false);
					}
					// chg pei 071002
					//setChar(' ', ScreenChar.F_DBC_OUT, (byte) 0);
					setChar(' ', ScreenChar.F_DBC_OUT, (byte) 0, false);
				}
			}
			lastPos= sv_lastpos;
			if (gui) {
				if (len > 1) {
					screen[sf.startPos()].setUseGUI(ScreenChar.FIELD_LEFT);
					if (lastPos > 0)
						screen[lastPos - 1].setUseGUI(ScreenChar.FIELD_RIGHT);
					else
						screen[lastPos].setUseGUI(ScreenChar.FIELD_RIGHT);

				} else
					screen[lastPos - 1].setUseGUI(ScreenChar.FIELD_ONE);
			}
			//         screen[lastPos].setCharAndAttr(initChar,initAttr,true);
			if (type == ScreenField.F_BUTTON) {
				drawButton(sf);
			}
			// chg pei 080208
//			if (type == ScreenField.F_SINGLESELECTION) {
//				drawSingleSelection((SingleSelectionField)sf);
//			}
//			} if (sf.isSelectionField()) {
//				drawSelection(sf);
//
//			}
			setEndingAttr(initAttr);

			lastPos = sf.startPos();
		}

		//if (fcw1 != 0 || fcw2 != 0) {

		//	System.out.println("lr = " + lastRow + " lc = " + lastCol + " " + sf.toString());
		//}
		sf = null;

	}

	public void removeButton() {
		ScreenField [] sfs= screenFields.getFields();
		for (int i= 0; i < sfs.length; ++i) {
			if (sfs[i].getType() == ScreenField.F_BUTTON) {
				clearButton((ButtonField)sfs[i]);
			}
		}
	}
	
// add start pei 060815 XN[o[̏\bh
	public void removeScrollBar() {
		ScreenField [] sfs= screenFields.getFields();
		for (int i= 0; i < sfs.length; ++i) {
			if (sfs[i].getType() == ScreenField.F_SCROLLBAR) {
				int len= sfs[i].getRows();
				int pos= sfs[i].startPos;
				// chg pei 060821
				//while (len-- > 0) {
				while (len-- > 0 && pos < screen.length) {
					screen[pos].setUseGUI(ScreenChar.NO_GUI);
					pos += numCols;
				}
			}
		}
	}
// add end
	
	//public void addChoiceField(int attr, int len, int ffw1, int ffw2, int fcw1, int fcw2) {
	//
	//lastAttr = attr;
	//
	//screen[lastPos].setCharAndAttr(initChar,lastAttr,true);
	//setDirty(lastPos);
	//
	//advancePos();
	//
	//boolean found = false;
	//ScreenField sf = null;
	//         // from 14.6.12 for Start of Field Order 5940 function manual
	//         //  examine the format table for an entry that begins at the current
	//         //  starting address plus 1.
	//for (int x = 0;x < sizeFields; x++) {
	//	sf = screenFields[x];
	//
	//	if (lastPos == sf.startPos()) {
	//		screenFields.getCurrentField() = sf;
	//		screenFields.getCurrentField().setFFWs(ffw1,ffw2);
	//		found = true;
	//	}
	//
	//}
	//
	//if (!found) {
	//	sf = setField(attr,getRow(lastPos),getCol(lastPos),len,ffw1,ffw2,fcw1,fcw2);
	//
	//	lastPos = sf.startPos();
	//	int x = len;
	//
	//	boolean gui = guiInterface;
	//	if (sf.isBypassField())
	//		gui = false;
	//
	//		while (x-- > 0) {
	//
	//			if (screen[lastPos].getChar() == 0)
	//				screen[lastPos].setCharAndAttr(' ',lastAttr,false);
	//			else
	//				screen[lastPos].setAttribute(lastAttr);
	//
	//			if (gui)
	//				screen[lastPos].setUseGUI(ScreenChar.FIELD_MIDDLE);
	//
	//			advancePos();
	//
	//		}
	//
	//	if (gui)
	//		if (len > 1) {
	//			screen[sf.startPos()].setUseGUI(ScreenChar.FIELD_LEFT);
	//			if (lastPos > 0)
	//				screen[lastPos-1].setUseGUI(ScreenChar.FIELD_RIGHT);
	//			else
	//				screen[lastPos].setUseGUI(ScreenChar.FIELD_RIGHT);
	//
	//		}
	//		else
	//			screen[lastPos-1].setUseGUI(ScreenChar.FIELD_ONE);
	//
	//		setEndingAttr(initAttr);
	//
	//		lastPos = sf.startPos();
	//	}
	//
	//	//      if (fcw1 != 0 || fcw2 != 0) {
	//	//
	//	//         System.out.println("lr = " + lastRow + " lc = " + lastCol + " " + sf.toString());
	//	//      }
	//	sf = null;
	//
	//}

	/**
	 * Return the fields that are contained in the Field Format Table
	 *
	 * @return ScreenFields object
	 * @see je.tn5250j.ScreenFields
	 */
	public ScreenFields getScreenFields() {
		return screenFields;
	}

	/**
	 * Redraw the fields on the screen.
	 *    Used for gui enhancement to redraw the fields when toggling
	 *
	 */
	public void drawFields() {

		ScreenField sf;

		int sizeFields = screenFields.getSize();
		for (int x = 0; x < sizeFields; x++) {

			sf = screenFields.getField(x);

			if (!sf.isBypassField()) {
				int pos = sf.startPos();

				int l = sf.length;

				boolean f = true;

				if (l >= lenScreen)
					l = lenScreen - 1;

				if (l > 1) {
					while (l-- > 0) {

						if (guiInterface && f) {
							screen[pos].setUseGUI(ScreenChar.FIELD_LEFT);
							f = false;
						} else {

							screen[pos].setUseGUI(ScreenChar.FIELD_MIDDLE);

						}

						if (guiInterface && l == 0) {
							screen[pos].setUseGUI(ScreenChar.FIELD_RIGHT);
						}

						pos++;
					}
				} else {
					screen[pos].setUseGUI(ScreenChar.FIELD_ONE);
				}
			}
		}

	}

	/**
	 * Draws the field on the screen.  Used to redraw or change the attributes
	 * of the field.
	 *
	 * @param sf - Field to be redrawn
	 * @see je.tn5250j.ScreenField.java
	 */
	public void drawField(ScreenField sf) {

		int pos = sf.startPos();

		int x = sf.length;

		while (x-- > 0) {
			setDirty(pos++);
		}
		//      updateImage(dirty);

	}

	/**
	 * Set the field to be displayed as highlighted.
	 *
	 * @param sf - Field to be highlighted
	 */
	public void setFieldHighlighted(ScreenField sf) {

		int pos = sf.startPos();

		int x = sf.length;
		int na = sf.getHighlightedAttr();

		while (x-- > 0) {
			screen[pos].setAttribute(na);
			setDirty(pos++);
		}
		updateImage(dirty);

	}

	/**
	 * Draw the field as un higlighted.  This is used to reset the field
	 * presentation on the screen after the field is exited.
	 *
	 * @param sf - Field to be unhighlighted
	 */
	public void unsetFieldHighlighted(ScreenField sf) {

		int pos = sf.startPos();

		int x = sf.length;
		int na = sf.getAttr();

		while (x-- > 0) {
			screen[pos].setAttribute(na);
			setDirty(pos++);
		}
		updateImage(dirty);

	}

	public void fieldReverse(int pos, int len) {

		int x= len;
		int na = screen[pos].getCharAttr() ^ 0x01;
		while (x-- > 0) {
			screen[pos].setAttribute(na);
			setDirty(pos++);
		}
		boolean cacs= cursorActive;
		cursorActive= false;
		updateImage(dirty);
		cursorActive= cacs;
	}

	public boolean checkHotSpots() {

		boolean retHS = false;
		retHS =
			GUIHotSpots.checkHotSpots(
				this,
				screen,
				numRows,
				numCols,
				lenScreen,
				fmWidth,
				fmHeight);

		// add pei 070618 HotSpot\QC
		if (retHS) drawing= true;

		return retHS;
	}

	private void setChar2(int pos, char c, int dbcf, byte ebc) {
		setDirty(pos);
		screen[pos].setChar(c, dbcf, ebc);
	}
	
	
/* del pei 071002 HotSpotcQC	
	// add pei 070528 HotSpotcQC
	public void clearChar(int cByte, int dbcf, byte ebc) {
		screen[lastPos].setUseGUI(ScreenChar.NO_GUI);
		setChar(cByte, dbcf, ebc);
	}
*/
	// chg pei 071002 HotSpotcQC
	//public void setChar(int cByte, int dbcf, byte ebc) {
	public void setChar(int cByte, int dbcf, byte ebc, boolean clearGUI) {
		ScreenField sf=screenFields.getCurrentField2(); 
		if (sf != null && sf.isDBCSOnly()) {
			if (dbcf == ScreenChar.F_DBC_OUT && lastPos != sf.endPos()) {
				return;
			}
			if (dbcf == ScreenChar.F_DBC_IN && lastPos != sf.startPos()) {
				return;
			}
		}
		// chg pei 080312
		//clearpos(lastPos);
		clearpos(lastPos, dbcf == ScreenChar.F_DBC1);
		
		// add pei 071002 HotSpotcQC
		if (clearGUI) {
			screen[lastPos].setUseGUI(ScreenChar.NO_GUI);
		}
		
		if (cByte > 0 && cByte < ' ') {
			screen[lastPos].setCharAndAttr((char) 0x00, 33, false, 0, (byte) 0);
			setDirty(lastPos);

			advancePos();
		} else {
			if (lastPos > 0) {
				if (screen[lastPos - 1].isAttributePlace()) // &&
					lastAttr = screen[lastPos - 1].getCharAttr();
			}

			screen[lastPos].setCharAndAttr(
				(char) cByte,
				lastAttr,
				false,
				dbcf,
				ebc);

			//         screen[lastPos].setCharAndAttr((char)cByte,
			//                           screen[lastPos].getCharAttr(),false);

			setDirty(lastPos);
			if (guiInterface && !isInField(lastPos, false))
				screen[lastPos].setUseGUI(ScreenChar.NO_GUI);

			advancePos();
		}

	}

	public void setEndingAttr(int cByte) {

		int attr = lastAttr;
		//      System.out.println("setting ending to " + cByte + " lastAttr is " + lastAttr +
		//                     " at " + (lastRow + 1) + "," + (lastCol + 1));
		//      System.out.print("setting ending to ");

		setAttr(cByte);
		lastAttr = attr;
	}

	public void setAttr(int cByte) {
		lastAttr = cByte;

		//      int sattr = screen[lastPos].getCharAttr();
		//         System.out.println("changing from " + sattr + " to attr " + lastAttr +
		//                     " at " + (this.getRow(lastPos) + 1) + "," + (this.getCol(lastPos) + 1));
		// chg pei 080312
		//clearpos(lastPos);		// pei V1.0
		clearpos(lastPos, false);		// pei V1.0
		
		screen[lastPos].setCharAndAttr(initChar, lastAttr, true, 0, (byte) 0);
		setDirty(lastPos);

		advancePos();
		int pos = lastPos;

		int times = 0;
		//      sattr = screen[lastPos].getCharAttr();
		//         System.out.println(" next position after change " + sattr + " last attr " + lastAttr +
		//                     " at " + (this.getRow(lastPos) + 1) + "," + (this.getCol(lastPos) + 1) +
		//                     " attr place " + screen[lastPos].isAttributePlace());
		while (screen[lastPos].getCharAttr() != lastAttr
			&& !screen[lastPos].isAttributePlace()) {

			screen[lastPos].setAttribute(lastAttr);
			if (guiInterface && !isInField(lastPos, false)) {
				int g = screen[lastPos].whichGui;
				if (g >= ScreenChar.FIELD_LEFT && g <= ScreenChar.FIELD_ONE)
					screen[lastPos].setUseGUI(ScreenChar.NO_GUI);
			}
			setDirty(lastPos);

			times++;
			advancePos();
		}

		// sanity check for right now
		//      if (times > 200)
		//         System.out.println("   setAttr = " + times + " start = " + (sr + 1) + "," + (sc + 1));

		lastPos = pos;
	}

	/**
	 * Draw or redraw the dirty parts of the screen and display them.
	 *
	 * Rectangle dirty holds the dirty area of the screen to be updated.
	 *
	 * If you want to change the screen in anyway you need to set the screen
	 * attributes before calling this routine.
	 */
	public void updateDirty() {

		//LDC - 12/02/2003 - check if we must repaint it
		if (drawing == false)
			return;
		Rectangle r = new Rectangle(dirty);

		// update the image
		updateImage(r);
		// update dirty to show that we have already painted that region of the
		//   screen so do not do it again.
		//      int height = (int)(tArea.getHeight() - dirty.height);
		//      if (height > 0)
		//      dirty.setBounds(dirty.x,dirty.height,dirty.width,(int)(tArea.getHeight() - dirty.height));
		//LDC - 12/02/2003 - set drawing to false
		drawing = false;

	}

	public void setDirty(int pos) {

		int bx = screen[pos].x;
		int by = screen[pos].y;
		//LDC - 12/02/2003 - if we must drawing something, do a union with it
		//  otherwise only this rectangle must be redrawing
		if (drawing) {
			workR.setBounds(bx, by, fmWidth, fmHeight);
			dirty = dirty.union(workR);
		} else {
			dirty.setBounds(bx, by, fmWidth, fmHeight);
			drawing = true;
		}

	}

	private void setDirty(int row, int col) {

		setDirty(getPos(row, col));

	}

	private void resetDirty(int pos) {

		dirty.setBounds(screen[pos].x, screen[pos].y, fmWidth, fmHeight);
		//LDC - 12/02/2003 - It must be painting this area
		drawing = true;
	}

	/**
	 * Change the screen position by one column
	 */
	protected void advancePos() {
		changePos(1);
	}

	/**
	 * Change position of the screen by the increment of parameter passed.
	 *
	 * If the position change is under the minimum of the first screen position
	 * then the position is moved to the last row and column of the screen.
	 *
	 * If the position change is over the last row and column of the screen then
	 * cursor is moved to first position of the screen.
	 *
	 * @param i
	 */
	protected void changePos(int i) {

		lastPos += i;
		if (lastPos < 0)
			lastPos = lenScreen + lastPos;
		if (lastPos > lenScreen - 1)
			lastPos = lastPos - lenScreen;

		//      System.out.println(lastRow + "," + ((lastPos) / numCols) + "," +
		//                         lastCol + "," + ((lastPos) % numCols) + "," +
		//                         ((lastRow * numCols) + lastCol) + "," +
		//                         (lastPos));

	}

	public void goHome() {

		//  now we try to move to first input field according to
		//  14.6 WRITE TO DISPLAY Command
		//    ? If the WTD command is valid, after the command is processed,
		//          the cursor moves to one of three locations:
		//    - The location set by an insert cursor order (unless control
		//          character byte 1, bit 1 is equal to B'1'.)
		//    - The start of the first non-bypass input field defined in the
		//          format table
		//    - A default starting address of row 1 column 1.
//		if (skipgohome) {
//			skipgohome= false;
//			return;
//		}
// add start pei 060817
		if (pendingInsertResore) {
			pendingInsertResore= false;
			return;
		}
// add end
		if (pendingInsert && homePos > 0) {
			goto_XY(getRow(homePos) + 1, getCol(homePos) + 1);
			isInField(); // we now check if we are in a field
		} else {
			if (!gotoField(1)) {
//				homePos = getPos(1, 1);
				homePos = 0;
				goto_XY(1, 1);
				isInField(0, 0); // we now check if we are in a field
			} else {
//				homePos = getPos(getCurrentRow(), getCurrentCol());
				homePos = lastPos;
			}
		}
	}

// add start pei 060817 J[\ʒuL
// chg start pei 060926
	//public void setPendingInsertRestore() {
	//	pendingInsertResore= true;
	//}
	public void setPendingInsertRestore(boolean p) {
		pendingInsertResore= p;
	}
// chg end
// add end

	public void setPendingInsert(boolean flag, int icX, int icY) {
		pendingInsert = flag;
		if (pendingInsert) {
			homePos = getPos(icX - 1, icY - 1);
		}

		if (!isStatusErrorCode()) {
			goto_XY(icX, icY);
		}
	}

	public void setPendingInsert(boolean flag) {
		if (homePos != -1) {
			pendingInsert = flag;
			if (!flag) homePos= -1;
		}
	}

	/**
	 * Set the error line number to that of number passed.
	 *
	 * @param line
	 */
	public void setErrorLine(int line) {

		if (line == 0 || line > numRows)
			errorLineNum = numRows;
		else
			errorLineNum = line;
	}

	/**
	 * Returns the current error line number
	 *
	 * @return current error line number
	 */
	public int getErrorLine() {
		return errorLineNum;
	}

	/**
	 * Saves off the current error line characters to be used later.
	 *
	 */
	public void saveErrorLine() {
		// if there is already an error line saved then do not save it again
		//  This signifies that there was a previous error and the original error
		//  line was not restored yet.
		if (errorLine == null) {
			errorLine = new ScreenChar[numCols];
			int r = getPos(errorLineNum - 1, 0);

			for (int x = 0; x < numCols; x++) {
				errorLine[x] = new ScreenChar(this);
				errorLine[x].setCharAndAttr(
					screen[r + x].getChar(),
					screen[r + x].getCharAttr(),
					screen[r + x].isAttributePlace(),
					screen[r + x].getDBCF(),
					screen[r + x].getEbcdic());
			}
		}
	}

	/**
	 * Restores the error line characters from the save buffer.
	 *
	 * @see #saveErrorLine()
	 */
	public void restoreErrorLine() {

		if (errorLine != null) {
			int r = getPos(errorLineNum - 1, 0);

			for (int x = 0; x < numCols - 1; x++) {
				screen[r
					+ x].setCharAndAttr(
						errorLine[x].getChar(),
						errorLine[x].getCharAttr(),
						errorLine[x].isAttributePlace(),
						errorLine[x].getDBCF(),
						errorLine[x].getEbcdic());
			}
			errorLine = null;
			updateImage(0, screen[r].y, bi.getWidth(), fmHeight);
		}
	}

	public void setKBIndicatorOn() {

		Graphics2D g2d = getWritingArea();
		float Y =
			(fmHeight * (numRows + 2)) - (lm.getLeading() + lm.getDescent());
		g2d.setColor(colorYellow);
		g2d.drawString("KB", (float) kbArea.getX(), Y);
		updateImage(kbArea.getBounds());
		g2d.dispose();

	}

	public void setKBIndicatorOff() {

		Graphics2D g2d = getWritingArea();

		g2d.setColor(colorBg);
		g2d.fill(kbArea);
		updateImage(kbArea.getBounds());
		g2d.dispose();

	}

	public void setSRIndicatorOn() {

		bi.drawScriptRunning(colorGreen);
		updateImage(scriptArea.getBounds());

	}

	public void setSRIndicatorOff() {

		bi.eraseScriptRunning(colorBg);
		updateImage(scriptArea.getBounds());

	}

	public void setMessageLightOn() {

		Graphics2D g2d = getWritingArea();
		float Y =
			(fmHeight * (numRows + 2)) - (lm.getLeading() + lm.getDescent());
		g2d.setColor(colorBlue);
		g2d.drawString("MW", (float) mArea.getX(), Y);
		messageLight = true;
		updateImage(mArea.getBounds());
		g2d.dispose();

	}

	public void setMessageLightOff() {

		Graphics2D g2d = getWritingArea();

		g2d.setColor(colorBg);
		g2d.fill(mArea);
		messageLight = false;
		updateImage(mArea.getBounds());
		g2d.dispose();

	}

	public boolean isMessageWait() {
		return messageLight;
	}

	public void setStatus(byte attr, byte value, String s) {

		statusString = s;

		// draw the status information
		bi.setStatus(
			attr,
			value,
			s,
			fmWidth,
			fmHeight,
			lm,
			font,
			colorBg,
			colorRed,
			colorWhite);

		// set environment variables
		switch (attr) {

			case STATUS_SYSTEM :
				if (value == STATUS_VALUE_ON) {
					statusXSystem = true;
				} else {
					statusXSystem = false;
				}
				break;

			case STATUS_ERROR_CODE :
				if (value == STATUS_VALUE_ON) {
// add start pei 060821
					if (!statusErrorCode) {
						saveHomePos = homePos;
						savependingInsert= pendingInsert;
					}
// add end
					setPrehelpState(true, true, false);
					Toolkit.getDefaultToolkit().beep();
				} else {
					setPrehelpState(false, true, true);
					homePos = saveHomePos;
					saveHomePos = 0;
//					pendingInsert = false;
					pendingInsert = savependingInsert;
				}
				break;

		}
		updateImage(sArea.getBounds());
	}

	public boolean isWithinScreenArea(int x, int y) {

		//      if (x == 0 || y == 0)
		//         return true;
		//
		//      x -= bi.offLeft;
		//      y -= bi.offTop;

		return tArea.contains(x, y);

	}

	public boolean isStatusErrorCode() {
		return statusErrorCode;
	}

	public boolean isXSystem() {
		return statusXSystem;
	}

	/**
	 * This routine clears the screen, resets row and column to 0,
	 * resets the last attribute to 32, clears the fields, turns insert mode
	 * off, clears/initializes the screen character array.
	 */
	public void clearAll() {

		lastAttr = 32;
		lastPos = 0;

		clearTable();
		clearScreen();
		screen[0].setAttribute(initAttr);
		insertMode = false;
		cursor.setRect(0, 0, 0, 0);
//		gridbf= null;
		p_mouse_btn.clear();
//		skipgohome= false;
	}

	/**
	 * Clear the fields table
	 */
	public void clearTable() {

		setKeyboardLocked(true);
		removeButton();
		// add pei 060815 XN[o[̏
		removeScrollBar();		
		screenFields.clearFFT();
		pendingInsert = false;
		// add pei 060817 J[\ʒuL
		pendingInsertResore= false;
		// add pei 060901
		// del pei 061030
		//p_mouse_btn.clear();
		homePos = -1;
	}

	/**
	 * Clear the gui constructs
	 *
	 */
	protected void clearGuiStuff() {

		for (int x = 0; x < lenScreen; x++) {
			//         screen[x].setCharAndAttr(' ',initAttr,false);
			screen[x].setUseGUI(ScreenChar.NO_GUI);
		}
		dirty.setBounds(tArea.getBounds());
		//      dirty.setBounds(fmWidth * numCols,fmHeight * numRows,0,0);
	}

	/**
	 * Clear the screen by setting the initial character and initial
	 * attribute to all the positions on the screen
	 */
	public void clearScreen() {

		for (int x = 0; x < lenScreen; x++) {
			screen[x].setCharAndAttr(' ', initAttr, false, 0, (byte) 0x40);
			screen[x].setUseGUI(ScreenChar.NO_GUI);
		}
		dirty.setBounds(tArea.getBounds());
		drawing = true;
	}

	public void clearScreen_onerr() {
		for (int x = 0; x < lenScreen; x++) {
			screen[x].setCharAndAttr(' ', initAttr, false, 0, (byte) 0x40);
			screen[x].setUseGUI(ScreenChar.NO_GUI);
		}
		for (int i= 0; i < gridbf_tb.length; ++i) {
			gridbf_tb[i]= null;
		}
		// chg pei 061121 rQΉ
		//gridbf= null;
		gridbf_bs= null;
		
		gui.resizeMe();
	}

	public void restoreScreen() {

		lastAttr = 32;
		dirty.setBounds(tArea.getBounds());
		updateImage(dirty);
	}

	/**
	 * Returns a pointer to the graphics area that we can draw on
	 *
	 * @return Graphics2D pointer of graphics buffer
	 */
	public Graphics2D getDrawingArea() {

		return bi.getDrawingArea();
	}

	/**
	  * Returns a pointer to the graphics area that we can write on
	  *
	  * @return Graphics2D pointer of graphics buffer
	  */
	public Graphics2D getWritingArea() {

		return bi.getWritingArea(font);
	}

	protected synchronized void updateImage(
		int x,
		int y,
		int width,
		int height) {
		if (gg2d == null) {
			//System.out.println("was null");
			gg2d = (Graphics2D) gui.getGraphics();
		}

		// check for selected area and erase it before updating screen
		if (gui.rubberband != null && gui.rubberband.isAreaSelected()) {
			gui.rubberband.erase();
		}

		if (bi == null || gg2d == null) {
			if (bi == null)
				System.out.println("bi was null in update image");
			//			if (gg2d == null)
			//				System.out.println("gg2d was null in update image");
			return;
		}

		g2d.setClip(x, y, width, height);
		if (!cursorActive
			&& x + width <= bi.getWidth(null)
			&& y + height <= (bi.getHeight(null) - fmWidth)) {
			paintComponent2(g2d);
		}

		//      if (tileimage != null) {
		//
		//         AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.5f);
		//         g2d.setComposite(ac);
		//         g2d.drawImage(tileimage, null, null);
		//      }
		// fix for jdk1.4 - found this while testing under jdk1.4
		//   if the height and or the width are equal to zero we skip the
		//   the updating of the image.
		//      if (gui.isVisible() && height > 0 && width > 0) {
		//         bi.drawImageBuffer(gg2d,x,y,width,height);
		//      }
		if (gui.isVisible()) {
			if (height > 0 && width > 0) {

				// We now redraw the selected area rectangle.
				if (gui.rubberband != null
					&& gui.rubberband.isAreaSelected()) {
					gui.rubberband.draw();
				}

				if (!fullRepaint) {
					bi.drawImageBuffer(gg2d, x, y, width, height);
				} else
					gui.repaint();

				//System.out.println(" something went right finally " + gui.isVisible() +
				//	" height " + height + " width " + width);
			}
			//else {
			//	bi.drawImageBuffer(gg2d);
			//	System.out.println(" something is wrong here " + gui.isVisible() +
			//		" height " + height + " width " + width);

			//}
		}

	}

	protected void updateImage(Rectangle r) {
		updateImage(r.x, r.y, r.width, r.height);
	}

	protected void paintComponent3(Graphics g) {
		//      System.out.println("paint from screen");
		Graphics2D g2 = (Graphics2D) g;

		//      Rectangle r = g.getClipBounds();

		g2.setColor(colorBg);
		g2.fillRect(0, 0, gui.getWidth(), gui.getHeight());

		bi.drawImageBuffer(g2);

		dispIM(g); //pei IM

	}

	protected void paintComponent2(Graphics2D g2) {

		if (bi == null) {
			paintComponent3(g2);
		}

		Rectangle r = g2.getClipBounds();

		if (r == null) {
			paintComponent3((Graphics) g2);
			return;
		}
		g2.setColor(colorBg);
		//      System.out.println("PaintComponent " + r);

		g2.fillRect(r.x, r.y, r.width, r.height);

		int sPos = getRowColFromPoint(r.x, r.y);

		int ePos = getRowColFromPoint(r.width, r.height) - numCols;
		// fix me here
		int er =
			(numRows
				- ((((fmHeight * (numRows + 1)) - ((r.y + r.height) + fmHeight))
					/ fmHeight)));
		int ec =
			(numCols
				- ((((fmWidth * (numCols + 1)) - ((r.x + r.width) + fmWidth))
					/ fmWidth)));

		//      int er1 = getRow(ePos);
		//      int ec2 = getCol(ePos);
		int sr = getRow(sPos);
		int c = getCol(sPos);
		er--;
		ec--;

		//      System.out.println(sr + "," + c + "," + er + "," + ec);
		workR.setBounds(sr, c, ec, er);

		int rows = er - sr;
		int cols = 0;
		int lr = workR.x;
		int lc = 0;

		lr = sPos;

		while (rows-- >= 0) {
			cols = ec - c;
			lc = lr;
			if (screen[lc].getDBCF() == ScreenChar.F_DBC2) {
				--lc;
				++cols;
			}
			while (cols-- >= 0) {
				if (lc >= 0 && lc < lenScreen) {
					screen[lc++].drawChar(g2);
				}
			}
			lr += numCols;
		}
		// chg pei 061121 rQΉ
		//if (gridbf != null) {
		if (gridbf_bs != null) {
			dispGrid(g2);
		}
		dispGrid_tb(g2);
	}

	/**
	  *
	  * This routine will make sure we have something to draw on
	  *
	  */
	private void checkOffScreenImage() {

		// do we have something already?
		if (bi == null) {

			bi = new GuiGraphicBuffer();

			if (antialiased) {
				bi.setUseAntialias(true);
			}

			// allocate a buffer Image with appropriate size
			bi.getImageBuffer(fmWidth * numCols, fmHeight * (numRows + 2));

			// fill in the areas
			tArea = new Rectangle2D.Float(0, 0, 0, 0);
			cArea = new Rectangle2D.Float(0, 0, 0, 0);
			aArea = new Rectangle2D.Float(0, 0, 0, 0);
			sArea = new Rectangle2D.Float(0, 0, 0, 0);
			pArea = new Rectangle2D.Float(0, 0, 0, 0);
			mArea = new Rectangle2D.Float(0, 0, 0, 0);
			kbArea = new Rectangle2D.Float(0, 0, 0, 0);
			scriptArea = new Rectangle2D.Float(0, 0, 0, 0);

			// Draw Operator Information Area
			drawOIA();
		}

	}

	/**
	 * Convinience method to resize the screen area such as when the parent frame
	 * is resized.
	 *
	 * @param width
	 * @param height
	 */
	private final void resizeScreenArea(int width, int height) {

		Font k = null;
		LineMetrics l;
		FontRenderContext f = null;
		k =
			GUIGraphicsUtils.getDerivedFont(
				font,
				width,
				height,
				numRows,
				numCols,
				sfh,
				sfw,
				FONT_WA,
				ps132);
		gui.ime_font = null;
		f = new FontRenderContext(k.getTransform(), true, true);

		l = k.getLineMetrics("Wy", f);

		if (font.getSize() != k.getSize()
			|| updateFont
			|| (bi.offLeft != (width - bi.getWidth()) / 2)
			|| (bi.offTop != (height - bi.getHeight()) / 2)) {

			// set up all the variables that are used in calculating the new
			// size
			font = k;
			FontRenderContext frc =
				new FontRenderContext(font.getTransform(), true, true);
			lm = font.getLineMetrics("Wy", frc);
			//fmWidth = (int) font.getStringBounds("W", frc).getWidth() + FONT_WA;
			fmWidth = (int) font.getStringBounds("W", frc).getWidth() + (int) FONT_WA;
			fmHeight =
				(int) (font.getStringBounds("g", frc).getHeight()
					+ lm.getDescent()
					+ lm.getLeading());
			dfmWidth = (int) font.getStringBounds("", frc).getWidth();
			bi.resize(fmWidth * numCols, fmHeight * (numRows + 2));

			// set the offsets for the screen centering.
			bi.offLeft = (width - bi.getWidth()) / 2;
			bi.offTop = (height - bi.getHeight()) / 2;
			if (bi.offLeft < 0)
				bi.offLeft = 0;
			if (bi.offTop < 0)
				bi.offTop = 0;

			drawOIA();

			// and loop through the screen buffer to draw the new image with
			// the correct attributes
			for (int m = 0; m < lenScreen; m++) {
				screen[m].setRowCol(getRow(m), getCol(m));

			}
			updateFont = false;
		}

	}

	/**
	 * Draw the Operator Information Area for feedback
	 */
	private void drawOIA() {

		// get ourselves a global pointer to the graphics
		// chg pei 060816 colorDivisionǉ
		g2d =
			bi.drawOIA(
				fmWidth,
				fmHeight,
				numRows,
				numCols,
				font,
				colorBg,
				colorBlue,
				colorDivision);

		tArea.setRect(bi.getTextArea());
		cArea.setRect(bi.getCommandLineArea());
		aArea.setRect(bi.getScreenArea());
		sArea.setRect(bi.getStatusArea());
		pArea.setRect(bi.getPositionArea());
		mArea.setRect(bi.getMessageArea());
		kbArea.setRect(bi.getKBIndicatorArea());
		scriptArea.setRect(bi.getScriptIndicatorArea());

	}

	/**
	  *
	  * This routine will calculate the new image size that will be displayed
	  * when the frame that holds it is resized.
	  *
	  * The font characteristics are changed to fit the new size as will as
	  * the screen buffer row column offsets so that the characters that
	  * make of the screen are displayed correctly
	  *
	  * @param width
	  * @param height
	  */

	// chg pei 061101 Synchronized
	//public final void setBounds(int width, int height) {
	public final synchronized void setBounds(int width, int height) {

		setCursorActive(false);
		resizeScreenArea(width, height);
		dirty.setBounds(tArea.getBounds());
		if (gui.getGraphics() != null) {
			// do not forget to null out gg2d before update or else there will
			//    be a very hard to trace screen resize problem
			gg2d = null;
			// kjp make sure we redraw the screen;
			drawing = true;
			updateDirty();
		}

		// restore statuses that were on the screen before resize
		if (isStatusErrorCode())
			setStatus(STATUS_ERROR_CODE, STATUS_VALUE_ON, statusString);
		if (isXSystem())
			setStatus(STATUS_SYSTEM, STATUS_VALUE_ON, statusString);
		if (isMessageWait())
			setMessageLightOn();
		setCursorActive(true);
	}

	/**
	  *
	  * This routine will calculate the new image size that will be displayed
	  * when the frame that holds it is resized.
	  *
	  * The font characteristics are changed to fit the new size as will as
	  * the screen buffer row column offsets so that the characters that
	  * make of the screen are displayed correctly
	  *
	  * @param r
	  */
	public final void setBounds(Rectangle r) {

		setBounds(r.width, r.height);
	}

	/**
	  *
	  * This routine returns the preferred size of the component that wants
	  * to be displayed
	  *
	  * @return the value of the preferredSize property
	  *
	  */
	public final Dimension getPreferredSize() {

		return new Dimension(fmWidth * numCols, fmHeight * (numRows + 2));

	}

	/**
	 *
	 * This routine is responsible for setting up a PrinterJob on this
	 * component and initiating the print session.
	 *
	 */
	public final void printMe() {

		// chg pei 070115 showPrintDialogǉ
		Thread printerThread =
			new PrinterThread(
				screen,
				font,
				numCols,
				numRows,
				colorBg,
				defaultPrinter,
				showPrintDialog,
				(Session) gui,
				gridbf_bs,		// add pei 070322
				gridbf_tb);		// add pei 070322

		printerThread.start();

	}

	private int updatepos(int pos, char c, boolean mode, byte ebc) {
		boolean dbc, in, out, sp, updatePos = true;
		boolean out2 = false;
		
// chg start pei 060824
		//if (ScreenChar.isDBC(c)) { // DBC ?
		int cc= 0;
		if (c == siso_char) { // SOSI GENARATE
			dbc = true;
			in = true;
			out = true;
			sp = false;
			if (screen[pos].getDBCF() == ScreenChar.F_DBC_OUT) {
				++pos;
				++lastPos;
			}
		} else if (ScreenChar.isDBC(c)) { // DBC ?
			cc= 2;				
// chg end

// add start pei 070306
			byte [] ebcdic= sessionVT.getCodePage().uni2ebcdic(c, true);
			if (ebcdic.length != 2) {
				c= 0xfffd;
			} else if (ebcdic[0] == -2 && ebcdic[1] == -3) {
				c= 0xfffd;
			}
// add end

			if (screenFields.getCurrentField().isSBCSOnly()) {
				displayError(ERR_SBCS);
				return (0);
			}
			
			dbc = true;
			in = true;
			out = true;
			sp = false;
			if (screenFields.getCurrentField().isDBCSPure()) {
				in = false;
				out = false;
			} else {
				switch (screen[pos].getDBCF()) {
					case 0 :
						break;
					case ScreenChar.F_DBC_OUT :				
						in = false;
						if (mode) {
							out = false;
						}
						break;
					case ScreenChar.F_DBC_IN :
						++pos;
						out2= true;
						in = false;
						if (!mode
							&& screen[pos].getDBCF() == ScreenChar.F_DBC_OUT) {
							break;
						}
						out = false;
						break;
					case ScreenChar.F_DBC1 :
						// add pei 061108 if
						if (pos > 0 && screen[pos - 1].getDBCF() != 0) {
							in = false;
						}
						out = !mode && pos + 2 < lenScreen && screen[pos + 2].getDBCF() == ScreenChar.F_DBC_OUT;
						break;
				}
			}
		} else {
			// add pei 060824
			cc= 1;
			
			if (screenFields.getCurrentField().isDBCSOnly()) {
				displayError(ERR_DBCS);
				return (0);
			}
			dbc = false;
			out = false;
			in = false;
			sp = false;
			
			// add pei 061109 SI/SO̔pXy[X
			if (screen[pos].getDBCF() == ScreenChar.F_DBC_OUT) {
				++pos;
				out2= true;
			}
			
			switch (screen[pos].getDBCF()) {
				case 0 :
					break;
					
				// del pei 061109 SI/SO̔pXy[X
				//case ScreenChar.F_DBC_OUT :
				//	++pos;
				//	out2= true;
				//	break;
				
				case ScreenChar.F_DBC_IN :
					if (mode)
						break;
					sp = true;
					if (screen[pos + 1].getDBCF() != ScreenChar.F_DBC_OUT) {
						in = true;
					}
					break;
				case ScreenChar.F_DBC1 :
					out = true;
					if (mode) {
						in = true;
					} else {
						sp = true;
						if (screen[pos + 2].getDBCF()
							!= ScreenChar.F_DBC_OUT) {
							in = true;
						}
					}
					break;
			}
		}
// chg start pei 060824		
		//if (in)
		//	++cc;
		//if (out)
		//	++cc;
		//if (sp)
		//	++cc;
		if (in)
			++cc;
		if (out)
			++cc;
		if (sp)
			++cc;
// chg end
		if (mode) {
			if (screenFields.getCurrentField().isDBCSOnly()) {
				if (!shiftRightDBC(pos)) {
					displayError(ERR_NO_ROOM_INSERT);
					updatePos = false;
				}
			} else {
/* chg start pei 071030 
				// chg pei 061108 ŏIInsert
				int last= screenFields.getCurrentField().endPos();
				//if (endOfField(false) + cc
				//	> screenFields.getCurrentField().endPos()) {
				if (endOfField(lastPos - 1, false) + cc > last) {

					displayError(ERR_NO_ROOM_INSERT);
					updatePos = false;
				} else {
					shiftRight(pos, cc);
				}
*/
				ScreenField csf= screenFields.getCurrentField();
				if (csf.isContinuedFirst() || csf.isContinuedMiddle()) {
					do {
						csf= csf.next;
					} while (!csf.isContinuedLast());
					int last= csf.endPos();
					if (endOfField(csf, csf.startPos(), false) + cc > last) {
						displayError(ERR_NO_ROOM_INSERT);
						updatePos = false;
					}
					csf= screenFields.getCurrentField();
					last= csf.endPos();
					char cs= screen[last].getChar();
					int is= screen[last].getDBCF();
					byte bs= screen[last].getEbcdic();
//					screen[last].setChar(' ', 0, (byte)0);
					shiftRight(csf, pos, cc);
					do {
						csf= csf.next;
						last= csf.endPos();
						int start= csf.startPos();
						char cs2= screen[last].getChar();
						int is2= screen[last].getDBCF();
						byte bs2= screen[last].getEbcdic();
//						screen[last].setChar(' ', 0, (byte)0);
						shiftRight(csf, start, cc);
						screen[start].setChar(cs, is, bs);
						setDirty(start);
						cs= cs2;
						is= is2;
						bs= bs2;
					} while (!csf.isContinuedLast());
				} else {
					int last= csf.endPos();
					if (endOfField(lastPos - 1, false) + cc > last) {
						displayError(ERR_NO_ROOM_INSERT);
						updatePos = false;
					} else {
						shiftRight(pos, cc);
					}
				}
// chg end
			}
		} else {
			screenFields.getCurrentField().getKeyPos(pos);
			if ((screenFields.getCurrentField().getCurrentPos() + cc - 1)
				> screenFields.getCurrentField().endPos()) {
				displayError(ERR_NO_ROOM_INSERT);
				updatePos = false;
			}
		}
		if (updatePos) {
			int curcur = pos;
			ScreenField sf= screenFields.getCurrentField();
			sf.getKeyPos(getRow(pos), getCol(pos));
			// moved pei 061108
			//sf.changePos(sp ? cc - 1 : cc);
			if (dbc) { //DBC
				if (in) {
					setChar2(pos++, ' ', ScreenChar.F_DBC_IN, (byte) 0);
				}
				if (!mode) {
					checkpos(pos, true);
				}
// chg start pei 060824
				//setChar2(pos++, c, ScreenChar.F_DBC1, (byte) 0);
				//if (!mode && !checkpos(pos, false) && out) {
				//	out= false;
				//	--cc;
				//}
				//setChar2(pos++, '*', ScreenChar.F_DBC2, (byte) 0);
				
				if (c != siso_char) {
					setChar2(pos++, c, ScreenChar.F_DBC1, (byte) 0);
					if (!mode && !checkpos(pos, false) && out) {
						out= false;
						--cc;
					}
					setChar2(pos++, '*', ScreenChar.F_DBC2, (byte) 0);
				}
// chg end				
				if (out) {
					if (!mode) {
						checkpos(pos, true);
					}
/*
					if (screen[pos].getDBCF() == ScreenChar.F_DBC_IN) {
						if (screen[pos + 1].getDBCF()
							!= ScreenChar.F_DBC_OUT) {
							setChar2(
								pos + 2,
								' ',
								ScreenChar.F_DBC_IN,
								(byte) 0);
						}
						setChar2(pos + 1, ' ', 0, (byte) 0x40);
					}
*/
					setChar2(pos++, ' ', ScreenChar.F_DBC_OUT, (byte) 0);
					--cc;
				}
			} else {
				if (out) {
					setChar2(pos++, ' ', ScreenChar.F_DBC_OUT, (byte) 0);
				}
				setChar2(pos++, c, 0, ebc);
				if (sp) {
					setChar2(pos++, ' ', 0, (byte) 0x40);
					--cc;
				}
				if (in) {
					setChar2(pos++, ' ', ScreenChar.F_DBC_IN, (byte) 0);
					--cc;
				}
			}
			if (out2)
				++cc;
			// moved pei 061108
			sf.changePos(cc);
		} else {
			cc = 0;
		}
		return (cc);
	}

	// chg pei 080312
	//private void clearpos(int pos) {
	private void clearpos(int pos, boolean db1) {
		// add pei 070326 HOTSPOTNA
		//screen[pos].setUseGUI(ScreenChar.NO_GUI);
		switch (screen[pos].getDBCF()) {
			case 0 :
				break;
			case ScreenChar.F_DBC_OUT :
				// add pei 080312
				if (db1) break;
				if (pos >= 1) {
					int dbcf = screen[pos - 1].getDBCF();
					if (dbcf == ScreenChar.F_DBC_IN) {
						setChar2(pos - 1, ' ', 0, (byte) 0x40);
					} else if (dbcf == ScreenChar.F_DBC2) {
						setChar2(pos - 1, ' ', 0, (byte) 0x40);
						setChar2(pos - 2, ' ', ScreenChar.F_DBC_OUT, (byte) 0);
					}
				}
				break;
			case ScreenChar.F_DBC1 :
				// add pei 080312 if
				if (db1) {
					setChar2(pos + 1, ' ', 0, (byte) 0x40);
					break;
				}
				if (pos >= 1) {
					int dbcf = screen[pos - 1].getDBCF();
					if (dbcf == ScreenChar.F_DBC_IN) {
						setChar2(pos - 1, ' ', 0, (byte) 0x40);
					} else if (dbcf == ScreenChar.F_DBC2) {
						setChar2(pos - 1, ' ', 0, (byte) 0x40);
						setChar2(pos - 2, ' ', ScreenChar.F_DBC_OUT, (byte) 0);
					}
				}
				if (pos < lenScreen - 1) {
					setChar2(pos + 1, ' ', ScreenChar.F_DBC_IN, (byte) 0);
				}
				break;
			case ScreenChar.F_DBC_IN :
				if (pos < lenScreen - 1) {
					int dbcf = screen[pos + 1].getDBCF();
					if (dbcf == ScreenChar.F_DBC_OUT) {
						setChar2(pos + 1, ' ', 0, (byte) 0x40);
					} else if (dbcf == ScreenChar.F_DBC1) {
						setChar2(pos + 1, ' ', 0, (byte) 0x40);
						setChar2(pos + 2, ' ', ScreenChar.F_DBC_IN, (byte) 0);
					}
				}
				break;
			case ScreenChar.F_DBC2 :
				// chg pei 060815
				//if (pos >= 1) {
				if (pos >= 1 && screen[pos - 1].getDBCF() == ScreenChar.F_DBC1) {
					setChar2(pos - 1, ' ', ScreenChar.F_DBC_OUT, (byte) 0);
				}
				if (pos < lenScreen - 1) {
					int dbcf = screen[pos + 1].getDBCF();
					if (dbcf == ScreenChar.F_DBC_OUT) {
						setChar2(pos + 1, ' ', 0, (byte) 0x40);
					} else if (dbcf == ScreenChar.F_DBC1) {
						setChar2(pos + 1, ' ', 0, (byte) 0x40);
						setChar2(pos + 2, ' ', ScreenChar.F_DBC_IN, (byte) 0);
					}
				}
				break;
		}
		setChar2(pos, ' ', 0, (byte) 0);
	}
	
	/**
	 * DDSrNA
	 */
	public void clearGrid() {
		// chg pei 061121 rQΉ
		//gridbf = null;
		gridbf_bs = null;
	}

// chg start pei 061121 rQΉ	
	//public void writeGrid(int c, byte[] d) {
		//gridbf = d;
	public void writeGrid(int c, ByteArrayOutputStream d) throws IOException {
		if (gridbf_bs == null) {
			gridbf_bs = d;
		} else {
// chg start pei 070313 rɕύXȂꍇ͌r㏑Ȃ
			//d.writeTo(gridbf_bs);
			boolean equal= false;
			if (gridbf_bs.size() >= d.size()) {
				byte [] b1= gridbf_bs.toByteArray();
				byte [] b2= d.toByteArray();
				int off= b1.length - b2.length;
				equal= true;
				for (int i= 0; i < b2.length; ++i) {
					if (b1[off + i] != b2[i]) {
						equal= false;
						break;
					}
				}
			}
			if (!equal) {
				d.writeTo(gridbf_bs);
			}
// chg end 070313
		}
// chg end 061121
		drawing= true;
	}

	public void writeGrid_tb(int c, byte[] d, int t) {
		gridbf_tb[t]= d;
	}

	/**
	 * DDSr`揈
	 */
	private void dispGrid(Graphics2D g) {
		// add pei 061121 rQΉ
		byte [] gridbf= gridbf_bs.toByteArray();
		
		// add pei 060815
		g.setClip(0, 0, (numCols * fmWidth) -1, (numRows * fmHeight) - 1);
		for (int pos = 0; pos < gridbf.length;) {
			int l = gridbf[pos];
			int y = (gridbf[pos + 3] & 0xff) - 1;
			int x = (gridbf[pos + 4] & 0xff) - 1;
			y *= fmHeight;
			x *= fmWidth;
			int dim = 0;
			// add pei 061121 rQΉ
			if (y > 0) --y;
			if (x > 0) --x;
			
			// chg pei 060816 TOOLBOXrJ[colorBluecolorDivisionɕύX
			//g.setColor(colorBlue);
			g.setColor(colorDivision);
			int type= gridbf[pos + 1];
			switch (type) {
				case 0 : //upper
					dim = (gridbf[pos + 5] & 0xff);
					int lines= l > 9 ? (gridbf[pos + 9] & 0xff) : 1;
					// add pei 070205 rJԂ`揈Ή
					int w= l > 10 ? (gridbf[pos + 10] & 0xff) : 1;
					
					for (int i= 0; i < lines; ++i) {
						g.drawLine(x, y, x + fmWidth * dim, y);
						// chg pei 070205 rJԂ`揈Ή
						//y += fmHeight;
						y += fmHeight * w;
					}
					break;
				case 1 : //lower
					dim = (gridbf[pos + 5] & 0xff);
					
					// chg pei 061121 rQΉ
					//y += fmHeight - 1;
					y += fmHeight;
					
					lines= l > 9 ? (gridbf[pos + 9] & 0xff) : 1;
					// add pei 070205 rJԂ`揈Ή
					w= l > 10 ? (gridbf[pos + 10] & 0xff) : 1;
					
					for (int i= 0; i < lines; ++i) {
						g.drawLine(x, y, x + fmWidth * dim, y);
						// chg pei 061121 rQΉ
						//y += fmHeight;
						y += fmHeight * w;
					}
					break;
				case 2 : //left
					dim = (gridbf[pos + 6] & 0xff);
					// chg pei 061121 rQΉ
					//g.drawLine(x, y, x, y + fmHeight * dim);
					lines= l > 9 ? (gridbf[pos + 9] & 0xff) : 1;
					w= l > 10 ? (gridbf[pos + 10] & 0xff) : 1;
					for (int i= 0; i < lines; ++i) {
						g.drawLine(x, y, x, y + fmHeight * dim);
						x += fmWidth * w;
					}
					
					break;
				case 3 : //right
					dim =  (gridbf[pos + 6] & 0xff);
					// add pei 070205 rJԂ`揈Ή
					lines= l > 9 ? (gridbf[pos + 9] & 0xff) : 1;
					w= l > 10 ? (gridbf[pos + 10] & 0xff) : 1;
					
					// chg pei 061121 rQΉ
					//x += fmWidth - 1;
					x += fmWidth;
					
					// chg pei 070205 rJԂ`揈Ή
					//g.drawLine(x, y, x, y + fmHeight * dim);
					for (int i= 0; i < lines; ++i) {
						g.drawLine(x, y, x, y + fmHeight * dim);
						x += fmWidth * w;
					}
					
					break;
				case 4 : //box
				case 5 : //box
				case 6 : //box
				case 7 : //box
					int right=  x + fmWidth * (gridbf[pos + 5] & 0xff);
					int bot=  y + fmHeight * (gridbf[pos + 6] & 0xff);
					
					// del pei 061121 rQΉ
					//--x;	//???
					//--bot;
					
					g.drawLine(x, y, right, y);
					g.drawLine(x, y, x, bot);
					g.drawLine(right, y, right, bot);
					g.drawLine(x, bot, right, bot);
					if (type == 5 || type == 7) {
						int interval= l > 9 ? (gridbf[pos + 9] & 0xff) : 1;
						interval *= fmHeight;
						for (int i= y + interval; i < bot; i += interval) {
							g.drawLine(x, i, right, i);
						}
					}
					if (type == 6 || type == 7) {
						int interval= l > 10 ? (gridbf[pos + 10] & 0xff) : 1;
						interval *= fmWidth;
						for (int i= x + interval; i < right; i += interval) {
							g.drawLine(i, y, i, bot);
						}
					}
					break;
			}
			pos += l;
		}
	}

	/**
	 * TOOLBOXr`揈
	 */
	private void dispGrid_tb(Graphics2D g) {
		byte [] d;
		// del pei 061106
		//if (screen[0].getCharAttr() == 0x27) return;
		if (screen[1].getCharAttr() != 0x2f) return;
		char c= screen[2].getChar();
		if (c > 'F' || c < 'A') return;
		d= gridbf_tb[c - 'A'];
		if (d == null) return;
		g.setClip(0, 0, (numCols * fmWidth) -1, (numRows * fmHeight) - 1);
		// chg pei 060816 TOOLBOXrJ[colorBluecolorDivisionɕύX
		//g.setColor(colorBlue);
		g.setColor(colorDivision);
		for (int i= 0,pos= 0; i < d.length; ++i) {
			byte wb= d[i];
			for (int j= 0; j < 3; ++j,++pos) {
				int x= (pos % numCols) * fmWidth;
				int y= (pos / numCols) * fmHeight;
				if (y > 0) --y;	//???
				int wi= wb >> ((2 - j) * 2);
				if ((wi & 0x01) != 0) {
					g.drawLine(x, y, x, y + fmHeight);
				}
				if ((wi & 0x02) != 0) {
					g.drawLine(x, y, x + fmWidth, y);
				}
			}
		} 
	}

	private void dispIM(Graphics g) {
		//	if (!gui.im_changed) return;
		if (gui.im_aci == null) {
			gui.im_changed = false;
			im_pre_acil = 0;
			return;
		}
		im_px = getCol(lastPos) * fmWidth;
		im_px += bi.offLeft;
		im_py = (getRow(lastPos) + 1) * fmHeight - 1;
		im_py += bi.offTop;
		im_py -= 2;
		int fh = fmHeight - 2;
		int dlen = gui.im_aci.getEndIndex();
		int cpos= 0;
		int ll= 0;
		if (dlen != 0) {
			FontRenderContext im_frc= ((Graphics2D)g).getFontRenderContext();
			ll= (int)gui.ime_font.getStringBounds(gui.im_aci, 0, dlen, im_frc).getWidth();
			cpos= (int)gui.ime_font.getStringBounds(gui.im_aci, 0, gui.im_caretpos, im_frc).getWidth();
			
			// chg pei 071026 IMEm̈̕wiFɎw
			//g.setColor(gui.getBackground());
			g.setColor(Color.BLACK);
			g.fillRect(im_px, im_py - fh + 1, ll + 1, fh + 1);
			g.setColor(Color.white);
			g.drawString(gui.im_aci, im_px, im_py);
			g.drawLine(
				im_px + cpos,
				im_py - fh + 1,
				im_px + cpos,
				im_py + 1);
		}
		im_pre_acil = ll;
		gui.im_changed = false;
	}

	public int getIMPosX() {
		return (im_px);		
	}
	
	public int getIMPosY() {
		return (im_py - fmHeight + 1);		
	}
	
	protected void changeIM(int w) {
		if (config.isPropertyExists("imecontrol")) {
			if (getStringProperty("imecontrol").equals("No")) return;
		}
		if (gui.im_aci != null)
			return;
		InputContext ic = gui.getInputContext();
		if (ic == null)
			return;
		if (screenFields.isInField()) {
			ScreenField fd= screenFields.getCurrentField();
// delete JUL/2006
//			if (fd.equals(im_pre_field)) return;

			// add pei 060828 ʃtB[hɈڂꍇ́ASpɖ߂
			if (!fd.equals(im_pre_field)) {
				ic.setCharacterSubsets(im_kanji);
			}

			if (fd.isDBCSOnly()) {
				ic.setCharacterSubsets(im_kanji);
			} else if (fd.isKANA()) {
				ic.setCharacterSubsets(im_kana);
			} else {
				if (w != 2) {
					ic.setCompositionEnabled(false);
				} else {
//					ic.setCharacterSubsets(im_kanji);
					ic.setCompositionEnabled(true);
				}
			}
			im_pre_field= fd;
		} else {
			im_pre_field= null;
		}
	}

	public void altCodePage() {
		sessionVT.altCodePage();
		CodePage cp = sessionVT.getCodePage();
		for (int i = 0; i < screen.length; ++i) {
			ScreenChar sc = screen[i];
			byte b = sc.getEbcdic();
			int dbcf= sc.getDBCF();
			if (dbcf == 0 && b != 0 && b != 0x40) {
				sc.setChar(cp.ebcdic2uni(b), 0, b);
				setDirty(i);
			} else if (dbcf == ScreenChar.F_DBC1) {
				setDirty(i);
			}
		}
		updateDirty();
	}

	public void altSISO() {
		siso_flg= !siso_flg;
		for (int i = 0; i < screen.length; ++i) {
			ScreenChar sc = screen[i];
			byte b = sc.getEbcdic();
			int dbcf= sc.getDBCF();
			if (dbcf == ScreenChar.F_DBC_IN || dbcf == ScreenChar.F_DBC_OUT) {
				setDirty(i);
			}
		}
		updateDirty();
	}

	/**
	 * J[\łXgbv
	 */
	public void stopBlinker() {
		cursorActive = false;
		if (blinker != null) {
			blinker.stop();
			blinker = null;
		}
	}

	// chg pei 060901
	//public boolean waitInput() {
	public boolean waitInput(int time) {
		synchronized (this) {
			if (!isKeyboardLocked())
				return (true);
			try {
				// chg pei 060901
				//wait();
				wait(time);
			} catch (Exception e) {
				System.out.println("waitInput Exception=" + e);
			}
		}
		return (!isKeyboardLocked());
	}

	public int getString(char[] d, int r, int c, int l) {
		int ret = 0;
		int pos = (r - 1) * numCols + c - 1;
		for (int i = 0; i < l; ++i) {
			ScreenChar sc = screen[pos++];
			char wc= sc.getChar();
			if (wc == 0) wc= ' ';
			switch (sc.getDBCF()) {
				case 0 :
					if (!sc.isAttributePlace()) {
						d[ret++] = wc;
					} else {
						d[ret++] = ' ';
					}
					break;
				case ScreenChar.F_DBC1 :
					d[ret++] = wc;
					break;
				case ScreenChar.F_DBC_IN :
				case ScreenChar.F_DBC_OUT :
					d[ret++] = ' ';
					break;
				case ScreenChar.F_DBC2 :
					break;
			}
		}
		return (ret);
	}

	
	public String checkPCO() {
		for (int i= 2; i < 9; ++i) {
			if (screen[i].getEbcdic() != pco_check_data[i]) return (null);
		}
		if (screen[9].getEbcdic() != (byte)0xa1) return ("");
		StringBuffer sb= new StringBuffer();
		for (int i= 12; i < 512; ++i) {
			ScreenChar sc = screen[i];
			char wc= sc.getChar();
			int dbcf= sc.getDBCF();
			if (dbcf == 0) {
				if (sc.getEbcdic() == 0) break;
				sb.append(wc);
			} else if (dbcf == ScreenChar.F_DBC1) {
				sb.append(wc);
			}
		}
// chg start pei 060630 gqɂDOS\/\APAUSEtw
		String sbString = sb.toString();
//		if (screen[11].getEbcdic() != (byte)0x81)
//			return (cmd + " /c start /wait " + cmd + " /c \"" + sb.toString() + " & pause\"");
		// PAUSE*YES̏ꍇ
		if (screen[11].getEbcdic() != (byte)0x81) {
			// EXENDOSʔ\ɕύX pei 060720 
			if (sbString.indexOf(".exe") >= 0 || sbString.indexOf(".EXE") >= 0){
				return (cmd + " /c \"" + sb.toString() + "\"");
			} else {
				return (cmd + " /c start /wait " + cmd + " /c \"" + sb.toString() + " & pause\"");
			}
		}
// chg end
// chg start 080303 PAUSE(*NO)̏ꍇEXEt@Cw莞ȊOSTARTR}hgpɕύX
		else if (sbString.indexOf(".exe") >= 0 || sbString.indexOf(".EXE") >= 0){
			return (sb.toString());
		}
		//return (sb.toString());
		return (cmd + " /c start " + cmd + " /c \"" + sb.toString() + "\"");
// chg end
	}

// del start pei 061027
/*	
	public boolean checkTBG() {
//		if (screen[0].getCharAttr() != 0x27) return (false);
		// add pei 060823 TOOLBOXr
		if (screen[0].getCharAttr() == 0x28) return (false);
		
		if (screen[1].getCharAttr() != 0x2f) return (false);
		char c= screen[2].getChar();
		if (c < 'A' && c > 'F') return (false);
//	delete JUN/2006		if (screen[3].getCharAttr() != 0x27) return (false);
		ByteArrayOutputStream baos= new ByteArrayOutputStream();
		for (int i= 4; i < (screen.length - 1); ++i) {
			if (screen[i].isAttributePlace()) break;
			byte wb= screen[i].getEbcdic();
			if (wb == (byte)0xC3) {
//				if (screen[i].getEbcdic() == (byte)0xc6) return (false);
				break;
			}
			if (wb < 0x40) return (false);
			baos.write(wb); 
		}
		if (baos.size() < 640) {
//			gridbf_tb[c - 'A']= null;
			return (false);
		}
//		System.out.println("TOOLBOX GRID");
		writeGrid_tb(0, baos.toByteArray(), c - 'A');	// ToolBox Grid
		return (true);
	}
*/
// del end

	private boolean checkpos(int pos, boolean first) {
		if (screen[pos].getDBCF() == ScreenChar.F_DBC_IN) {
			if (screen[pos + 1].getDBCF()
				!= ScreenChar.F_DBC_OUT) {
				if (!first) return (false);
				setChar2(
					pos + 2,
					' ',
					ScreenChar.F_DBC_IN,
					(byte) 0);
			}
			setChar2(pos + 1, ' ', 0, (byte) 0x40);
		}
		return (true); 
	}
	
	public void roll(boolean up, int top, int bot, int l) {
		if (l == 0) return;
		int c= bot - top + 1 - l;
		int from= up ? top + l : bot - l;
		int to= up ? top : bot;
		--from;	// from 0
		--to;	// from 0
		for (int i= 0; i < c; ++i) {
			moveline(to, from);
			if (up) {
				++to;
				++from;
			} else {
				--to;
				--from;
			}
		} 
	}
	
	private void moveline(int to, int from) {
		int fpos= getPos(from, 0);
		int tpos= getPos(to, 0);
		for (int i= 0; i < numCols; ++i) {
			screen[tpos].setChar(
				screen[fpos].getChar(),
				screen[fpos].getDBCF(),
				screen[fpos].getEbcdic());
			setDirty(tpos);
			++fpos;
			++tpos;
		}
	}	

	public void drawButton(ScreenField sf) {
		int len= sf.getFieldLength();
		int pos= sf.startPos;
		if (len > 1) {
			screen[pos++].setUseGUI(ScreenChar.BUTTON_LEFT);
			while (--len > 1) {
				screen[pos++].setUseGUI(ScreenChar.BUTTON_MIDDLE);
			}
			screen[pos].setUseGUI(ScreenChar.BUTTON_RIGHT);

		} else
			screen[pos].setUseGUI(ScreenChar.BUTTON_ONE);
	}
	
// chg start pei 080208
//	public void drawSingleSelection(SingleSelectionField ssf) {
//		int pos= ssf.startPos() - 2;
//		for (int i= 1; i <= ssf.rows; ++i) {
//			if (ssf.isAvalilable(i)) {
//				if (ssf.getSelectPos() == (i)) {
//					screen[pos].setChar((char)0xffed, 0, (byte)0);
//				} else {
//					screen[pos].setChar((char)0xffee, 0, (byte)0);
//				}
//				setDirty(pos);
//			}
//			pos += getCols();
//		}
//		// del pei 071031 ʃ`cLΉ
//		//updateImage(dirty);
//	}
	public void drawSelection(ScreenField sf) {
		if (!sf.isSelectionField()) return;
		int type= sf.getType();
// chg start pei 080312
		//if (type == ScreenField.F_SINGLESELECTION || type == ScreenField.F_SINGLESELECTION_PD) {
		if (type == ScreenField.F_SINGLESELECTION 
			|| type == ScreenField.F_MULTISELECTION
			|| type == ScreenField.F_SINGLESELECTION_PD
			) {
			//SingleSelectionField ssf= (SingleSelectionField)sf;
			SelectionField ssf= (SelectionField)sf;
			//int pos= ssf.startPos() - 2;
			//for (int i= 1; i <= ssf.rows; ++i) {
			for (int i= 1; i <= ssf.getChoice_cnt(); ++i) {
				if (ssf.isAvalilable(i)) {
					//if (ssf.getSelectPos() == (i)) {
					int pos = ssf.getChoice_pos(i) - 2;
					// chg pei 080317 WI{^E`FbN{bNX̕ύX
					// I
					if (ssf.isSelected(i)) {	
//						screen[pos].setChar((char)0xffed, 0, (byte)0); // original
						if (type == ScreenField.F_MULTISELECTION) 
							screen[pos].setChar((char)0x22a0, 0, (byte)0); // I
						else screen[pos].setChar((char)0x25c9, 0, (byte)0); // I
					// I
					} else {
						if (type == ScreenField.F_MULTISELECTION)
							screen[pos].setChar((char)0x25a2, 0, (byte)0); // I
						else screen[pos].setChar((char)0xffee, 0, (byte)0); // original
					}
					setDirty(pos);
				}
				//pos += getCols();
			}
		} else if (type == ScreenField.F_SINGLESELECTION_LIST) {
			//SingleSelectionField ssf= (SingleSelectionField)sf;
			SelectionField ssf= (SelectionField)sf;
			int pos= ssf.startPos();
			for (int i= 1; i <= ssf.rows; ++i) {
				if (ssf.isAvalilable(i)) {
					int attr= screen[pos].getCharAttr();
					//if (ssf.getSelectPos() == (i)) {
					if (ssf.isSelected(i)) {
						attr |= 0x02;
					} else {
						attr &= ~0x02;
					}
					for (int j= 0; j < ssf.length; ++j) {
						screen[pos + j].setAttribute(attr);
						setDirty(pos + j);
					}
				}
				pos += getCols();
			}
// chg end
		}
	}
// chg end	
	
	public void clearButton(ButtonField sf) {
		int len= sf.getFieldLength();
		int pos= sf.startPos;
		
		// chg pei 060831 
		//while (len-- > 0) {
		while (len-- > 0 && pos < screen.length) {
			screen[pos++].setUseGUI(ScreenChar.NO_GUI);
		}
		sf.resetButton();
	}
	
	public void addPMouseB(byte b1, byte b2, byte b3, byte b4) {
		// add pei 080312 for
		for (int i= 0; i < p_mouse_btn.size(); ++i) {
			ProgMouseButton pmb= (ProgMouseButton)p_mouse_btn.elementAt(i);
			if (pmb.getFlag() == b1 && pmb.getEV1() == b2 && pmb.getEV2() == b3 && pmb.getAid() == b4) return;
		}
		p_mouse_btn.add(new ProgMouseButton(b1, b2, b3, b4));
	}
	
	public void clearPMouseB() {
		p_mouse_btn.clear();
	}

// add start pei 060824 SO/SI GENERATE
	protected void sosi_gen() {
		if (screenFields.isInField()) {
			ScreenField sf= screenFields.getCurrentField();
		
			int fcw1= sf.getFCW1();
			int fcw2= sf.getFCW2();
		
			// chg pei 070221 ptB[hɓ͕s(tB[h)
			//if (sf.isSBCSOnly()){
			if (sf.isSBCSOnly() && !(fcw1 == 0x82 && fcw2 == 0x40)){
				displayError(ERR_SBCS);
				return;
			}
			
			if (fcw1 == 0x82 && fcw2 == 0x40) {
				int startp= sf.startPos();
				if (screen[startp].getDBCF() == ScreenChar.F_DBC_IN) {
					if (lastPos == (startp + 1)) {
						int l= sf.getLength();
						resetDirty(lastPos);
						for (int i= 0; i < l; ++i) {
							screen[startp + i].setChar(' ', 0, (byte)0x40);
							setDirty(startp + i);
						}
						lastPos= startp;
						updateDirty();
					}
				} else {
					if (lastPos == startp) {
						int l= sf.getLength();
						resetDirty(lastPos);
						for (int i= 0; i < l; ++i) {
							if (i == 0) {
								screen[startp + i].setChar(' ', ScreenChar.F_DBC_IN, (byte)0);
							} else if (i >= (l - 2)) {
								screen[startp + i].setChar(' ', ScreenChar.F_DBC_OUT, (byte)0);
								setDirty(startp + i);
								break;
							} else {
								screen[startp + i].setChar('@', ScreenChar.F_DBC1, (byte) 0);
								setDirty(startp + i);
								++i;
								screen[startp + i].setChar('*', ScreenChar.F_DBC2, (byte) 0);
							}
							setDirty(startp + i);
						}
						lastPos= startp + 1;
						updateDirty();
					}
				}
				return;
			}
			if (sf.isDBCSOnly()) return;
		}
		insertMode= true;
		simulateKeyStroke(siso_char);
	}
// add end

	// add pei 061128 ADDIN
	public void addin_key(KeyEvent e) {
		if (addin != null) {
			addin.exec_passive(e);
		}
	}
	
	// add pei 070124 OɃZbVID擾p
	public int getSessionID() {
		return (SessionManager.instance().getSessions().getID((Session)gui));
	}
	
// add start pei 080208
// chg start pei 080312 
	//private void ss_up(ScreenField sf) {
	private void ss_up(SelectionField ssf) {
		//SingleSelectionField ssf= (SingleSelectionField)sf;
		int next= -numCols;
		if (ssf.getType() == ScreenField.F_SINGLESELECTION_PD) {
			if (getRow(lastPos) == ssf.startRow()) {
				next= numCols * (ssf.getRows() - 1);
			}
		} else if (ssf.getType() == ScreenField.F_SINGLESELECTION_LIST) {
			if (getRow(lastPos) == ssf.startRow()) {
				int ln= ssf.getRows();
				//while (!((SingleSelectionField)ssf).isAvalilable(ln)) --ln;
				while (!((SelectionField)ssf).isAvalilable(ln)) --ln;
				next= numCols * (ln - 1);
			}
		} else {
			next= ssf.c_up(next, lastPos);
		}
		process_XY(next);
	}
	
	//private void ss_down(ScreenField sf) {
	private void ss_down(SelectionField ssf) {
		//SingleSelectionField ssf= (SingleSelectionField)sf;
		int next= numCols;
		if (ssf.getType() == ScreenField.F_SINGLESELECTION_PD) {
			if (getRow(lastPos) == (ssf.startRow() + ssf.getRows() - 1)) {
				next= -(numCols * (ssf.getRows() - 1));
			}
		} else if (ssf.getType() == ScreenField.F_SINGLESELECTION_LIST) {
			try {
				int ln= getRow(lastPos) - ssf.startRow();
				//if (!((SingleSelectionField)ssf).isAvalilable(ln + 2)) {
				if (!ssf.isAvalilable(ln + 2)) {
					next= -(numCols * ln);
				}
			} catch (ArrayIndexOutOfBoundsException e) {
				next= -(numCols * (ssf.getRows() - 1));
			}
		} else {
			next= ssf.c_down(next, lastPos);
		}
		process_XY(next);
	}
	
	//private void ss_left(ScreenField sf) {
	private void ss_left(SelectionField ssf) {
		//SingleSelectionField ssf= (SingleSelectionField)sf;
		int next= -1;
//		if (ssf.getType() == ScreenField.F_MENU && ((SingleSelectionField)ssf).getSelectPos() != 1)  {
//			ssf.advanceMenu(false);
//			goto_XY(ssf.getMenu_pos(ssf.getSelectPos()));
//			return;
//		} else if (ssf.getType() == ScreenField.F_SINGLESELECTION_PD) {
//			if ((ssf.getMinorFlag(2, ssf.getSelectPos()) & 0x10) != 0) {
		if (ssf.getType() == ScreenField.F_MENU)  {
			if (ssf.getSingleSelectedPos() != 1)  {
				ssf.advancePos(false);
				goto_XY(ssf.getChoice_pos(ssf.getSingleSelectedPos()));
				return;
			}
		} else if (ssf.getType() == ScreenField.F_SINGLESELECTION_PD) {
			if ((ssf.getMinorFlag(2, ssf.getSingleSelectedPos()) & 0x10) != 0) {
				sendAid(AID_ROLL_LEFT);
				return;
			}
		} else if (ssf.getType() == ScreenField.F_SINGLESELECTION_LIST) {
			//ss_up(sf);
			ss_up(ssf);
			return;
		} else {
			next= ssf.c_left(next, lastPos);
		}
		process_XY(next);
	}
	
	//private void ss_right(ScreenField sf) {
	private void ss_right(SelectionField ssf) {
		//SingleSelectionField ssf= (SingleSelectionField)sf;
		int next= 1;
//		if (ssf.getType() == ScreenField.F_MENU && ssf.getSelectPos() != ssf.getMenu_cnt())  {
//			ssf.advanceMenu(true);
//			goto_XY(ssf.getMenu_pos(ssf.getSelectPos()));
//			return;
//		} else if (ssf != null && ssf.getType() == ScreenField.F_SINGLESELECTION_PD) {
//			if ((ssf.getMinorFlag(2, ssf.getSelectPos()) & 8) != 0) {
		if (ssf.getType() == ScreenField.F_MENU)  {
			if (ssf.getSingleSelectedPos() != ssf.getChoice_cnt())  {
				ssf.advancePos(true);
				goto_XY(ssf.getChoice_pos(ssf.getSingleSelectedPos()));
				return;
			} else {
				next = ssf.getChoice_len(ssf.getChoice_cnt());
			}
		} else if (ssf != null && ssf.getType() == ScreenField.F_SINGLESELECTION_PD) {
			if ((ssf.getMinorFlag(2, ssf.getSingleSelectedPos()) & 8) != 0) {
				sendAid(AID_ROLL_RIGHT);
				return;
			}
		} else if (ssf.getType() == ScreenField.F_SINGLESELECTION_LIST) {
			//ss_down(sf);
			ss_down(ssf);
			return;
		} else {
			next= ssf.c_right(next, lastPos);
		}
		process_XY(next);
	}
// add end
}
