/**
 * Title: tn5250J
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.5
 * 
 * Modified by pei DEC/2004
 * 
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j;

import java.io.*;
import java.net.*;

import je.tn5250j.DataStreamTracer;
//import org.python.modules.synchronize;

//import je.tn5250j.encoding.CodePage;

public class DataStreamProducer implements Runnable {

	private BufferedInputStream bin;
	private ByteArrayOutputStream baosin;
	private Thread me;
	private byte[] saveStream;
	private DataStreamQueue dsq;
	private tnvt vt;
	private byte[] abyte2;
	private DataStreamTracer tracer;

	public DataStreamProducer(
		tnvt vt,
		BufferedInputStream in,
		DataStreamQueue queue,
		byte[] init,
		DataStreamTracer trc) {
		bin = in;
		this.vt = vt;
		baosin = new ByteArrayOutputStream();
		dsq = queue;
		abyte2 = init;
		tracer= trc;
	}

	public void setInputStream(ByteArrayOutputStream is) {

		baosin = is;

	}

	public void setQueue(DataStreamQueue queue) {

		dsq = queue;

	}

	public final void run() {

		boolean done = false;

		me = Thread.currentThread();

		// load the first response screen
		try {
			loadStream(abyte2, 0);
		} catch (IOException ioef) {
			System.out.println(" run() " + ioef.getMessage());
		}
		while (!done) {
			try {

				byte[] abyte0 = readIncoming();
				
				if (abyte0 == null) continue;
				// WVL - LDC : 16/07/2003 : TR.000345
				// When the socket has been closed, the reading returns
				// no bytes (an empty byte arrray).
				// But the loadStream fails on this, so we check it here!
				if (abyte0.length > 0) {
					loadStream(abyte0, 0);
				}
				// WVL - LDC : 16/07/2003 : TR.000345
				// Returning no bytes means the input buffer has
				// reached end-of-stream, so we do a disconnect!
				else {
					done = true;
					vt.disconnect();
				}

			} catch (SocketException se) {
				System.out.println("   DataStreamProducer interrupted:" + se.getMessage());
//				System.out.println("   DataStreamProducer thread interrupted and stopping ");
				if (!"socket closed".equals(se.getMessage())) {
					vt.tcpreset();
				}
				done = true;
			} catch (IOException ioe) {

				//              System.out.println(ioe.getMessage());
				if (me.isInterrupted())
					done = true;

			} catch (Exception ex) {

				System.out.println(ex.getMessage());
				if (me.isInterrupted())
					done = true;

			}
		}
	}

	private final void loadStream(byte abyte0[], int i) throws IOException {

		int j = 0;
		int size = 0;
		if (saveStream == null) {
			j = (abyte0[i] & 0xff) << 8 | abyte0[i + 1] & 0xff;
			size = abyte0.length;
		} else {
			size = saveStream.length + abyte0.length;
			byte[] inter = new byte[size];
			System.arraycopy(saveStream, 0, inter, 0, saveStream.length);
			System.arraycopy(
				abyte0,
				0,
				inter,
				saveStream.length,
				abyte0.length);
			abyte0 = new byte[size];
			System.arraycopy(inter, 0, abyte0, 0, size);
			saveStream = null;
			inter = null;
			j = (abyte0[i] & 0xff) << 8 | abyte0[i + 1] & 0xff;
			//         System.out.println("partial stream found");
		}

		if (j > size) {
//			saveStream = new byte[abyte0.length];
//			System.arraycopy(abyte0, 0, saveStream, 0, abyte0.length);
			saveStream = new byte[size];
			System.arraycopy(abyte0, 0, saveStream, 0, size);
		} else {
			byte abyte1[];
			try {
				abyte1 = new byte[j + 2];

				System.arraycopy(abyte0, i, abyte1, 0, j + 2);
				dsq.put(new Stream5250(abyte1));
				if (abyte0.length > abyte1.length + i)
					loadStream(abyte0, i + j + 2);
			} catch (Exception ex) {

				System.out.println("load stream error " + ex.getMessage());
				//        ex.printStackTrace();
				//        dump(abyte0);

			}
		}
	}

	public final byte[] readIncoming() throws IOException {

		boolean done = false;
		boolean negotiate = false;

		baosin.reset();
		int j = -1;
		int i = 0;

		while (!done) {
			i = bin.read();

			// WVL - LDC : 16/07/2003 : TR.000345
			// The inStream return -1 when end-of-stream is reached. This
			// happens e.g. when the connection is closed from the AS/400.
			// So we stop in this case!
			// ==> an empty byte array is returned from this method.
			if (i == -1) // nothing read!
			{
				done = true;
				vt.disconnect();
				throw new SocketException("return -1");
//				continue;
			}

			// We use the values instead of the static values IAC and EOR
			//    because they are defined as bytes.
			//
			// The > if(i != 255 || j != 255)  < is a hack for the double FF FF's
			// that are being returned.  I do not know why this is like this and
			// can not find any documentation for it.  It is also being returned
			// on my Client Access tcp dump as well so they are handling it.
			//
			// my5250
			// 0000:  00 50 DA 44 C8 45 42 00 00 00 00 24 08 00 45 00 .P.D.EB....$..E.
			// 0010:  04 2A BC F9 00 00 40 06 D0 27 C1 A8 33 04 C1 A8 .*....@..'..3...
			// 0020:  33 58 00 17 04 18 6F A2 83 CB 00 1E D1 BA 50 18 3X....o.......P.
			// 0030:  20 00 8A 9A 00 00 03 FF FF 12 A0 00 00 04 00 00  ...............
			// --------------------------- || || -------------------------------------
			// 0040:  03 04 40 04 11 00 20 01 07 00 00 00 18 00 00 10 ..@... .........

			if (j == 255 && i == 255) {
				j = -1;
				continue;
			} else {
				baosin.write(i);
				// check for end of record EOR and IAC  - FFEF
				if (j == 255 && i == 239)
					done = true;

				// This is to check for the TELNET TIMING MARK OPTION
				// rfc860 explains this in more detail.  When we receive it
				// we will negotiate with the server by sending a WONT'T TIMING-MARK
				// This will let the server know that we processed the information
				// and are just waiting for the user to enter some data so keep the
				// socket alive.   This is more or less a AYT (ARE YOU THERE) or not.
				if (i == 253 && j == 255) {
					done = true;
					negotiate = true;
				}
				j = i;
			}
		}

		// after the initial negotiation we might get other options such as
		//    timing marks ??????????????  do we ???????????? look at telnet spec
		// yes we do. rfc860 explains about timing marks.
		if (negotiate) {
			// get the negotiation option
			baosin.write(bin.read());
			tracer.dump(baosin.toByteArray(), 0);
			vt.negotiate(baosin.toByteArray());
			return (null);
		}

//		if (dumpBytes) {
		tracer.dump(baosin.toByteArray(), 0);
//		}

		return baosin.toByteArray();
	}
}