/* gcc -Wall tless.c -o tmore -lncursesw */
/*
    tmore --tategaki more--  ver. 1.0 
    Copyright (C) 2009  Yasuhiko Kuramata

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <stdio.h>
#include <ncurses.h>
#include <locale.h>
#include <unistd.h>

/* 文字の先頭バイトにアクセスし、その文字が何バイト文字かを返す関数 */
int
charbytes(const char *cp)
{
  if(!(128&(*cp))) return  1;
  if(!( 64&(*cp))) return  0;
  if(!( 32&(*cp))) return  2;
  if(!( 16&(*cp))) return  3;
  if(!(  8&(*cp))) return  4;
  return -1;
}

/* 多バイト文字対応のgetc
  char *cに文字を格納する。このための領域は別に確保する必要がある。
返値:
  ファイル終了時     は     EOF(=-1) 
  半角文字（見た目が）の時は 1
  全角文字（見た目が）の時は 2
*/
int
getwc(char *c, FILE *fp)
{
  int i, size, ret=1;
  c[0] = getc(fp); /* getcをcharで受けているが..? */

  if(c[0] == EOF) return EOF;

  size = charbytes(c);
  /* size=1の時、このforループは１度も実行されない。*/
  for(i=1; i<size; i++){
    c[i] = getc(fp);
    ret = 2;
  }
  c[size]='\0';
  
  return ret;
}

/* 縦の一行を端末に出力する関数
引数
  win: 対象ウィンドウ
　fp : 対象ファイル
  x  : 出力する行番号
  limit: 一行の最大文字数
返値:
  EOF：EOFによる終了(=-1)
  0：limitに達したための終了
  1：改行による終了
*/
int
print_vline(WINDOW *win, FILE *fp, int x, int limit)
{
  char cbuf[5]; /* UTF-8の文字は最大4バイトなので */
  int y=0, ret=0;

  while(1){
    getwc(cbuf, fp);
    if(*cbuf==EOF) { ret=-1; break; }
    if(*cbuf=='\n'){ ret=1; break; }
    wmove(win, y, x);
    wprintw(win, "%s", cbuf);
    y++;
    if(y==limit){ ret=0; break; }
  }
  wrefresh(win);
  return ret;
}

/* 端末１画面を出力する関数 */
int
next_page(WINDOW *win, FILE *fp)
{
  int ret=0;
  int x, y;
  x=COLS-2;
  y=0;

  wclear(win);

  while(1){
    if( print_vline(win, fp, x, LINES-1) == EOF){ 
      ret = EOF;
      break;
    }
    x-=3;
    if(x<0) break;
  }


  return ret;
}


/* tmoreのメインループ関数 */
void
do_tmore(FILE *fp)
{
  setlocale( LC_ALL, "ja_JP.UTF-8" );
  int c   =' ';
  int eflag =0;
  long int fsize=1;

  WINDOW *win;
  FILE *in;
  win = initscr();
  noecho();
  raw();

  in = fopen("/dev/tty", "r");
  fseek(fp, 0, SEEK_END);
  fgetpos(fp, &fsize);
  fseek(fp, 0, SEEK_SET);

  while(1)
  {
    switch(c)
    {
      case 'q' :
        goto FINISH;
        break;
      case ' ' :
        if(eflag==EOF) goto FINISH;
        eflag = next_page(win, fp);
        break;
      default:
        break;
    }
    attron(A_REVERSE);
      mvprintw(LINES-1, 0, "次のページ:space  終了:q (%3d％)", (ftell(fp)*100)/fsize);
    attroff(A_REVERSE);

    wrefresh(win);
    c = getc(in);
  }
FINISH:
  fclose(in);
  endwin();
}

/* main */
int
main(int argc, char *argv[])
{

  FILE *fp;
  int isPiped = isatty(fileno(stdin));

  if(!isatty(fileno(stdout))){
    fprintf(stderr, "%s: リダイレクト不可\n", argv[0]);
    return -1;
  }

  if(argc==1 && !isPiped){
    do_tmore(stdin);
    return 0;
  }

  if(argc < 2){
    fprintf(stderr, "%s: ファイル名を指定してください。\n", argv[0]);
    return -1;
  }

  fp = fopen(argv[1], "r");
  if(fp==NULL){
    fprintf(stderr, "%s: %s というファイルが見つかりません。\n", argv[0], argv[1]);
    return -1;
  } 
  do_tmore(fp);
  fclose(fp);

  return 0;
}
