/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.extension.PluginExtensionPointRuntimeException;

public class PluginExtensionPointFactory<T> {
    private String extensionPointId;
    private List<T> instanceList;
    private IExtensionRegistry registry;
    private Comparator<T> comparator;
    private static Logger logger = LoggerFactory.getLogger(PluginExtensionPointFactory.class);

    public PluginExtensionPointFactory(String extensionPoint) {
        this(extensionPoint, null);
    }

    public PluginExtensionPointFactory(String extensionPoint, Comparator<T> comparator) {
        this.extensionPointId = extensionPoint;
        this.instanceList = new ArrayList<T>();
        this.registry = Platform.getExtensionRegistry();
        this.comparator = comparator;
        this.registry.addListener(new IRegistryEventListener(){

            public void removed(IExtensionPoint[] extensionPoints) {
                logger.debug("removed(IExtensionPoint[] extensionPoints)");
                PluginExtensionPointFactory.this.setup();
            }

            public void removed(IExtension[] extensions) {
                logger.debug("removed(IExtension[] extensions");
                PluginExtensionPointFactory.this.setup();
            }

            public void added(IExtensionPoint[] extensionPoints) {
                logger.debug("added(IExtensionPoint[] extensionPoints)");
                PluginExtensionPointFactory.this.setup();
            }

            public void added(IExtension[] extensions) {
                logger.debug("added(IExtension[] extensions)");
                PluginExtensionPointFactory.this.setup();
            }
        }, this.extensionPointId);
        this.setup();
    }

    public T getInstance() {
        if (!this.instanceList.isEmpty()) {
            return this.instanceList.get(0);
        }
        return null;
    }

    public T getInstance(T empty) {
        T instance = this.getInstance();
        if (instance == null) {
            instance = empty;
        }
        return instance;
    }

    public List<T> getInstances() {
        return Collections.unmodifiableList(this.instanceList);
    }

    private void setup() {
        this.instanceList.clear();
        IExtensionPoint point = this.registry.getExtensionPoint(this.extensionPointId);
        if (point == null) {
            logger.debug("{} is not exists.", (Object)this.extensionPointId);
            return;
        }
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ex = iExtensionArray[n2];
            this.addExsecutableExtensionsFromExtension(ex);
            ++n2;
        }
        if (this.comparator != null) {
            Collections.sort(this.instanceList, this.comparator);
        }
    }

    private void addExsecutableExtensionsFromExtension(IExtension ex) {
        IConfigurationElement[] iConfigurationElementArray = ex.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                this.instanceList.add(ce.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                logger.warn(e.getMessage());
                throw new PluginExtensionPointRuntimeException(e);
            }
            ++n2;
        }
    }
}

