/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.views.properties.gef3;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.extension.DialectProviderFactory;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.views.properties.gef3.AbstractPropertySource;
import org.tmdmaker.ui.views.properties.gef3.commands.PropertyChangeCommand;

public class DiagramPropertySource
extends AbstractPropertySource {
    private static final String NAME = "name";
    private static final String DATABASE_NAME = "databaseName";
    private static final String DESCRIPTION = "description";
    private Diagram diagram;
    private IPropertyDescriptor[] propertyFields;
    private String[] dataBaseList;

    public DiagramPropertySource(CommandStack commandStack, Diagram diagram) {
        super(commandStack);
        this.diagram = diagram;
        this.dataBaseList = DialectProviderFactory.getDialectProvider().getDatabaseList().toArray(new String[0]);
        this.propertyFields = this.buildPropertyDescriptors();
    }

    public Object getEditableValue() {
        return this.diagram;
    }

    protected IPropertyDescriptor[] buildPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)NAME, Messages.ModelName), new ComboBoxPropertyDescriptor((Object)DATABASE_NAME, Messages.DatabaseName, this.dataBaseList), new TextPropertyDescriptor((Object)DESCRIPTION, Messages.Description)};
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyFields;
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(DATABASE_NAME)) {
            return ArrayUtils.indexOf((Object[])this.dataBaseList, (Object)this.diagram.getDatabaseName());
        }
        return this.canonicalize((String)this.getPropertyValue(this.diagram, id.toString()));
    }

    @Override
    public void resetPropertyValue(Object id) {
    }

    @Override
    protected Command createSetPropertyCommand(Object id, Object newValue) {
        String propertyName = id.toString();
        Object oldValue = this.getPropertyValue(this.diagram, propertyName);
        if (id.equals(DATABASE_NAME)) {
            newValue = this.dataBaseList[(Integer)newValue];
        }
        return new PropertyChangeCommand(this.diagram, propertyName, oldValue, newValue);
    }
}

