/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.treeeditparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.CombinationTable;
import org.tmdmaker.core.model.Detail;
import org.tmdmaker.core.model.Identifier;
import org.tmdmaker.core.model.KeyModel;
import org.tmdmaker.core.model.Laputa;
import org.tmdmaker.core.model.MappingList;
import org.tmdmaker.core.model.MultivalueOrEntity;
import org.tmdmaker.core.model.RecursiveTable;
import org.tmdmaker.core.model.ReusedIdentifier;
import org.tmdmaker.core.model.SubsetEntity;
import org.tmdmaker.core.model.VirtualEntity;
import org.tmdmaker.core.model.VirtualSuperset;
import org.tmdmaker.core.model.other.TurboFile;
import org.tmdmaker.ui.Activator;
import org.tmdmaker.ui.editor.gef3.treeeditparts.FolderTreeEditPart;
import org.tmdmaker.ui.util.ModelEditUtils;
import org.tmdmaker.ui.views.properties.IPropertyAvailable;
import org.tmdmaker.ui.views.properties.gef3.AbstractEntityModelPropertySource;

public class AbstractEntityModelTreeEditPart<T extends AbstractEntityModel>
extends AbstractTreeEditPart
implements PropertyChangeListener,
IPropertyAvailable {
    private static Logger logger = LoggerFactory.getLogger(AbstractEntityModelTreeEditPart.class);
    private static Map<Type, String> icons = new HashMap<Type, String>();
    protected EditPolicy componentPolicy;
    List<List<?>> modelChildren = new ArrayList();
    List<Identifier> identifiers = new ArrayList<Identifier>();

    static {
        icons.put((Type)((Object)CombinationTable.class), "icons/outline/combination_table.png");
        icons.put((Type)((Object)SubsetEntity.class), "icons/outline/subset_resource.png");
        icons.put((Type)((Object)VirtualEntity.class), "icons/outline/virtual_entity.png");
        icons.put((Type)((Object)MultivalueOrEntity.class), "icons/outline/multivalue_or.png");
        icons.put((Type)((Object)Detail.class), "icons/outline/detail.png");
        icons.put((Type)((Object)RecursiveTable.class), "icons/outline/recursive_table.png");
        icons.put((Type)((Object)MappingList.class), "icons/outline/mapping_list.png");
        icons.put((Type)((Object)Laputa.class), "icons/outline/laputa.png");
        icons.put((Type)((Object)VirtualSuperset.class), "icons/outline/virtual_entity.png");
        icons.put((Type)((Object)TurboFile.class), "icons/outline/virtual_entity.png");
    }

    public AbstractEntityModelTreeEditPart(T model, EditPolicy policy) {
        this.setModel(model);
        this.componentPolicy = policy;
    }

    public T getModel() {
        return (T)((AbstractEntityModel)super.getModel());
    }

    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            this.executeEditCommand(this.getCommand(request));
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", this.componentPolicy);
    }

    protected void executeEditCommand(Command command) {
        this.getViewer().getEditDomain().getCommandStack().execute(command);
    }

    protected List<List<?>> getModelChildren() {
        return this.modelChildren;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.updateChildren();
    }

    protected void clearChildren() {
        this.modelChildren.clear();
        this.identifiers.clear();
    }

    protected void updateChildren() {
        this.clearChildren();
        this.setIdentifiers();
        this.setAttributes();
        this.setKeyModels();
    }

    protected void setIdentifiers() {
        for (ReusedIdentifier r : this.getModel().getReusedIdentifiers().values()) {
            for (Identifier i : r.getIdentifiers()) {
                this.identifiers.add(i);
            }
        }
        if (this.identifiers != null && !this.identifiers.isEmpty()) {
            this.modelChildren.add(this.identifiers);
        }
    }

    protected void setAttributes() {
        List attributes = this.getModel().getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            this.modelChildren.add(attributes);
        }
    }

    protected void setKeyModels() {
        ArrayList<KeyModel> keymodels = new ArrayList<KeyModel>();
        for (KeyModel key : this.getModel().getKeyModels()) {
            keymodels.add(key);
        }
        if (!keymodels.isEmpty()) {
            this.modelChildren.add(keymodels);
        }
    }

    protected String getText() {
        return ModelEditUtils.toBlankStringIfNull(this.getModel().getName());
    }

    protected Image getImage() {
        if (icons.containsKey(this.getModel().getClass())) {
            String path = icons.get(this.getModel().getClass());
            return Activator.getImage(path);
        }
        return super.getImage();
    }

    public void activate() {
        super.activate();
        this.getModel().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        this.getModel().removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug("{}.{}", this.getClass(), (Object)evt.getPropertyName());
        if (evt.getPropertyName().equals("_property_name")) {
            this.handleNameChange(evt);
        } else if (evt.getPropertyName().equals("_property_constraint")) {
            this.handleConstraintChange(evt);
        } else if (evt.getPropertyName().equals("p_attribute")) {
            this.handleAttributeChange(evt);
        } else if (evt.getPropertyName().equals("p_source_connection")) {
            this.handleSourceConnectionChange(evt);
        } else if (evt.getPropertyName().equals("p_target_connection")) {
            this.handleTargetConnectionChange(evt);
        } else if (evt.getPropertyName().equals("p_reused")) {
            this.handleReUseKeyChange(evt);
        } else if (evt.getPropertyName().equals("_property_identifier")) {
            this.handleIdentifierChange(evt);
        } else if (evt.getPropertyName().equals("p_entity_type")) {
            this.handleEntityTypeChange(evt);
        } else if (evt.getPropertyName().equals("p_attribute_reorder")) {
            logger.warn("Handle Reorder Occured.");
            this.refreshChildren();
        } else {
            logger.warn("Not Handle Event Occured.");
        }
    }

    protected void handleNameChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleConstraintChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleAttributeChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
        this.refreshChildren();
    }

    protected void handleIdentifierChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleAttributeReorder(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleReUseKeyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleEntityTypeChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleSourceConnectionChange(PropertyChangeEvent evt) {
    }

    protected void handleTargetConnectionChange(PropertyChangeEvent evt) {
    }

    protected void refreshVisuals() {
        logger.debug("{}#refreshVisuals()", this.getClass());
        super.refreshVisuals();
        this.refreshChildren();
    }

    protected void refreshChildren() {
        logger.debug("{}#refreshChildren()", this.getClass());
        this.updateChildren();
        List children = this.getChildren();
        int size = children.size();
        HashMap<Object, FolderTreeEditPart> modelToEditPart = new HashMap<Object, FolderTreeEditPart>();
        if (size > 0) {
            modelToEditPart = new HashMap(size);
            for (FolderTreeEditPart e : children) {
                modelToEditPart.put(e.getModel(), e);
            }
        }
        List<List<?>> modelObjects = this.getModelChildren();
        int i = 0;
        while (i < modelObjects.size()) {
            List<?> model = modelObjects.get(i);
            FolderTreeEditPart editPart = (FolderTreeEditPart)modelToEditPart.get(model);
            if (editPart != null) {
                this.reorderChild((EditPart)editPart, i);
            } else {
                editPart = (FolderTreeEditPart)this.createChild(model);
                this.addChild((EditPart)editPart, i);
            }
            ++i;
        }
        size = children.size();
        if (i < size) {
            ArrayList<FolderTreeEditPart> trash = new ArrayList<FolderTreeEditPart>(size - i);
            while (i < size) {
                trash.add((FolderTreeEditPart)children.get(i));
                ++i;
            }
            i = 0;
            while (i < trash.size()) {
                EditPart ep = (EditPart)trash.get(i);
                this.removeChild(ep);
                ++i;
            }
        }
    }

    @Override
    public IPropertySource getPropertySource(CommandStack commandStack) {
        return new AbstractEntityModelPropertySource(commandStack, (AbstractEntityModel)this.getModel());
    }
}

