/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.rulers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.tmdmaker.ui.editor.gef3.rulers.commands.CreateGuideCommand;
import org.tmdmaker.ui.editor.gef3.rulers.commands.DeleteGuideCommand;
import org.tmdmaker.ui.editor.gef3.rulers.commands.MoveGuideCommand;
import org.tmdmaker.ui.editor.gef3.rulers.model.GuideModel;
import org.tmdmaker.ui.editor.gef3.rulers.model.RulerModel;

public class TMDRulerProvider
extends RulerProvider {
    private RulerModel ruler;
    private PropertyChangeListener rulerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("property_children")) {
                GuideModel guide = this.getGuide(evt);
                this.handleChildrenChanged(guide);
            }
        }

        private GuideModel getGuide(PropertyChangeEvent evt) {
            GuideModel guide = (GuideModel)evt.getNewValue();
            if (TMDRulerProvider.this.getGuides().contains(guide)) {
                guide.addPropertyChangeListener(TMDRulerProvider.this.guideListener);
            } else {
                guide = (GuideModel)evt.getOldValue();
                guide.removePropertyChangeListener(TMDRulerProvider.this.guideListener);
            }
            return guide;
        }

        private void handleChildrenChanged(GuideModel guide) {
            int i = 0;
            while (i < TMDRulerProvider.this.listeners.size()) {
                ((RulerChangeListener)TMDRulerProvider.this.listeners.get(i)).notifyGuideReparented((Object)guide);
                ++i;
            }
        }
    };
    private PropertyChangeListener guideListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("property_position")) {
                this.handleGuideMoved((GuideModel)evt.getSource());
            }
        }

        private void handleGuideMoved(GuideModel guide) {
            int i = 0;
            while (i < TMDRulerProvider.this.listeners.size()) {
                ((RulerChangeListener)TMDRulerProvider.this.listeners.get(i)).notifyGuideMoved((Object)guide);
                ++i;
            }
        }
    };

    public TMDRulerProvider(RulerModel ruler) {
        this.ruler = ruler;
        this.ruler.addPropertyChangeListener(this.rulerListener);
    }

    public void setUnit(int newUnit) {
        this.ruler.setUnit(newUnit);
    }

    public int getUnit() {
        return this.ruler.getUnit();
    }

    public Object getRuler() {
        return this.ruler;
    }

    public int[] getGuidePositions() {
        List guides = this.getGuides();
        int[] results = new int[guides.size()];
        int i = 0;
        while (i < guides.size()) {
            results[i] = ((GuideModel)guides.get(i)).getPosition();
            ++i;
        }
        return results;
    }

    public int getGuidePosition(Object guide) {
        return ((GuideModel)guide).getPosition();
    }

    public List getGuides() {
        return this.ruler.getGuides();
    }

    public Command getCreateGuideCommand(int position) {
        return new CreateGuideCommand(this.ruler, position);
    }

    public Command getDeleteGuideCommand(Object guide) {
        return new DeleteGuideCommand(this.ruler, (GuideModel)guide);
    }

    public Command getMoveGuideCommand(Object guide, int positionDelta) {
        return new MoveGuideCommand((GuideModel)guide, positionDelta);
    }
}

