/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.commands;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.VirtualSuperset;
import org.tmdmaker.core.model.virtual.VirtualSubsetBuilder;
import org.tmdmaker.ui.editor.draw2d.adjuster.VirtualSupersetAdjuster;

public class VirtualSupersetCreateCommand
extends Command {
    private VirtualSuperset superset;
    private VirtualSubsetBuilder builder;
    private int x;
    private int y;

    public VirtualSupersetCreateCommand(VirtualSuperset superset, List<AbstractEntityModel> subsets, int x, int y) {
        this.superset = superset;
        this.builder = this.superset.virtualSubsets().builder();
        this.builder.subsetList(subsets);
        this.x = x;
        this.y = y;
    }

    public VirtualSupersetCreateCommand(VirtualSuperset superset, List<AbstractEntityModel> subsets) {
        this(superset, subsets, 0, 0);
    }

    public void execute() {
        this.builder.build();
        if (this.needPositionAdjust()) {
            new VirtualSupersetAdjuster(this.superset, this.x, this.y).adjust();
        }
    }

    private boolean needPositionAdjust() {
        return this.x != 0 || this.y != 0;
    }

    public void undo() {
        this.builder.rollback();
    }

    public void redo() {
        this.builder.build();
    }
}

