/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.draw2d.anchors;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.tmdmaker.core.model.constraint.AnchorConstraint;
import org.tmdmaker.ui.editor.draw2d.anchors.RectangleUtils;

public class XYChopboxAnchorHelper {
    private int rightSide;
    private int leftSide;
    private int topSide;
    private int bottomSide;
    private Rectangle bounds;

    public XYChopboxAnchorHelper(Rectangle r) {
        this.bounds = r;
        this.rightSide = r.x + r.width;
        this.topSide = r.y + r.height;
        this.leftSide = r.x;
        this.bottomSide = r.y;
    }

    private boolean isCloseToLeft(Point s) {
        int x1 = s.x - this.leftSide;
        int x2 = this.rightSide - s.x;
        return x1 < x2;
    }

    private boolean isCloseToTop(Point s) {
        int y1 = s.y - this.bottomSide;
        int y2 = this.topSide - s.y;
        return y1 >= y2;
    }

    private boolean isCloseToX(int dx, int dy) {
        return dx >= dy;
    }

    public AnchorConstraint calculateAnchorConstraint(Point location) {
        Rectangle centerRectangle = RectangleUtils.calculateCenter(this.bounds);
        if (centerRectangle.contains(location)) {
            return new AnchorConstraint();
        }
        return this.calculateIntersectAnchorConstraint(location);
    }

    private AnchorConstraint calculateIntersectAnchorConstraint(Point s) {
        Point point = this.getIntersectionPoint(s);
        int xp = 100 * (point.x - this.bounds.x) / this.bounds.width;
        int yp = 100 * (point.y - this.bounds.y) / this.bounds.height;
        return new AnchorConstraint(xp, yp);
    }

    private Point getIntersectionPoint(Point s) {
        int x = 0;
        int dx = 0;
        if (this.isCloseToLeft(s)) {
            x = this.leftSide;
            dx = s.x - this.leftSide;
        } else {
            x = this.rightSide;
            dx = this.rightSide - s.x;
        }
        int y = 0;
        int dy = 0;
        if (this.isCloseToTop(s)) {
            y = this.topSide;
            dy = this.topSide - s.y;
        } else {
            y = this.bottomSide;
            dy = s.y - this.bottomSide;
        }
        if (this.isCloseToX(dx, dy)) {
            x = s.x;
        } else {
            y = s.y;
        }
        return new Point(x, y);
    }
}

