/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.dialogs.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.EntityType;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.KeyModels;
import org.tmdmaker.core.model.StandardSQLDataType;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.dialogs.model.EditAttribute;

public class EditTable {
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_NAME = "_edit_property_name";
    public static final String PROPERTY_ATTRIBUTES = "_edit_property_attributes";
    public static final String PROPERTY_TYPE = "_edit_property_type";
    protected AbstractEntityModel entity;
    protected String name;
    protected boolean notImplement = false;
    protected String implementName = "";
    private EntityType type;
    private boolean entityTypeEditable;
    protected List<EditAttribute> attributes = new ArrayList<EditAttribute>();
    private List<EditAttribute> newAttributes = new ArrayList<EditAttribute>();
    private List<EditAttribute> deleteAttributes = new ArrayList<EditAttribute>();

    public EditTable(AbstractEntityModel model) {
        this.entity = model;
        this.name = model.getName();
        this.notImplement = model.isNotImplement();
        this.implementName = model.getImplementName();
        this.type = this.entity.getEntityType();
        for (IAttribute a : this.entity.getAttributes()) {
            this.attributes.add(new EditAttribute(a));
        }
        this.entityTypeEditable = this.entity.isEntityTypeEditable();
    }

    protected EditTable() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.listeners != null && this.listeners.getPropertyChangeListeners() != null) {
            this.listeners.firePropertyChange(propName, oldValue, newValue);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public int getMaxAttributeIndex() {
        return this.attributes.size() - 1;
    }

    public void addAttribute() {
        EditAttribute ea = new EditAttribute();
        this.setDefaultValue(ea);
        this.attributes.add(ea);
        this.newAttributes.add(ea);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, null, ea);
    }

    protected void setDefaultValue(EditAttribute attribute) {
        attribute.setName(String.valueOf(Messages.EditTable_DefaultAttributeName) + String.valueOf(this.attributes.size() + 1));
        attribute.setDataType(StandardSQLDataType.CHARACTER_VARYING);
        attribute.setImplementName(attribute.getName());
        attribute.setSize("10");
    }

    public void upAttribute(int index) {
        int newIndex = index - 1;
        EditAttribute attribute = this.attributes.remove(index);
        this.attributes.add(newIndex, attribute);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, index, newIndex);
    }

    public void downAttribute(int index) {
        int newIndex = index + 1;
        EditAttribute attribute = this.attributes.remove(index);
        this.attributes.add(newIndex, attribute);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, index, newIndex);
    }

    public void editAttribute(int index, EditAttribute attribute) {
        this.attributes.remove(index);
        this.attributes.add(index, attribute);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, null, attribute);
    }

    public void deleteAttribute(int index) {
        EditAttribute deleted = this.attributes.remove(index);
        this.deleteAttributes.add(deleted);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, deleted, null);
    }

    public void uptoIdentifier(int index) {
    }

    public List<EditAttribute> getAttributes() {
        return this.attributes;
    }

    public EditAttribute getEditAttribute(int index) {
        return this.attributes.get(index);
    }

    public List<IAttribute> getAttributesOrder() {
        ArrayList<IAttribute> order = new ArrayList<IAttribute>();
        for (EditAttribute ea : this.attributes) {
            order.add(ea.getOriginalAttribute());
        }
        return order;
    }

    public boolean isNotImplement() {
        return this.notImplement;
    }

    public void setNotImplement(boolean notImplement) {
        this.notImplement = notImplement;
    }

    public String getImplementName() {
        return this.implementName;
    }

    public void setImplementName(String implementName) {
        this.implementName = implementName;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setType(EntityType type) {
        EntityType oldValue = this.type;
        this.type = type;
        this.firePropertyChange(PROPERTY_TYPE, oldValue, type);
    }

    public boolean canUpToIdentifier() {
        return false;
    }

    public KeyModels getKeyModels() {
        return this.entity.getKeyModels();
    }

    public List<AbstractEntityModel> getImplementDerivationModels() {
        return this.entity.getImplementDerivationModels();
    }

    public boolean isEntityTypeEditable() {
        return this.entityTypeEditable;
    }

    public boolean isValid() {
        return this.name != null && !this.name.isEmpty();
    }

    public <T extends AbstractEntityModel> T createEditedModel() {
        AbstractEntityModel edited = this.entity.getCopy();
        this.copyTo(edited);
        this.copySpecialTo(edited);
        return (T)edited;
    }

    protected void copyTo(AbstractEntityModel to) {
        to.setName(this.getName());
        to.setNotImplement(this.isNotImplement());
        to.setImplementName(this.getImplementName());
        to.setAttributes(this.getAttributesOrder());
        to.setKeyModels(this.getKeyModels());
        to.setImplementDerivationModels(this.getImplementDerivationModels());
        to.setEntityType(this.getType());
    }

    protected void copySpecialTo(AbstractEntityModel to) {
    }
}

