/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.editor.TMDEditor;
import org.tmdmaker.ui.preferences.IPreferenceListener;
import org.tmdmaker.ui.preferences.appearance.AppearancePreferenceListener;
import org.tmdmaker.ui.preferences.rule.RulePreferenceListener;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tmdmaker.ui";
    public static final String IMPORTER_PLUGIN_ID = "tmdmaker.importers";
    private static Activator plugin;
    private IPropertyChangeListener[] listeners = new IPropertyChangeListener[]{new AppearancePreferenceListener(), new RulePreferenceListener()};

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IPreferenceStore store = plugin.getPreferenceStore();
        IPropertyChangeListener[] iPropertyChangeListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyChangeListener listener = iPropertyChangeListenerArray[n2];
            if (listener instanceof IPreferenceListener) {
                ((IPreferenceListener)listener).preferenceStart(store);
            }
            store.addPropertyChangeListener(listener);
            ++n2;
        }
        this.update();
    }

    public void stop(BundleContext context) throws Exception {
        IPreferenceStore store = plugin.getPreferenceStore();
        IPropertyChangeListener[] iPropertyChangeListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyChangeListener listener = iPropertyChangeListenerArray[n2];
            store.removePropertyChangeListener(listener);
            ++n2;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(Throwable t) {
        Status status = new Status(4, PLUGIN_ID, 4, t.getMessage(), t);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Status status = new Status(4, PLUGIN_ID, 4, message, null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public static void showMessageDialog(String message) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 34);
        messageBox.setText(Messages.TMDPlugin_InformationTitle);
        messageBox.setMessage(message);
        messageBox.open();
    }

    public static void showErrorDialog(String message) {
        Status status = new Status(4, PLUGIN_ID, message);
        Activator.log(message);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.TMDPlugin_ErrorTitle, (String)message, (IStatus)status);
    }

    public static void showErrorDialog(Throwable t) {
        Activator.showErrorDialog(Messages.TMDPlugin_ErrorMessage, t);
    }

    public static void showErrorDialog(String message, Throwable t) {
        Status status = new Status(4, PLUGIN_ID, 0, t.getMessage(), t);
        Activator.log(t);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.TMDPlugin_ErrorTitle, (String)message, (IStatus)status);
    }

    public static Image getImage(String path) {
        ImageRegistry images = Activator.getDefault().getImageRegistry();
        Image image = images.get(path);
        if (image == null) {
            image = Activator.getImageDescriptor(path).createImage();
            images.put(path, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void update() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = w.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference ref = iEditorReferenceArray[n6];
                    IEditorPart part = ref.getEditor(false);
                    if (part instanceof TMDEditor) {
                        ((TMDEditor)part).updateVisuals();
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }
}

