/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.engine.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Memento {
    private static final Collection<Class<?>> simples = Arrays.asList(String.class, Integer.class, Long.class, Float.class, Double.class, Byte.class, Short.class, Character.class, Boolean.class);
    private static final Collection<Class<?>> simpleArrays = Arrays.asList(String[].class, Integer[].class, Long[].class, Float[].class, Double[].class, Byte[].class, Short[].class, Character[].class, Boolean[].class);
    private static final Collection<Class<?>> primitiveArrays = Arrays.asList(long[].class, int[].class, short[].class, char[].class, byte[].class, double[].class, float[].class, boolean[].class);
    Map<String, Object> mementoMap = new HashMap<String, Object>();

    public Object remove(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.mementoMap.remove(key);
    }

    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        Memento.validateValue(value);
        return this.mementoMap.put(key, value);
    }

    public Object get(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.mementoMap.get(key);
    }

    public Enumeration<String> getKeys() {
        return new Enumeration<String>(){
            Iterator<String> keysIterator;
            {
                this.keysIterator = Memento.this.mementoMap.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.keysIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return this.keysIterator.next();
            }
        };
    }

    private static void validateValue(Object value) {
        if (value == null) {
            return;
        }
        Class<?> clazz = value.getClass();
        if (simples.contains(clazz)) {
            return;
        }
        if (simpleArrays.contains(clazz) || primitiveArrays.contains(clazz)) {
            return;
        }
        throw new IllegalArgumentException(clazz.getName());
    }
}

