/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.generate.html.keydefinitionlist;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.KeyModel;
import org.tmdmaker.core.model.rule.ImplementRule;
import org.tmdmaker.generate.html.Messages;
import org.tmdmaker.generate.html.internal.HtmlGeneratorUtils;
import org.tmdmaker.generate.html.keydefinitionlist.KeyDefinitionMapping;
import org.tmdmaker.model.generate.Generator;
import org.tmdmaker.model.generate.GeneratorRuntimeException;

public class KeyDefinitionListHtmlGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(KeyDefinitionListHtmlGenerator.class);

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        logger.info("generate");
        VelocityContext context = HtmlGeneratorUtils.getVecityContext();
        try {
            HtmlGeneratorUtils.outputCSS(rootDir);
            HtmlGeneratorUtils.copyStream(KeyDefinitionListHtmlGenerator.class.getResourceAsStream("index.html"), new FileOutputStream(new File(rootDir, "keys_index.html")));
            context.put("entities", models);
            HtmlGeneratorUtils.applyTemplate("summary.html", this.getClass(), new File(rootDir, "summary.html"), context);
            HtmlGeneratorUtils.applyTemplate("key_list.html", this.getClass(), new File(rootDir, "key_list.html"), context);
            File keysDir = new File(rootDir, "keys");
            keysDir.mkdir();
            for (AbstractEntityModel m : models) {
                context.put("keys", (Object)m.getKeyModels());
                Map<IAttribute, List<KeyDefinitionMapping>> attributeKeyMap = this.createData(m);
                context.put("attributes", attributeKeyMap.keySet());
                context.put("mappings", attributeKeyMap.entrySet());
                context.put("entity", (Object)m);
                HtmlGeneratorUtils.applyTemplate("keys.html", this.getClass(), new File(keysDir, String.valueOf(m.getName()) + ".html"), context);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new GeneratorRuntimeException((Throwable)e);
        }
    }

    private Map<IAttribute, List<KeyDefinitionMapping>> createData(AbstractEntityModel model) {
        List attributes = ImplementRule.findAllImplementAttributes((AbstractEntityModel)model);
        LinkedHashMap<IAttribute, List<KeyDefinitionMapping>> data = new LinkedHashMap<IAttribute, List<KeyDefinitionMapping>>();
        for (IAttribute a : attributes) {
            ArrayList<KeyDefinitionMapping> list = new ArrayList<KeyDefinitionMapping>();
            for (KeyModel k : model.getKeyModels()) {
                list.add(new KeyDefinitionMapping(a, k));
            }
            data.put(a, list);
        }
        return data;
    }

    public String getGeneratorName() {
        return Messages.KeyDefinitionListHtmlGenerator_GeneratorName;
    }

    public String getGroupName() {
        return "HTML";
    }

    public boolean isImplementModelOnly() {
        return true;
    }
}

