/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import jp.sourceforge.tmdmaker.model.IAcceptor;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.constraint.Constraint;

public class ModelElement
implements Serializable,
IAcceptor {
    public static final String PROPERTY_NAME = "_property_name";
    public static final String PROPERTY_DESCRIPTION = "_property_description";
    public static final String PROPERTY_CONSTRAINT = "_property_constraint";
    private String name;
    private String description;
    private Constraint constraint;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propName, oldValue, newValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, null, name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.firePropertyChange(PROPERTY_DESCRIPTION, null, description);
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        Constraint oldValue = this.constraint;
        this.constraint = constraint;
        this.firePropertyChange(PROPERTY_CONSTRAINT, oldValue, constraint);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public void move(int x, int y) {
        Constraint oldPosition = this.getConstraint();
        Constraint newPosition = oldPosition.getCopy();
        newPosition.x = x;
        newPosition.y = y;
        this.setConstraint(newPosition);
    }

    public boolean canCreateSubset() {
        return false;
    }

    public boolean canCreateMultivalueOr() {
        return false;
    }

    public boolean canCreateMultivalueAnd() {
        return false;
    }

    public boolean canCreateVirtualEntity() {
        return false;
    }
}

