/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.ProblemView;
import org.eclipse.ui.views.markers.internal.TaskFilter;
import org.eclipse.ui.views.markers.internal.TaskView;

public class CPMarkerViewHelper {
    public static final int SEVERITY_MASK_OFF = 0;
    public static final int SEVERITY_MASK_WARNING = 2;
    public static final int SEVERITY_MASK_ERROR = 4;
    public static final int PRIORITY_MASK_OFF = 0;
    public static final int PRIORITY_MASK_NORMAL = 2;
    public static final int PRIORITY_MASK_HIGH = 4;
    public static final String[] TYPES_ALL = new String[]{"org.eclipse.core.resources.problemmarker"};
    public static final String[] TYPES_PROBLEMS_ONLY = new String[]{"org.eclipse.core.resources.problemmarker"};
    public static final String[] TYPES_TASKS_ONLY = new String[]{"org.eclipse.core.resources.taskmarker"};
    public static final String[] TYPES_JAVA_ONLY = new String[]{"org.eclipse.jdt.core.problem"};
    private static MarkerTypesModel typesModel = CPMarkerViewHelper.getTypesModel();
    public static final int RESOURCE_ANY = 0;
    public static final int RESOURCE_SELECTED_ONLY = 1;
    public static final int RESOURCE_SELECTED_AND_CHILDREN = 2;
    public static final int RESOURCE_OF_SAME_PROJECT = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static String[] getTypesFilter(MarkerView markerView) {
        MarkerFilter[] filters = markerView.getAllFilters();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.markers.internal.MarkerFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MarkerFilter filter = CPMarkerViewHelper.getFilter(filters, clazz);
        Object[] markerTypes = filter.getSelectedTypes().toArray();
        String[] types = new String[markerTypes.length];
        int i = 0;
        while (i < markerTypes.length) {
            types[i] = ((MarkerType)markerTypes[i]).getId();
            ++i;
        }
        return types;
    }

    private static MarkerTypesModel getTypesModel() {
        return MarkerTypesModel.getInstance();
    }

    public static void setTypesFilter(MarkerView markerView, String[] types) {
        MarkerFilter[] filters = markerView.getAllFilters();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.markers.internal.MarkerFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MarkerFilter filter = CPMarkerViewHelper.getFilter(filters, clazz);
        ArrayList markerTypes = new ArrayList(types.length);
        int i = 0;
        while (i < types.length) {
            CPMarkerViewHelper.addAllSubTypes(markerTypes, typesModel.getType(types[i]));
            ++i;
        }
        filter.setSelectedTypes(markerTypes);
    }

    private static void addAllSubTypes(ArrayList markerTypes, MarkerType type) {
        if (type == null) {
            return;
        }
        if (!markerTypes.contains(type)) {
            markerTypes.add(type);
        }
        MarkerType[] subTypes = type.getSubtypes();
        int i = 0;
        while (i < subTypes.length) {
            CPMarkerViewHelper.addAllSubTypes(markerTypes, subTypes[i]);
            ++i;
        }
    }

    public static int getOnResource(MarkerFilter filter) {
        return filter.getOnResource();
    }

    public static void setOnResource(MarkerFilter filter, int resourceFilter) {
        filter.setOnResource(resourceFilter);
    }

    public static void filterChanged(MarkerView problemOrTaskView) {
        problemOrTaskView.refreshViewer();
    }

    public static ProblemFilter getProblemFilter(ProblemView problemList) {
        MarkerFilter[] filters = problemList.getAllFilters();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.markers.internal.ProblemFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ProblemFilter)CPMarkerViewHelper.getFilter(filters, clazz);
    }

    public static TaskFilter getTaskFilter(TaskView taskList) {
        MarkerFilter[] filters = taskList.getUserFilters();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.views.markers.internal.TaskFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TaskFilter)CPMarkerViewHelper.getFilter(filters, clazz);
    }

    private static MarkerFilter getFilter(MarkerFilter[] filters, Class filterClass) {
        int i = 0;
        while (i < filters.length) {
            if (filterClass.isInstance(filters[i])) {
                return filters[i];
            }
            ++i;
        }
        return null;
    }
}

