/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.FeatureSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;

public class QuickStartAction
extends Action {
    public static final String PREFIX = "org.eclipse.ui.";
    public static final String QUICK_START_ACTION = "org.eclipse.ui.quick_start_action_context";
    public static final String WELCOME_PAGE_SELECTION_DIALOG = "org.eclipse.ui.welcome_page_selection_dialog";
    private static final String EDITOR_ID = "org.eclipse.ui.internal.dialogs.WelcomeEditor";
    private IWorkbenchWindow window;

    public QuickStartAction(IWorkbenchWindow window) {
        super("&Welcome...");
        Assert.isNotNull((Object)window);
        this.setToolTipText("Open a Welcome Editor");
        WorkbenchHelp.setHelp((IAction)this, (String)QUICK_START_ACTION);
        this.setActionDefinitionId("org.eclipse.ui.help.quickStartAction");
        this.window = window;
    }

    public void run() {
        AboutInfo feature = this.promptForFeature();
        if (feature != null) {
            this.openWelcomePage(feature);
        }
    }

    private AboutInfo promptForFeature() {
        FeatureSelectionDialog d;
        block6: {
            AboutInfo[] features = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
            int i = 0;
            while (i < features.length) {
                if (features[i].getWelcomePageURL() != null) {
                    welcomeFeatures.add(features[i]);
                }
                ++i;
            }
            Shell shell = this.window.getShell();
            if (welcomeFeatures.size() == 0) {
                MessageDialog.openInformation((Shell)shell, (String)"Welcome", (String)"No features with quick start information are available");
                return null;
            }
            features = new AboutInfo[welcomeFeatures.size()];
            welcomeFeatures.toArray(features);
            AboutInfo primaryFeature = IDEWorkbenchPlugin.getDefault().getPrimaryInfo();
            try {
                d = new FeatureSelectionDialog(shell, features, primaryFeature.getFeatureId(), "WelcomePageSelectionDialog.title", "WelcomePageSelectionDialog.message", WELCOME_PAGE_SELECTION_DIALOG);
                if (d.open() == 0 && d.getResult().length == 1) break block6;
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }
        return (AboutInfo)d.getResult()[0];
    }

    public boolean openWelcomePage(String featureId) {
        AboutInfo feature = this.findFeature(featureId);
        if (feature == null || feature.getWelcomePageURL() == null) {
            return false;
        }
        return this.openWelcomePage(feature);
    }

    private AboutInfo findFeature(String featureId) {
        AboutInfo[] features = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        int i = 0;
        while (i < features.length) {
            AboutInfo info = features[i];
            if (info.getFeatureId().equals(featureId)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    private boolean openWelcomePage(AboutInfo feature) {
        IWorkbenchPage page = null;
        String perspectiveId = feature.getWelcomePerspectiveId();
        if (perspectiveId == null && ((page = this.window.getActivePage()) == null || page.getPerspective() == null)) {
            perspectiveId = WorkbenchPlugin.getDefault().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (perspectiveId != null) {
            try {
                page = (WorkbenchPage)this.window.getWorkbench().showPerspective(perspectiveId, this.window);
            }
            catch (WorkbenchException workbenchException) {
                return false;
            }
        }
        page.setEditorAreaVisible(true);
        WelcomeEditorInput input = new WelcomeEditorInput(feature);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.activate((IWorkbenchPart)editor);
            return true;
        }
        try {
            page.openEditor((IEditorInput)input, EDITOR_ID);
        }
        catch (PartInitException e) {
            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, "An exception occurred when opening the editor", (Throwable)e);
            ErrorDialog.openError((Shell)this.window.getShell(), (String)"Problem", (String)"Unable to open editor", (IStatus)status);
            return false;
        }
        return true;
    }
}

