/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import jp.sourceforge.tmdmaker.generate.DatabaseNotSelectRuntimeException;
import jp.sourceforge.tmdmaker.generate.DdlUtilsConverter;
import jp.sourceforge.tmdmaker.generate.Generator;
import jp.sourceforge.tmdmaker.generate.GeneratorRuntimeException;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.IAttribute;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.model.Database;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlUtilsDDLGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(DdlUtilsDDLGenerator.class);
    private DdlUtilsConverter converter = new DdlUtilsConverter();

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        assert (models.size() != 0);
        Diagram diagram = models.get(0).getDiagram();
        String databaseName = diagram.getDatabaseName();
        if (databaseName == null || databaseName.length() == 0) {
            throw new DatabaseNotSelectRuntimeException();
        }
        Database database = this.converter.convert(diagram, models);
        this.converter.addCommonColumns(database, (List<IAttribute>)diagram.getCommonAttributes());
        Platform platform = PlatformFactory.createNewPlatformInstance((String)databaseName);
        String sql = platform.getCreateModelSql(database, true, true);
        logger.debug(sql);
        this.writeSqlFile(rootDir, "ddl.sql", sql);
    }

    private void writeSqlFile(String rootDir, String fileName, String sql) {
        File file = new File(rootDir, fileName);
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                out.write(sql.getBytes("UTF-8"));
            }
            catch (FileNotFoundException e) {
                logger.error("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (Throwable)e);
                throw new GeneratorRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                logger.error("\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                throw new GeneratorRuntimeException((Throwable)e);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getGeneratorName() {
        return "DDL\u3092\u51fa\u529b";
    }

    public String getGroupName() {
        return "DDL";
    }

    public boolean isImplementModelOnly() {
        return true;
    }
}

