/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jp.sourceforge.tmdmaker.extension.PluginExtensionPointRuntimeException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;

public class PluginExtensionPointFactory<T> {
    private String extensionPointId;
    private List<T> instanceList;
    private IExtensionRegistry registry;
    private Comparator<T> comparator;

    public PluginExtensionPointFactory(String extensionPoint) {
        this(extensionPoint, null);
    }

    public PluginExtensionPointFactory(String extensionPoint, Comparator<T> comparator) {
        this.extensionPointId = extensionPoint;
        this.instanceList = new ArrayList<T>();
        this.registry = Platform.getExtensionRegistry();
        this.comparator = comparator;
        this.registry.addListener(new IRegistryEventListener(){

            public void removed(IExtensionPoint[] extensionPoints) {
                System.out.println("removed(IExtensionPoint[] extensionPoints)");
                PluginExtensionPointFactory.this.setup();
            }

            public void removed(IExtension[] extensions) {
                System.out.println("removed(IExtension[] extensions");
                PluginExtensionPointFactory.this.setup();
            }

            public void added(IExtensionPoint[] extensionPoints) {
                System.out.println("added(IExtensionPoint[] extensionPoints)");
                PluginExtensionPointFactory.this.setup();
            }

            public void added(IExtension[] extensions) {
                System.out.println("added(IExtension[] extensions)");
                PluginExtensionPointFactory.this.setup();
            }
        }, this.extensionPointId);
        this.setup();
    }

    public T getInstance() {
        if (this.instanceList.size() >= 1) {
            return this.instanceList.get(0);
        }
        return null;
    }

    public List<T> getInstances() {
        return Collections.unmodifiableList(this.instanceList);
    }

    private void setup() {
        this.instanceList.clear();
        IExtensionPoint point = this.registry.getExtensionPoint(this.extensionPointId);
        if (point == null) {
            System.out.println(String.valueOf(this.extensionPointId) + " is not exists.");
            return;
        }
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ex = iExtensionArray[n2];
            this.addExsecutableExtensionsFromExtension(ex);
            ++n2;
        }
        if (this.comparator != null) {
            Collections.sort(this.instanceList, this.comparator);
        }
    }

    private void addExsecutableExtensionsFromExtension(IExtension ex) {
        IConfigurationElement[] iConfigurationElementArray = ex.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                this.instanceList.add(ce.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                throw new PluginExtensionPointRuntimeException(e);
            }
            ++n2;
        }
    }
}

