/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.generate.GeneratorUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramImageSaveAction
extends Action {
    private GraphicalViewer viewer;
    private IWorkbenchPart part;
    public static final String ID = "DiagramImageSaveAction";

    public DiagramImageSaveAction(GraphicalViewer viewer, IWorkbenchPart part) {
        this.viewer = viewer;
        this.part = part;
        this.setText("\u753b\u50cf\u3068\u3057\u3066\u4fdd\u5b58");
        this.setId(ID);
    }

    public void run() {
        FreeformGraphicalRootEditPart rootEditPart = (FreeformGraphicalRootEditPart)this.getViewer().getRootEditPart();
        FileDialog dialog = new FileDialog(this.viewer.getControl().getShell(), 8192);
        IFile editfile = GeneratorUtils.getEditFile(this.part);
        dialog.setFileName(String.valueOf(editfile.getLocation().toOSString()) + ".jpg");
        dialog.setFilterPath(editfile.getLocation().removeFirstSegments(1).toOSString());
        String file = dialog.open();
        if (file != null) {
            IFigure figure = rootEditPart.getLayer((Object)"Printable Layers");
            Rectangle rectangle = figure.getBounds();
            Image image = new Image((Device)Display.getDefault(), rectangle.width + 50, rectangle.height + 50);
            GC gc = new GC((Drawable)image);
            SWTGraphics graphics = new SWTGraphics(gc);
            graphics.translate(rectangle.x * -1, rectangle.y * -1);
            figure.paint((Graphics)graphics);
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            if (file.endsWith(".bmp")) {
                loader.save(file, 0);
            } else if (file.endsWith(".gif")) {
                loader.save(file, 2);
            } else if (file.endsWith(".jpg") || file.endsWith(".jpeg")) {
                loader.save(file, 4);
            } else if (file.endsWith(".png")) {
                loader.save(file, 5);
            } else if (file.endsWith(".tiff")) {
                loader.save(file, 6);
            } else {
                file = String.valueOf(file) + ".bmp";
                loader.save(file, 0);
            }
            TMDPlugin.showMessageDialog(String.valueOf(this.getText()) + " \u5b8c\u4e86");
            try {
                GeneratorUtils.refreshGenerateResource(file);
            }
            catch (Exception e) {
                TMDPlugin.showErrorDialog(e);
            }
            image.dispose();
            gc.dispose();
        }
    }

    protected GraphicalViewer getViewer() {
        return this.viewer;
    }
}

