/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import java.net.URI;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.Policy;
import org.eclipse.core.internal.net.proxy.win32.winhttp.WinHttpProxyProvider;
import org.eclipse.core.net.proxy.IProxyData;

public class WindowsProxyProvider
extends AbstractProxyProvider {
    private static final String LIBRARY_NAME = "jWinHttp-1.0.0";
    private static boolean jWinHttpLoaded = false;
    private WinHttpProxyProvider winHttpProxyProvider = jWinHttpLoaded ? new WinHttpProxyProvider() : null;

    static {
        try {
            System.loadLibrary(LIBRARY_NAME);
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Loaded jWinHttp-1.0.0 library");
            }
            jWinHttpLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            Activator.logError("Could not load library: " + System.mapLibraryName(LIBRARY_NAME), e);
        }
    }

    protected IProxyData[] getProxyData(URI uri) {
        if (jWinHttpLoaded) {
            return this.winHttpProxyProvider.getProxyData(uri);
        }
        return new IProxyData[0];
    }

    protected IProxyData[] getProxyData() {
        if (jWinHttpLoaded) {
            return this.winHttpProxyProvider.getProxyData();
        }
        return new IProxyData[0];
    }

    protected String[] getNonProxiedHosts() {
        if (jWinHttpLoaded) {
            return this.winHttpProxyProvider.getNonProxiedHosts();
        }
        return new String[0];
    }
}

