/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractTMDEditPart;
import jp.sourceforge.tmdmaker.editpart.XYChopboxAnchor;
import jp.sourceforge.tmdmaker.editpart.XYChopboxAnchorHelper;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.command.AttributeEditCommand;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ReconnectRequest;

public abstract class AbstractEntityEditPart
extends AbstractTMDEditPart
implements NodeEditPart {
    private ConnectionAnchor anchor;

    @Override
    public void activate() {
        logger.debug(this.getClass() + "#activate()");
        super.activate();
        ((ModelElement)this.getModel()).addPropertyChangeListener(this);
    }

    @Override
    public void deactivate() {
        logger.debug(this.getClass() + "#deactivate()");
        super.deactivate();
        ((ModelElement)this.getModel()).removePropertyChangeListener(this);
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new XYChopboxAnchor(this.getFigure());
        }
        return this.anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        AbstractConnectionModel relationship = (AbstractConnectionModel)connection.getModel();
        XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure(), relationship.getSourceXp(), relationship.getSourceYp());
        return anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart connectionEditPart = reconnectRequest.getConnectionEditPart();
            AbstractConnectionModel relationship = (AbstractConnectionModel)connectionEditPart.getModel();
            if (relationship.getSource() == relationship.getTarget()) {
                return new XYChopboxAnchor(this.getFigure());
            }
            EditPart editPart = reconnectRequest.getTarget();
            if (editPart == null || !editPart.getModel().equals(relationship.getSource())) {
                return new XYChopboxAnchor(this.getFigure());
            }
            Point location = new Point(reconnectRequest.getLocation());
            this.getFigure().translateToRelative((Translatable)location);
            IFigure sourceFigure = ((AbstractEntityEditPart)connectionEditPart.getSource()).getFigure();
            XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure());
            Rectangle bounds = sourceFigure.getBounds();
            Rectangle centerRectangle = new Rectangle(bounds.x + bounds.width / 4, bounds.y + bounds.height / 4, bounds.width / 2, bounds.height / 2);
            if (!centerRectangle.contains(location)) {
                Point point = new XYChopboxAnchorHelper(bounds).getIntersectionPoint(location);
                int xp = 100 * (point.x - bounds.x) / bounds.width;
                int yp = 100 * (point.y - bounds.y) / bounds.height;
                anchor.setLocation(xp, yp);
            }
            return anchor;
        }
        return new XYChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        AbstractConnectionModel relationship = (AbstractConnectionModel)connection.getModel();
        XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure(), relationship.getTargetXp(), relationship.getTargetYp());
        if (relationship.getTargetXp() != -1) {
            relationship.getTargetYp();
        }
        return anchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        System.out.println("getTargetConnectionAnchor(Request request)");
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart connectionEditPart = reconnectRequest.getConnectionEditPart();
            AbstractConnectionModel relationship = (AbstractConnectionModel)connectionEditPart.getModel();
            if (relationship.getSource() == relationship.getTarget()) {
                return new XYChopboxAnchor(this.getFigure());
            }
            EditPart editPart = reconnectRequest.getTarget();
            if (editPart == null || !editPart.getModel().equals(relationship.getTarget())) {
                return new XYChopboxAnchor(this.getFigure());
            }
            Point location = new Point(reconnectRequest.getLocation());
            this.getFigure().translateToRelative((Translatable)location);
            IFigure targetFigure = ((AbstractEntityEditPart)connectionEditPart.getTarget()).getFigure();
            XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure(), relationship.getTargetXp(), relationship.getTargetYp());
            Rectangle bounds = targetFigure.getBounds();
            Rectangle centerRectangle = new Rectangle(bounds.x + bounds.width / 4, bounds.y + bounds.height / 4, bounds.width / 2, bounds.height / 2);
            if (!centerRectangle.contains(location)) {
                Point point = new XYChopboxAnchorHelper(bounds).getIntersectionPoint(location);
                int xp = 100 * (point.x - bounds.x) / bounds.width;
                int yp = 100 * (point.y - bounds.y) / bounds.height;
                anchor.setLocation(xp, yp);
            }
            return anchor;
        }
        return new XYChopboxAnchor(this.getFigure());
    }

    protected List<AbstractConnectionModel> getModelSourceConnections() {
        return ((ConnectableElement)this.getModel()).getModelSourceConnections();
    }

    protected List<AbstractConnectionModel> getModelTargetConnections() {
        return ((ConnectableElement)this.getModel()).getModelTargetConnections();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug(this.getClass() + "." + evt.getPropertyName());
        if (evt.getPropertyName().equals("_property_name")) {
            this.handleNameChange(evt);
        } else if (evt.getPropertyName().equals("_property_constraint")) {
            this.handleConstraintChange(evt);
        } else if (evt.getPropertyName().equals("p_attribute")) {
            this.handleAttributeChange(evt);
        } else if (evt.getPropertyName().equals("p_source_connection")) {
            this.handleSourceConnectionChange(evt);
        } else if (evt.getPropertyName().equals("p_target_connection")) {
            this.handleTargetConnectionChange(evt);
        } else if (evt.getPropertyName().equals("p_reused")) {
            this.handleReUseKeyChange(evt);
        } else if (evt.getPropertyName().equals("_property_identifier")) {
            this.handleIdentifierChange(evt);
        } else if (evt.getPropertyName().equals("p_attribute_reorder")) {
            logger.warn("Handle Reorder Occured.");
            this.refreshChildren();
        } else {
            logger.warn("Not Handle Event Occured.");
        }
    }

    protected void handleNameChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleConstraintChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleAttributeChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
        this.refreshChildren();
    }

    protected void handleIdentifierChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleSourceConnectionChange(PropertyChangeEvent evt) {
        this.refreshSourceConnections();
    }

    protected void handleTargetConnectionChange(PropertyChangeEvent evt) {
        this.refreshTargetConnections();
    }

    protected void handleAttributeReorder(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleReUseKeyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    public void refresh() {
        super.refresh();
        this.refleshConnections();
    }

    protected void refreshVisuals() {
        logger.debug(String.valueOf(this.getClass().toString()) + "#refreshVisuals()");
        super.refreshVisuals();
        Object model = this.getModel();
        Rectangle bounds = new Rectangle(((ModelElement)model).getConstraint());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
        this.updateFigure(this.getFigure());
        this.refreshChildren();
    }

    protected void refleshConnections() {
        for (AbstractConnectionModel connection : this.getModelSourceConnections()) {
            connection.fireParentMoved();
        }
        for (AbstractConnectionModel connection : this.getModelTargetConnections()) {
            connection.fireParentMoved();
        }
    }

    protected abstract void updateFigure(IFigure var1);

    protected void addAttributeEditCommands(CompoundCommand ccommand, AbstractEntityModel entity, List<EditAttribute> editAttributeList) {
        for (EditAttribute ea : editAttributeList) {
            IAttribute original = ea.getOriginalAttribute();
            if (!ea.isEdited() || ea.isAdded()) continue;
            Attribute editedValueAttribute = new Attribute();
            ea.copyTo(editedValueAttribute);
            AttributeEditCommand editCommand = new AttributeEditCommand(original, editedValueAttribute, entity);
            ccommand.add((Command)editCommand);
        }
    }

    public IFigure getContentPane() {
        return ((EntityFigure)this.getFigure()).getAttributeCompartmentFigure();
    }

    protected List getModelChildren() {
        return ((AbstractEntityModel)this.getModel()).getAttributes();
    }

    protected IFigure createFigure() {
        EntityFigure figure = new EntityFigure();
        this.updateFigure((IFigure)figure);
        return figure;
    }
}

