/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import jp.sourceforge.tmdmaker.dialog.DatabaseSelectDialog;
import jp.sourceforge.tmdmaker.model.Diagram;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;

public class DatabaseSelectAction
extends Action {
    private GraphicalViewer viewer;
    public static final String ID = "DatabaseSelectAction";

    public DatabaseSelectAction(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.setText("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u9078\u629e");
        this.setId(ID);
    }

    public void run() {
        System.out.println("database select");
        try {
            Diagram diagram = (Diagram)this.viewer.getContents().getModel();
            DatabaseSelectDialog dialog = new DatabaseSelectDialog(this.viewer.getControl().getShell(), diagram.getDatabaseName());
            if (dialog.open() == 0) {
                this.viewer.getEditDomain().getCommandStack().execute((Command)new DatabaseChangeCommand(diagram, dialog.getSelectedDatabaseName()));
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    private static class DatabaseChangeCommand
    extends Command {
        private Diagram diagram;
        private String oldDatabaseName;
        private String newDatabaseName;

        public DatabaseChangeCommand(Diagram diagram, String newDatabaseName) {
            this.diagram = diagram;
            this.oldDatabaseName = diagram.getDatabaseName();
            this.newDatabaseName = newDatabaseName;
        }

        public void execute() {
            this.diagram.setDatabaseName(this.newDatabaseName);
        }

        public void undo() {
            this.diagram.setDatabaseName(this.oldDatabaseName);
        }
    }
}

