/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.ChineseDateFormatSymbols;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ChineseCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Locale;

public class ChineseDateFormat
extends SimpleDateFormat {
    static final long serialVersionUID = -4610300753104099899L;

    public ChineseDateFormat(String pattern, Locale locale) {
        this(pattern, ULocale.forLocale(locale));
    }

    public ChineseDateFormat(String pattern, ULocale locale) {
        this(pattern, (String)null, locale);
    }

    public ChineseDateFormat(String pattern, String override, ULocale locale) {
        super(pattern, new ChineseDateFormatSymbols(locale), new ChineseCalendar(TimeZone.getDefault(), locale), locale, true, override);
    }

    protected void subFormat(StringBuffer buf, char ch, int count, int beginOffset, FieldPosition pos, Calendar cal) {
        switch (ch) {
            case 'G': {
                this.zeroPaddingNumber(this.numberFormat, buf, cal.get(0), 1, 9);
                break;
            }
            case 'l': {
                buf.append(((ChineseDateFormatSymbols)this.getSymbols()).getLeapMonth(cal.get(ChineseCalendar.IS_LEAP_MONTH)));
                break;
            }
            default: {
                super.subFormat(buf, ch, count, beginOffset, pos, cal);
            }
        }
    }

    protected int subParse(String text, int start, char ch, int count, boolean obeyCount, boolean allowNegative, boolean[] ambiguousYear, Calendar cal) {
        if (ch != 'G' && ch != 'l' && ch != 'y') {
            return super.subParse(text, start, ch, count, obeyCount, allowNegative, ambiguousYear, cal);
        }
        start = Utility.skipWhitespace(text, start);
        ParsePosition pos = new ParsePosition(start);
        switch (ch) {
            case 'G': 
            case 'y': {
                Number number = null;
                if (obeyCount) {
                    if (start + count > text.length()) {
                        return -start;
                    }
                    number = this.numberFormat.parse(text.substring(0, start + count), pos);
                } else {
                    number = this.numberFormat.parse(text, pos);
                }
                if (number == null) {
                    return -start;
                }
                int value = number.intValue();
                cal.set(ch == 'G' ? 0 : 1, value);
                return pos.getIndex();
            }
            case 'l': {
                ChineseDateFormatSymbols symbols = (ChineseDateFormatSymbols)this.getSymbols();
                int result = this.matchString(text, start, ChineseCalendar.IS_LEAP_MONTH, symbols.isLeapMonth, cal);
                if (result < 0) {
                    cal.set(ChineseCalendar.IS_LEAP_MONTH, 0);
                    result = start;
                }
                return result;
            }
        }
        return 0;
    }
}

